/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Breakfast
extends JPanel
implements KeyListener,
MouseListener {
    private static final int MODE_WELCOME = 0;
    private static final int MODE_RPG = 1;
    private static final int MODE_ROCKFALL = 2;
    private static final int MODE_FISHING = 3;
    private static final int MODE_JELLYFISH = 4;
    private static final int MODE_FOREST = 5;
    private static final int MODE_SHOP = 6;
    private static final int MODE_MOUNTAIN = 7;
    private static final int MODE_COMPLETE = 8;
    private static final int MODE_RUMBLE = 10;
    private static final int MODE_SHAKE = 11;
    private static final int MODE_SHOWTASK = 12;
    private static final int MODE_ROCKFALL_WAIT = 13;
    private static final int MODE_FOREST_WAIT = 14;
    private static final int MODE_MOUNTAIN_WAIT = 15;
    private static final int NPC_OLDMAN = 8;
    private static final int NPC_GUARD = 9;
    private static final int NPC_PROF = 10;
    private static final int DEBUG = 0;
    private static final int fps = 30;
    private static int fpsdelay = 33;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean fire = false;
    private static Settings mysettings = new Settings();
    private final int swidth;
    private final int sheight;
    private static final String title = "Adventure for Breakfast";
    private final String website;
    private final String version;
    private Player myplayer = new Player();
    private Dialog mydialog = new Dialog();
    private Infobar myinfobar = new Infobar();
    private Map mymap = new Map();
    private Inventory myinventory = new Inventory();
    private Task[] mytask = new Task[4];
    private Fishing myfishing = new Fishing();
    private JellyFishing myjelly = new JellyFishing();
    private int exit_x = 0;
    private int exit_y = 0;
    private int exit_mx = 0;
    private int exit_my = 0;
    private int showtask = 0;
    private int talk = -1;
    private int showpage = 99;
    private int state = 0;
    private int resume_state = 0;

    public Breakfast() {
        this.swidth = 640;
        this.sheight = 480;
        this.website = "http://ssjx.co.uk";
        this.version = "v2.0 (29/01/21)";
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(this.swidth, this.sheight));
        this.addKeyListener(this);
        this.addMouseListener(this);
        for (int i = 0; i < this.mytask.length; ++i) {
            this.mytask[i] = new Task();
        }
        this.mymap.load(1);
        this.mymap.restore(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Breakfast.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Breakfast());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        this.controls();
        switch (this.state) {
            case 8: {
                this.mymap.draw(graphics, 7);
                this.myplayer.draw(graphics);
                this.mydialog.draw(graphics);
                break;
            }
            case 10: {
                this.mymap.rumble(graphics);
                this.mydialog.draw(graphics);
                if (this.mymap.effect_timer != 0) break;
                this.state = 7;
                break;
            }
            case 11: {
                this.mymap.teleport(graphics);
                this.mydialog.draw(graphics);
                if (this.mymap.effect_timer != 0) break;
                this.state = 7;
                break;
            }
            case 0: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                this.mymap.mappos(0, 0);
                this.mymap.draw(graphics, 1);
                this.myinventory.draw(graphics);
                this.myinfobar.txt("Welcome to '" + title + "' [" + this.version + "] - " + this.website);
                this.myinfobar.draw(graphics);
                this.mydialog.txt(99);
                this.mydialog.draw(graphics);
                break;
            }
            case 3: {
                this.myinfobar.txt("The Great Fishing Lake - Press Space to drop your hook!");
                this.myfishing.draw(graphics);
                this.myfishing.update();
                this.myplayer.drawboat(graphics);
                this.myplayer.updateboat();
                if (this.myplayer.drop <= 0) break;
                for (int i = 0; i < this.myfishing.myfish.length; ++i) {
                    if (this.myfishing.myfish[i].active != 1 || !this.myplayer.hookBounds().intersects(this.myfishing.myfish[i].getBounds())) continue;
                    this.myfishing.myfish[i].active = 2;
                    this.myplayer.drop = 2;
                    this.myinventory.add("Fish");
                }
                break;
            }
            case 4: {
                this.myinfobar.txt("The Great Fishing Lake - Press Space to drop your hook!");
                this.myjelly.draw(graphics);
                this.myjelly.update();
                this.myplayer.drawboat(graphics);
                this.myplayer.updateboat();
                if (this.myplayer.drop <= 0) break;
                for (int i = 0; i < this.myjelly.jelly.length; ++i) {
                    if (!this.myplayer.hookBounds().intersects(this.myjelly.jelly[i].jellyBounds())) continue;
                    this.myplayer.drop = 2;
                }
                if (this.myjelly.gotstone != 0 || !this.myplayer.hookBounds().intersects(this.myjelly.stoneBounds())) break;
                this.myjelly.gotstone = 2;
                this.myplayer.drop = 2;
                this.myinventory.add("Water Stone");
                break;
            }
            case 1: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                this.mymap.draw(graphics, 1);
                this.mymap.update(this.state, this.myplayer.actualx(), this.myplayer.actualy());
                this.myplayer.draw(graphics);
                this.myplayer.update();
                switch (this.talk) {
                    case 8: {
                        switch (this.mytask[1].state) {
                            case 0: {
                                if (this.showpage != 0) break;
                                this.mydialog.txt(0);
                                break;
                            }
                            case 1: {
                                if (this.showpage != 1) break;
                                this.mydialog.txt(1);
                                break;
                            }
                            case 2: {
                                if (this.showpage != 2) break;
                                this.mydialog.txt(2);
                                break;
                            }
                            case 3: {
                                this.mydialog.txt(3);
                            }
                        }
                        this.mydialog.draw(graphics);
                        break;
                    }
                    case 9: {
                        switch (this.mytask[2].state) {
                            case 0: {
                                if (this.showpage == 4) {
                                    this.mydialog.txt(4);
                                }
                                if (this.showpage != 5) break;
                                this.mydialog.txt(5);
                                break;
                            }
                            case 1: {
                                if (this.showpage != 7) break;
                                this.mydialog.txt(7);
                                break;
                            }
                            case 2: {
                                if (this.showpage != 6) break;
                                this.mydialog.txt(6);
                                break;
                            }
                            case 3: {
                                if (this.showpage != 8) break;
                                this.mydialog.txt(8);
                            }
                        }
                        this.mydialog.draw(graphics);
                    }
                }
                break;
            }
            case 13: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                this.mymap.draw(graphics, 2);
                this.myplayer.draw(graphics);
                break;
            }
            case 2: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                int n = this.myplayer.actualx();
                int n2 = this.myplayer.actualy();
                this.mymap.draw(graphics, this.state);
                this.mymap.update(this.state, n, n2);
                this.myplayer.draw(graphics);
                this.myplayer.update();
                switch (this.mymap.sqr(n, n2)) {
                    case 1: {
                        this.mymap.clr(n, n2);
                        break;
                    }
                    case 4: {
                        this.mymap.clr(n, n2);
                        this.myinventory.add("Diamond");
                    }
                }
                for (int i = 0; i < this.mymap.mine_npc[0].count; ++i) {
                    if (!this.myplayer.getBounds().intersects(this.mymap.mine_npc[i].getBounds())) continue;
                    this.state = 13;
                    this.myinfobar.txt("%You hit a spike! Press [Space] to continue");
                    return;
                }
                break;
            }
            case 14: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                this.mymap.draw(graphics, 5);
                this.myplayer.draw(graphics);
                break;
            }
            case 5: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                this.mymap.draw(graphics, this.state);
                this.mymap.update(this.state, this.myplayer.actualx(), this.myplayer.actualy());
                this.myplayer.draw(graphics);
                this.myplayer.update();
                for (int i = 0; i < this.mymap.forest_npc[0].count; ++i) {
                    if (!this.myplayer.getBounds().intersects(this.mymap.forest_npc[i].getBounds())) continue;
                    this.resume_state = this.state;
                    this.state = 14;
                    this.myinfobar.txt("%You hit a ghost! Press [Space] to continue");
                    return;
                }
                switch (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy())) {
                    case 4: {
                        this.mymap.clr(this.myplayer.actualx(), this.myplayer.actualy());
                        this.myinventory.add("Cherry");
                        break;
                    }
                    case 5: {
                        this.mymap.clr(this.myplayer.actualx(), this.myplayer.actualy());
                        this.myinventory.add("Apple");
                        break;
                    }
                    case 6: {
                        this.mymap.clr(this.myplayer.actualx(), this.myplayer.actualy());
                        this.myinventory.add("Earth Stone");
                    }
                }
                break;
            }
            case 15: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                this.mymap.draw(graphics, 7);
                this.myplayer.draw(graphics);
                break;
            }
            case 7: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, this.swidth, this.sheight);
                this.mymap.draw(graphics, this.state);
                this.mymap.update(this.state, this.myplayer.actualx(), this.myplayer.actualy());
                this.myplayer.draw(graphics);
                this.myplayer.update();
                for (int i = 0; i < this.mymap.mountain_npc[0].count; ++i) {
                    if (!this.myplayer.getBounds().intersects(this.mymap.mountain_npc[i].getBounds())) continue;
                    this.state = 15;
                    this.myinfobar.txt("%You hit a Spider-Lizard thing! Press [Space] to continue");
                    return;
                }
                if (this.talk != 10) break;
                block42 : switch (this.mytask[3].state) {
                    case 0: {
                        switch (this.showpage) {
                            case 9: {
                                this.mydialog.txt(9);
                                this.myplayer.task = 3;
                                this.mymap.replace(1, 11, 0);
                                this.mymap.replace(5, 3, 1);
                                this.mymap.replace(7, 6, 3);
                                this.mymap.restore(this.state);
                                break;
                            }
                            case 10: {
                                this.mydialog.txt(10);
                                this.myplayer.x = 5;
                                this.myplayer.y = 8;
                                break;
                            }
                            case 11: {
                                this.mymap.set(46, 33, 13);
                                this.mydialog.txt(11);
                                this.state = 10;
                                this.mymap.effect_timer = 20;
                                ++this.showpage;
                                break;
                            }
                            case 12: {
                                this.mymap.set(46, 33, 3);
                                this.mydialog.txt(12);
                                break;
                            }
                            case 13: {
                                this.mydialog.txt(13);
                                this.mytask[3].state = 1;
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (this.showpage != 30) break;
                        this.mydialog.txt(30);
                        break;
                    }
                    case 2: {
                        switch (this.showpage) {
                            case 20: {
                                this.mydialog.txt(20);
                                break block42;
                            }
                            case 21: {
                                this.mydialog.txt(21);
                                break block42;
                            }
                            case 22: {
                                this.mymap.set(46, 33, 13);
                                this.mymap.set(48, 33, 14);
                                this.mymap.set(52, 33, 15);
                                this.mymap.set(54, 33, 16);
                                this.myinventory.remove("Air Stone", 1);
                                this.myinventory.remove("Earth Stone", 1);
                                this.myinventory.remove("Fire Stone", 1);
                                this.myinventory.remove("Water Stone", 1);
                                this.mydialog.txt(22);
                                break block42;
                            }
                            case 23: {
                                this.state = 11;
                                this.mymap.effect_timer = 20;
                                this.mydialog.txt(23);
                                ++this.showpage;
                                break block42;
                            }
                            case 24: {
                                this.mydialog.txt(24);
                                break block42;
                            }
                            case 25: {
                                this.myplayer.mx = 0;
                                this.myplayer.my = 0;
                                this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                                this.mydialog.txt(25);
                            }
                        }
                    }
                }
                this.mydialog.draw(graphics);
                break;
            }
            case 6: {
                this.mymap.draw(graphics, this.state);
                this.myplayer.draw(graphics);
                this.myplayer.update();
                if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() + 1) == 2) {
                    if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 3) != 0) {
                        int n = -1;
                        String string = "";
                        switch (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 3)) {
                            case 3: {
                                string = "Pint of Milk";
                                n = 5;
                                break;
                            }
                            case 4: {
                                string = "Box of Oats";
                                n = 5;
                                break;
                            }
                            case 5: {
                                string = "Sweets";
                                n = 5;
                                break;
                            }
                            case 6: {
                                string = "Fire Stone";
                                n = 40;
                            }
                        }
                        if (this.myinventory.count("Diamond") >= n) {
                            this.myinfobar.txt(string + " = " + n + " Diamonds");
                            break;
                        }
                        this.myinfobar.txt("%" + string + " = " + n + " Diamonds (You do not have enough...)");
                        break;
                    }
                    this.myinfobar.txt("Welcome to this shop! Press [Space] under an item to buy it!");
                    break;
                }
                this.myinfobar.txt("Welcome to this shop! Press [Space] under an item to buy it!");
                break;
            }
            case 12: {
                this.mymap.draw(graphics, this.resume_state);
                this.myplayer.draw(graphics);
                this.mytask[this.myplayer.task].draw(graphics);
            }
        }
        if (this.state != 0) {
            this.myinventory.draw(graphics);
            this.myinfobar.draw(graphics);
        }
    }

    public void controls() {
        switch (this.state) {
            case 1: {
                this.myinfobar.txt("Welcome to this town!!");
                if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy()) == 6) {
                    this.myinfobar.txt("Press Space to climb down the hole!");
                }
                if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy()) == 10) {
                    this.myinfobar.txt("Press Space enter this shop!");
                }
                if (this.myplayer.actualx() == 0) {
                    this.myinfobar.txt("Onward to the Haunted Fruit Forest!");
                }
                if (this.myplayer.actualy() == 0) {
                    this.myinfobar.txt("Across the river to the Dark Mountains!");
                }
                if (this.myplayer.actualx() == 59) {
                    this.myinfobar.txt("To The Great Fishing Lake!");
                }
                if (this.myplayer.actualy() - 1 >= 0) {
                    if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 1) == 8) {
                        this.myinfobar.txt("Press Space to talk to Mr Oldman!");
                    }
                    if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 1) == 9) {
                        this.myinfobar.txt("Press Space to talk to the guard");
                    }
                }
            }
            case 2: {
                if (this.state == 2) {
                    this.myinfobar.txt("Underground Mine!");
                }
            }
            case 5: {
                if (this.state == 5) {
                    this.myinfobar.txt("Haunted Fruit Forest!");
                }
            }
            case 6: {
                if (this.right && !this.mymap.hitcheck(this.myplayer.x + 1, this.myplayer.y)) {
                    if (this.myplayer.x == 19) {
                        if (this.myplayer.actualx() == 59) {
                            switch (this.state) {
                                case 1: {
                                    this.exit_x = this.myplayer.x;
                                    this.exit_y = this.myplayer.y;
                                    this.exit_mx = this.myplayer.mx;
                                    this.exit_my = this.myplayer.my;
                                    if (this.myplayer.my == 0) {
                                        this.myjelly.refresh();
                                        this.state = 4;
                                        break;
                                    }
                                    if (this.myplayer.my != 1) break;
                                    this.state = 3;
                                    break;
                                }
                                case 5: {
                                    this.mymap.copy(this.state);
                                    this.state = 1;
                                }
                            }
                            this.myplayer.mx = 0;
                            this.myplayer.x = 0;
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                            this.mymap.restore(this.state);
                        } else {
                            ++this.myplayer.mx;
                            this.myplayer.x = 0;
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                        }
                    } else {
                        this.myplayer.move(1, 0);
                    }
                }
                if (this.left && !this.mymap.hitcheck(this.myplayer.x - 1, this.myplayer.y)) {
                    if (this.myplayer.x == 0) {
                        if (this.myplayer.actualx() == 0) {
                            switch (this.state) {
                                case 1: {
                                    this.exit_x = this.myplayer.x;
                                    this.exit_y = this.myplayer.y;
                                    this.exit_mx = this.myplayer.mx;
                                    this.exit_my = this.myplayer.my;
                                    this.myplayer.x = 19;
                                    this.myplayer.mx = 2;
                                    this.myinventory.copy();
                                    this.state = 5;
                                    break;
                                }
                                case 6: {
                                    this.mymap.copy(this.state);
                                    this.myplayer.x = this.exit_x;
                                    this.myplayer.y = this.exit_y;
                                    this.myplayer.mx = this.exit_mx;
                                    this.myplayer.my = this.exit_my;
                                    this.state = 1;
                                }
                            }
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                            this.mymap.restore(this.state);
                        } else if (this.myplayer.mx > 0) {
                            this.myplayer.x = 19;
                            --this.myplayer.mx;
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                            this.myinfobar.txt("Somewhere");
                        }
                    } else {
                        this.myplayer.move(-1, 0);
                    }
                }
                if (this.up && !this.mymap.hitcheck(this.myplayer.x, this.myplayer.y - 1)) {
                    if (this.state == 2 && this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy()) == 5) {
                        this.mymap.copy(this.state);
                        this.state = 1;
                        this.mymap.restore(this.state);
                        for (int i = 0; i < 13; ++i) {
                            for (int j = 0; j < 19; ++j) {
                                if (this.mymap.sqr(this.myplayer.mx * 20 + j, this.myplayer.my * 13 + i) != 6) continue;
                                this.myplayer.x = j;
                                this.myplayer.y = i;
                                return;
                            }
                        }
                    }
                    if (this.myplayer.y == 0) {
                        if (this.myplayer.actualy() == 0) {
                            switch (this.state) {
                                case 1: {
                                    this.exit_x = this.myplayer.x;
                                    this.exit_y = this.myplayer.y;
                                    this.exit_mx = this.myplayer.mx;
                                    this.exit_my = this.myplayer.my;
                                    this.myinventory.copy();
                                    this.state = 7;
                                }
                            }
                            this.myplayer.y = 12;
                            this.myplayer.mx = 0;
                            this.myplayer.my = 3;
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                            this.mymap.restore(this.state);
                        } else if (this.myplayer.my > 0) {
                            this.myplayer.y = 12;
                            --this.myplayer.my;
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                            this.myinfobar.txt("Somewhere");
                        }
                    } else if (this.state != 6) {
                        this.myplayer.move(0, -1);
                    }
                }
                if (!this.down || this.mymap.hitcheck(this.myplayer.x, this.myplayer.y + 1)) break;
                if (this.myplayer.y == 12) {
                    if (this.myplayer.my >= 4) break;
                    this.myplayer.y = 0;
                    ++this.myplayer.my;
                    this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                    break;
                }
                if (this.state == 2 && this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 1) == 3) {
                    this.mymap.set(this.myplayer.actualx(), this.myplayer.actualy() - 1, 0);
                    this.mymap.set(this.myplayer.actualx(), this.myplayer.actualy(), 3);
                    this.myinfobar.txt("%You were hit by a Boulder! Press [Space] to continue");
                    this.state = 13;
                    return;
                }
                this.myplayer.move(0, 1);
                break;
            }
            case 7: {
                int n;
                if (this.mymap.sqr(this.myplayer.actualx() + 1, this.myplayer.actualy()) == 10 || this.mymap.sqr(this.myplayer.actualx() - 1, this.myplayer.actualy()) == 10) {
                    this.myinfobar.txt("Press Space to talk to Professor White!");
                } else {
                    this.myinfobar.txt("Dark Mountains!");
                }
                if (!this.fire || this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 1) == 19) {
                    // empty if block
                }
                if (this.right && !this.mymap.hitcheck(this.myplayer.x + 1, this.myplayer.y)) {
                    n = this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy());
                    if (n != 8) {
                        n = this.mymap.sqr(this.myplayer.actualx() + 1, this.myplayer.actualy() + 1);
                    }
                    if (n != 3 && n != 0) {
                        if (this.myplayer.x == 19) {
                            this.myplayer.x = 0;
                            ++this.myplayer.mx;
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                        } else {
                            this.myplayer.move(1, 0);
                        }
                    }
                }
                if (this.left && !this.mymap.hitcheck(this.myplayer.x - 1, this.myplayer.y)) {
                    n = this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy());
                    if (n != 8) {
                        n = this.mymap.sqr(this.myplayer.actualx() - 1, this.myplayer.actualy() + 1);
                    }
                    if (n != 3 && n != 0) {
                        if (this.myplayer.x == 0) {
                            if (this.myplayer.mx > 0) {
                                this.myplayer.x = 19;
                                --this.myplayer.mx;
                                this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                            }
                        } else {
                            this.myplayer.move(-1, 0);
                        }
                    }
                }
                if (this.up && (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 1) == 5 || this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 1) == 8)) {
                    if (this.myplayer.y == 0) {
                        if (this.myplayer.my > 0) {
                            this.myplayer.y = 12;
                            --this.myplayer.my;
                            this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                        }
                    } else {
                        this.myplayer.move(0, -1);
                    }
                }
                if (!this.down) break;
                if (this.myplayer.actualy() == 51) {
                    this.state = 1;
                    this.myplayer.y = 0;
                    this.myplayer.mx = 1;
                    this.myplayer.my = 0;
                    this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                    this.mymap.restore(this.state);
                    return;
                }
                if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() + 1) != 5 && this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() + 1) != 8) break;
                if (this.myplayer.y == 12) {
                    if (this.myplayer.my >= 4) break;
                    this.myplayer.y = 0;
                    ++this.myplayer.my;
                    this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                    break;
                }
                this.myplayer.move(0, 1);
                break;
            }
            case 3: 
            case 4: {
                if (this.fire && this.myplayer.drop == 0) {
                    this.myplayer.drop = 1;
                }
                if (this.myplayer.drop != 0) break;
                if (this.right && this.myplayer.x + 4 < this.swidth - 64) {
                    this.myplayer.x += 4;
                }
                if (!this.left) break;
                if (this.myplayer.x - 4 >= 0) {
                    this.myplayer.x -= 4;
                    break;
                }
                this.state = 1;
                this.myplayer.x = this.exit_x;
                this.myplayer.y = this.exit_y;
                this.myplayer.mx = this.exit_mx;
                this.myplayer.my = this.exit_my;
                this.myplayer.xdir = 0;
                this.myplayer.ydir = 0;
                this.myplayer.ox = 0;
                this.myplayer.oy = 0;
                this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                this.mymap.restore(this.state);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == ' ') {
            switch (this.state) {
                case 8: {
                    this.mymap.load(1);
                    this.mymap.restore(1);
                    this.state = 0;
                    break;
                }
                case 0: {
                    this.setgamestate(this.state);
                    break;
                }
                case 6: {
                    if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() + 1) != 2) break;
                    switch (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 3)) {
                        case 3: {
                            if (this.myinventory.count("Diamond") < 5) break;
                            this.myinventory.add("Milk");
                            this.myinventory.remove("Diamond", 5);
                            break;
                        }
                        case 4: {
                            if (this.myinventory.count("Diamond") < 5) break;
                            this.myinventory.add("Oats");
                            this.myinventory.remove("Diamond", 5);
                            break;
                        }
                        case 5: {
                            if (this.myinventory.count("Diamond") < 5) break;
                            this.myinventory.add("Sweets");
                            this.myinventory.remove("Diamond", 5);
                            break;
                        }
                        case 6: {
                            if (this.myinventory.count("Diamond") < 40) break;
                            this.myinventory.add("Fire Stone");
                            this.myinventory.remove("Diamond", 40);
                            this.mymap.clr(this.myplayer.actualx(), this.myplayer.actualy() - 3);
                        }
                    }
                    break;
                }
                case 1: {
                    if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy()) == 10) {
                        this.exit_x = this.myplayer.x;
                        this.exit_y = this.myplayer.y;
                        this.exit_mx = this.myplayer.mx;
                        this.exit_my = this.myplayer.my;
                        this.myplayer.x = 0;
                        this.myplayer.y = 11;
                        this.myplayer.mx = 0;
                        this.myplayer.my = 3;
                        this.state = 6;
                        this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                        this.mymap.restore(this.state);
                    }
                    if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy()) == 6) {
                        int n;
                        this.exit_x = this.myplayer.x;
                        this.exit_y = this.myplayer.y;
                        this.exit_mx = this.myplayer.mx;
                        this.exit_my = this.myplayer.my;
                        this.state = 2;
                        this.myinventory.copy();
                        for (n = 0; n < this.mymap.mine_npc[0].count; ++n) {
                            this.mymap.mine_npc[n].reset();
                        }
                        this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                        this.mymap.restore(this.state);
                        for (n = 0; n < 13; ++n) {
                            for (int i = 0; i < 19; ++i) {
                                if (this.mymap.sqr(this.myplayer.mx * 20 + i, this.myplayer.my * 13 + n) != 5) continue;
                                this.myplayer.x = i;
                                this.myplayer.y = n;
                            }
                        }
                    }
                    if (this.talk == -1) {
                        switch (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy() - 1)) {
                            case 8: {
                                this.talk = 8;
                                break;
                            }
                            case 9: {
                                this.talk = 9;
                            }
                        }
                        if (this.talk == 8) {
                            if (this.mytask[1].state == 0) {
                                this.showpage = 0;
                            }
                            if (this.mytask[1].state == 1) {
                                this.task_update(1);
                                if (this.mytask[1].isdone()) {
                                    this.showpage = 2;
                                    this.myinventory.remove("Oats", 1);
                                    this.myinventory.remove("Milk", 1);
                                    this.myinventory.remove("Cherry", 2);
                                    this.myinventory.remove("Apple", 2);
                                    this.myinventory.remove("Fish", 2);
                                    this.myinventory.add("Air Stone");
                                    this.myplayer.task = 0;
                                } else {
                                    this.showpage = 1;
                                }
                            }
                            if (this.mytask[1].state == 3) {
                                this.showpage = 3;
                            }
                        }
                        if (this.talk != 9) break;
                        if (this.mytask[2].state == 0) {
                            this.showpage = this.mytask[1].state != 3 ? 4 : 5;
                        }
                        if (this.mytask[2].state == 1) {
                            this.task_update(2);
                            if (this.mytask[2].isdone()) {
                                this.showpage = 6;
                                this.myinventory.remove("Sweets", 1);
                                this.mymap.replace(this.state, 13, 0);
                                this.mymap.restore(this.state);
                                this.myplayer.task = 0;
                            } else {
                                this.showpage = 7;
                            }
                        }
                        if (this.mytask[2].state != 3) break;
                        this.showpage = 8;
                        break;
                    }
                    if (this.talk == 9) {
                        ++this.showpage;
                        if (this.mytask[2].state == 0 && this.showpage == 5) {
                            this.talk = -1;
                        }
                        if (this.mytask[2].state == 0 && this.showpage == 6) {
                            this.myplayer.task = 2;
                            this.mytask[2].state = 1;
                            this.talk = -1;
                        }
                        if (this.mytask[2].state == 1 && this.showpage == 8) {
                            this.talk = -1;
                        }
                        if (this.mytask[2].state == 2 && this.showpage == 7) {
                            this.mytask[2].state = 3;
                            this.talk = -1;
                        }
                        if (this.mytask[2].state == 3 && this.showpage == 9) {
                            this.talk = -1;
                        }
                    }
                    if (this.talk == 8) {
                        ++this.showpage;
                        if (this.mytask[1].state == 0 && this.showpage == 1) {
                            this.myplayer.task = 1;
                            this.mytask[1].state = 1;
                            this.talk = -1;
                        }
                        if (this.mytask[1].state == 1 && this.showpage == 2) {
                            this.talk = -1;
                        }
                        if (this.mytask[1].state == 2 && this.showpage == 3) {
                            this.mytask[1].state = 3;
                            this.talk = -1;
                        }
                        if (this.mytask[1].state == 3 && this.showpage == 4) {
                            this.talk = -1;
                        }
                    }
                    this.talk = -1;
                    break;
                }
                case 15: {
                    this.state = 1;
                    this.myplayer.x = this.exit_x;
                    this.myplayer.y = this.exit_y;
                    this.myplayer.mx = this.exit_mx;
                    this.myplayer.my = this.exit_my;
                    this.myplayer.ox = 0;
                    this.myplayer.oy = 0;
                    this.myplayer.xdir = 0;
                    this.myplayer.ydir = 0;
                    this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                    this.mymap.restore(this.state);
                    this.myinventory.restore();
                    break;
                }
                case 14: {
                    this.state = 1;
                    this.myplayer.x = this.exit_x;
                    this.myplayer.y = this.exit_y;
                    this.myplayer.mx = this.exit_mx;
                    this.myplayer.my = this.exit_my;
                    this.myplayer.ox = 0;
                    this.myplayer.oy = 0;
                    this.myplayer.xdir = 0;
                    this.myplayer.ydir = 0;
                    this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                    this.mymap.restore(this.state);
                    this.myinventory.restore();
                    break;
                }
                case 13: {
                    this.state = 1;
                    this.myplayer.x = this.exit_x;
                    this.myplayer.y = this.exit_y;
                    this.myplayer.mx = this.exit_mx;
                    this.myplayer.my = this.exit_my;
                    this.myplayer.ox = 0;
                    this.myplayer.oy = 0;
                    this.myplayer.xdir = 0;
                    this.myplayer.ydir = 0;
                    this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                    this.mymap.restore(this.state);
                    this.myinventory.restore();
                    break;
                }
                case 12: {
                    this.state = this.resume_state;
                    break;
                }
                case 7: {
                    if (this.talk == -1) {
                        if (this.mymap.sqr(this.myplayer.actualx(), this.myplayer.actualy()) == 10) {
                            this.talk = 10;
                        }
                        if (this.mymap.sqr(this.myplayer.actualx() - 1, this.myplayer.actualy()) == 10) {
                            this.talk = 10;
                        }
                        if (this.mymap.sqr(this.myplayer.actualx() + 1, this.myplayer.actualy()) == 10) {
                            this.talk = 10;
                        }
                        if (this.talk != 10) break;
                        if (this.mytask[3].state == 0) {
                            this.showpage = 9;
                        }
                        if (this.mytask[3].state != 1) break;
                        this.task_update(3);
                        if (this.mytask[3].isdone()) {
                            this.mytask[3].state = 2;
                            this.showpage = 20;
                            break;
                        }
                        this.showpage = 30;
                        break;
                    }
                    if (this.talk != 10) break;
                    ++this.showpage;
                    if (this.showpage == 14) {
                        this.talk = -1;
                    }
                    if (this.showpage == 26) {
                        this.talk = -1;
                        this.mydialog.txt(98);
                        this.state = 8;
                    }
                    if (this.showpage != 31) break;
                    this.talk = -1;
                }
            }
        }
        if (this.state != 0 && this.state != 8) {
            if (c == 't') {
                if (this.state != 12) {
                    this.resume_state = this.state;
                    this.task_update(this.myplayer.task);
                    this.mytask[this.myplayer.task].update();
                    this.state = 12;
                } else {
                    this.state = this.resume_state;
                }
            }
            if (c == '\u001b') {
                this.mymap.mappos(0, 0);
                this.mymap.restore(1);
                this.state = 0;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.talk == -1) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 32: {
                    this.fire = true;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.up = false;
                break;
            }
            case 40: {
                this.down = false;
                break;
            }
            case 37: {
                this.left = false;
                break;
            }
            case 39: {
                this.right = false;
                break;
            }
            case 32: {
                this.fire = false;
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.state == 0) {
            this.setgamestate(this.state);
        } else {
            this.setgamestate(this.state);
        }
    }

    private void setgamestate(int n) {
        switch (n) {
            case 0: {
                int n2;
                this.state = 1;
                this.myplayer.x = 5;
                this.myplayer.y = 5;
                this.myplayer.mx = 0;
                this.myplayer.my = 0;
                this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                this.mymap.load(5);
                this.mymap.load(1);
                this.mymap.load(2);
                this.mymap.load(7);
                this.mymap.load(6);
                this.showpage = -1;
                this.talk = -1;
                this.myjelly.gotstone = 0;
                this.mymap.restore(this.state);
                this.myinventory.clear();
                if (false) {
                    this.state = 7;
                    this.mymap.restore(this.state);
                    this.myplayer.x = 5;
                    this.myplayer.y = 8;
                    this.myplayer.mx = 2;
                    this.myplayer.my = 2;
                    this.mymap.mappos(this.myplayer.mx, this.myplayer.my);
                    this.myinventory.add("Cherry");
                    this.myinventory.add("Cherry");
                    this.myinventory.add("Apple");
                    this.myinventory.add("Apple");
                    this.myinventory.add("Milk");
                    this.myinventory.add("Oats");
                    this.myinventory.add("Fish");
                    this.myinventory.add("Fish");
                    this.myinventory.add("Sweets");
                    this.myinventory.add("Air Stone");
                    this.myinventory.add("Earth Stone");
                    this.myinventory.add("Fire Stone");
                    this.myinventory.add("Water Stone");
                    this.myinventory.add("Fish");
                    for (n2 = 0; n2 < 50; ++n2) {
                        this.myinventory.add("Diamond");
                    }
                }
                for (n2 = 0; n2 < this.mytask.length; ++n2) {
                    this.mytask[n2].set(n2);
                }
                break;
            }
        }
    }

    private void task_update(int n) {
        for (int i = 0; i < this.mytask[n].current.length; ++i) {
            this.mytask[n].current[i] = this.myinventory.count(this.mytask[n].required[i]);
        }
    }

    private void grey() {
        for (int i = 0; i < this.sheight - 64; i += 2) {
            for (int j = 0; j < this.swidth; j += 2) {
            }
        }
    }
}

