/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Blockdrop
extends JPanel
implements KeyListener {
    FontMetrics fmetric;
    Random rand;
    static final String title = "Block Drop";
    static final String url = "https://ssjx.co.uk";
    static final String version = "v0.4a (15/09/2024)";
    static final int swidth = 480;
    static final int sheight = 480;
    static final int fps = 25;
    static int fpsdelay = 40;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean moveleft = false;
    boolean moveright = false;
    boolean moveup = false;
    boolean movedown = false;
    Playerxy player = new Playerxy();
    int level = 1;
    int[] hiscore = new int[]{10, 10};
    int block_range = 0;
    int game_select = 0;
    int alt = 0;
    int fc = 0;
    int tim = 0;
    boolean fall = false;
    static final int grid_width = 6;
    static final int grid_height = 13;
    int[][] grid = new int[6][13];
    int[][] grid_remove = new int[6][13];
    int[] player_blocks = new int[]{0, 0, 0};
    int[] next_blocks = new int[]{0, 0, 0};
    final byte[] over_text = new byte[]{2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 2, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 2};
    int[] target = new int[]{0, 0, 0, 0, 0, 0, 0};
    static State gamestate = State.WELCOME;
    Game gametype = Game.NORMAL;
    static Image bg_img;
    static Image txt_img;
    static Image[] sprite;
    final Font smlFont = new Font("Arial", 0, 16);
    final Font medFont = new Font("Arial", 0, 18);
    final Font bigFont = new Font("Arial", 0, 24);
    final Font titleFont = new Font("Arial", 0, 38);
    Explosion exp = new Explosion();
    static Color[] rainbow;
    boolean drawnow = true;
    String[] info_headings = new String[]{"Score", "Blocks"};

    public Blockdrop() {
        URL uRL;
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(480, 480));
        this.addKeyListener(this);
        Blockdrop.rainbow[0] = Color.red;
        Blockdrop.rainbow[1] = Color.orange;
        Blockdrop.rainbow[2] = Color.yellow;
        Blockdrop.rainbow[3] = Color.green;
        Blockdrop.rainbow[4] = Color.blue;
        Blockdrop.rainbow[5] = new Color(75, 0, 130);
        Blockdrop.rainbow[6] = new Color(238, 130, 238);
        String[] stringArray = new String[]{"blank", "orange", "pink", "purple", "yellow", "red", "blue", "solid", "bomb", "vbomb"};
        int n = 0;
        for (String string : stringArray) {
            try {
                uRL = Blockdrop.class.getClassLoader().getResource("gfx/" + string + ".gif");
                Blockdrop.sprite[n] = new ImageIcon(uRL).getImage();
            }
            catch (Exception exception) {
                System.out.println("Main: Exception loading " + string);
            }
            ++n;
        }
        try {
            uRL = Blockdrop.class.getClassLoader().getResource("gfx/solid.gif");
            bg_img = new ImageIcon(uRL).getImage();
            uRL = Blockdrop.class.getClassLoader().getResource("gfx/red16.gif");
            txt_img = new ImageIcon(uRL).getImage();
        }
        catch (Exception exception) {
            System.out.println("Main: Exception loading either solid or red16 graphics");
        }
        this.rand = new Random();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Blockdrop.this.update();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Block Drop v0.4a (15/09/2024) https://ssjx.co.uk");
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Blockdrop());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void reset() {
        this.player.x = 3;
        this.player.y = 0;
        this.player.score = 0;
        this.player.blocks = 0;
        this.player.time = 60;
        this.up = false;
        this.down = false;
        this.left = false;
        this.right = false;
        this.fall = false;
        this.block_range = 4;
        this.next_blocks[0] = 1 + this.rand.nextInt(this.block_range);
        this.next_blocks[1] = 1 + this.rand.nextInt(this.block_range);
        this.next_blocks[2] = 1 + this.rand.nextInt(this.block_range);
        this.set_player_blocks();
        this.exp.reset();
        this.clear_grid();
        if (this.gametype == Game.TARGET) {
            for (int i = 0; i < this.target.length; ++i) {
                this.target[i] = 0;
            }
            this.level = 1;
            this.set_target();
        }
    }

    void clear_grid() {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.grid[j][i] = 0;
            }
        }
    }

    void set_target() {
        if (this.block_range > 6) {
            this.block_range = 6;
            ++this.level;
        }
        int n = 1;
        while (n < 1 + this.block_range) {
            int n2 = n++;
            this.target[n2] = this.target[n2] + this.level * 3;
        }
    }

    boolean met_target() {
        for (int n : this.target) {
            if (n <= 0) continue;
            return false;
        }
        return true;
    }

    void set_player_blocks() {
        this.player_blocks[0] = this.next_blocks[0];
        this.player_blocks[1] = this.next_blocks[1];
        this.player_blocks[2] = this.next_blocks[2];
        if (this.block_range == 8) {
            if (this.rand.nextInt(9) == 1) {
                this.next_blocks[0] = 1 + this.rand.nextInt(this.block_range);
                this.next_blocks[1] = 1 + this.rand.nextInt(this.block_range);
                this.next_blocks[2] = 1 + this.rand.nextInt(this.block_range);
            } else {
                this.next_blocks[0] = 1 + this.rand.nextInt(this.block_range - 3);
                this.next_blocks[1] = 1 + this.rand.nextInt(this.block_range - 3);
                this.next_blocks[2] = 1 + this.rand.nextInt(this.block_range - 3);
            }
        } else {
            this.next_blocks[0] = 1 + this.rand.nextInt(this.block_range);
            this.next_blocks[1] = 1 + this.rand.nextInt(this.block_range);
            this.next_blocks[2] = 1 + this.rand.nextInt(this.block_range);
        }
    }

    void rotate_player_blocks_down() {
        int n = this.player_blocks[0];
        this.player_blocks[0] = this.player_blocks[1];
        this.player_blocks[1] = this.player_blocks[2];
        this.player_blocks[2] = n;
    }

    void rotate_player_blocks_up() {
        int n = this.player_blocks[2];
        this.player_blocks[2] = this.player_blocks[1];
        this.player_blocks[1] = this.player_blocks[0];
        this.player_blocks[0] = n;
    }

    void setstate(State state) {
        switch (state) {
            case WELCOME: {
                if (this.gametype == Game.NORMAL && this.player.score > this.hiscore[0]) {
                    this.hiscore[0] = this.player.score;
                }
                if (this.gametype != Game.TARGET || this.player.score <= this.hiscore[1]) break;
                this.hiscore[1] = this.player.score;
                break;
            }
            case GAME: {
                this.reset();
            }
        }
        gamestate = state;
        this.drawnow = true;
    }

    public void update() {
        switch (gamestate) {
            case GAME: {
                this.alt = 1 - this.alt;
                ++this.fc;
                if (this.fc == 4) {
                    this.fc = 0;
                }
                this.drawnow = true;
                break;
            }
            case UPDATE: {
                int n = this.grid_mark();
                this.fc = 0;
                if (n > 0) {
                    this.player.blocks += n;
                    switch (this.gametype) {
                        case NORMAL: {
                            if (this.player.blocks >= 50 && this.block_range == 4) {
                                this.block_range = 5;
                            }
                            if (this.player.blocks >= 100 && this.block_range == 5) {
                                this.block_range = 6;
                            }
                            if (this.player.blocks >= 120 && this.block_range == 6) {
                                this.block_range = 7;
                            }
                            if (this.player.blocks < 130 || this.block_range != 7) break;
                            this.block_range = 9;
                            break;
                        }
                        case TARGET: {
                            this.player.time += this.line_score(n);
                            if (!this.met_target()) break;
                            this.grid[0][12] = 8;
                            this.player.score += 20;
                            ++this.block_range;
                            this.set_target();
                        }
                    }
                    gamestate = State.EXPLODE;
                } else {
                    gamestate = State.GAME;
                }
                this.drawnow = true;
                break;
            }
            case EXPLODE: {
                this.exp.update();
                ++this.fc;
                if (this.fc == 8) {
                    this.fc = 0;
                    this.check_grid();
                    gamestate = State.UPDATE;
                }
                this.drawnow = true;
            }
        }
        if (this.drawnow) {
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.draw_bg(graphics);
        switch (gamestate) {
            case WELCOME: {
                this.draw_title(graphics);
                this.draw_footer(graphics);
                break;
            }
            case GAME: {
                this.draw_game(graphics);
                break;
            }
            case PAUSED: {
                this.draw_gamescreen(graphics);
                String[] stringArray = new String[]{"- PAUSED -", "Press P or Space to continue!"};
                int n = 314;
                graphics.setFont(this.bigFont);
                graphics.setColor(Color.yellow);
                this.fmetric = graphics.getFontMetrics(this.bigFont);
                for (String string : stringArray) {
                    int n2 = (480 - this.fmetric.stringWidth(string)) / 2;
                    graphics.drawString(string, n2, n);
                    n += 20;
                }
                break;
            }
            case UPDATE: {
                this.draw_game(graphics);
                break;
            }
            case EXPLODE: {
                this.draw_game_exp(graphics);
                this.exp.draw(graphics);
                break;
            }
            case OVER: {
                this.draw_gameover(graphics);
            }
        }
    }

    void draw_bg(Graphics graphics) {
        for (int i = 0; i < 480; i += 32) {
            for (int j = 0; j < 480; j += 32) {
                graphics.drawImage(bg_img, j, i, null);
            }
        }
    }

    void draw_footer(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 460, 480, 20);
        graphics.setColor(Color.white);
        graphics.setFont(this.smlFont);
        graphics.drawString(url, 360, 476);
        graphics.drawString(version, 2, 476);
    }

    void draw_title(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(Color.black);
        graphics.fillRect(16, 16, 448, 432);
        int n3 = 40;
        graphics.setColor(Color.blue);
        graphics.setFont(this.titleFont);
        graphics.drawString(title, n3, 68);
        int n4 = 0;
        this.fmetric = graphics.getFontMetrics(this.titleFont);
        for (int i = 0; i < title.length(); ++i) {
            n2 = title.charAt(i);
            int n5 = this.fmetric.stringWidth("" + (char)n2);
            if (n2 != 32) {
                graphics.setColor(rainbow[n4]);
                graphics.drawString("" + (char)n2, n3, 68);
                if (++n4 >= rainbow.length) {
                    n4 = 0;
                }
            }
            n3 += n5;
        }
        String[] stringArray = new String[]{"Use the Arrow and Space keys to", "create lines of 3 or more blocks!", "", "Select a game type below to start:"};
        n2 = 134;
        graphics.setColor(Color.white);
        graphics.setFont(this.bigFont);
        String[] stringArray2 = stringArray;
        int n6 = stringArray2.length;
        for (n = 0; n < n6; ++n) {
            String string = stringArray2[n];
            if (!string.equals("")) {
                graphics.drawString(string, 40, n2);
            }
            n2 += 22;
        }
        graphics.setFont(this.medFont);
        n2 = 224;
        for (int i = 0; i < 2; ++i) {
            switch (i) {
                case 0: {
                    stringArray[0] = "Standard Game";
                    stringArray[1] = "Keep playing until you lose or get bored!";
                    stringArray[2] = "";
                    stringArray[3] = "High Score: " + this.hiscore[0];
                    break;
                }
                case 1: {
                    stringArray[0] = "Target Game";
                    stringArray[1] = "Remove specific numbers of each block!";
                    stringArray[2] = "";
                    stringArray[3] = "High Score: " + this.hiscore[1];
                }
            }
            if (this.game_select == i) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.fillRect(32, n2, 416, 90);
            graphics.setColor(Color.black);
            graphics.fillRect(36, n2 + 4, 408, 82);
            Color color = Color.white;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals("")) {
                    switch (n) {
                        case 0: {
                            color = Color.cyan;
                            break;
                        }
                        case 1: {
                            color = Color.yellow;
                            break;
                        }
                        default: {
                            color = Color.white;
                        }
                    }
                    graphics.setColor(color);
                    graphics.drawString(stringArray[n], 40, n2 + 20);
                }
                n2 += 20;
            }
            n2 += 24;
        }
    }

    void draw_block(Graphics graphics, int n, int n2, int n3) {
        graphics.drawImage(sprite[0], (n2 += 2) * 32, ++n3 * 32, null);
        graphics.drawImage(sprite[n], n2 * 32, n3 * 32, null);
    }

    void draw_player_blocks(Graphics graphics, int n, int n2) {
        int n3 = (this.player.x + 2) * 32;
        int n4 = (n + 1) * 32 + this.player.ofy;
        graphics.drawImage(sprite[n2], n3, n4, null);
    }

    void clear_remove() {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.grid_remove[j][i] = 0;
            }
        }
    }

    int line_score(int n) {
        int n2 = 0;
        for (int i = 0; i < n + 1; ++i) {
            n2 += i;
        }
        return n2;
    }

    int grid_mark() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < 13; ++n6) {
            n5 = this.grid[0][n6];
            n4 = 0;
            n3 = 1;
            for (n2 = 1; n2 < 6; ++n2) {
                this.grid_remove[n2][n6] = 0;
                if (n5 == 7) {
                    n5 = 0;
                }
                if (this.grid[n2][n6] == n5) {
                    ++n3;
                    continue;
                }
                if (n3 >= 3 && n5 != 0) {
                    switch (this.gametype) {
                        case NORMAL: {
                            this.player.score += this.line_score(n3);
                            break;
                        }
                        case TARGET: {
                            if (this.target[n5] <= 0) break;
                            int n7 = n5;
                            this.target[n7] = this.target[n7] - n3;
                            if (this.target[n5] < 0) {
                                this.target[n5] = 0;
                            }
                            if (this.target[n5] != 0) break;
                            this.player.score += 10;
                        }
                    }
                    for (n = n4; n < n4 + n3; ++n) {
                        this.grid_remove[n][n6] = -1;
                    }
                }
                n4 = n2;
                n5 = this.grid[n2][n6];
                n3 = 1;
            }
            if (n3 < 3 || n5 == 0) continue;
            switch (this.gametype) {
                case NORMAL: {
                    this.player.score += this.line_score(n3);
                    break;
                }
                case TARGET: {
                    if (this.target[n5] <= 0) break;
                    int n8 = n5;
                    this.target[n8] = this.target[n8] - n3;
                    if (this.target[n5] < 0) {
                        this.target[n5] = 0;
                    }
                    if (this.target[n5] != 0) break;
                    this.player.score += 10;
                }
            }
            for (n2 = n4; n2 < n4 + n3; ++n2) {
                this.grid_remove[n2][n6] = -1;
            }
        }
        for (n6 = 0; n6 < 6; ++n6) {
            n5 = this.grid[n6][0];
            n4 = 0;
            n3 = 1;
            for (n2 = 1; n2 < 13; ++n2) {
                if (n5 == 7) {
                    n5 = 0;
                }
                if (this.grid[n6][n2] == n5) {
                    ++n3;
                    continue;
                }
                if (n3 >= 3 && n5 != 0) {
                    switch (this.gametype) {
                        case NORMAL: {
                            this.player.score += this.line_score(n3);
                            break;
                        }
                        case TARGET: {
                            if (this.target[n5] <= 0) break;
                            int n9 = n5;
                            this.target[n9] = this.target[n9] - n3;
                            if (this.target[n5] < 0) {
                                this.target[n5] = 0;
                            }
                            if (this.target[n5] != 0) break;
                            this.player.score += 10;
                        }
                    }
                    for (n = n4; n < n4 + n3; ++n) {
                        this.grid_remove[n6][n] = -1;
                    }
                }
                n4 = n2;
                n5 = this.grid[n6][n2];
                n3 = 1;
            }
            if (n3 < 3 || n5 == 0) continue;
            switch (this.gametype) {
                case NORMAL: {
                    this.player.score += this.line_score(n3);
                    break;
                }
                case TARGET: {
                    if (this.target[n5] <= 0) break;
                    int n10 = n5;
                    this.target[n10] = this.target[n10] - n3;
                    if (this.target[n5] < 0) {
                        this.target[n5] = 0;
                    }
                    if (this.target[n5] != 0) break;
                    this.player.score += 10;
                }
            }
            for (n2 = n4; n2 < n4 + n3; ++n2) {
                this.grid_remove[n6][n2] = -1;
            }
        }
        n6 = 0;
        for (n2 = 0; n2 < 13; ++n2) {
            for (n = 0; n < 6; ++n) {
                if (this.grid[n][n2] != 8) continue;
                n6 = 1;
            }
            if (n6 != 1) continue;
            n6 = 0;
            this.player.score += this.line_score(6);
            for (n = 0; n < 6; ++n) {
                if (this.grid[n][n2] <= 0) continue;
                this.grid_remove[n][n2] = -1;
            }
        }
        n6 = 0;
        for (n2 = 0; n2 < 6; ++n2) {
            for (n = 0; n < 13; ++n) {
                if (this.grid[n2][n] != 9) continue;
                n6 = 1;
            }
            if (n6 != 1) continue;
            n6 = 0;
            this.player.score += this.line_score(13);
            for (n = 0; n < 13; ++n) {
                if (this.grid[n2][n] <= 0) continue;
                this.grid_remove[n2][n] = -1;
            }
        }
        this.exp.reset();
        int n11 = 0;
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (this.grid_remove[j][i] != -1) continue;
                this.exp.add((j + 2) * 32, (i + 1) * 32, this.grid[j][i]);
                ++n11;
            }
        }
        return n11;
    }

    int check_grid() {
        int n;
        int n2;
        for (n2 = 0; n2 < 13; ++n2) {
            for (n = 0; n < 6; ++n) {
                if (this.grid_remove[n][n2] != -1) continue;
                this.grid_remove[n][n2] = 0;
                this.grid[n][n2] = 0;
            }
        }
        n = 0;
        do {
            n2 = 0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 12; ++j) {
                    if (this.grid[i][j] == 0 || this.grid[i][j + 1] != 0) continue;
                    this.grid[i][j + 1] = this.grid[i][j];
                    this.grid[i][j] = 0;
                    n2 = 1;
                    n = 1;
                }
            }
        } while (n2 == 1);
        if (n == 1) {
            return 1;
        }
        return 0;
    }

    void info_panel(Graphics graphics) {
        int n = 152;
        graphics.setColor(Color.black);
        graphics.fillRect(288, n, 128, 128);
        graphics.setColor(Color.yellow);
        graphics.setFont(this.medFont);
        for (String string : this.info_headings) {
            graphics.drawString(string, 292, n + 18);
            n += 64;
        }
        n = 184;
        int[] nArray = new int[]{this.player.score, this.player.blocks};
        graphics.setColor(Color.cyan);
        for (int n2 : nArray) {
            graphics.drawString("" + n2, 292, n + 18);
            n += 64;
        }
    }

    void info_target(Graphics graphics) {
        int n = 152;
        graphics.setColor(Color.black);
        graphics.fillRect(288, n, 128, 64);
        graphics.setFont(this.medFont);
        graphics.setColor(Color.yellow);
        graphics.drawString("Score:", 292, n + 18);
        graphics.setColor(Color.cyan);
        graphics.drawString("" + this.player.score, 292, n + 32 + 18);
        n = 224;
        graphics.setColor(Color.black);
        graphics.fillRect(288, n, 128, 224);
        graphics.setColor(Color.yellow);
        graphics.drawString("Targets:", 292, n + 18);
        n += 32;
        graphics.setColor(Color.cyan);
        for (int i = 0; i < this.target.length; ++i) {
            if (this.target[i] <= 0) continue;
            graphics.drawImage(sprite[i], 304, n, null);
            graphics.drawString(" x " + this.target[i], 336, n + 10 + 18);
            n += 32;
        }
    }

    void draw_game_exp(Graphics graphics) {
        int n;
        int n2;
        for (n2 = 0; n2 < 480; n2 += 32) {
            for (n = 0; n < 480; n += 32) {
                graphics.drawImage(bg_img, n, n2, null);
            }
        }
        for (n2 = 0; n2 < 13; ++n2) {
            for (n = 0; n < 6; ++n) {
                if (this.grid_remove[n][n2] == 0) {
                    this.draw_block(graphics, this.grid[n][n2], n, n2);
                    continue;
                }
                this.draw_block(graphics, 0, n, n2);
            }
        }
        this.draw_block(graphics, this.next_blocks[2], 7, 0);
        this.draw_block(graphics, this.next_blocks[1], 7, 1);
        this.draw_block(graphics, this.next_blocks[0], 7, 2);
        if (this.gametype == Game.NORMAL) {
            this.info_panel(graphics);
        }
        if (this.gametype == Game.TARGET) {
            this.info_target(graphics);
        }
    }

    void draw_gamescreen(Graphics graphics) {
        int n;
        int n2;
        if (gamestate == State.PAUSED) {
            for (n2 = 0; n2 < 13; ++n2) {
                for (n = 0; n < 6; ++n) {
                    if (this.grid[n][n2] == 0) {
                        this.draw_block(graphics, 0, n, n2);
                        continue;
                    }
                    this.draw_block(graphics, 7, n, n2);
                }
            }
        } else {
            for (n2 = 0; n2 < 13; ++n2) {
                for (n = 0; n < 6; ++n) {
                    this.draw_block(graphics, this.grid[n][n2], n, n2);
                }
            }
        }
        this.draw_player_blocks(graphics, this.player.y, this.player_blocks[0]);
        this.draw_player_blocks(graphics, this.player.y - 1, this.player_blocks[1]);
        this.draw_player_blocks(graphics, this.player.y - 2, this.player_blocks[2]);
        for (n = 0; n < 480; n += 32) {
            graphics.drawImage(bg_img, n, 0, null);
        }
        if (this.gametype == Game.NORMAL) {
            this.info_panel(graphics);
        }
        if (this.gametype == Game.TARGET) {
            this.info_target(graphics);
        }
        this.draw_block(graphics, this.next_blocks[2], 7, 0);
        this.draw_block(graphics, this.next_blocks[1], 7, 1);
        this.draw_block(graphics, this.next_blocks[0], 7, 2);
    }

    void draw_game(Graphics graphics) {
        this.draw_gamescreen(graphics);
        if (this.player.y == -1 && this.grid[this.player.x][0] != 0) {
            this.setstate(State.OVER);
            return;
        }
        boolean bl = false;
        if (this.player.y == 12) {
            bl = true;
        } else if (this.player.y + 1 >= 0 && this.player.y + 1 <= 12 && this.grid[this.player.x][this.player.y + 1] != 0) {
            bl = true;
        }
        if (bl) {
            if (this.player.y < 0) {
                this.setstate(State.OVER);
                return;
            }
            this.grid[this.player.x][this.player.y] = this.player_blocks[0];
            if (this.player.y - 1 < 0) {
                this.setstate(State.OVER);
                return;
            }
            this.grid[this.player.x][this.player.y - 1] = this.player_blocks[1];
            if (this.player.y - 2 < 0) {
                this.setstate(State.OVER);
                return;
            }
            this.grid[this.player.x][this.player.y - 2] = this.player_blocks[2];
            this.player.y = -2;
            this.fall = false;
            this.set_player_blocks();
            this.setstate(State.UPDATE);
        } else {
            int n;
            if (!this.fall) {
                this.player.ofy += 4;
                if (this.player.ofy == 32) {
                    this.player.ofy = 0;
                    ++this.player.y;
                }
            } else {
                if (this.player.ofy > 0) {
                    this.player.ofy = 0;
                }
                ++this.player.y;
                this.movedown = false;
            }
            if (this.moveleft) {
                if (this.player.x > 0) {
                    n = 0;
                    if (this.player.ofy > 0) {
                        n = 1;
                    }
                    if (this.player.y >= 0 && this.player.y <= 13) {
                        if (this.grid[this.player.x - 1][this.player.y + n] == 0) {
                            --this.player.x;
                        }
                    } else {
                        --this.player.x;
                    }
                }
                this.moveleft = false;
            }
            if (this.moveright) {
                if (this.player.x < 5) {
                    n = 0;
                    if (this.player.ofy > 0) {
                        n = 1;
                    }
                    if (this.player.y >= 0 && this.player.y <= 13) {
                        if (this.grid[this.player.x + 1][this.player.y + n] == 0) {
                            ++this.player.x;
                        }
                    } else {
                        ++this.player.x;
                    }
                }
                this.moveright = false;
            }
            if (this.moveup) {
                this.rotate_player_blocks_up();
                this.moveup = false;
            }
        }
    }

    void draw_gameover(Graphics graphics) {
        this.draw_gamescreen(graphics);
        int n = 0;
        n = 0;
        for (int i = 0; i < 11; ++i) {
            int n2 = 128 + i * 16;
            for (int j = 0; j < 20; ++j) {
                if (this.over_text[n] > 0) {
                    int n3 = 80 + j * 16;
                    graphics.drawImage(txt_img, n3, n2, null);
                }
                ++n;
            }
        }
        int n4 = this.hiscore[0];
        if (this.gametype == Game.TARGET) {
            n4 = this.hiscore[1];
        }
        if (this.player.score > n4) {
            graphics.setColor(Color.yellow);
            graphics.setFont(this.bigFont);
            this.fmetric = graphics.getFontMetrics(this.bigFont);
            int n5 = this.fmetric.stringWidth("You have a new high score!");
            graphics.drawString("You have a new high score!", (480 - n5) / 2, 344);
        }
    }

    void draw_welldone(Graphics graphics) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (!this.up) break;
                if (gamestate == State.WELCOME) {
                    this.game_select = 0;
                    this.drawnow = true;
                    break;
                }
                this.moveup = true;
                this.up = false;
                break;
            }
            case 40: {
                if (!this.down) break;
                if (gamestate == State.WELCOME) {
                    this.game_select = 1;
                    this.drawnow = true;
                    break;
                }
                this.movedown = true;
                this.down = false;
                if (this.fall) break;
                this.fall = true;
                break;
            }
            case 37: {
                if (!this.left) break;
                this.moveleft = true;
                this.left = false;
                break;
            }
            case 39: {
                if (!this.right) break;
                this.moveright = true;
                this.right = false;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.up = false;
        this.down = false;
        this.left = false;
        this.right = false;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.up = true;
                break;
            }
            case 40: {
                this.down = true;
                break;
            }
            case 37: {
                this.left = true;
                break;
            }
            case 39: {
                this.right = true;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                if (this.game_select == 0) {
                    this.gametype = Game.NORMAL;
                }
                if (this.game_select == 1) {
                    this.gametype = Game.TARGET;
                }
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c == 'q') {
                    this.setstate(State.OVER);
                }
                if (c == ' ') {
                    this.rotate_player_blocks_down();
                }
                if (c != 'p') break;
                this.setstate(State.PAUSED);
                break;
            }
            case PAUSED: {
                if (c == 'p') {
                    gamestate = State.GAME;
                }
                if (c != ' ') break;
                gamestate = State.GAME;
                break;
            }
            case OVER: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    static {
        sprite = new Image[10];
        rainbow = new Color[7];
    }

    public static enum Game {
        NORMAL,
        TARGET;

    }

    public static enum State {
        WELCOME,
        GAME,
        UPDATE,
        OVER,
        EXPLODE,
        PAUSED;

    }
}

