/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Batty
extends JPanel
implements KeyListener {
    private static final String title = "Batty";
    private static final String url = "https://ssjx.co.uk";
    private static final String version = "v0.2a (15/09/24)";
    private static final int swidth = 480;
    private static final int sheight = 480;
    private static final int fps = 60;
    private static int fpsdelay = 16;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean fire = false;
    int[][] grid = new int[10][15];
    int[][] col = new int[10][15];
    Playerxy player = new Playerxy();
    Image[] player_img = new Image[4];
    Playerxy ball = new Playerxy();
    Rectangle bat_rect = new Rectangle(64, 16);
    Rectangle bat_end = new Rectangle(8, 16);
    Rectangle ball_rect = new Rectangle(16, 16);
    Rectangle block_rect = new Rectangle(48, 24);
    BonusItem bonus = BonusItem.NONE;
    BonusItem active_bonus = BonusItem.NONE;
    int bonus_timer = 0;
    Rectangle bonus_rect = new Rectangle(32, 32);
    Image[] bonus_img = new Image[4];
    Boolean[] shot_active = new Boolean[20];
    Rectangle[] shot_rect = new Rectangle[20];
    Image shot_img;
    int score = 0;
    int hiscore = 10;
    int level = 1;
    int clen = 10;
    String score_str;
    int fc = 0;
    int firecount = 0;
    private FontMetrics fmetric;
    final int[] over_text = new int[]{2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 2, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 2};
    final int[] title_text = new int[]{1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0};
    final int[] welldone_text = new int[]{1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1};
    State gamestate = State.WELCOME;
    Image ball_img;
    Image bg_img;
    Image shadow_img;
    Image blackball_img;
    Image[] block_img = new Image[10];
    private final Font medFont = new Font("Arial", 0, 16);
    private final Font bigFont = new Font("Arial", 0, 20);
    String[] title_line = new String[]{"Use the arrows and space key to", "destroy the block wall!", "", "High Score", "", "", "Recent Score", "", "", "Press Space to start!"};
    boolean drawnow = true;

    public Batty() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(480, 480));
        this.addKeyListener(this);
        try {
            URL uRL = Batty.class.getClassLoader().getResource("gfx/bg.gif");
            this.bg_img = ImageIO.read(uRL);
            uRL = Batty.class.getClassLoader().getResource("gfx/block-shadow.gif");
            this.shadow_img = ImageIO.read(uRL);
            uRL = Batty.class.getClassLoader().getResource("gfx/ball.gif");
            this.ball_img = ImageIO.read(uRL);
            uRL = Batty.class.getClassLoader().getResource("gfx/black-ball.gif");
            this.blackball_img = ImageIO.read(uRL);
            uRL = Batty.class.getClassLoader().getResource("gfx/shot.gif");
            this.shot_img = ImageIO.read(uRL);
            String[] stringArray = new String[]{"player", "player_laser", "player_small", "player_big"};
            int n = 0;
            for (String string : stringArray) {
                uRL = Batty.class.getClassLoader().getResource("gfx/" + string + ".gif");
                this.player_img[n] = ImageIO.read(uRL);
                ++n;
            }
            String[] stringArray2 = new String[]{"block", "block-red", "block-yellow", "block-green", "block-blue", "block-purple", "block"};
            n = 0;
            for (String string : stringArray2) {
                uRL = Batty.class.getClassLoader().getResource("gfx/" + string + ".gif");
                this.block_img[n] = ImageIO.read(uRL);
                ++n;
            }
            String[] stringArray3 = new String[]{"bonus-smash", "bonus-laser", "bonus-big", "bonus-small"};
            n = 0;
            for (String string : stringArray3) {
                uRL = Batty.class.getClassLoader().getResource("gfx/" + string + ".gif");
                this.bonus_img[n] = ImageIO.read(uRL);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the sprites");
            System.out.println(exception);
        }
        this.score_str = String.valueOf(0);
        this.setstate(this.gamestate);
        for (int i = 0; i < this.shot_rect.length; ++i) {
            this.shot_rect[i] = new Rectangle(16, 16);
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Batty.this.update();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Batty v0.2a (15/09/24) https://ssjx.co.uk");
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Batty());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void reset() {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.grid[j][i] = 0;
                this.col[j][i] = 0;
            }
        }
        this.load(this.level);
        this.score_str = String.valueOf(this.score);
        this.restart();
    }

    void restart() {
        this.ball.xdir = -1;
        this.ball.ydir = -1;
        this.player.y = 408;
        this.player.x = (480 - this.bat_rect.width) / 2;
        this.ball.x = this.player.x + 24;
        this.ball.y = this.player.y - 16;
        this.up = false;
        this.down = false;
        this.left = false;
        this.right = false;
        this.fire = false;
        this.firecount = 0;
        Arrays.fill((Object[])this.shot_active, (Object)false);
        this.bonus_timer = 0;
        this.bonus = BonusItem.NONE;
        this.active_bonus = BonusItem.NONE;
        this.bat_rect.width = 64;
        this.bat_rect.height = 16;
    }

    private void setstate(State state) {
        switch (state) {
            case WELCOME: {
                fpsdelay = 100;
                if (this.score > this.hiscore) {
                    this.hiscore = this.score;
                }
                this.title_line[4] = String.valueOf(this.hiscore);
                this.title_line[7] = String.valueOf(this.score);
                break;
            }
            case READY: {
                break;
            }
            case GAME: {
                fpsdelay = 16;
                break;
            }
            case OVER: {
                fpsdelay = 100;
            }
        }
        this.drawnow = true;
        this.gamestate = state;
    }

    public void update() {
        if (this.gamestate == State.GAME) {
            this.update_game();
            this.drawnow = true;
        }
        if (this.drawnow) {
            this.repaint();
            this.drawnow = false;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.draw_bg(graphics);
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_title(graphics);
                this.draw_footer(graphics);
                break;
            }
            case READY: {
                this.draw_game_static(graphics);
                this.draw_ready(graphics);
                break;
            }
            case GAME: {
                this.draw_game_static(graphics);
                break;
            }
            case OVER: {
                this.draw_game_static(graphics);
                this.draw_gameover(graphics);
                break;
            }
            case COMPLETE: {
                this.draw_game_static(graphics);
                this.draw_welldone(graphics);
            }
        }
    }

    void draw_bg(Graphics graphics) {
        for (int i = 0; i < 480; i += 48) {
            for (int j = 0; j < 480; j += 48) {
                graphics.drawImage(this.bg_img, j, i, null);
            }
        }
    }

    void draw_footer(Graphics graphics) {
        graphics.setFont(this.medFont);
        graphics.setColor(Color.white);
        graphics.drawString(url, 360, 476);
        graphics.drawString(version, 2, 476);
    }

    void draw_title(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < 5; ++n4) {
            n3 = 48 + n4 * 12 + 4;
            for (n2 = 0; n2 < 29; ++n2) {
                if (this.title_text[n5] > 0) {
                    n = 66 + n2 * 12 + 4;
                    graphics.drawImage(this.blackball_img, n, n3, null);
                }
                ++n5;
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < 5; ++n4) {
            n3 = 48 + n4 * 12;
            for (n2 = 0; n2 < 29; ++n2) {
                if (this.title_text[n5] > 0) {
                    n = 66 + n2 * 12;
                    graphics.drawImage(this.ball_img, n, n3, null);
                }
                ++n5;
            }
        }
        for (n4 = 0; n4 < 29; ++n4) {
            n3 = 66 + n4 * 12;
            n2 = 24;
            graphics.drawImage(this.blackball_img, n3 + 4, n2 + 4, null);
            graphics.drawImage(this.ball_img, n3, n2, null);
            n2 = 120;
            graphics.drawImage(this.blackball_img, n3 + 4, n2 + 4, null);
            graphics.drawImage(this.ball_img, n3, n2, null);
        }
        n3 = 172;
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        for (n2 = 0; n2 < this.title_line.length; ++n2) {
            Color color;
            switch (n2) {
                case 3: 
                case 6: {
                    color = Color.orange;
                    break;
                }
                case 9: {
                    color = Color.yellow;
                    break;
                }
                default: {
                    color = Color.white;
                }
            }
            if (this.title_line[n2].length() > 0) {
                graphics.setColor(color);
                graphics.drawString(this.title_line[n2], (480 - this.fmetric.stringWidth(this.title_line[n2])) / 2, n3);
            }
            n3 += 24;
        }
    }

    void draw_game_static(Graphics graphics) {
        int n;
        graphics.drawImage(this.ball_img, this.ball.x, this.ball.y, null);
        for (int i = 0; i < 15; ++i) {
            int n2 = i * 24;
            for (n = 0; n < 10; ++n) {
                if (this.grid[n][i] <= 0) continue;
                int n3 = n * 48;
                graphics.drawImage(this.shadow_img, n3 + 8, n2 + 8, null);
                graphics.drawImage(this.block_img[this.col[n][i]], n3, n2, null);
            }
        }
        switch (this.active_bonus) {
            case BIGBAT: {
                graphics.drawImage(this.player_img[3], this.player.x, this.player.y, null);
                break;
            }
            case SMLBAT: {
                graphics.drawImage(this.player_img[2], this.player.x, this.player.y, null);
                break;
            }
            case LASER: {
                graphics.drawImage(this.player_img[1], this.player.x, this.player.y, null);
                break;
            }
            default: {
                graphics.drawImage(this.player_img[0], this.player.x, this.player.y, null);
            }
        }
        for (n = 0; n < this.player.lives; ++n) {
            graphics.drawImage(this.player_img[2], n * 40, 0, null);
        }
        for (int i = 0; i < this.shot_active.length; ++i) {
            if (!this.shot_active[i].booleanValue()) continue;
            graphics.drawImage(this.shot_img, this.shot_rect[i].x, this.shot_rect[i].y, null);
        }
        if (this.bonus != BonusItem.NONE) {
            switch (this.bonus) {
                case SMASH: {
                    graphics.drawImage(this.bonus_img[0], this.bonus_rect.x, this.bonus_rect.y, null);
                    break;
                }
                case LASER: {
                    graphics.drawImage(this.bonus_img[1], this.bonus_rect.x, this.bonus_rect.y, null);
                    break;
                }
                case BIGBAT: {
                    graphics.drawImage(this.bonus_img[2], this.bonus_rect.x, this.bonus_rect.y, null);
                    break;
                }
                case SMLBAT: {
                    graphics.drawImage(this.bonus_img[3], this.bonus_rect.x, this.bonus_rect.y, null);
                }
            }
        }
        int n4 = 480 - this.fmetric.stringWidth(this.score_str);
        graphics.setColor(Color.yellow);
        graphics.setFont(this.medFont);
        graphics.drawString(this.score_str, n4, 12);
    }

    void update_game() {
        int n;
        for (n = 0; n < this.shot_active.length; ++n) {
            if (!this.shot_active[n].booleanValue()) continue;
            this.shot_rect[n].y -= 4;
        }
        if (this.bonus != BonusItem.NONE) {
            ++this.bonus_rect.y;
            if (this.hit_bonus()) {
                this.active_bonus = this.bonus;
                this.bonus = BonusItem.NONE;
                this.bonus_timer = 10;
                if (this.active_bonus == BonusItem.SMLBAT) {
                    this.bat_rect.width = 32;
                    this.bat_rect.height = 8;
                }
                if (this.active_bonus == BonusItem.BIGBAT) {
                    this.bat_rect.width = 96;
                    this.bat_rect.height = 16;
                }
            }
            if (this.bonus_rect.y > 480) {
                this.bonus = BonusItem.NONE;
            }
        }
        if (this.left && this.player.x > 0) {
            for (n = 0; n < 4; ++n) {
                --this.player.x;
            }
        }
        if (this.right && this.player.x + this.bat_rect.width < 480) {
            for (n = 0; n < 4; ++n) {
                ++this.player.x;
            }
        }
        if (this.firecount == 0) {
            if (this.active_bonus == BonusItem.LASER && this.fire) {
                this.shot_add(this.player.x + 24, this.player.y);
                this.firecount = 20;
            }
        } else {
            --this.firecount;
        }
        if (this.ball.y > 480) {
            --this.player.lives;
            if (this.player.lives < 0) {
                this.setstate(State.OVER);
            } else {
                this.restart();
            }
        }
        ++this.fc;
        switch (this.fc) {
            case 0: 
            case 30: {
                if (!this.grid_clear()) break;
                ++this.level;
                if (this.level > 5) {
                    this.setstate(State.COMPLETE);
                    break;
                }
                this.reset();
                this.setstate(State.READY);
                break;
            }
            case 60: {
                this.fc = 0;
                if (this.bonus_timer <= 0) break;
                --this.bonus_timer;
                if (this.bonus_timer != 0) break;
                this.active_bonus = BonusItem.NONE;
                this.bat_rect.width = 64;
                this.bat_rect.height = 16;
            }
        }
        this.shot_update();
        this.ball_update();
    }

    void draw_gameover(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < 11; ++n4) {
            n3 = 128 + n4 * 16;
            for (n2 = 0; n2 < 20; ++n2) {
                if (this.over_text[n5] > 0) {
                    n = 80 + n2 * 16;
                    graphics.drawImage(this.blackball_img, n + 4, n3 + 4, null);
                }
                ++n5;
            }
        }
        n5 = 0;
        for (n4 = 0; n4 < 11; ++n4) {
            n3 = 128 + n4 * 16;
            for (n2 = 0; n2 < 20; ++n2) {
                if (this.over_text[n5] > 0) {
                    n = 80 + n2 * 16;
                    graphics.drawImage(this.ball_img, n, n3, null);
                }
                ++n5;
            }
        }
        if (this.score > this.hiscore) {
            graphics.setFont(this.bigFont);
            this.fmetric = graphics.getFontMetrics(this.bigFont);
            n2 = 480 - this.fmetric.stringWidth("You have a new high score!") >> 1;
            graphics.drawString("You have a new high score!", n2, 344);
        }
    }

    void draw_ready(Graphics graphics) {
        String string = "Level " + String.valueOf(this.level);
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        int n = 480 - this.fmetric.stringWidth(string) >> 1;
        graphics.drawString(string, n, 344);
    }

    void draw_welldone(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            for (n = 0; n < 35; ++n) {
                if (this.welldone_text[n3] > 0) {
                    graphics.drawImage(this.blackball_img, 30 + n * 12 + 4, 210 + n2 * 12 + 4, null);
                }
                ++n3;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            for (n = 0; n < 35; ++n) {
                if (this.welldone_text[n3] > 0) {
                    graphics.drawImage(this.ball_img, 30 + n * 12, 210 + n2 * 12, null);
                }
                ++n3;
            }
        }
        for (n2 = 0; n2 < 35; ++n2) {
            n = 30 + n2 * 12;
            graphics.drawImage(this.blackball_img, 4 + n, 190, null);
            graphics.drawImage(this.ball_img, n, 186, null);
            graphics.drawImage(this.blackball_img, 4 + n, 286, null);
            graphics.drawImage(this.ball_img, n, 282, null);
        }
        if (this.score > this.hiscore) {
            graphics.setFont(this.bigFont);
            this.fmetric = graphics.getFontMetrics(this.bigFont);
            int n4 = 480 - this.fmetric.stringWidth("You have a new high score!") >> 1;
            graphics.drawString("You have a new high score!", n4, 344);
        }
    }

    public boolean load(int n) {
        boolean bl = false;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("level/" + n + ".bmp");
            byte[] byArray = inputStream.readAllBytes();
            inputStream.close();
            int n2 = byArray[10] + (byArray[11] << 8);
            int n3 = byArray[18] + (byArray[19] << 8);
            int n4 = byArray[22] + (byArray[23] << 8);
            int n5 = byArray[28] + (byArray[29] << 8);
            if (n3 * n4 <= 150) {
                if (n5 == 8) {
                    int n6 = 0;
                    for (int i = n4 - 1; i > -1; --i) {
                        for (int j = 0; j < n3; ++j) {
                            int n7 = byArray[n2 + n6];
                            if (n7 > 0) {
                                this.col[j][i] = n7;
                                this.grid[j][i] = 1;
                                if (n7 == 6) {
                                    this.grid[j][i] = 2;
                                }
                            }
                            ++n6;
                        }
                        n6 += 2;
                    }
                    bl = true;
                } else {
                    System.out.println("Depth should be 8 not " + n5);
                }
            } else {
                System.out.println("Level is too big for map buffer! " + byArray.length + " > 100");
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map...");
        }
        return bl;
    }

    void ball_update() {
        for (int i = 0; i < 2; ++i) {
            if (this.ball.x + this.ball.xdir > 0 && this.ball.x + 16 + this.ball.xdir < 480) {
                this.ball.x += this.ball.xdir;
            } else {
                this.ball.xdir *= -1;
            }
            if (this.ball.y + this.ball.ydir > 0) {
                this.ball.y += this.ball.ydir;
            } else {
                this.ball.ydir *= -1;
            }
            if (this.hit_block(-1, 0)) {
                this.ball.xdir = 1;
            }
            if (this.hit_block(1, 0)) {
                this.ball.xdir = -1;
            }
            if (this.hit_block(0, -1)) {
                this.ball.ydir = 1;
            }
            if (this.hit_block(0, 1)) {
                this.ball.ydir = -1;
            }
            if (!this.hit_bat()) continue;
            this.ball.ydir = -1;
        }
    }

    boolean hit_bonus() {
        this.bat_rect.setLocation(this.player.x, this.player.y);
        if (this.bat_rect.intersects(this.bonus_rect)) {
            return true;
        }
        return this.bonus_rect.intersects(this.bat_rect);
    }

    boolean hit_block(int n, int n2) {
        this.ball_rect.setLocation(this.ball.x + n, this.ball.y + n2);
        for (int i = 0; i < 15; ++i) {
            int n3 = i * 24;
            for (int j = 0; j < 10; ++j) {
                if (this.grid[j][i] <= 0) continue;
                int n4 = j * 48;
                this.block_rect.setLocation(n4, n3);
                if (!this.ball_rect.intersects(this.block_rect)) continue;
                if (this.grid[j][i] > 0) {
                    int[] nArray = this.grid[j];
                    int n5 = i;
                    nArray[n5] = nArray[n5] - 1;
                }
                if (this.grid[j][i] == 0 && this.bonus == BonusItem.NONE && this.active_bonus == BonusItem.NONE && Math.floor(Math.random() * 100.0) > 90.0) {
                    int n6 = (int)Math.floor(Math.random() * 4.0);
                    switch (n6) {
                        case 0: {
                            this.bonus = BonusItem.SMASH;
                            break;
                        }
                        case 1: {
                            this.bonus = BonusItem.LASER;
                            break;
                        }
                        case 2: {
                            this.bonus = BonusItem.BIGBAT;
                            break;
                        }
                        case 3: {
                            this.bonus = BonusItem.SMLBAT;
                        }
                    }
                    this.bonus_rect.x = n4 + 8;
                    this.bonus_rect.y = n3;
                }
                this.score += 10;
                this.score_str = String.valueOf(this.score);
                if (this.active_bonus == BonusItem.SMASH) continue;
                return true;
            }
        }
        return false;
    }

    boolean hit_bat() {
        this.ball_rect.setLocation(this.ball.x, this.ball.y);
        this.bat_rect.setLocation(this.player.x, this.player.y);
        switch (this.active_bonus) {
            case SMLBAT: {
                if (this.ball_rect.intersects(this.bat_rect)) {
                    return true;
                }
                if (!this.bat_rect.intersects(this.ball_rect)) break;
                return true;
            }
            default: {
                if (!this.ball_rect.intersects(this.bat_rect)) break;
                this.bat_end.setLocation(this.player.x, this.player.y);
                if (this.ball_rect.intersects(this.bat_end)) {
                    if (this.ball.xdir == 1) {
                        this.ball.xdir = -1;
                    }
                    return true;
                }
                this.bat_end.setLocation(this.player.x + this.bat_rect.width - this.bat_end.width, this.player.y);
                if (this.ball_rect.intersects(this.bat_end)) {
                    if (this.ball.xdir == -1) {
                        this.ball.xdir = 1;
                    }
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    void shot_add(int n, int n2) {
        for (int i = 0; i < this.shot_active.length; ++i) {
            if (this.shot_active[i].booleanValue()) continue;
            this.shot_active[i] = true;
            this.shot_rect[i].x = n;
            this.shot_rect[i].y = n2;
            break;
        }
    }

    void shot_update() {
        boolean bl = false;
        for (int i = 0; i < this.shot_active.length; ++i) {
            if (!this.shot_active[i].booleanValue()) continue;
            if (this.shot_rect[i].y + 16 < 0) {
                this.shot_active[i] = false;
                continue;
            }
            if (!this.shot_block(i)) continue;
            this.shot_active[i] = false;
        }
    }

    boolean shot_block(int n) {
        for (int i = 0; i < 15; ++i) {
            int n2 = i * 24;
            for (int j = 0; j < 10; ++j) {
                if (this.grid[j][i] <= 0) continue;
                int n3 = j * 48;
                this.block_rect.setLocation(n3, n2);
                if (!this.shot_rect[n].intersects(this.block_rect)) continue;
                this.grid[j][i] = 0;
                this.score += 10;
                this.score_str = String.valueOf(this.score);
                return true;
            }
        }
        return false;
    }

    boolean grid_clear() {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.grid[j][i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    void cheat() {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.grid[j][i] = 0;
                this.col[j][i] = 0;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = false;
                    break;
                }
                case 40: {
                    this.down = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                    break;
                }
                case 32: {
                    this.fire = false;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 32: {
                    if (this.active_bonus != BonusItem.LASER) break;
                    this.fire = true;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                this.level = 1;
                this.player.lives = 3;
                this.score = 0;
                this.reset();
                this.setstate(State.READY);
                break;
            }
            case READY: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != 'q') break;
                this.setstate(State.OVER);
                break;
            }
            case OVER: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
                break;
            }
            case COMPLETE: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    private static enum State {
        WELCOME,
        READY,
        GAME,
        OVER,
        COMPLETE;

    }

    private static enum BonusItem {
        NONE,
        SMASH,
        SMLBAT,
        BIGBAT,
        LASER;

    }
}

