/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Map {
    int[][] data = new int[200][100];
    int[][] col = new int[200][100];
    int offsetx = 0;
    int offsety = 0;
    int tiles;
    int width;
    int height;
    int level = 1;
    int zones;
    private int lavaframe = 0;
    private int lavacount = 0;
    private Image[] block = new Image[40];
    private BufferedImage[] lava_sprite = new BufferedImage[16];
    private int startx;
    private int starty;

    public void set(int n, int n2) {
        this.offsetx = (10 - n) * 32;
        this.offsety = (10 - n2) * 32;
    }

    public void move(int n, int n2) {
        this.offsetx += n;
        this.offsety += n2;
    }

    public void remove(int n) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.data[j][i] != n) continue;
                this.data[j][i] = 0;
                this.col[j][i] = 0;
            }
        }
    }

    public int count(int n) {
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.data[j][i] != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    public void update(Collide collide) {
        this.zones = 0;
        this.tiles = 0;
        collide.clear();
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.data[j][i] <= 0) continue;
                ++this.tiles;
                if (this.col[j][i] <= 0) continue;
                collide.set(this.zones, j * 32, i * 32, this.col[j][i]);
                ++this.zones;
            }
        }
    }

    public void draw(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 480);
        this.tiles = 0;
        int n = -(this.offsetx / 32);
        int n2 = -(this.offsety / 32);
        int n3 = this.offsetx + n * 32;
        int n4 = this.offsety + n2 * 32;
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i < n2 + 16; ++i) {
            n5 = 0;
            for (int j = n; j < n + 21; ++j) {
                if (j > 0 && i > 0 && this.data[j][i] > 0) {
                    ++this.tiles;
                    if (this.data[j][i] == 16) {
                        graphics.drawImage(this.lava_sprite[this.lavaframe], n5 + n3, n6 + n4, null);
                        ++this.lavacount;
                        if (this.lavacount >= 15) {
                            this.lavacount = 0;
                            ++this.lavaframe;
                            if (this.lavaframe > 15) {
                                this.lavaframe = 0;
                            }
                        }
                    } else {
                        graphics.drawImage(this.block[this.data[j][i]], n5 + n3, n6 + n4, null);
                    }
                }
                n5 += 32;
            }
            n6 += 32;
        }
    }

    public void setmap() {
        this.offsetx = 0;
        this.offsety = 0;
    }

    public void addbeam() {
        for (int i = 0; i < 100 && this.col[this.startx][i] == 0; ++i) {
            this.data[this.startx][i] = 39;
            this.col[this.startx][i] = 99;
        }
    }

    public void load() {
        URL uRL;
        try {
            Object object;
            Object object2;
            uRL = this.getClass().getResource("gfx/blank32.gif");
            this.block[0] = ImageIO.read(uRL);
            System.out.print("0");
            uRL = this.getClass().getResource("level" + this.level + "/scene/block.gif");
            this.block[1] = ImageIO.read(uRL);
            System.out.print("1");
            if (this.level == 1) {
                uRL = this.getClass().getResource("level" + this.level + "/scene/dark_floor.gif");
                this.block[2] = ImageIO.read(uRL);
                System.out.print("2");
            }
            uRL = this.getClass().getResource("level" + this.level + "/scene/grass.gif");
            this.block[3] = ImageIO.read(uRL);
            System.out.print("3");
            uRL = this.getClass().getResource("level" + this.level + "/scene/rocktop.gif");
            this.block[4] = ImageIO.read(uRL);
            System.out.print("4");
            uRL = this.getClass().getResource("level" + this.level + "/scene/plant1.gif");
            this.block[10] = ImageIO.read(uRL);
            System.out.print("5");
            uRL = this.getClass().getResource("level" + this.level + "/scene/plant2.gif");
            this.block[11] = ImageIO.read(uRL);
            System.out.print("6");
            uRL = this.getClass().getResource("level" + this.level + "/scene/cavewall.gif");
            this.block[12] = ImageIO.read(uRL);
            System.out.print("7");
            uRL = this.getClass().getResource("level" + this.level + "/scene/vgirder1.gif");
            this.block[13] = ImageIO.read(uRL);
            System.out.print("8");
            uRL = this.getClass().getResource("gfx/diamond.gif");
            this.block[14] = ImageIO.read(uRL);
            System.out.print("9");
            uRL = this.getClass().getResource("gfx/diamond2.gif");
            this.block[15] = ImageIO.read(uRL);
            System.out.print("a");
            uRL = this.getClass().getResource("level" + this.level + "/enemy/lava.gif");
            this.block[16] = ImageIO.read(uRL);
            System.out.print("b");
            if (this.level == 1) {
                uRL = this.getClass().getResource("level" + this.level + "/scene/hbarrier2.gif");
                this.block[17] = ImageIO.read(uRL);
                System.out.print("c");
            }
            uRL = this.getClass().getResource("level" + this.level + "/scene/destructable.gif");
            this.block[18] = ImageIO.read(uRL);
            System.out.print("d");
            int n = 19;
            switch (this.level) {
                case 1: {
                    for (String string : object2 = new String[]{"gen2.gif", "gen3.gif", "flow.gif"}) {
                        uRL = this.getClass().getResource("level" + this.level + "/scene/" + string);
                        this.block[n] = ImageIO.read(uRL);
                        System.out.print(".");
                        ++n;
                    }
                    break;
                }
                case 2: {
                    object = new String[]{"lock1.gif", "lock2.gif", "key1.gif", "key2.gif", "hostage1.gif"};
                    for (String string : object) {
                        uRL = this.getClass().getResource("level" + this.level + "/collect/" + string);
                        this.block[n] = ImageIO.read(uRL);
                        System.out.print(".");
                        ++n;
                    }
                    break;
                }
            }
            uRL = this.getClass().getResource("gfx/transporter.gif");
            this.block[39] = ImageIO.read(uRL);
            System.out.println("#");
            this.lava_sprite[0] = new BufferedImage(32, 32, 2);
            object2 = this.lava_sprite[0].createGraphics();
            ((Graphics)object2).drawImage(this.block[16], 0, 0, null);
            ((Graphics)object2).dispose();
            for (n = 1; n < this.lava_sprite.length; ++n) {
                this.lava_sprite[n] = new BufferedImage(32, 32, 2);
                object = this.lava_sprite[n].createGraphics();
                ((Graphics)object).drawImage(this.lava_sprite[n - 1], 0, 0, 30, 32, 2, 0, 32, 32, null);
                ((Graphics)object).drawImage(this.lava_sprite[n - 1], 30, 0, 32, 32, 0, 0, 2, 32, null);
                ((Graphics)object).dispose();
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the Level " + this.level + " map sprites...");
            System.out.println(exception);
        }
        try {
            System.out.println("Loading map " + this.level);
            uRL = this.getClass().getResource("level" + this.level + "/map.bmp");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n = bufferedImage.getRGB(j, i);
                    int n2 = n & 0xFF;
                    int n3 = (n & 0xFF00) >> 8;
                    int n4 = (n & 0xFF0000) >> 16;
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    this.data[j][i] = 0;
                    this.col[j][i] = 0;
                    if (n4 == 0 && n3 == 0 && n2 == 0) {
                        this.data[j][i] = 1;
                        this.col[j][i] = 1;
                    }
                    if (n4 == 255 && n3 == 128 && n2 == 0) {
                        this.data[j][i] = 1;
                        this.col[j][i] = 0;
                    }
                    if (n4 == 255 && n3 == 128 && n2 == 64) {
                        this.data[j][i] = 2;
                        this.col[j][i] = 1;
                    }
                    if (n4 == 64 && n3 == 0 && n2 == 0) {
                        this.data[j][i] = 3;
                        this.col[j][i] = 1;
                    }
                    if (n4 == 64 && n3 == 0 && n2 == 64) {
                        this.data[j][i] = 4;
                        this.col[j][i] = 1;
                    }
                    if (n4 == 128 && n3 == 128 && n2 == 0) {
                        this.data[j][i] = 17;
                        this.col[j][i] = 1;
                    }
                    if (n4 == 128 && n3 == 255 && n2 == 128) {
                        this.data[j][i] = 21;
                        this.col[j][i] = 13;
                    }
                    if (n4 == 255 && n3 == 240 && n2 == 0) {
                        this.data[j][i] = 19;
                        this.col[j][i] = 1;
                    }
                    if (n4 == 0 && n3 == 50 && n2 == 64) {
                        this.data[j][i] = 20;
                        this.col[j][i] = 1;
                    }
                    if (n4 == 0 && n3 == 128 && n2 == 128) {
                        this.data[j][i] = 18;
                        this.col[j][i] = 4;
                    }
                    if (n4 == 128 && n3 == 128 && n2 == 128) {
                        this.data[j][i] = 19;
                        this.col[j][i] = 5;
                    }
                    if (n4 == 128 && n3 == 128 && n2 == 64) {
                        this.data[j][i] = 20;
                        this.col[j][i] = 5;
                    }
                    if (n4 == 0 && n3 == 255 && n2 == 0) {
                        this.data[j][i] = 10;
                    }
                    if (n4 == 128 && n3 == 128 && n2 == 255) {
                        this.data[j][i] = 12;
                    }
                    if (n4 == 0 && n3 == 64 && n2 == 0) {
                        this.data[j][i] = 13;
                    }
                    if (n4 == 255 && n3 == 0 && n2 == 0) {
                        this.data[j][i] = 14;
                        this.col[j][i] = 2;
                    }
                    if (n4 == 128 && n3 == 0 && n2 == 255) {
                        this.data[j][i] = 15;
                        this.col[j][i] = 3;
                    }
                    if (n4 == 0 && n3 == 0 && n2 == 64) {
                        this.data[j][i] = 22;
                        this.col[j][i] = 15;
                    }
                    if (n4 == 255 && n3 == 255 && n2 == 0) {
                        this.data[j][i] = 21;
                        this.col[j][i] = 14;
                    }
                    if (n4 == 50 && n3 == 50 && n2 == 50) {
                        this.data[j][i] = 23;
                        this.col[j][i] = 16;
                    }
                    if (n4 == 255 && n3 == 0 && n2 == 255) {
                        this.data[j][i] = 7;
                        this.startx = j;
                        this.starty = i;
                    }
                    if (n4 == 0 && n3 == 0 && n2 == 255) {
                        this.col[j][i] = 10;
                    }
                    if (n4 == 0 && n3 == 255 && n2 == 255) {
                        this.col[j][i] = 11;
                    }
                    if (n4 == 128 && n3 == 0 && n2 == 0) {
                        this.col[j][i] = 12;
                    }
                    if (n4 == 192 && n3 == 192 && n2 == 192) {
                        this.data[j][i] = 16;
                        this.col[j][i] = 13;
                    }
                    if (n4 != 64 || n3 != 0 || n2 != 128) continue;
                    this.col[j][i] = 17;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Load Map file error caught...");
            System.out.println(iOException);
        }
    }
}

