/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;

public class Explosion {
    boolean active = false;
    private Particle[] blast = new Particle[10];
    private int dist;
    private static Image sprite;
    private static boolean loaded;

    public Explosion() {
        for (int i = 0; i < this.blast.length; ++i) {
            this.blast[i] = new Particle();
        }
        if (!loaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/shot.gif");
                sprite = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Problem loading the explosion sprite...");
            }
            loaded = true;
        }
    }

    public void clear() {
        this.active = false;
        this.dist = 0;
        for (int i = 0; i < this.blast.length; ++i) {
            this.blast[i].reset();
        }
    }

    public void set(int n, int n2) {
        this.active = true;
        this.dist = 0;
        for (int i = 0; i < this.blast.length; ++i) {
            this.blast[i].angle = Math.random() * 7.0;
            this.blast[i].sx = n;
            this.blast[i].sy = n2;
        }
    }

    public void move(int n, int n2) {
        if (!this.active) {
            return;
        }
        for (int i = 0; i < this.blast.length; ++i) {
            this.blast[i].sx += Math.cos(this.blast[i].angle);
            this.blast[i].sy += Math.sin(this.blast[i].angle);
            this.blast[i].x = n + (int)this.blast[i].sx;
            this.blast[i].y = n2 + (int)this.blast[i].sy;
        }
        ++this.dist;
        if (this.dist >= 30) {
            this.clear();
        }
    }

    public void draw(Graphics graphics) {
        if (!this.active) {
            return;
        }
        for (Particle particle : this.blast) {
            graphics.drawImage(sprite, particle.x, particle.y, null);
        }
    }

    static {
        loaded = false;
    }
}

