/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class Enemy {
    private static final boolean debug = false;
    private static final Rectangle block = new Rectangle(32, 32);
    int active = 0;
    int type = 0;
    boolean visible = false;
    private int x;
    private int y;
    int sx;
    int sy;
    private int mx;
    private int my;
    int fire;
    private int ox;
    private int oy;
    int xdir;
    int ydir;
    private int frame = 0;
    private int cdir = 1;
    private static Random rand = new Random();
    private static Image[] sprite = new Image[20];

    public void load(int n) {
        String[] stringArray = new String[]{"walker_l1.gif", "walker_l1.gif", "walker_r1.gif", "walker_r1.gif", "flyer1.gif", "flyer2.gif", "turret_l1.gif", "turret_r1.gif", "snake1.gif"};
        int n2 = 0;
        for (String string : stringArray) {
            try {
                URL uRL = this.getClass().getResource("level" + n + "/enemy/" + string);
                Enemy.sprite[n2] = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Problem loading the sprite " + string);
            }
            if (++n2 == 8 && n == 1) break;
        }
    }

    private int randdir() {
        int n = 1;
        if (rand.nextInt(9) <= 4) {
            n = -1;
        }
        return n;
    }

    public void startpos(int n, int n2) {
        this.mx = n;
        this.my = n2;
        this.ox = 0;
        this.oy = 0;
        this.sx = this.mx * 32;
        this.sy = this.my * 32;
        this.cdir = 1;
        this.xdir = 0;
        if (this.active == 1 || this.active == 2) {
            this.xdir = this.randdir();
        }
        if (this.active == 3) {
            this.xdir = -1;
        }
        if (this.active == 4) {
            this.xdir = 1;
        }
        if (this.active == 5) {
            this.xdir = 1;
        }
        this.ydir = 0;
    }

    public void move(Map map) {
        int n;
        if (this.active == 3 || this.active == 4) {
            this.x = this.sx + map.offsetx;
            this.y = this.sy + map.offsety;
            if (this.fire > 0) {
                --this.fire;
            }
            return;
        }
        this.ox += this.xdir;
        this.oy += this.ydir;
        if (Math.abs(this.ox) == 32) {
            this.ox = 0;
        }
        if (Math.abs(this.oy) == 32) {
            this.oy = 0;
        }
        if (this.ox == 0 && this.oy == 0) {
            this.mx += this.xdir;
            this.my += this.ydir;
            switch (this.active) {
                case 1: {
                    if (map.col[this.mx + this.xdir][this.my] == 0 && map.col[this.mx + this.xdir][this.my + 1] != 0 && map.col[this.mx + this.xdir][this.my + 1] != 13) break;
                    this.xdir *= -1;
                    break;
                }
                case 2: {
                    if (map.col[this.mx + this.xdir][this.my] == 0) break;
                    this.xdir *= -1;
                    break;
                }
                case 5: {
                    if (map.col[this.mx + this.xdir][this.my + this.ydir] != 1 && map.col[this.mx + this.xdir][this.my + this.ydir] != 4) break;
                    ++this.cdir;
                    if (this.cdir > 4) {
                        this.cdir = 1;
                    }
                    if (this.cdir == 1) {
                        this.xdir = 1;
                        this.ydir = 0;
                    }
                    if (this.cdir == 2) {
                        this.xdir = 0;
                        this.ydir = 1;
                    }
                    if (this.cdir == 3) {
                        this.xdir = -1;
                        this.ydir = 0;
                    }
                    if (this.cdir != 4) break;
                    this.xdir = 0;
                    this.ydir = -1;
                }
            }
        }
        if ((n = this.xdir != 0 ? Math.abs(this.ox) : Math.abs(this.oy)) == 0 || n == 8 || n == 16 || n == 24) {
            this.frame = 1 - this.frame;
        }
        if (this.fire > 0) {
            --this.fire;
        }
        this.sx = this.mx * 32 + this.ox;
        this.sy = this.my * 32 + this.oy;
        this.x = this.sx + map.offsetx;
        this.y = this.sy + map.offsety;
    }

    public void draw(Graphics graphics) {
        this.visible = false;
        if (this.active == 0) {
            return;
        }
        if (this.x > -32 && this.x < 640 && this.y > -32 && this.y < 480) {
            this.visible = true;
            switch (this.active) {
                case 1: {
                    if (this.xdir == -1) {
                        graphics.drawImage(sprite[this.frame], this.x, this.y, null);
                        break;
                    }
                    graphics.drawImage(sprite[2 + this.frame], this.x, this.y, null);
                    break;
                }
                case 2: {
                    graphics.drawImage(sprite[4 + this.frame], this.x, this.y, null);
                    break;
                }
                case 3: {
                    graphics.drawImage(sprite[6], this.x, this.y, null);
                    break;
                }
                case 4: {
                    graphics.drawImage(sprite[7], this.x, this.y, null);
                    break;
                }
                case 5: {
                    graphics.drawImage(sprite[8], this.x, this.y, null);
                }
            }
        }
    }

    public int hit(int n, int n2) {
        int n3 = 0;
        if (this.active != 0) {
            block.setLocation(this.sx, this.sy);
            if (block.contains(n, n2)) {
                n3 = 1;
                this.active = 0;
            }
        }
        return n3;
    }
}

