/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Armour
extends JPanel
implements MouseListener,
KeyListener {
    static final int swidth = 640;
    static final int sheight = 480;
    public static final int fps = 60;
    public static int fpsdelay = 16;
    long actual;
    long av;
    static final boolean debug = false;
    static final String title = "Armour Ranger";
    static final String version = "v0.5 (22/12/20)";
    static String[] line = new String[30];
    int sx;
    int sy;
    int level;
    int hit = 0;
    int taskdone = 0;
    int moveleft = 0;
    int moveright = 0;
    int movejump = 0;
    int moveup = 0;
    int movedown = 0;
    int movefire = 0;
    int firedelay;
    int rangle;
    int streamer;
    int streamcount;
    int lavahit;
    int power;
    int diamonds;
    int xs;
    static int score;
    static int hiscore;
    static int prevscore;
    static Image block;
    static Image grass;
    static Image lswan;
    static Image rswan;
    static Image stream;
    static Image ydiamond;
    static Image gdiamond;
    static Image plant;
    static Image full_square;
    static Image empty_square;
    static Image dia_sml;
    static Map mymap;
    static Player myplayer;
    static Collide zone;
    static Explosion[] explo;
    static Shot[] myshot;
    static Enemy[] myenemy;
    static Selector levelselect;
    FontMetrics fmetric;
    final Font fs = new Font("Arial", 1, 16);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 1, 30);
    State gamestate = State.WELCOME;

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Armour() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addMouseListener(this);
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Armour.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        int n;
        myenemy = new Enemy[80];
        for (n = 0; n < myenemy.length; ++n) {
            Armour.myenemy[n] = new Enemy();
        }
        myshot = new Shot[40];
        for (n = 0; n < myshot.length; ++n) {
            Armour.myshot[n] = new Shot();
        }
        explo = new Explosion[20];
        for (n = 0; n < explo.length; ++n) {
            Armour.explo[n] = new Explosion();
        }
        try {
            serializable = Armour.class.getClassLoader().getResource("level1/scene/block.gif");
            block = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("level1/scene/grass.gif");
            grass = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("level1/enemy/walker_r1.gif");
            lswan = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("level1/enemy/walker_l1.gif");
            rswan = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("gfx/streamer.gif");
            stream = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("gfx/diamond.gif");
            ydiamond = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("gfx/diamond2.gif");
            gdiamond = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("level1/scene/plant1.gif");
            plant = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("gfx/square1.gif");
            full_square = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("gfx/square2.gif");
            empty_square = ImageIO.read((URL)serializable);
            serializable = Armour.class.getClassLoader().getResource("gfx/dia_sml.gif");
            dia_sml = ImageIO.read((URL)serializable);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the sprites");
            System.out.println(exception);
        }
        serializable = new JFrame("Armour Ranger - v5");
        ((Frame)serializable).setResizable(false);
        ((JFrame)serializable).setDefaultCloseOperation(3);
        ((JFrame)serializable).setContentPane(new Armour());
        ((Window)serializable).pack();
        ((Window)serializable).setVisible(true);
    }

    public void startgame() {
        this.taskdone = 0;
        this.power = 5;
        this.lavahit = 0;
        this.diamonds = 100;
        this.streamcount = 0;
        this.firedelay = 0;
        this.level = Armour.levelselect.highlight + 1;
        this.setlevel(this.level);
    }

    public void setlevel(int n) {
        int n2;
        Armour.mymap.level = n;
        mymap.load();
        mymap.setmap();
        mymap.update(zone);
        zone.debug();
        myenemy[0].load(n);
        for (n2 = 0; n2 < myenemy.length; ++n2) {
            Armour.myenemy[n2].active = 0;
        }
        for (n2 = 0; n2 < myshot.length; ++n2) {
            myshot[n2].clear();
        }
        for (n2 = 0; n2 < explo.length; ++n2) {
            explo[n2].clear();
        }
        n2 = 0;
        for (int i = 0; i < Armour.mymap.width; ++i) {
            block10: for (int j = 0; j < Armour.mymap.height; ++j) {
                if (Armour.mymap.data[i][j] == 7) {
                    Armour.myplayer.ox = 0;
                    Armour.myplayer.oy = 0;
                    Armour.myplayer.startx = i;
                    Armour.myplayer.starty = j;
                    mymap.set(i, j);
                }
                switch (Armour.mymap.col[i][j]) {
                    case 10: {
                        Armour.myenemy[n2].active = 1;
                        myenemy[n2].startpos(i, j);
                        ++n2;
                        Armour.mymap.col[i][j] = 0;
                        continue block10;
                    }
                    case 11: {
                        Armour.myenemy[n2].active = 2;
                        myenemy[n2].startpos(i, j);
                        ++n2;
                        Armour.mymap.col[i][j] = 0;
                        continue block10;
                    }
                    case 12: {
                        Armour.myenemy[n2].active = Armour.mymap.col[i + 1][j] == 0 ? 4 : 3;
                        myenemy[n2].startpos(i, j);
                        ++n2;
                        Armour.mymap.col[i][j] = 0;
                        continue block10;
                    }
                    case 17: {
                        Armour.myenemy[n2].active = 5;
                        myenemy[n2].startpos(i, j);
                        ++n2;
                        Armour.mymap.col[i][j] = 0;
                    }
                }
            }
        }
    }

    public void addexplosion(int n, int n2) {
        for (int i = 0; i < explo.length; ++i) {
            if (Armour.explo[i].active) continue;
            explo[i].set(n, n2);
            break;
        }
    }

    public void draw_game(Graphics graphics) {
        int n;
        mymap.draw(graphics);
        for (Enemy object : myenemy) {
            object.draw(graphics);
        }
        Object[] objectArray = myshot;
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            Object explosion = objectArray[n];
            ((Shot)explosion).draw(Armour.mymap.offsetx, Armour.mymap.offsety, graphics);
        }
        if (this.streamer == 1) {
            double d = Math.toRadians(this.rangle);
            for (n = 2; n < this.xs; ++n) {
                int n3 = 28 + 320 + (int)(Math.cos(d) * (double)(n * 12));
                int n4 = 22 + 320 + (int)(Math.sin(d) * (double)(n * 12));
                graphics.drawImage(stream, n3 - 8, n4 - 8, null);
            }
        }
        myplayer.draw(graphics);
        for (Explosion explosion : explo) {
            explosion.draw(graphics);
        }
        graphics.setColor(Color.yellow);
        graphics.setFont(this.fs);
        graphics.drawString("" + score, 10, 20);
        graphics.drawImage(dia_sml, 556, 8, null);
        graphics.drawString("x" + this.diamonds, 572, 24);
        for (int i = 0; i < 5; ++i) {
            if (this.power <= i) {
                graphics.drawImage(full_square, 620 - i * 16, 32, null);
                continue;
            }
            graphics.drawImage(empty_square, 620 - i * 16, 32, null);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.gamestate) {
            case GAME: {
                this.maingame();
                this.draw_game(graphics);
                break;
            }
            case WELCOME: {
                int n;
                graphics.setFont(this.fb);
                this.fmetric = graphics.getFontMetrics(this.fb);
                score = 0;
                for (n = 0; n < 24; ++n) {
                    graphics.setColor(new Color(0, 0, 255 - n * 10));
                    graphics.fillRect(0, 0 + n * 20, 640, 20);
                }
                for (n = 0; n < 20; ++n) {
                    graphics.drawImage(grass, n * 32, 416, null);
                    graphics.drawImage(block, n * 32, 448, null);
                }
                for (n = 2; n < 18; ++n) {
                    graphics.drawImage(plant, n * 32, 384, null);
                }
                graphics.drawImage(lswan, 32, 384, null);
                graphics.drawImage(rswan, 576, 384, null);
                graphics.drawImage(ydiamond, 128, 384, null);
                graphics.drawImage(gdiamond, 480, 384, null);
                graphics.setColor(Color.black);
                graphics.drawString("http://ssjx.co.uk", 500, 477);
                graphics.drawString(version, 4, 477);
                graphics.setColor(Color.green);
                graphics.drawString("http://ssjx.co.uk", 498, 475);
                graphics.drawString(version, 2, 475);
                Arrays.fill(line, "");
                Armour.line[0] = title;
                Armour.line[2] = "High Score";
                Armour.line[3] = Integer.toString(hiscore);
                Armour.line[4] = "Previous High Score";
                Armour.line[5] = Integer.toString(prevscore);
                Armour.line[7] = "Controls";
                Armour.line[8] = "Arrows - Move";
                Armour.line[9] = "Z - Fire (Regular shot)";
                Armour.line[10] = "X - Streamer (High power beam)";
                Armour.line[11] = "Direct the Streamer using Left+Right";
                Armour.line[14] = "Yellow diamonds power the Streamer weapon";
                Armour.line[15] = "Green diamonds restore one unit of power";
                Armour.line[18] = "Click to play!!";
                for (n = 0; n < line.length; ++n) {
                    if (n == 0 || n == 18) {
                        graphics.setFont(this.fm);
                        this.fmetric = graphics.getFontMetrics(this.fm);
                    } else {
                        graphics.setFont(this.fs);
                        this.fmetric = graphics.getFontMetrics(this.fs);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawString(line[n], 2 + (640 - this.fmetric.stringWidth(line[n])) / 2, 42 + n * 18);
                    if (n >= 7 && n < 18) {
                        graphics.setColor(Color.white);
                    } else {
                        graphics.setColor(Color.yellow);
                    }
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 40 + n * 18);
                }
                break;
            }
            case OVER: {
                Arrays.fill(line, "");
                Armour.line[0] = "Game Over";
                Armour.line[1] = "Final Score : " + score;
                if (score > hiscore) {
                    Armour.line[2] = "New high score!";
                }
                this.draw_game(graphics);
                this.infobox(graphics);
                break;
            }
            case GAME_COMPLETE: {
                Arrays.fill(line, "");
                Armour.line[0] = "Missions Completed!";
                Armour.line[1] = "Final Score : " + score;
                if (score > hiscore) {
                    Armour.line[2] = "New high score!";
                }
                this.draw_game(graphics);
                this.infobox(graphics);
                break;
            }
            case READY: {
                Arrays.fill(line, "");
                Armour.line[0] = "Mission " + this.level;
                Armour.line[2] = "Get Ready!";
                mymap.draw(graphics);
                this.infobox(graphics);
                break;
            }
            case MISSION_COMPLETE: {
                Arrays.fill(line, "");
                Armour.line[0] = "Mission " + this.level + " Completed!";
                Armour.line[2] = "On to the next mission";
                this.draw_game(graphics);
                this.infobox(graphics);
                break;
            }
            case SELECT: {
                int n;
                graphics.setColor(Color.blue);
                graphics.fillRect(0, 0, 640, 480);
                for (n = 0; n < 24; ++n) {
                    graphics.setColor(new Color(0, 0, 255 - n * 10));
                    graphics.fillRect(0, 0 + n * 20, 640, 20);
                }
                Arrays.fill(line, "");
                Armour.line[0] = title;
                Armour.line[2] = "Mission Selection";
                for (n = 0; n < line.length; ++n) {
                    if (n == 2) {
                        graphics.setColor(Color.orange);
                    } else {
                        graphics.setColor(Color.yellow);
                    }
                    this.ctext(graphics, this.fm, line[n], 40 + n * 18, true);
                }
                graphics.setColor(Color.yellow);
                this.ctext(graphics, this.fs, "Use the Up/Down arrows or mouse to choose a mission", 445, true);
                this.ctext(graphics, this.fs, "Click or press Space to start", 460, true);
                levelselect.draw(graphics);
            }
        }
    }

    public void maingame() {
        boolean bl;
        int n;
        int n2;
        boolean bl2 = false;
        int n3 = Armour.myplayer.startx * 32 + Armour.myplayer.ox;
        int n4 = Armour.myplayer.starty * 32 + Armour.myplayer.oy;
        int n5 = zone.over(n3, n4);
        switch (n5) {
            case 2: {
                Armour.mymap.data[Armour.zone.mx][Armour.zone.my] = 0;
                Armour.mymap.col[Armour.zone.mx][Armour.zone.my] = 0;
                score += 10;
                ++this.diamonds;
                bl2 = true;
                break;
            }
            case 3: {
                if (this.power >= 5) break;
                Armour.mymap.data[Armour.zone.mx][Armour.zone.my] = 0;
                Armour.mymap.col[Armour.zone.mx][Armour.zone.my] = 0;
                score += 20;
                ++this.power;
                bl2 = true;
                break;
            }
            case 13: {
                ++this.lavahit;
                if (this.lavahit <= 120) break;
                --this.power;
                this.lavahit = 0;
                break;
            }
            case 14: {
                Armour.mymap.data[Armour.zone.mx][Armour.zone.my] = 0;
                Armour.mymap.col[Armour.zone.mx][Armour.zone.my] = 0;
                score += 10;
                mymap.remove(19);
                bl2 = true;
                break;
            }
            case 15: {
                Armour.mymap.data[Armour.zone.mx][Armour.zone.my] = 0;
                Armour.mymap.col[Armour.zone.mx][Armour.zone.my] = 0;
                score += 10;
                mymap.remove(20);
                bl2 = true;
                break;
            }
            case 16: {
                Armour.mymap.data[Armour.zone.mx][Armour.zone.my] = 0;
                Armour.mymap.col[Armour.zone.mx][Armour.zone.my] = 0;
                score += 20;
                bl2 = true;
                break;
            }
            case 99: {
                this.gamestate = this.level < 2 ? State.MISSION_COMPLETE : State.GAME_COMPLETE;
            }
        }
        for (n2 = 0; n2 < myshot.length; ++n2) {
            if (!Armour.myshot[n2].active) continue;
            int n6 = Armour.myshot[n2].sx + 4;
            n = Armour.myshot[n2].sy + 4;
            if (zone.pointhit(n6, n, 1)) {
                this.addexplosion(n6, n);
                myshot[n2].clear();
            }
            if (zone.pointhit(n6, n, 4)) {
                this.addexplosion(n6, n);
                myshot[n2].clear();
            }
            if (!zone.pointhit(n6, n, 5)) continue;
            this.addexplosion(n6, n);
            myshot[n2].clear();
        }
        if (this.moveright == 1) {
            if (this.streamer == 1) {
                if (this.rangle == 360) {
                    this.rangle = 0;
                }
                this.rangle += 4;
            } else if (this.dirclear(2, 0)) {
                Armour.myplayer.xdir = 1;
                Armour.myplayer.ydir = 0;
                if (!Armour.myplayer.crouch) {
                    mymap.move(-2, 0);
                    myplayer.move(1, 0);
                }
            }
        }
        if (this.moveleft == 1) {
            if (this.streamer == 1) {
                if (this.rangle == 0) {
                    this.rangle = 360;
                }
                this.rangle -= 4;
            } else if (this.dirclear(-2, 0)) {
                Armour.myplayer.xdir = -1;
                Armour.myplayer.ydir = 0;
                if (!Armour.myplayer.crouch) {
                    mymap.move(2, 0);
                    myplayer.move(-1, 0);
                }
            }
        }
        if (this.streamer == 1 && !Armour.myplayer.crouch) {
            n2 = this.dirclear(0, 49) ? 1 : 0;
            if (this.diamonds > 0 && n2 == 0) {
                Armour.myplayer.xdir = this.rangle > 90 && this.rangle < 270 ? -1 : 1;
                this.xs = 0;
                double d = Math.toRadians(this.rangle);
                int n7 = Armour.myplayer.startx * 32 + Armour.myplayer.ox;
                int n8 = Armour.myplayer.starty * 32 + Armour.myplayer.oy;
                for (int i = 2; i < 12; ++i) {
                    int n9 = 28 + n7 + (int)(Math.cos(d) * (double)(i * 12));
                    int n10 = 22 + n8 + (int)(Math.sin(d) * (double)(i * 12));
                    this.xs = i;
                    if (zone.pointhit(n9, n10, 1)) break;
                    if (zone.pointhit(n9, n10, 4)) {
                        Armour.mymap.data[Armour.zone.mx][Armour.zone.my] = 0;
                        Armour.mymap.col[Armour.zone.mx][Armour.zone.my] = 0;
                        this.addexplosion(n9, n10);
                        bl2 = true;
                    }
                    if (zone.pointhit(n9, n10, 5)) {
                        Armour.mymap.data[Armour.zone.mx][Armour.zone.my] = 0;
                        Armour.mymap.col[Armour.zone.mx][Armour.zone.my] = 0;
                        this.addexplosion(n9, n10);
                        if (mymap.count(20) == 0) {
                            mymap.remove(21);
                        }
                        if (mymap.count(19) == 0) {
                            mymap.remove(17);
                        }
                        bl2 = true;
                    }
                    for (int j = 0; j < myenemy.length; ++j) {
                        if (myenemy[j].hit(n9, n10) <= 0) continue;
                        this.addexplosion(Armour.myenemy[j].sx + 16, Armour.myenemy[j].sy + 16);
                        score += 10;
                    }
                    ++this.streamcount;
                }
                if (this.streamcount >= 300) {
                    --this.diamonds;
                    this.streamcount = 0;
                }
            }
        }
        if (this.moveup == 1 && (n2 = (int)(this.dirclear(0, -2) ? 1 : 0)) == 1 && !(bl = this.dirclear(0, 2))) {
            this.movejump = 52;
        }
        Armour.myplayer.crouch = false;
        if (this.movedown == 1 && !this.dirclear(0, 2)) {
            Armour.myplayer.crouch = true;
            this.streamer = 0;
        }
        if (this.movejump > 0) {
            this.streamer = 0;
            if (this.dirclear(0, -2)) {
                --this.movejump;
                mymap.move(0, 2);
                myplayer.move(0, -1);
            } else {
                this.movejump = 0;
            }
        }
        if (this.movejump == 0 && (n2 = (int)(this.dirclear(0, 2) ? 1 : 0)) == 1) {
            this.streamer = 0;
            mymap.move(0, -2);
            myplayer.move(0, 1);
        }
        if (this.firedelay == 0) {
            if (this.movefire == 1) {
                for (n2 = 0; n2 < myshot.length; ++n2) {
                    if (Armour.myshot[n2].active) continue;
                    if (!Armour.myplayer.crouch) {
                        myshot[n2].fire(Armour.mymap.offsetx, Armour.mymap.offsety, Armour.myplayer.xdir, Armour.myplayer.ydir);
                    } else {
                        myshot[n2].fire(Armour.mymap.offsetx, Armour.mymap.offsety - 15, Armour.myplayer.xdir, Armour.myplayer.ydir);
                    }
                    this.firedelay = 10;
                    break;
                }
            }
        } else {
            --this.firedelay;
        }
        for (n2 = 0; n2 < myshot.length; ++n2) {
            myshot[n2].move();
        }
        for (n2 = 0; n2 < explo.length; ++n2) {
            explo[n2].move(Armour.mymap.offsetx, Armour.mymap.offsety);
        }
        if (this.taskdone == 0) {
            switch (this.level) {
                case 1: {
                    if (mymap.count(19) != 0 || mymap.count(20) != 0) break;
                    this.taskdone = 1;
                    break;
                }
                case 2: {
                    if (mymap.count(23) != 0) break;
                    this.taskdone = 1;
                }
            }
            if (this.taskdone == 1) {
                mymap.addbeam();
            }
        }
        if (this.power == 0) {
            this.gamestate = State.OVER;
        }
        for (n2 = 0; n2 < myenemy.length; ++n2) {
            if (Armour.myenemy[n2].active <= 0) continue;
            myenemy[n2].move(mymap);
            if (Armour.myenemy[n2].visible && Armour.myenemy[n2].fire == 0 && Math.random() * 100.0 > 98.0) {
                if (Armour.myenemy[n2].active == 5) {
                    int n11 = 1;
                    for (n = 0; n < myshot.length; ++n) {
                        if (Armour.myshot[n].active) continue;
                        switch (n11) {
                            case 1: {
                                myshot[n].fireb(Armour.myenemy[n2].sx + 16, Armour.myenemy[n2].sy + 10, 1, 0, Armour.myenemy[n2].active);
                                ++n11;
                                break;
                            }
                            case 2: {
                                myshot[n].fireb(Armour.myenemy[n2].sx + 16, Armour.myenemy[n2].sy + 10, -1, 0, Armour.myenemy[n2].active);
                                ++n11;
                                break;
                            }
                            case 3: {
                                myshot[n].fireb(Armour.myenemy[n2].sx + 16, Armour.myenemy[n2].sy + 10, 0, 1, Armour.myenemy[n2].active);
                                ++n11;
                                break;
                            }
                            case 4: {
                                myshot[n].fireb(Armour.myenemy[n2].sx + 16, Armour.myenemy[n2].sy + 10, 0, -1, Armour.myenemy[n2].active);
                                ++n11;
                            }
                        }
                        if (n11 == 5) break;
                    }
                    Armour.myenemy[n2].fire = 90;
                } else {
                    for (int i = 0; i < myshot.length; ++i) {
                        if (Armour.myshot[i].active) continue;
                        myshot[i].fireb(Armour.myenemy[n2].sx + 16, Armour.myenemy[n2].sy + 10, Armour.myenemy[n2].xdir, Armour.myenemy[n2].ydir, Armour.myenemy[n2].active);
                        Armour.myenemy[n2].fire = 30;
                        break;
                    }
                }
            }
            for (int i = 0; i < myshot.length; ++i) {
                if (Armour.myshot[i].owner != 0 || myenemy[n2].hit(Armour.myshot[i].sx + 4, Armour.myshot[i].sy + 4) <= 0) continue;
                this.addexplosion(Armour.myenemy[n2].sx + 12, Armour.myenemy[n2].sy + 12);
                score += 10;
                myshot[i].clear();
            }
        }
        for (n2 = 0; n2 < myshot.length; ++n2) {
            if (Armour.myshot[n2].owner <= 0 || myplayer.hit(Armour.myshot[n2].sx + 4, Armour.myshot[n2].sy + 4) <= 0) continue;
            this.addexplosion(Armour.myshot[n2].sx + 4, Armour.myshot[n2].sy + 4);
            --this.power;
            myshot[n2].clear();
        }
        if (bl2) {
            mymap.update(zone);
        }
    }

    public void setgamestate(State state) {
        switch (this.gamestate) {
            case WELCOME: {
                this.gamestate = State.SELECT;
                break;
            }
            case OVER: {
                this.gamestate = State.WELCOME;
                if (score <= hiscore) break;
                prevscore = hiscore;
                hiscore = score;
                break;
            }
            case GAME_COMPLETE: {
                this.gamestate = State.WELCOME;
                if (score <= hiscore) break;
                prevscore = hiscore;
                hiscore = score;
                break;
            }
            case READY: {
                this.gamestate = State.GAME;
                break;
            }
            case MISSION_COMPLETE: {
                this.gamestate = State.SELECT;
                break;
            }
            case SELECT: {
                this.gamestate = State.READY;
                this.startgame();
                break;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.gamestate != State.GAME) {
            this.setgamestate(this.gamestate);
        } else if (levelselect.hit(n, n2) != -1) {
            this.gamestate = State.READY;
            this.startgame();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 90: {
                if (this.firedelay != 0) break;
                this.movefire = 1;
                break;
            }
            case 88: {
                if (this.gamestate != State.GAME) break;
                this.streamer = 1;
                if (Armour.myplayer.xdir > 0) {
                    this.rangle = 0;
                    break;
                }
                this.rangle = 180;
                break;
            }
            case 39: {
                this.moveright = 1;
                break;
            }
            case 37: {
                this.moveleft = 1;
                break;
            }
            case 32: {
                this.setgamestate(this.gamestate);
                break;
            }
            case 38: {
                if (this.gamestate == State.SELECT) {
                    levelselect.prev();
                    break;
                }
                this.moveup = 1;
                break;
            }
            case 40: {
                if (this.gamestate == State.SELECT) {
                    levelselect.next();
                    break;
                }
                this.movedown = 1;
                break;
            }
            case 80: {
                break;
            }
            case 81: {
                if (this.gamestate == State.GAME) {
                    this.gamestate = State.OVER;
                }
                if (this.gamestate != State.SELECT) break;
                this.gamestate = State.WELCOME;
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 90: {
                this.movefire = 0;
                break;
            }
            case 88: {
                this.streamer = 0;
                break;
            }
            case 39: {
                this.moveright = 0;
                break;
            }
            case 37: {
                this.moveleft = 0;
                break;
            }
            case 32: 
            case 38: {
                this.moveup = 0;
                break;
            }
            case 40: {
                this.movedown = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void infobox(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(220, 190, 200, 100);
        graphics.setColor(Color.yellow);
        graphics.drawRect(220, 190, 200, 100);
        graphics.drawRect(221, 191, 198, 98);
        graphics.setFont(this.fb);
        this.fmetric = graphics.getFontMetrics(this.fb);
        graphics.setColor(Color.yellow);
        for (int i = 0; i < line.length; ++i) {
            graphics.drawString(line[i], (640 - this.fmetric.stringWidth(line[i])) / 2, 220 + i * 25);
        }
    }

    public void ctext(Graphics graphics, Font font, String string, int n, boolean bl) {
        Color color = graphics.getColor();
        graphics.setFont(font);
        this.fmetric = graphics.getFontMetrics(font);
        if (bl) {
            graphics.setColor(Color.black);
            graphics.drawString(string, 2 + (640 - this.fmetric.stringWidth(string)) / 2, n + 2);
        }
        graphics.setColor(color);
        graphics.drawString(string, (640 - this.fmetric.stringWidth(string)) / 2, n);
    }

    public boolean dirclear(int n, int n2) {
        int n3 = Armour.myplayer.startx * 32 + Armour.myplayer.ox;
        int n4 = Armour.myplayer.starty * 32 + Armour.myplayer.oy;
        boolean bl = zone.hit(n3 + n, n4 + n2, 1);
        if (!bl) {
            bl = zone.hit(n3 + n, n4 + n2, 4);
        }
        return !bl;
    }

    static {
        hiscore = 10;
        prevscore = 0;
        mymap = new Map();
        myplayer = new Player();
        zone = new Collide();
        levelselect = new Selector();
    }

    private static enum State {
        WELCOME,
        SELECT,
        READY,
        MISSION_COMPLETE,
        GAME_COMPLETE,
        GAME,
        OVER;

    }
}

