/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

class Teleport {
    public int x;
    public int y;
    public boolean active;
    public boolean tdown = false;
    private int dist;
    static Image[] sprite = new Image[8];
    static boolean gfxloaded = false;
    static Rectangle dest = new Rectangle(0, 0, 32, 32);
    private static Clip sfx_teleport;

    public Teleport() {
        if (!gfxloaded) {
            String[] stringArray = new String[]{"gfx/common/teleport.gif"};
            try {
                int n = 0;
                for (String string : stringArray) {
                    System.out.println("Loading Teleport - " + string);
                    URL uRL = Teleport.class.getClassLoader().getResource(string);
                    Teleport.sprite[n] = ImageIO.read(uRL);
                    ++n;
                }
                try {
                    sfx_teleport = AudioSystem.getClip();
                    URL exception = Map.class.getClassLoader().getResource("snd/teleport.wav");
                    sfx_teleport.open(AudioSystem.getAudioInputStream(exception));
                }
                catch (Exception exception) {
                    System.out.println("Problem loading sound in Teleport");
                    System.out.println(exception);
                }
            }
            catch (Exception exception) {
                System.out.println("Problem loading the teleport sprite...");
                System.out.println(exception);
            }
            gfxloaded = true;
        }
    }

    public void clear() {
        this.x = 0;
        this.y = 0;
        this.active = false;
        this.dist = 0;
    }

    public int update() {
        if (!this.active) {
            return -1;
        }
        if (!this.tdown) {
            this.y -= 4;
            ++this.dist;
            if (this.dist > 100) {
                this.active = false;
            }
        } else {
            this.y += 4;
            this.dist -= 4;
            if (this.dist <= 0) {
                this.active = false;
            }
        }
        return -1;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.active) {
            Teleport.dest.x = this.x - n;
            Teleport.dest.y = this.y - n2;
            graphics.drawImage(sprite[0], Teleport.dest.x, Teleport.dest.y, null);
        }
    }

    public void down(int n, int n2) {
        this.dist = 256;
        this.x = n * 32;
        this.y = (n2 - 8) * 32;
        this.active = true;
        this.tdown = true;
        if (sfx_teleport != null) {
            sfx_teleport.setFramePosition(0);
            sfx_teleport.start();
        }
    }

    public void add(int n, int n2) {
        this.x = n * 32;
        this.y = n2 * 32;
        this.dist = 0;
        this.active = true;
        this.tdown = false;
        if (sfx_teleport != null) {
            sfx_teleport.setFramePosition(0);
            sfx_teleport.start();
        }
    }
}

