/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

class Tank {
    public boolean active = false;
    public int ox;
    public int x = 6;
    public int oy;
    public int y = 6;
    public int xdir = 0;
    public int ydir = 0;
    public int firedelay = 30;
    public boolean visible = false;
    public boolean onscreen = false;
    private final Font smlFont = new Font("Arial", 0, 8);
    int delay = 10;
    static Image[] sprite = new Image[17];
    static boolean gfxloaded = false;
    static Rectangle dest = new Rectangle(0, 0, 32, 32);
    static Rectangle src = new Rectangle(0, 0, 32, 32);
    int fc = 0;
    int frame = 0;
    public enemy type = enemy.TANK;
    public direction movedir = direction.NONE;
    direction prevdir = direction.NONE;
    final int SPEED = 1;
    static int[] order = new int[]{0, 1, 2, 3};
    int spr;
    Rectangle tank_rect = new Rectangle(0, 0, 32, 32);
    Rectangle play_rect = new Rectangle(0, 0, 32, 32);

    public Tank() {
        if (!gfxloaded) {
            String[] stringArray = new String[]{"gfx/common/portal_0.gif", "gfx/common/portal_1.gif", "gfx/common/portal_2.gif", "gfx/common/portal_3.gif", "gfx/common/stun-tank1.gif", "gfx/common/stun-tank2.gif", "gfx/common/stun-tank3.gif", "gfx/common/stun-tank4.gif", "gfx/common/tank1.gif", "gfx/common/tank2.gif", "gfx/common/tank3.gif", "gfx/common/tank4.gif", "gfx/common/crab1.gif", "gfx/common/crab2.gif", "gfx/common/crab3.gif", "gfx/common/crab4.gif", "gfx/common/turret.gif"};
            try {
                int n = 0;
                for (String string : stringArray) {
                    System.out.println("Loading Tank - " + string);
                    URL uRL = Tank.class.getClassLoader().getResource(string);
                    Tank.sprite[n] = ImageIO.read(uRL);
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Tank sprite...");
                System.out.println(exception);
            }
            gfxloaded = true;
        }
    }

    public void set(int n, int n2, enemy enemy2) {
        this.active = true;
        this.ox = 0;
        this.oy = 0;
        this.x = n;
        this.y = n2;
        this.spr = 0;
        this.type = enemy2;
        this.delay = 3;
        this.firedelay = (int)Math.floor(Math.random() * 150.0);
        this.xdir = 0;
        this.ydir = 0;
        this.movedir = direction.PORTAL;
    }

    public void stun() {
        if (this.movedir != direction.STUN) {
            this.delay = 10;
            this.firedelay = (int)Math.floor(Math.random() * (double)(30 * this.delay));
            this.prevdir = this.movedir;
            this.movedir = direction.STUN;
        }
    }

    private void jumble() {
        for (int i = 0; i < 10; ++i) {
            int n = (int)Math.floor(Math.random() * 4.0);
            int n2 = (int)Math.floor(Math.random() * 4.0);
            int n3 = order[n];
            Tank.order[n] = order[n2];
            Tank.order[n2] = n3;
        }
    }

    public boolean hit(int n, int n2) {
        int n3 = this.x * 32 + this.ox;
        int n4 = this.y * 32 + this.oy;
        return n > n3 && n < n3 + 32 && n2 > n4 && n2 < n4 + 32;
    }

    public boolean collide(int n, int n2) {
        int n3 = this.x * 32 + this.ox;
        int n4 = this.y * 32 + this.oy;
        this.tank_rect.x = n3;
        this.tank_rect.y = n4;
        this.play_rect.x = n;
        this.play_rect.y = n2;
        return false;
    }

    public void update(byte[] byArray) {
        if (!this.active) {
            return;
        }
        if (this.movedir != direction.PORTAL && this.type == enemy.TURRET) {
            return;
        }
        if (this.movedir == direction.NONE) {
            this.xdir = 0;
            this.ydir = 0;
            this.jumble();
            int n = 0;
            for (int n2 : order) {
                switch (n2) {
                    case 0: {
                        if (this.y - 1 < 0 || (n = 32 * (this.y - 1) + this.x) < 0 || n >= byArray.length || byArray[n] != 0) break;
                        this.movedir = direction.UP;
                        this.ydir = -1;
                        break;
                    }
                    case 1: {
                        if (this.x + 1 > 31 || (n = 32 * this.y + this.x + 1) < 0 || n >= byArray.length || byArray[n] != 0) break;
                        this.movedir = direction.RIGHT;
                        this.xdir = 1;
                        break;
                    }
                    case 2: {
                        if (this.y + 1 > 31 || (n = 32 * (this.y + 1) + this.x) < 0 || n >= byArray.length || byArray[n] != 0) break;
                        this.movedir = direction.DOWN;
                        this.ydir = 1;
                        break;
                    }
                    case 3: {
                        if (this.x - 1 < 0 || (n = 32 * this.y + this.x - 1) < 0 || n >= byArray.length || byArray[n] != 0) break;
                        this.movedir = direction.LEFT;
                        this.xdir = -1;
                    }
                }
                if (this.movedir == direction.NONE) {
                    continue;
                }
                break;
            }
        } else {
            switch (this.movedir) {
                case STUN: {
                    ++this.fc;
                    if (this.fc != 30) break;
                    this.fc = 0;
                    --this.delay;
                    if (this.delay != 0) break;
                    this.movedir = this.prevdir;
                    break;
                }
                case PORTAL: {
                    ++this.fc;
                    if (this.fc != 8) break;
                    this.fc = 0;
                    ++this.frame;
                    if (this.frame != 4) break;
                    this.frame = 0;
                    --this.delay;
                    if (this.delay != 0) break;
                    this.movedir = direction.NONE;
                    break;
                }
                case UP: {
                    --this.oy;
                    if (this.oy == -32) {
                        this.oy = 0;
                        --this.y;
                        if (this.y - 1 < 0) {
                            this.y = 0;
                            this.movedir = direction.NONE;
                        } else if (byArray[32 * (this.y - 1) + this.x] != 0) {
                            this.movedir = direction.NONE;
                        }
                    }
                    this.spr = 0;
                    break;
                }
                case RIGHT: {
                    ++this.ox;
                    if (this.ox == 32) {
                        this.ox = 0;
                        ++this.x;
                        if (this.x + 1 > 31) {
                            this.x = 31;
                            this.movedir = direction.NONE;
                        } else if (byArray[32 * this.y + this.x + 1] != 0) {
                            this.movedir = direction.NONE;
                        }
                    }
                    this.spr = 1;
                    break;
                }
                case DOWN: {
                    ++this.oy;
                    if (this.oy == 32) {
                        this.oy = 0;
                        ++this.y;
                        if (this.y + 1 > 31) {
                            this.y = 31;
                            this.movedir = direction.NONE;
                        } else if (byArray[32 * (this.y + 1) + this.x] != 0) {
                            this.movedir = direction.NONE;
                        }
                    }
                    this.spr = 2;
                    break;
                }
                case LEFT: {
                    --this.ox;
                    if (this.ox == -32) {
                        this.ox = 0;
                        --this.x;
                        if (this.x - 1 < 0) {
                            this.x = 0;
                            this.movedir = direction.NONE;
                        } else if (byArray[32 * this.y + this.x - 1] != 0) {
                            this.movedir = direction.NONE;
                        }
                    }
                    this.spr = 3;
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, boolean[] blArray) {
        if (this.active) {
            Tank.dest.x = this.x * 32 + this.ox - n;
            Tank.dest.y = this.y * 32 + this.oy - n2;
            this.onscreen = false;
            if (Tank.dest.x >= -32 && Tank.dest.x <= 704 && Tank.dest.y >= -32 && Tank.dest.y <= 544) {
                this.onscreen = true;
            }
            if (!this.onscreen) {
                return;
            }
            int n3 = this.y * 32 + this.x;
            if (!blArray[n3]) {
                this.visible = false;
                return;
            }
            this.visible = true;
            switch (this.movedir) {
                case PORTAL: {
                    graphics.drawImage(sprite[0 + this.frame], Tank.dest.x, Tank.dest.y, Tank.dest.x + Tank.dest.width, Tank.dest.y + Tank.dest.height, Tank.src.x, Tank.src.y, Tank.src.x + Tank.src.width, Tank.src.y + Tank.src.height, null);
                    break;
                }
                case STUN: {
                    graphics.drawImage(sprite[4 + this.spr], Tank.dest.x, Tank.dest.y, Tank.dest.x + Tank.dest.width, Tank.dest.y + Tank.dest.height, Tank.src.x, Tank.src.y, Tank.src.x + Tank.src.width, Tank.src.y + Tank.src.height, null);
                    break;
                }
                default: {
                    if (this.type == enemy.TANK) {
                        graphics.drawImage(sprite[8 + this.spr], Tank.dest.x, Tank.dest.y, Tank.dest.x + Tank.dest.width, Tank.dest.y + Tank.dest.height, Tank.src.x, Tank.src.y, Tank.src.x + Tank.src.width, Tank.src.y + Tank.src.height, null);
                    }
                    if (this.type == enemy.CRAB) {
                        graphics.drawImage(sprite[12 + this.spr], Tank.dest.x, Tank.dest.y, Tank.dest.x + Tank.dest.width, Tank.dest.y + Tank.dest.height, Tank.src.x, Tank.src.y, Tank.src.x + Tank.src.width, Tank.src.y + Tank.src.height, null);
                    }
                    if (this.type != enemy.TURRET) break;
                    graphics.drawImage(sprite[16], Tank.dest.x, Tank.dest.y, Tank.dest.x + Tank.dest.width, Tank.dest.y + Tank.dest.height, Tank.src.x, Tank.src.y, Tank.src.x + Tank.src.width, Tank.src.y + Tank.src.height, null);
                }
            }
        }
    }

    public static enum direction {
        NONE,
        STUN,
        PORTAL,
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static enum enemy {
        TANK,
        CRAB,
        TURRET;

    }
}

