/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

class Snow {
    Image flake;
    boolean gfxloaded = false;
    Rectangle dest = new Rectangle(0, 0, 8, 8);
    Point[] xy = new Point[50];

    public Snow() {
        if (!this.gfxloaded) {
            try {
                URL uRL = Snow.class.getClassLoader().getResource("gfx/common/flake.gif");
                this.flake = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Problem loading the SNOW sprite...");
                System.out.println(exception);
            }
            this.gfxloaded = true;
        }
        for (int i = 0; i < this.xy.length; ++i) {
            this.xy[i] = new Point(0, 0);
        }
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < this.xy.length; ++i) {
            this.xy[i].x = (int)Math.floor(Math.random() * 1024.0);
            this.xy[i].y = (int)Math.floor(Math.random() * 1024.0);
        }
    }

    public void update() {
        for (int i = 0; i < this.xy.length; ++i) {
            ++this.xy[i].x;
            ++this.xy[i].y;
            if (this.xy[i].x > 1024) {
                this.xy[i].x = 0;
            }
            if (this.xy[i].y <= 1024) continue;
            this.xy[i].y = 0;
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        for (Point point : this.xy) {
            this.dest.x = point.x - n;
            this.dest.y = point.y - n2;
            graphics.drawImage(this.flake, this.dest.x, this.dest.y, null);
        }
    }
}

