/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

class Shot {
    public int type;
    public int x;
    public int y;
    public int xdir;
    public int ydir;
    public int owner;
    public boolean active;
    public int hitx;
    public int hity;
    int dist;
    static Image[] sprite = new Image[8];
    static boolean gfxloaded = false;
    static Rectangle dest = new Rectangle(0, 0, 8, 8);

    public Shot() {
        if (!gfxloaded) {
            String[] stringArray = new String[]{"gfx/player/shot.gif", "gfx/player/rocket.gif", "gfx/player/freeze.gif", "gfx/player/heat.gif", "gfx/player/omni.gif"};
            try {
                int n = 0;
                for (String string : stringArray) {
                    System.out.println("Loading Shot - " + string);
                    URL uRL = Shot.class.getClassLoader().getResource(string);
                    Shot.sprite[n] = ImageIO.read(uRL);
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Shot sprites");
                System.out.println(exception);
            }
            gfxloaded = true;
        }
    }

    public void clear() {
        this.owner = -1;
        this.x = 0;
        this.y = 0;
        this.xdir = 0;
        this.ydir = 0;
        this.active = false;
        this.dist = 0;
    }

    public int update(byte[] byArray) {
        if (!this.active) {
            return -1;
        }
        this.x += this.xdir * 4;
        this.y += this.ydir * 4;
        ++this.dist;
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                if (byArray[n] > 0) {
                    int n2 = j * 32;
                    int n3 = i * 32;
                    if (this.x > n2 && this.x < n2 + 32 && this.y > n3 && this.y < n3 + 32) {
                        this.active = false;
                        this.hitx = j;
                        this.hity = i;
                        return n;
                    }
                }
                ++n;
            }
        }
        if (this.dist >= 80) {
            this.active = false;
        }
        return -1;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.active) {
            Shot.dest.x = this.x - n;
            Shot.dest.y = this.y - n2;
            graphics.drawImage(sprite[this.type], Shot.dest.x, Shot.dest.y, null);
        }
    }

    public void add(int n, int n2, int n3, int n4, int n5, int n6) {
        this.x = n + 12;
        this.y = n2 + 12;
        this.xdir = n3;
        this.ydir = n4;
        this.dist = 0;
        this.type = n6;
        this.owner = n5;
        this.active = true;
    }
}

