/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

class Player {
    public int ox;
    public int x = 6;
    public int oy;
    public int y = 6;
    public int mx;
    public int mapx = 0;
    public int my;
    public int mapy = 0;
    public boolean moving = false;
    public boolean hide = false;
    public boolean has_armour = false;
    public boolean has_heat = false;
    public boolean has_freeze = false;
    public boolean has_omni = false;
    public int diamonds = 0;
    public int scientists = 0;
    public int satellites = 0;
    public int rockets = 0;
    public int health;
    public int firedelay = 0;
    public int invincible = 0;
    int ic = 0;
    private final Font smlFont = new Font("Arial", 0, 12);
    public int spr = 0;
    private static Image[] sprite = new Image[20];
    private static boolean gfxloaded = false;
    static Rectangle dest = new Rectangle(0, 0, 32, 32);
    static Rectangle src = new Rectangle(0, 0, 32, 32);
    private int frame = 0;
    private int fc = 0;
    private direction movedir = direction.NONE;
    final int SPEED = 4;
    public int current_weapon;
    public int[] weapon = new int[5];
    private String[] weapon_name = new String[]{"Standard Blaster", "Rockets", "Freeze Ray", "Heat Gun", "Omni Blaster"};
    int tmr = 0;
    Color bg = new Color(0, 0, 0, 128);
    Color tlime = new Color(0, 255, 0, 128);
    Color tyellow = new Color(255, 255, 0, 128);

    public Player() {
        if (!gfxloaded) {
            String[] stringArray = new String[]{"gfx/player/up.gif", "gfx/player/up_1.gif", "gfx/player/right.gif", "gfx/player/right_1.gif", "gfx/player/down.gif", "gfx/player/down_1.gif", "gfx/player/left.gif", "gfx/player/left_1.gif", "", "", "gfx/player/arm_up.gif", "gfx/player/arm_up_1.gif", "gfx/player/arm_right.gif", "gfx/player/arm_right_1.gif", "gfx/player/arm_down.gif", "gfx/player/arm_down_1.gif", "gfx/player/arm_left.gif", "gfx/player/arm_left_1.gif"};
            try {
                int n = 0;
                for (String string : stringArray) {
                    if (string != "") {
                        System.out.println("Loading " + n + " - " + string);
                        URL uRL = Player.class.getClassLoader().getResource(string);
                        Player.sprite[n] = ImageIO.read(uRL);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Player sprites");
                System.out.println(exception);
            }
            gfxloaded = true;
        }
    }

    public void reset() {
        this.spr = 5;
        this.frame = 0;
        this.fc = 0;
        this.ox = 0;
        this.x = 6;
        this.oy = 0;
        this.y = 6;
        this.mx = 0;
        this.mapx = 0;
        this.my = 0;
        this.mapy = 0;
        this.rockets = 0;
        this.health = 5;
        this.diamonds = 0;
        this.scientists = 0;
        this.satellites = 0;
        this.firedelay = 0;
        this.has_armour = false;
        this.movedir = direction.NONE;
        this.invincible = 0;
        this.ic = 0;
        for (int i = 0; i < this.weapon.length; ++i) {
            this.weapon[i] = -1;
        }
        this.current_weapon = 0;
        this.weapon[this.current_weapon] = 10;
    }

    public void omni_only() {
        for (int i = 0; i < this.weapon.length; ++i) {
            this.weapon[i] = -1;
        }
        this.weapon[0] = 10;
        this.weapon[4] = 10;
        this.current_weapon = 4;
    }

    public void next_weapon() {
        do {
            ++this.current_weapon;
            if (this.current_weapon < this.weapon.length) continue;
            this.current_weapon = 0;
        } while (this.weapon[this.current_weapon] < 0);
    }

    public void turn(int n, int n2) {
        if (this.movedir == direction.NONE) {
            if (n2 == -1) {
                this.spr = 0;
            }
            if (n == 1) {
                this.spr = 2;
            }
            if (n2 == 1) {
                this.spr = 4;
            }
            if (n == -1) {
                this.spr = 6;
            }
        }
    }

    public void update(int n, int n2) {
        ++this.tmr;
        if (this.tmr == 120) {
            this.tmr = 0;
            for (int i = 2; i < 4; ++i) {
                if (this.weapon[i] < 0 || this.weapon[i] >= 10) continue;
                int n3 = i;
                this.weapon[n3] = this.weapon[n3] + 1;
            }
        }
        if (this.firedelay > 0) {
            --this.firedelay;
        }
        if (this.movedir == direction.NONE) {
            this.moving = false;
            if (n2 == -1) {
                this.movedir = direction.UP;
                this.moving = true;
            }
            if (n == 1) {
                this.movedir = direction.RIGHT;
                this.moving = true;
            }
            if (n2 == 1) {
                this.movedir = direction.DOWN;
                this.moving = true;
            }
            if (n == -1) {
                this.movedir = direction.LEFT;
                this.moving = true;
            }
        } else {
            ++this.fc;
            if (this.fc == 4) {
                this.fc = 0;
                this.frame = 1 - this.frame;
            }
        }
        switch (this.movedir) {
            case UP: {
                if (this.y < 4 && this.mapy > 0) {
                    this.my -= 4;
                    if (this.my == -32) {
                        this.my = 0;
                        --this.mapy;
                        this.movedir = direction.NONE;
                    }
                } else {
                    this.oy -= 4;
                    if (this.oy == -32) {
                        this.oy = 0;
                        --this.y;
                        this.movedir = direction.NONE;
                    }
                }
                this.spr = 0;
                break;
            }
            case RIGHT: {
                if (this.x > 15 && this.mapx < 12) {
                    this.mx += 4;
                    if (this.mx == 32) {
                        this.mx = 0;
                        ++this.mapx;
                        this.movedir = direction.NONE;
                    }
                } else {
                    this.ox += 4;
                    if (this.ox == 32) {
                        this.ox = 0;
                        ++this.x;
                        this.movedir = direction.NONE;
                    }
                }
                this.spr = 2;
                break;
            }
            case DOWN: {
                if (this.y > 10 && this.mapy < 17) {
                    this.my += 4;
                    if (this.my == 32) {
                        this.my = 0;
                        ++this.mapy;
                        this.movedir = direction.NONE;
                    }
                } else {
                    this.oy += 4;
                    if (this.oy == 32) {
                        this.oy = 0;
                        ++this.y;
                        this.movedir = direction.NONE;
                    }
                }
                this.spr = 4;
                break;
            }
            case LEFT: {
                if (this.x < 4 && this.mapx > 0) {
                    this.mx -= 4;
                    if (this.mx == -32) {
                        this.mx = 0;
                        --this.mapx;
                        this.movedir = direction.NONE;
                    }
                } else {
                    this.ox -= 4;
                    if (this.ox == -32) {
                        this.ox = 0;
                        --this.x;
                        this.movedir = direction.NONE;
                    }
                }
                this.spr = 6;
            }
        }
    }

    public boolean hit(int n, int n2) {
        int n3 = (this.mapx + this.x) * 32 + this.ox + this.mx;
        int n4 = (this.mapy + this.y) * 32 + this.oy + this.my;
        return n > n3 && n < n3 + 32 && n2 > n4 && n2 < n4 + 32;
    }

    private void bar(Graphics graphics, int n, int n2, String string, int n3, int n4) {
        if (n4 > n3) {
            n3 = n4;
        }
        int n5 = n4 * 160 / n3;
        graphics.setColor(this.bg);
        graphics.fillRect(n, n2, 160, 16);
        graphics.setFont(this.smlFont);
        if (string == "Health") {
            graphics.setColor(Color.pink);
            graphics.fillRect(n, n2, n5, 16);
            graphics.setColor(Color.blue);
        } else if (string == "Diamonds") {
            graphics.setColor(this.tyellow);
            graphics.fillRect(n, n2, n5, 16);
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(this.tlime);
            graphics.fillRect(n, n2, n5, 16);
            graphics.setColor(Color.white);
        }
        graphics.drawString(string, n + 2, n2 + 14);
        graphics.setColor(Color.green);
        graphics.drawRect(n, n2, 160, 16);
    }

    public void draw(Graphics graphics) {
        int n;
        Player.dest.x = this.x * 32 + this.ox;
        Player.dest.y = this.y * 32 + this.oy;
        if (!this.hide) {
            n = 0;
            if (this.has_armour) {
                n = 10;
            }
            if (this.invincible > 0) {
                ++this.ic;
                if (this.ic == 4) {
                    --this.invincible;
                    this.ic = 0;
                    graphics.drawImage(sprite[this.spr + this.frame + n], Player.dest.x, Player.dest.y, Player.dest.x + Player.dest.width, Player.dest.y + Player.dest.height, Player.src.x, Player.src.y, Player.src.x + Player.src.width, Player.src.y + Player.src.height, null);
                }
            } else {
                graphics.drawImage(sprite[this.spr + this.frame + n], Player.dest.x, Player.dest.y, Player.dest.x + Player.dest.width, Player.dest.y + Player.dest.height, Player.src.x, Player.src.y, Player.src.x + Player.src.width, Player.src.y + Player.src.height, null);
            }
        }
        n = 0;
        Point point = new Point(16, 460);
        for (int n2 : this.weapon) {
            if (n2 >= 0) {
                point.x = 16;
                if (n == this.current_weapon) {
                    point.x = 32;
                }
                this.bar(graphics, point.x, point.y, this.weapon_name[n], 10, n2);
                point.y -= 18;
            }
            ++n;
        }
        this.bar(graphics, 478, 460, "Health", 10, this.health);
        switch (Map.mission) {
            case 1: {
                this.bar(graphics, 478, 442, "Diamonds", 10, this.diamonds);
                break;
            }
            case 2: {
                this.bar(graphics, 478, 442, "Scientists", 4, this.scientists);
                break;
            }
            case 3: {
                this.bar(graphics, 478, 442, "Satellites", 4, this.satellites);
            }
        }
    }

    private static enum direction {
        NONE,
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

