/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

class Map {
    public Location level;
    public int collected;
    public int moreinfo;
    public int forceinfo;
    public int chat;
    public int facing;
    public int remove;
    public int movie = 0;
    public int actualx;
    public int actualy;
    public World myworld = new World();
    public Snow mysnow = new Snow();
    Message mymessage = new Message();
    final boolean cheat = false;
    public static final int swidth = 640;
    public static final int sheight = 480;
    String infotext = "";
    int facing_loc;
    public static int mission = 1;
    private final Font smlFont = new Font("Arial", 0, 18);
    MapSquare[] map_space = new MapSquare[1024];
    MapSquare[] map_forest = new MapSquare[1024];
    MapSquare[] map_lake = new MapSquare[1024];
    MapSquare[] map_mountain = new MapSquare[1024];
    MapSquare[] map_ice = new MapSquare[1024];
    MapSquare[] map_desert = new MapSquare[1024];
    byte[] mymap = new byte[1024];
    byte[] solid = new byte[1024];
    boolean[] visible = new boolean[1024];
    byte prev_tile;
    Image[] block = new Image[20];
    static Rectangle dest = new Rectangle(0, 0, 32, 32);
    static Rectangle src = new Rectangle(0, 0, 32, 32);
    static Rectangle bigdest = new Rectangle(0, 0, 64, 32);
    static Rectangle ship_dst = new Rectangle(0, 0, 128, 32);
    public static Rectangle ship_src = new Rectangle(0, 32, 128, 32);
    static Rectangle mov_src = new Rectangle(0, 0, 32, 32);
    static int fc = 0;
    public Player myplayer = new Player();
    public Inventory myinventory = new Inventory();
    Tank[] mytank = new Tank[20];
    Shot[] myshot = new Shot[40];
    Teleport[] myteleport = new Teleport[20];
    Explosion myexplosion = new Explosion();
    int width;
    int height;
    Clip sfx_beep;
    Clip sfx_teleport;
    Clip sfx_zap;

    public Map() {
        int n;
        for (n = 0; n < 1024; ++n) {
            this.map_space[n] = new MapSquare();
            this.map_forest[n] = new MapSquare();
            this.map_lake[n] = new MapSquare();
            this.map_mountain[n] = new MapSquare();
            this.map_ice[n] = new MapSquare();
            this.map_desert[n] = new MapSquare();
        }
        for (n = 0; n < this.mytank.length; ++n) {
            this.mytank[n] = new Tank();
        }
        for (n = 0; n < this.myshot.length; ++n) {
            this.myshot[n] = new Shot();
        }
        for (n = 0; n < this.myteleport.length; ++n) {
            this.myteleport[n] = new Teleport();
        }
        try {
            this.sfx_beep = AudioSystem.getClip();
            URL uRL = Map.class.getClassLoader().getResource("snd/beep.wav");
            this.sfx_beep.open(AudioSystem.getAudioInputStream(uRL));
            this.sfx_teleport = AudioSystem.getClip();
            uRL = Map.class.getClassLoader().getResource("snd/teleport.wav");
            this.sfx_teleport.open(AudioSystem.getAudioInputStream(uRL));
            this.sfx_zap = AudioSystem.getClip();
            uRL = Map.class.getClassLoader().getResource("snd/zap.wav");
            this.sfx_zap.open(AudioSystem.getAudioInputStream(uRL));
        }
        catch (Exception exception) {
            System.out.println("Problem loading sound in Explosion");
            System.out.println(exception);
        }
    }

    private void play(Sound sound) {
        switch (sound) {
            case BEEP: {
                if (this.sfx_beep == null) break;
                this.sfx_beep.setFramePosition(0);
                this.sfx_beep.start();
                break;
            }
            case ZAP: {
                if (this.sfx_zap == null) break;
                this.sfx_zap.setFramePosition(0);
                this.sfx_zap.start();
                break;
            }
            case TELEPORT: {
                if (this.sfx_teleport == null) break;
                this.sfx_teleport.setFramePosition(0);
                this.sfx_teleport.start();
            }
        }
    }

    public void reset() {
        this.movie = 0;
        Map.ship_src.y = 32;
        this.initmap();
        this.myplayer.reset();
        mission = 0;
        this.level = Location.SPACE;
        this.myteleport[0].down(this.myplayer.x, this.myplayer.y);
        this.myplayer.hide = true;
        this.myworld.reset();
        this.myinventory.reset();
        this.myexplosion.reset();
        this.mymessage.clear();
    }

    public void update(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = -1;
        this.infotext = null;
        if (fc >= 15) {
            fc = 0;
            ++Map.mov_src.x;
            if (Map.mov_src.x == 32) {
                Map.mov_src.x = 0;
            }
        } else {
            ++fc;
        }
        if (!this.myplayer.moving) {
            n5 = this.myplayer.x + this.myplayer.mapx;
            n4 = this.myplayer.y + this.myplayer.mapy;
            if (this.is_solid(n5 + n, n4 + n2) == 0) {
                this.myplayer.update(n, n2);
            } else {
                this.myplayer.turn(n, n2);
            }
        } else {
            this.myplayer.update(0, 0);
        }
        if (this.myplayer.ox == 0 && this.myplayer.oy == 0 && this.myplayer.mx == 0 && this.myplayer.my == 0) {
            int n7;
            int n8;
            int n9;
            n5 = this.myplayer.x + this.myplayer.mapx;
            n4 = this.myplayer.y + this.myplayer.mapy;
            for (n3 = 0; n3 < 9; ++n3) {
                for (n9 = 0; n9 < 9; ++n9) {
                    int n10 = n5 - 4 + n9;
                    n8 = n4 - 4 + n3;
                    if (n10 < 0 || n10 > 31 || n8 < 0 || n8 > 31) continue;
                    n7 = n8 * 32 + n10;
                    this.visible[n7] = true;
                }
            }
            n3 = 0;
            if (n4 == 0 && n2 == -1) {
                this.map_save();
                this.myworld.move(0, -1);
                this.level = this.myworld.location;
                this.load_gfx();
                this.myplayer.y = 15;
                this.myplayer.mapy = 17;
                this.myplayer.update(0, -1);
                n3 = 1;
            }
            if (n3 == 0 && n5 >= 31 && n == 1) {
                this.map_save();
                this.myworld.move(1, 0);
                this.level = this.myworld.location;
                this.load_gfx();
                this.myplayer.x = -1;
                this.myplayer.mapx = 0;
                this.myplayer.update(1, 0);
                n3 = 1;
            }
            if (n3 == 0 && n4 == 31 && n2 == 1) {
                this.map_save();
                this.myworld.move(0, 1);
                this.level = this.myworld.location;
                this.load_gfx();
                this.myplayer.y = -1;
                this.myplayer.mapy = 0;
                this.myplayer.update(0, 1);
                n3 = 1;
            }
            if (n3 == 0 && n5 <= 0 && n == -1) {
                this.map_save();
                this.myworld.move(-1, 0);
                this.level = this.myworld.location;
                this.load_gfx();
                this.myplayer.x = 20;
                this.myplayer.mapx = 12;
                this.myplayer.update(-1, 0);
                n3 = 1;
            }
            n9 = 32 * (this.myplayer.y + this.myplayer.mapy) + (this.myplayer.x + this.myplayer.mapx);
            this.collected = 0;
            this.moreinfo = 0;
            this.chat = 0;
            this.remove = 0;
            this.facing = 0;
            if (n9 >= 0 && n9 < 1024) {
                int[] nArray = new int[]{-32, -32, 1, 1, 32, 32, -1, -1};
                this.facing_loc = n9 + nArray[this.myplayer.spr];
                if (this.facing_loc >= 0 && this.facing_loc < 1024) {
                    this.facing = this.solid[this.facing_loc] == 11 ? 11 : this.mymap[this.facing_loc];
                }
                switch (this.level) {
                    case SPACE: {
                        if (!this.myteleport[0].active) {
                            this.myplayer.hide = false;
                        }
                        this.actualx = this.myplayer.x + this.myplayer.mapx;
                        this.actualy = this.myplayer.y + this.myplayer.mapy;
                        if (this.mymap[n9] == 12) {
                            this.myinventory.add("Keycard");
                            this.mymessage.set("Keycard collected!");
                            this.mymap[n9] = this.mymap[n9 + 1];
                            this.collected = 1;
                            this.play(Sound.BEEP);
                        }
                        if (this.mymap[n9] == 10) {
                            this.myinventory.add("Armour");
                            this.mymessage.set("Modulus Armour collected");
                            this.mymap[n9] = this.mymap[n9 + 1];
                            this.myplayer.has_armour = true;
                            this.myplayer.health = 10;
                            this.collected = 2;
                            this.play(Sound.BEEP);
                        }
                        if (this.mymap[n9] == 9) {
                            this.collected = 3;
                            this.myinventory.add("Omnicog");
                            this.mymessage.set("Omni-Cog collected");
                            this.mymap[n9] = this.mymap[n9 + 1];
                            this.play(Sound.BEEP);
                        }
                        if (this.facing == 6) {
                            this.infotext = "Teleporter controls! Access Keycard Required!";
                            if (this.myinventory.have("Keycard")) {
                                this.infotext = "Teleporter controls! Press Space to log in!";
                            }
                        }
                        if (this.facing == 7) {
                            this.infotext = "Barrier controls! Access Keycard Required!";
                            if (this.myinventory.have("Keycard")) {
                                this.infotext = "Barrier controls! Press Space to log in!";
                            }
                        }
                        if (this.facing == 13) {
                            this.infotext = "Information controls! Access Keycard Required!";
                            if (this.myinventory.have("Keycard")) {
                                this.infotext = "Information controls! Press Space to log in!";
                            }
                        }
                        if (this.myinventory.have("Armour") && this.actualx == 25 && this.actualy >= 22 && !this.map_contains(3)) {
                            for (n8 = 0; n8 < this.width; ++n8) {
                                for (n7 = 12; n7 < 31; ++n7) {
                                    if (this.get(n7, n8) != 4) continue;
                                    this.set(n7, n8, this.get(n7 + 1, n8));
                                }
                            }
                            for (n8 = 0; n8 < 80; ++n8) {
                                int n11;
                                n7 = (int)Math.floor(Math.random() * 31.0);
                                if (this.get(n7, n11 = (int)Math.floor(Math.random() * 17.0)) != 2) continue;
                                this.set(n7, n11, 3);
                            }
                            for (n8 = 0; n8 < this.width; ++n8) {
                                if (this.get(n8, 17) != 2) continue;
                                this.set(n8, 17, 3);
                            }
                            this.create_solid_map();
                            this.forceinfo = 3;
                        }
                        if (!this.myinventory.have("AWAY") || this.myteleport[0].active) break;
                        if (this.movie == 0) {
                            this.movie = 3;
                            return;
                        }
                        this.movie = 0;
                        this.map_save();
                        this.myworld.set(2, 2);
                        this.level = this.myworld.location;
                        this.map_restore();
                        this.load_gfx();
                        this.myplayer.x = 6;
                        this.myplayer.y = 6;
                        this.myplayer.mapx = 0;
                        this.myplayer.mapy = 0;
                        this.myplayer.ox = 0;
                        this.myplayer.oy = 0;
                        this.myplayer.mx = 0;
                        this.myplayer.my = 0;
                        this.myplayer.hide = true;
                        this.myteleport[0].down(this.myplayer.x, this.myplayer.y);
                        break;
                    }
                    case FOREST: {
                        if (this.myplayer.hide && !this.myteleport[0].active) {
                            this.myplayer.hide = false;
                            this.myinventory.remove("AWAY");
                            this.forceinfo = 89;
                        }
                        if (this.mymap[n9] == 10) {
                            this.mymap[n9] = this.mymap[n9 + 1];
                            if (this.myplayer.rockets == 0) {
                                this.collected = 5;
                            }
                            this.myplayer.rockets = 1;
                            if (this.myplayer.weapon[1] == -1) {
                                this.myplayer.weapon[1] = 0;
                            }
                            this.myplayer.weapon[1] = this.myplayer.weapon[1] + 5;
                            this.mymessage.set("Rockets collected! (Press X to select)");
                            this.play(Sound.BEEP);
                        }
                        if (this.facing == 3) {
                            this.infotext = "Crystal Barrier - Press Space for more information";
                        }
                        if (this.facing == 4) {
                            this.infotext = "Boulder - Press Space for more information";
                        }
                        if (this.facing != 11) break;
                        this.infotext = "Your Ship - Press Space for more information";
                        break;
                    }
                    case LAKE: {
                        if (this.facing == 3) {
                            this.infotext = "Crystal - Press Space for more information";
                        }
                        if (this.facing != 4) break;
                        this.infotext = "Lake - Press Space for more information";
                        break;
                    }
                    case MOUNTAIN: {
                        if (this.facing == 4) {
                            this.infotext = "Lava - Press Space for more information";
                        }
                        if (this.mymap[n9] != 10) break;
                        this.mymap[n9] = this.mymap[n9 + 1];
                        this.myplayer.weapon[3] = 10;
                        this.collected = 7;
                        this.mymessage.set("Heat Gun collected! (Press X to select)");
                        break;
                    }
                    case ICE: {
                        if (this.facing == 1) {
                            this.moreinfo = 1;
                            this.infotext = "Solid Ice - Press Space for more information";
                        }
                        if (this.mymap[n9] != 10) break;
                        this.mymap[n9] = this.mymap[n9 + 1];
                        this.myplayer.weapon[2] = 10;
                        this.collected = 6;
                        this.mymessage.set("Freeze Gun collected! (Press X to select)");
                    }
                }
                if (this.level != Location.SPACE) {
                    if (this.mymap[n9] == 9 && this.prev_tile != 9) {
                        if (mission == 2) {
                            this.mymessage.set("Scientist rescued!");
                            this.play(Sound.BEEP);
                            this.mymap[n9] = this.mymap[n9 + 1];
                            if (!this.myinventory.have("Scientist")) {
                                this.collected = 4;
                            }
                            this.myinventory.add("Scientist");
                            this.teleport_add(this.myplayer.x + this.myplayer.mapx, this.myplayer.y + this.myplayer.mapy);
                            this.myplayer.scientists = this.myinventory.count("Scientist");
                            if (this.myplayer.scientists == 4) {
                                this.collected = 9;
                            }
                        } else {
                            this.forceinfo = 90;
                        }
                    }
                    if (this.mymap[n9] == 12 && this.prev_tile != 12) {
                        if (mission == 3) {
                            this.mymessage.set("Satellite found!");
                            this.play(Sound.BEEP);
                            this.mymap[n9] = this.mymap[n9 + 1];
                            this.myinventory.add("Satellite");
                            this.teleport_add(this.myplayer.x + this.myplayer.mapx, this.myplayer.y + this.myplayer.mapy);
                            this.myplayer.satellites = this.myinventory.count("Satellite");
                            if (this.myplayer.satellites == 4) {
                                this.collected = 10;
                            }
                            if (this.level == Location.DESERT) {
                                n8 = this.myplayer.y + this.myplayer.mapy;
                                n7 = this.myplayer.x + this.myplayer.mapx;
                                if (n7 == 27 && n8 == 15) {
                                    this.set(27, 10, 2);
                                    this.set(27, 19, 1);
                                    this.set(8, 26, 1);
                                    this.set(5, 5, 2);
                                    this.set(5, 20, 2);
                                    this.create_solid_map();
                                    this.forceinfo = 2;
                                }
                            }
                        } else {
                            this.forceinfo = 92;
                        }
                    }
                }
                this.prev_tile = this.mymap[n9];
                if (this.mymap[n9] == 8) {
                    this.mymap[n9] = 2;
                    ++this.myplayer.diamonds;
                    this.mymessage.set("Diamond collected!");
                    this.play(Sound.BEEP);
                    if (this.myplayer.diamonds == 10) {
                        this.forceinfo = 91;
                    }
                }
                if (this.mymap[n9] == 14 && this.myplayer.health < 10) {
                    ++this.myplayer.health;
                    this.mymap[n9] = 2;
                    this.mymessage.set("Health increased!");
                    this.play(Sound.BEEP);
                }
            }
        }
        for (n5 = 0; n5 < this.myshot.length; ++n5) {
            n6 = this.myshot[n5].update(this.solid);
            if (n6 >= 0) {
                n4 = 0;
                n3 = this.myshot[n5].type;
                switch (this.level) {
                    case FOREST: {
                        if ((n3 == 1 || n3 == 4) && this.mymap[n6] == 4) {
                            n4 = 1;
                        }
                        if (n3 == 4 && this.mymap[n6] == 3) {
                            n4 = 1;
                        }
                        if (n4 != 1) break;
                        this.mymap[n6] = 2;
                        this.create_solid_map();
                        break;
                    }
                    case ICE: {
                        if ((n3 == 3 || n3 == 4) && this.mymap[n6] == 1) {
                            n4 = 1;
                        }
                        if (n3 == 4 && this.mymap[n6] == 3) {
                            n4 = 1;
                        }
                        if (n4 != 1) break;
                        this.mymap[n6] = 2;
                        this.create_solid_map();
                        break;
                    }
                    case LAKE: {
                        if ((n3 == 2 || n3 == 4) && this.mymap[n6] == 4) {
                            this.mymap[n6] = 0;
                            n4 = 1;
                        }
                        if (n3 == 4 && this.mymap[n6] == 3) {
                            this.mymap[n6] = 2;
                            n4 = 1;
                        }
                        if (n4 != 1) break;
                        this.create_solid_map();
                        break;
                    }
                    case MOUNTAIN: {
                        if ((n3 == 2 || n3 == 4) && this.mymap[n6] == 4) {
                            n4 = 1;
                        }
                        if (n3 == 4 && this.mymap[n6] == 3) {
                            n4 = 1;
                        }
                        if (n4 != 1) break;
                        this.mymap[n6] = 2;
                        this.create_solid_map();
                        break;
                    }
                    case DESERT: {
                        if (n3 == 4 && this.mymap[n6] == 3) {
                            n4 = 1;
                        }
                        if (n4 != 1) break;
                        this.mymap[n6] = 2;
                        this.create_solid_map();
                    }
                }
                this.myexplosion.add(this.myshot[n5].hitx * 32 + 8, this.myshot[n5].hity * 32 + 8);
                continue;
            }
            if (this.myshot[n5].owner == 1) {
                for (n4 = 0; n4 < this.mytank.length; ++n4) {
                    if (!this.mytank[n4].active || !this.mytank[n4].hit(this.myshot[n5].x, this.myshot[n5].y)) continue;
                    this.myshot[n5].clear();
                    if (this.myplayer.has_armour) {
                        this.mytank[n4].active = false;
                        this.myexplosion.add(this.mytank[n4].x * 32 + this.mytank[n4].ox, this.mytank[n4].y * 32 + this.mytank[n4].oy);
                        continue;
                    }
                    this.mytank[n4].stun();
                }
            }
            if (this.myshot[n5].owner != 0 || this.myplayer.invincible != 0 || !this.myplayer.hit(this.myshot[n5].x, this.myshot[n5].y)) continue;
            n4 = (this.myplayer.mapx + this.myplayer.x) * 32 + this.myplayer.ox + this.myplayer.mx;
            n3 = (this.myplayer.mapy + this.myplayer.y) * 32 + this.myplayer.oy + this.myplayer.my;
            this.myexplosion.add(n4, n3);
            this.myshot[n5].clear();
            --this.myplayer.health;
            this.myplayer.invincible = 20;
            if (this.myplayer.health != 0) continue;
            this.forceinfo = 100;
        }
        this.myexplosion.update();
        n5 = (this.myplayer.mapx + this.myplayer.x) * 32 + this.myplayer.ox + this.myplayer.mx;
        n4 = (this.myplayer.mapy + this.myplayer.y) * 32 + this.myplayer.oy + this.myplayer.my;
        for (n3 = 0; n3 < this.mytank.length; ++n3) {
            this.mytank[n3].update(this.solid);
            if (this.mytank[n3].movedir == Tank.direction.STUN || this.mytank[n3].movedir == Tank.direction.PORTAL || !this.mytank[n3].active || this.myplayer.invincible != 0 || !this.mytank[n3].collide(n5, n4)) continue;
            --this.myplayer.health;
            this.myplayer.invincible = 20;
            if (this.myplayer.health != 0) continue;
            this.forceinfo = 100;
        }
        this.add_enemyshot();
        for (n3 = 0; n3 < this.myteleport.length; ++n3) {
            this.myteleport[n3].update();
        }
        if (this.level == Location.ICE) {
            this.mysnow.update();
        }
        this.mymessage.update();
    }

    public void set(int n, int n2, int n3) {
        int n4 = 32 * n2 + n;
        this.mymap[n4] = (byte)n3;
    }

    private int get(int n, int n2) {
        int n3 = 32 * n2 + n;
        return this.mymap[n3];
    }

    private int is_solid(int n, int n2) {
        int n3;
        if (n >= 0 && n <= 31 && n2 >= 0 && n2 <= 31 && (n3 = 32 * n2 + n) >= 0 && n3 < this.solid.length) {
            return this.solid[n3];
        }
        return 1;
    }

    public boolean teleport_add(int n, int n2) {
        for (int i = 1; i < this.myteleport.length; ++i) {
            if (this.myteleport[i].active) continue;
            this.myteleport[i].add(n, n2);
            return true;
        }
        return false;
    }

    public boolean add_enemyshot() {
        boolean bl = false;
        int n = 0;
        for (Tank tank : this.mytank) {
            if (!tank.active) {
                ++n;
                continue;
            }
            if (!tank.visible || !tank.onscreen) {
                ++n;
                continue;
            }
            if (tank.movedir == Tank.direction.PORTAL || tank.movedir == Tank.direction.STUN) {
                ++n;
                continue;
            }
            if (tank.firedelay == 0) {
                if ((int)Math.floor(Math.random() * 100.0) > 95) {
                    for (int i = 20; i < this.myshot.length; ++i) {
                        if (this.myshot[i].active) continue;
                        int n2 = tank.x * 32 + tank.ox;
                        int n3 = tank.y * 32 + tank.oy;
                        if (tank.type == Tank.enemy.TURRET) {
                            int n4 = (int)Math.floor(Math.random() * 8.0);
                            if (n4 == 0) {
                                this.myshot[i].add(n2, n3, 1, 1, 0, 0);
                            }
                            if (n4 == 1) {
                                this.myshot[i].add(n2, n3, 1, -1, 0, 0);
                            }
                            if (n4 == 2) {
                                this.myshot[i].add(n2, n3, -1, 1, 0, 0);
                            }
                            if (n4 == 3) {
                                this.myshot[i].add(n2, n3, -1, -1, 0, 0);
                            }
                            if (n4 == 4) {
                                this.myshot[i].add(n2, n3, 0, 1, 0, 0);
                            }
                            if (n4 == 5) {
                                this.myshot[i].add(n2, n3, 0, -1, 0, 0);
                            }
                            if (n4 == 6) {
                                this.myshot[i].add(n2, n3, 1, 0, 0, 0);
                            }
                            if (n4 == 7) {
                                this.myshot[i].add(n2, n3, -1, 0, 0, 0);
                            }
                            this.mytank[n].firedelay = 75;
                        } else {
                            this.myshot[i].add(n2, n3, tank.xdir, tank.ydir, 0, 0);
                            this.mytank[n].firedelay = 150;
                        }
                        bl = true;
                        break;
                    }
                }
            } else {
                --this.mytank[n].firedelay;
            }
            ++n;
        }
        return bl;
    }

    public boolean addshot() {
        boolean bl = false;
        for (int i = 0; i < this.myshot.length; ++i) {
            if (this.myshot[i].active) continue;
            int n = this.myplayer.x + this.myplayer.mapx;
            int n2 = this.myplayer.y + this.myplayer.mapy;
            int n3 = n * 32 + this.myplayer.mx + this.myplayer.ox;
            int n4 = n2 * 32 + this.myplayer.my + this.myplayer.oy;
            if (this.myplayer.current_weapon == 0 || this.myplayer.weapon[this.myplayer.current_weapon] > 0) {
                int n5;
                this.play(Sound.ZAP);
                if (this.myplayer.spr == 0 || this.myplayer.spr == 10) {
                    this.myshot[i].add(n3, n4, 0, -1, 1, this.myplayer.current_weapon);
                }
                if (this.myplayer.spr == 2 || this.myplayer.spr == 12) {
                    this.myshot[i].add(n3, n4, 1, 0, 1, this.myplayer.current_weapon);
                }
                if (this.myplayer.spr == 4 || this.myplayer.spr == 14) {
                    this.myshot[i].add(n3, n4, 0, 1, 1, this.myplayer.current_weapon);
                }
                if (this.myplayer.spr == 6 || this.myplayer.spr == 16) {
                    this.myshot[i].add(n3, n4, -1, 0, 1, this.myplayer.current_weapon);
                }
                if (this.myplayer.current_weapon == 1) {
                    int n6 = this.myplayer.current_weapon;
                    this.myplayer.weapon[n6] = this.myplayer.weapon[n6] - 1;
                    if (this.myplayer.weapon[this.myplayer.current_weapon] == 0) {
                        this.myplayer.weapon[this.myplayer.current_weapon] = -1;
                        this.myplayer.current_weapon = 0;
                        if (this.level == Location.FOREST && this.count_sprite(4) > 0 && this.count_sprite(10) == 0) {
                            int n7;
                            int n8;
                            do {
                                n5 = (int)Math.floor(Math.random() * 32.0);
                            } while (this.mymap[n8 = (n7 = (int)Math.floor(Math.random() * 32.0)) * 32 + n5] != 2);
                            this.mymap[n8] = 10;
                        }
                    }
                }
                for (n5 = 2; n5 < 4; ++n5) {
                    if (this.myplayer.current_weapon != n5) continue;
                    int n9 = this.myplayer.current_weapon;
                    this.myplayer.weapon[n9] = this.myplayer.weapon[n9] - 1;
                }
            }
            bl = true;
            break;
        }
        return bl;
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.myplayer.mapx;
        int n8 = this.myplayer.mapy;
        int n9 = -1;
        for (n6 = -32; n6 < 512; n6 += 32) {
            n5 = -1;
            n4 = (n8 + n9) * 32 + n7 + n5;
            for (n3 = -32; n3 < 672; n3 += 32) {
                if (n4 >= 0 && n4 < 1024 && this.visible[n4] && this.block[n2 = this.mymap[n4]] != null) {
                    Map.dest.x = n3 - this.myplayer.mx;
                    Map.dest.y = n6 - this.myplayer.my;
                    if (n2 == 3) {
                        graphics.drawImage(this.block[2], Map.dest.x, Map.dest.y, null);
                    }
                    if (n2 >= 8 && n2 <= 14) {
                        n = 2;
                        graphics.drawImage(this.block[n], Map.dest.x, Map.dest.y, null);
                        if (n2 == 8) {
                            n2 = 1;
                        }
                        if (n2 == 14) {
                            n2 = 1;
                        }
                    }
                    if (this.level == Location.SPACE && n2 == 8) {
                        n2 = 2;
                    }
                    if (this.level == Location.MOUNTAIN && n2 == 0) {
                        n2 = 1;
                    }
                    if ((this.level == Location.MOUNTAIN || this.level == Location.LAKE) && n2 == 4) {
                        graphics.drawImage(this.block[n2], Map.dest.x, Map.dest.y, Map.dest.x + Map.dest.width, Map.dest.y + Map.dest.height, Map.mov_src.x, Map.mov_src.y, Map.mov_src.x + Map.mov_src.width, Map.mov_src.y + Map.mov_src.height, null);
                        n2 = 1;
                    }
                    if (n2 != 11 && n2 != 1) {
                        graphics.drawImage(this.block[n2], Map.dest.x, Map.dest.y, null);
                    }
                }
                ++n4;
            }
            ++n9;
        }
        if (this.level == Location.MOUNTAIN) {
            n9 = -1;
            for (n6 = -32; n6 < 512; n6 += 32) {
                n5 = -1;
                n4 = (n8 + n9) * 32 + n7 + n5;
                for (n3 = -32; n3 < 672; n3 += 32) {
                    if (n4 >= 0 && n4 < 1024 && this.visible[n4] && this.block[n2 = this.mymap[n4]] != null) {
                        Map.dest.x = n3 - this.myplayer.mx;
                        Map.dest.y = n6 - this.myplayer.my;
                        if (n2 == 1) {
                            Map.dest.y += 16;
                            graphics.drawImage(this.block[0], Map.dest.x, Map.dest.y, null);
                        }
                    }
                    ++n4;
                }
                ++n9;
            }
        }
        n9 = -1;
        for (n6 = -32; n6 < 512; n6 += 32) {
            n5 = -1;
            n4 = (n8 + n9) * 32 + n7 + n5;
            for (n3 = -32; n3 < 672; n3 += 32) {
                if (n4 >= 0 && n4 < 1024 && this.visible[n4] && this.block[n2 = this.mymap[n4]] != null) {
                    Map.dest.x = n3 - this.myplayer.mx;
                    Map.dest.y = n6 - this.myplayer.my;
                    if (n2 == 1 || n2 == 3) {
                        graphics.drawImage(this.block[n2], Map.dest.x, Map.dest.y, null);
                    }
                    if (n2 == 8 || n2 == 14) {
                        graphics.drawImage(this.block[n2], Map.dest.x, Map.dest.y, null);
                    }
                }
                ++n4;
            }
            ++n9;
        }
        n9 = -1;
        for (n6 = -32; n6 < 512; n6 += 32) {
            n5 = -1;
            n4 = (n8 + n9) * 32 + n7 + n5;
            for (n3 = -32; n3 < 672; n3 += 32) {
                if (n4 >= 0 && n4 < 1024 && this.block[n2 = this.mymap[n4]] != null && n2 == 11) {
                    Map.bigdest.x = n3 - this.myplayer.mx;
                    Map.bigdest.y = n6 - this.myplayer.my;
                    if (this.level == Location.SPACE) {
                        Map.bigdest.width = 64;
                        graphics.drawImage(this.block[n2], Map.bigdest.x, Map.bigdest.y, null);
                    }
                    if (this.level == Location.FOREST) {
                        Map.bigdest.width = 128;
                        graphics.drawImage(this.block[n2], Map.bigdest.x, Map.bigdest.y, Map.bigdest.x + Map.bigdest.width, Map.bigdest.y + Map.bigdest.height, Map.ship_src.x, Map.ship_src.y, Map.ship_src.x + Map.ship_src.width, Map.ship_src.y + Map.ship_src.height, null);
                    }
                }
                ++n4;
            }
            ++n9;
        }
        n = n7 * 32 + this.myplayer.mx;
        int n10 = n8 * 32 + this.myplayer.my;
        for (Shot shot : this.myshot) {
            shot.draw(graphics, n, n10);
        }
        for (Teleport teleport : this.myteleport) {
            teleport.draw(graphics, n, n10);
        }
        for (Tank tank : this.mytank) {
            tank.draw(graphics, n, n10, this.visible);
        }
        this.myplayer.draw(graphics);
        this.myexplosion.draw(graphics, n, n10);
        if (this.level == Location.ICE) {
            this.mysnow.draw(graphics, n, n10);
        }
        if (this.infotext != null) {
            Color color = new Color(0, 0, 0, 128);
            graphics.setColor(color);
            graphics.fillRect(0, 456, 640, 24);
            graphics.setFont(this.smlFont);
            graphics.setColor(Color.yellow);
            graphics.drawString(this.infotext, 8, 474);
        }
        this.mymessage.draw(graphics);
    }

    public void initmap() {
        try {
            String[] stringArray = new String[]{"station.bmp", "forest.bmp", "mountain.bmp", "ice.bmp", "lake.bmp", "desert.bmp"};
            int n = 0;
            for (String string : stringArray) {
                System.out.println("Loading Map : " + string);
                String string2 = "maps/" + string;
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string2);
                if (inputStream != null) {
                    byte[] byArray = inputStream.readAllBytes();
                    int n2 = byArray[10] + (byArray[11] << 8);
                    this.width = byArray[18] + (byArray[19] << 8);
                    this.height = byArray[22] + (byArray[23] << 8);
                    int n3 = byArray[28] + (byArray[29] << 8);
                    System.out.println("Level - " + string + ": " + this.width + " x " + this.height + " x " + n3);
                    if (this.width * this.height <= this.mymap.length) {
                        if (n3 == 8) {
                            int n4 = 0;
                            for (int i = this.height - 1; i > -1; --i) {
                                for (int j = 0; j < this.width; ++j) {
                                    if (n == 0) {
                                        this.map_space[n4].sprite = byArray[n2 + i * this.width + j];
                                        this.map_space[n4].visible = true;
                                    }
                                    if (n == 1) {
                                        this.map_forest[n4].sprite = byArray[n2 + i * this.width + j];
                                        this.map_forest[n4].visible = true;
                                    }
                                    if (n == 2) {
                                        this.map_mountain[n4].sprite = byArray[n2 + i * this.width + j];
                                        this.map_mountain[n4].visible = false;
                                    }
                                    if (n == 3) {
                                        this.map_ice[n4].sprite = byArray[n2 + i * this.width + j];
                                        this.map_ice[n4].visible = true;
                                    }
                                    if (n == 4) {
                                        this.map_lake[n4].sprite = byArray[n2 + i * this.width + j];
                                        this.map_lake[n4].visible = true;
                                    }
                                    if (n == 5) {
                                        this.map_desert[n4].sprite = byArray[n2 + i * this.width + j];
                                        this.map_desert[n4].visible = true;
                                    }
                                    ++n4;
                                }
                            }
                        } else {
                            System.out.println("Depth should be 8 not " + n3);
                        }
                    } else {
                        System.out.println("Level is too big for map buffer! " + byArray.length + " > " + this.mymap.length);
                    }
                } else {
                    System.out.println("Map file [" + string + "] not found!");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map...");
            System.out.println(exception);
        }
    }

    private boolean map_contains(int n) {
        for (byte by : this.mymap) {
            if (by != n) continue;
            return true;
        }
        return false;
    }

    public void create_solid_map() {
        int n;
        for (n = 0; n < this.solid.length; ++n) {
            this.solid[n] = 0;
        }
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                int n2 = n * 32 + i;
                if (this.mymap[n2] == 1) {
                    this.solid[n2] = 1;
                }
                if (this.mymap[n2] == 3) {
                    this.solid[n2] = 3;
                }
                if (this.mymap[n2] == 4) {
                    this.solid[n2] = 2;
                }
                if (this.mymap[n2] == 6 || this.mymap[n2] == 7) {
                    this.solid[n2] = 1;
                }
                if (this.mymap[n2] == 13) {
                    this.solid[n2] = 1;
                }
                if (this.mymap[n2] == 11) {
                    this.solid[n2] = 11;
                    this.solid[n2 + 1] = 11;
                    if (this.level == Location.FOREST) {
                        this.solid[n2 + 2] = 11;
                        this.solid[n2 + 3] = 11;
                    }
                }
                if (this.level != Location.SPACE || this.mymap[n2] != 8) continue;
                this.solid[n2] = 1;
            }
        }
    }

    public void map_save() {
        for (int i = 0; i < this.mymap.length; ++i) {
            if (this.level == Location.SPACE) {
                this.map_space[i].sprite = this.mymap[i];
                this.map_space[i].visible = this.visible[i];
            }
            if (this.level == Location.FOREST) {
                this.map_forest[i].sprite = this.mymap[i];
                this.map_forest[i].visible = this.visible[i];
            }
            if (this.level == Location.LAKE) {
                this.map_lake[i].sprite = this.mymap[i];
                this.map_lake[i].visible = this.visible[i];
            }
            if (this.level == Location.ICE) {
                this.map_ice[i].sprite = this.mymap[i];
                this.map_ice[i].visible = this.visible[i];
            }
            if (this.level == Location.MOUNTAIN) {
                this.map_mountain[i].sprite = this.mymap[i];
                this.map_mountain[i].visible = this.visible[i];
            }
            if (this.level != Location.DESERT) continue;
            this.map_desert[i].sprite = this.mymap[i];
            this.map_desert[i].visible = this.visible[i];
        }
    }

    public void map_restore() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.mymap.length; ++n4) {
            if (this.level == Location.SPACE) {
                this.mymap[n4] = this.map_space[n4].sprite;
                this.visible[n4] = this.map_space[n4].visible;
            }
            if (this.level == Location.FOREST) {
                this.mymap[n4] = this.map_forest[n4].sprite;
                this.visible[n4] = this.map_forest[n4].visible;
            }
            if (this.level == Location.LAKE) {
                this.mymap[n4] = this.map_lake[n4].sprite;
                this.visible[n4] = this.map_lake[n4].visible;
            }
            if (this.level == Location.ICE) {
                this.mymap[n4] = this.map_ice[n4].sprite;
                this.visible[n4] = this.map_ice[n4].visible;
            }
            if (this.level == Location.MOUNTAIN) {
                this.mymap[n4] = this.map_mountain[n4].sprite;
                this.visible[n4] = this.map_mountain[n4].visible;
            }
            if (this.level != Location.DESERT) continue;
            this.mymap[n4] = this.map_desert[n4].sprite;
            this.visible[n4] = this.map_desert[n4].visible;
        }
        for (n4 = 0; n4 < this.myshot.length; ++n4) {
            this.myshot[n4].clear();
        }
        for (n4 = 0; n4 < this.mytank.length; ++n4) {
            this.mytank[n4].active = false;
        }
        if (this.level == Location.SPACE) {
            for (n4 = 0; n4 < this.mytank.length; ++n4) {
                n3 = (int)Math.floor(Math.random() * 32.0);
                n2 = (int)Math.floor(Math.random() * 32.0);
                n = n2 * 32 + n3;
                if (this.mymap[n] != 2) continue;
                this.mytank[n4].set(n3, n2, Tank.enemy.TANK);
            }
        }
        if (this.level == Location.FOREST) {
            for (n4 = 0; n4 < this.mytank.length; ++n4) {
                n3 = (int)Math.floor(Math.random() * 32.0);
                n2 = (int)Math.floor(Math.random() * 32.0);
                n = n2 * 32 + n3;
                if (this.mymap[n] != 2) continue;
                this.mytank[n4].set(n3, n2, Tank.enemy.TANK);
            }
            if (this.myplayer.weapon[1] == 0 && this.count_sprite(4) > 0 && this.count_sprite(10) == 0) {
                do {
                    n4 = (int)Math.floor(Math.random() * 32.0);
                } while (this.mymap[n2 = (n3 = (int)Math.floor(Math.random() * 32.0)) * 32 + n4] != 2);
                this.mymap[n2] = 10;
            }
        }
        if (this.level == Location.LAKE) {
            for (n4 = 0; n4 < this.mytank.length; ++n4) {
                n3 = (int)Math.floor(Math.random() * 32.0);
                n2 = (int)Math.floor(Math.random() * 32.0);
                n = n2 * 32 + n3;
                if (this.mymap[n] != 2) continue;
                this.mytank[n4].set(n3, n2, Tank.enemy.CRAB);
            }
        }
        if (this.level == Location.ICE) {
            for (n4 = 0; n4 < this.mytank.length; ++n4) {
                n3 = (int)Math.floor(Math.random() * 32.0);
                n2 = (int)Math.floor(Math.random() * 32.0);
                n = n2 * 32 + n3;
                if (this.mymap[n] != 2) continue;
                this.mytank[n4].set(n3, n2, Tank.enemy.TANK);
            }
        }
        if (this.level == Location.MOUNTAIN) {
            for (n4 = 0; n4 < this.mytank.length; ++n4) {
                n3 = (int)Math.floor(Math.random() * 32.0);
                n2 = (int)Math.floor(Math.random() * 32.0);
                n = n2 * 32 + n3;
                if (this.mymap[n] != 2) continue;
                this.mytank[n4].set(n3, n2, Tank.enemy.TURRET);
            }
        }
        if (this.level == Location.DESERT) {
            for (n4 = 0; n4 < this.mytank.length; ++n4) {
                n3 = (int)Math.floor(Math.random() * 32.0);
                n2 = (int)Math.floor(Math.random() * 32.0);
                n = n2 * 32 + n3;
                if (this.mymap[n] != 2) continue;
                this.mytank[n4].set(n3, n2, Tank.enemy.CRAB);
            }
        }
    }

    public int count_sprite(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mymap.length; ++i) {
            if (this.mymap[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public void load_gfx() {
        System.out.println("Loading Level : " + this.level);
        String string = "";
        if (this.level == Location.SPACE) {
            string = "gfx/station/";
        }
        if (this.level == Location.FOREST) {
            string = "gfx/forest/";
        }
        if (this.level == Location.LAKE) {
            string = "gfx/lake/";
        }
        if (this.level == Location.ICE) {
            string = "gfx/ice/";
        }
        if (this.level == Location.MOUNTAIN) {
            string = "gfx/mountain/";
        }
        if (this.level == Location.DESERT) {
            string = "gfx/desert/";
        }
        System.out.println("Map Sprite Path : " + string);
        try {
            URL uRL;
            String[] stringArray = new String[]{"space", "wall", "floor", "", "barrier", "star", "console", "console2"};
            int n = 0;
            for (String string2 : stringArray) {
                if (string2.length() > 0) {
                    uRL = Map.class.getClassLoader().getResource(string + string2 + ".gif");
                    this.block[n] = ImageIO.read(uRL);
                }
                ++n;
            }
            switch (this.level) {
                case SPACE: {
                    stringArray = new String[]{"gfx/collect/satellite.gif", "gfx/collect/cog.gif", "gfx/collect/armour.gif", string + "tv.gif", "gfx/collect/keycard.gif", string + "console-info.gif"};
                    n = 8;
                    for (String string2 : stringArray) {
                        if (string2.length() > 0) {
                            uRL = Map.class.getClassLoader().getResource(string2);
                            this.block[n] = ImageIO.read(uRL);
                        }
                        ++n;
                    }
                    uRL = Map.class.getClassLoader().getResource("gfx/common/fire.gif");
                    this.block[3] = ImageIO.read(uRL);
                    break;
                }
                case FOREST: {
                    stringArray = new String[]{string + "console.gif", "gfx/common/fire.gif", "gfx/collect/diamond.gif", "gfx/collect/scientist.gif", "gfx/collect/rockets.gif", string + "ship.gif", "gfx/collect/satellite.gif", "", "gfx/collect/heart.gif"};
                    n = 6;
                    for (String string2 : stringArray) {
                        if (string2.length() > 0) {
                            uRL = Map.class.getClassLoader().getResource(string2);
                            this.block[n] = ImageIO.read(uRL);
                        }
                        ++n;
                    }
                    uRL = Map.class.getClassLoader().getResource("gfx/common/barrier.gif");
                    this.block[3] = ImageIO.read(uRL);
                    break;
                }
                case LAKE: {
                    stringArray = new String[]{"gfx/common/fire.gif", "gfx/collect/diamond.gif", "gfx/collect/scientist.gif", "gfx/collect/freeze.gif", "", "gfx/collect/satellite.gif", "", "gfx/collect/heart.gif"};
                    n = 7;
                    for (String string2 : stringArray) {
                        if (string2.length() > 0) {
                            uRL = Map.class.getClassLoader().getResource(string2);
                            this.block[n] = ImageIO.read(uRL);
                        }
                        ++n;
                    }
                    uRL = Map.class.getClassLoader().getResource("gfx/common/barrier.gif");
                    this.block[3] = ImageIO.read(uRL);
                    break;
                }
                case MOUNTAIN: {
                    stringArray = new String[]{"gfx/collect/diamond.gif", "gfx/collect/scientist.gif", "gfx/collect/heat.gif", "", "gfx/collect/satellite.gif", "", "gfx/collect/heart.gif"};
                    n = 8;
                    for (String string2 : stringArray) {
                        if (string2.length() > 0) {
                            uRL = Map.class.getClassLoader().getResource(string2);
                            this.block[n] = ImageIO.read(uRL);
                        }
                        ++n;
                    }
                    uRL = Map.class.getClassLoader().getResource("gfx/common/barrier.gif");
                    this.block[3] = ImageIO.read(uRL);
                    break;
                }
                case ICE: {
                    stringArray = new String[]{"gfx/collect/diamond.gif", "gfx/collect/scientist.gif", "gfx/collect/freeze.gif", "", "gfx/collect/satellite.gif", "", "gfx/collect/heart.gif"};
                    n = 8;
                    for (String string2 : stringArray) {
                        if (string2.length() > 0) {
                            uRL = Map.class.getClassLoader().getResource(string2);
                            this.block[n] = ImageIO.read(uRL);
                        }
                        ++n;
                    }
                    uRL = Map.class.getClassLoader().getResource("gfx/common/barrier.gif");
                    this.block[3] = ImageIO.read(uRL);
                    break;
                }
                case DESERT: {
                    stringArray = new String[]{"gfx/collect/diamond.gif", "gfx/collect/scientist.gif", "", "", "gfx/collect/satellite.gif", "", "gfx/collect/heart.gif"};
                    n = 8;
                    for (String string2 : stringArray) {
                        if (string2.length() > 0) {
                            uRL = Map.class.getClassLoader().getResource(string2);
                            this.block[n] = ImageIO.read(uRL);
                        }
                        ++n;
                    }
                    uRL = Map.class.getClassLoader().getResource("gfx/common/barrier.gif");
                    this.block[3] = ImageIO.read(uRL);
                }
            }
            this.map_restore();
            this.create_solid_map();
        }
        catch (Exception exception) {
            System.out.println("Problem loading the basic map sprites...");
            System.out.println(exception);
        }
    }

    public static enum Sound {
        BEEP,
        ZAP,
        TELEPORT;

    }

    public static enum Location {
        SPACE,
        FOREST,
        ROCK,
        ICE,
        DESERT,
        LAKE,
        TOWN,
        MOUNTAIN;

    }
}

