/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

class Intro {
    static Image[] sprite = new Image[10];
    static boolean gfxloaded = false;
    static Point[] stars = new Point[40];
    int frame = 0;
    int ofx = 0;
    String[] txt = new String[10];
    private final Font smlFont = new Font("Arial", 0, 18);
    boolean done = false;
    Point tp = new Point(0, 0);
    Point station_pt = new Point(0, 0);
    Point con_pt = new Point(0, 0);
    private static Clip clip_explosion;
    private static Clip clip_beep;
    static Rectangle ship_src;
    static Rectangle ship_dst;
    Explosion station_exp = new Explosion();
    Color sky = new Color(0, 128, 255);
    int[] angle = new int[]{0, 90, 180, 270};
    int alt = 0;
    int ring = 0;
    Point[] pts = new Point[4];

    public Intro() {
        int n;
        String[] stringArray;
        if (!gfxloaded) {
            stringArray = new String[]{"gfx/forest/ship.gif", "gfx/station/fire.gif", "gfx/collect/satellite.gif", "gfx/intro/tree.gif", "gfx/intro/grass.gif", "gfx/intro/station4.gif", "gfx/intro/star.png", "gfx/intro/cloud.gif", "gfx/intro/planet.gif"};
            try {
                n = 0;
                for (String string : stringArray) {
                    if (string != "") {
                        System.out.println("Loading Intro " + n + " - " + string);
                        URL uRL = Map.class.getClassLoader().getResource(string);
                        Intro.sprite[n] = ImageIO.read(uRL);
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Intro sprites...");
                System.out.println(exception);
            }
            gfxloaded = true;
        }
        try {
            clip_explosion = AudioSystem.getClip();
            stringArray = Map.class.getClassLoader().getResource("snd/explosion.wav");
            clip_explosion.open(AudioSystem.getAudioInputStream((URL)stringArray));
            clip_beep = AudioSystem.getClip();
            stringArray = Map.class.getClassLoader().getResource("snd/beep.wav");
            clip_beep.open(AudioSystem.getAudioInputStream((URL)stringArray));
        }
        catch (Exception exception) {
            System.out.println("Problem loading sound in Intro");
            System.out.println(exception);
        }
        for (int i = 0; i < stars.length; ++i) {
            n = (int)Math.floor(Math.random() * 640.0);
            int n2 = (int)Math.floor(Math.random() * 480.0);
            Intro.stars[i] = new Point(n, n2);
        }
        this.con_pt.x = 440;
        this.con_pt.y = 472;
    }

    public void set_space_part1() {
        Intro.ship_dst.x = 256;
        Intro.ship_dst.y = 224;
        Intro.ship_src.y = 0;
        this.frame = 0;
        this.txt[0] = "While travelling through space, you pick up";
        this.txt[1] = "a distress signal from a research station!";
        this.txt[2] = "You change course to investigate!";
        this.txt[3] = null;
    }

    public void space_part1(Graphics graphics) {
        for (int i = 0; i < stars.length; ++i) {
            Intro.stars[i].x = (i & 1) == 1 ? (Intro.stars[i].x -= 2) : --Intro.stars[i].x;
            if (Intro.stars[i].x < 0) {
                Intro.stars[i].x = 642;
            }
            graphics.drawImage(sprite[6], Intro.stars[i].x, Intro.stars[i].y, null);
        }
        graphics.drawImage(sprite[0], Intro.ship_dst.x, Intro.ship_dst.y, Intro.ship_dst.x + Intro.ship_dst.width, Intro.ship_dst.y + Intro.ship_dst.height, Intro.ship_src.x, Intro.ship_src.y, Intro.ship_src.x + Intro.ship_src.width, Intro.ship_src.y + Intro.ship_src.height, null);
        this.tp.y = 18;
        this.tp.x = 4;
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.yellow);
        for (String string : this.txt) {
            if (string != null) {
                graphics.drawString(string, this.tp.x, this.tp.y);
            }
            this.tp.y += 20;
        }
        if (this.frame >= 100) {
            graphics.setColor(Color.green);
            graphics.drawString("Press Space to Continue", this.con_pt.x, this.con_pt.y);
        } else {
            ++this.frame;
        }
    }

    public void set_space_part2() {
        Intro.ship_dst.x = -128;
        Intro.ship_dst.y = 224;
        this.done = false;
        this.txt[0] = "Approaching the research station, you notice";
        this.txt[1] = "damage to the exterior. You pull up along side";
        this.txt[2] = "the station and teleport over to find out more...";
    }

    public void space_part2(Graphics graphics) {
        for (Point object : stars) {
            graphics.drawImage(sprite[6], object.x, object.y, null);
        }
        graphics.drawImage(sprite[0], Intro.ship_dst.x, Intro.ship_dst.y, Intro.ship_dst.x + Intro.ship_dst.width, Intro.ship_dst.y + Intro.ship_dst.height, Intro.ship_src.x, Intro.ship_src.y, Intro.ship_src.x + Intro.ship_src.width, Intro.ship_src.y + Intro.ship_src.height, null);
        graphics.drawImage(sprite[5], 352, Intro.ship_dst.y - 128, null);
        this.tp.y = 18;
        this.tp.x = 4;
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.yellow);
        for (String string : this.txt) {
            if (string != null) {
                graphics.drawString(string, this.tp.x, this.tp.y);
            }
            this.tp.y += 20;
        }
        if (this.done) {
            graphics.setColor(Color.green);
            graphics.drawString("Press Space to Continue", this.con_pt.x, this.con_pt.y);
        } else {
            for (int i = 0; i < stars.length; ++i) {
                --Intro.stars[i].x;
                if (Intro.stars[i].x >= 0) continue;
                Intro.stars[i].x = 642;
            }
            if (Intro.ship_dst.x < 384) {
                Intro.ship_dst.x += 2;
            } else {
                this.done = true;
            }
        }
    }

    public void set_crash_part1() {
        this.frame = 0;
        Intro.ship_dst.x = 256;
        Intro.ship_dst.y = 224;
        Intro.ship_src.y = 32;
        this.station_pt.x = 64;
        this.station_pt.y = 64;
        for (int i = 0; i < 20; ++i) {
            int n = this.station_pt.x + (int)Math.floor(Math.random() * 240.0);
            int n2 = this.station_pt.y + (int)Math.floor(Math.random() * 112.0);
            if (i == 0) {
                this.station_exp.add(n, n2);
                continue;
            }
            this.station_exp.add_silent(n, n2, true);
        }
        this.done = false;
        this.ofx = 0;
        this.txt[0] = "The station explodes!!";
        this.txt[1] = "You manage to teleport away just in time! Your ship gets";
        this.txt[2] = "caught in the blast and is sent hurtling towards the planet!";
    }

    public void crash_part1(Graphics graphics) {
        for (Point object : stars) {
            graphics.drawImage(sprite[6], object.x, object.y, null);
        }
        graphics.drawImage(sprite[0], Intro.ship_dst.x, Intro.ship_dst.y, Intro.ship_dst.x + Intro.ship_dst.width, Intro.ship_dst.y + Intro.ship_dst.height, Intro.ship_src.x, Intro.ship_src.y, Intro.ship_src.x + Intro.ship_src.width, Intro.ship_src.y + Intro.ship_src.height, null);
        for (int i = 0; i < 3; ++i) {
            graphics.drawImage(sprite[1], Intro.ship_dst.x + i * 32, Intro.ship_dst.y, null);
        }
        graphics.drawImage(sprite[5], this.station_pt.x, this.station_pt.x, null);
        this.station_exp.draw(graphics, 0, 0);
        this.tp.y = 18;
        this.tp.x = 4;
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.yellow);
        for (String string : this.txt) {
            if (string != null) {
                graphics.drawString(string, this.tp.x, this.tp.y);
            }
            this.tp.y += 20;
        }
        if (this.done) {
            graphics.setColor(Color.green);
            graphics.drawString("Press Space to Continue", this.con_pt.x, this.con_pt.y);
        } else {
            int n;
            this.station_exp.update(-1);
            for (n = 0; n < stars.length; ++n) {
                --Intro.stars[n].x;
                --Intro.stars[n].y;
                if (Intro.stars[n].x < 0) {
                    Intro.stars[n].x = 642;
                }
                if (Intro.stars[n].y >= 0) continue;
                Intro.stars[n].y = 482;
            }
            --this.station_pt.x;
            --this.station_pt.y;
            ++Intro.ship_dst.x;
            ++Intro.ship_dst.y;
            if (Intro.ship_dst.y > 480) {
                this.done = true;
            }
            n = this.station_pt.x + (int)Math.floor(Math.random() * 240.0);
            int n2 = this.station_pt.y + (int)Math.floor(Math.random() * 112.0);
            this.station_exp.add_silent(n, n2, false);
        }
    }

    public void set_crash_part2() {
        Intro.ship_dst.x = 256;
        Intro.ship_dst.y = -32;
        this.station_pt.x = 32;
        this.station_pt.y = 32;
        this.done = false;
        this.ofx = 0;
        this.txt[0] = "Your ship and the wreckage from the research station";
        this.txt[1] = "plummet to the ground! Luckily your ship is well built";
        this.txt[2] = "and should not be too damaged...";
        for (int i = 0; i < 20; ++i) {
            Intro.stars[i].x = (int)Math.floor(Math.random() * 1280.0);
            Intro.stars[i].y = (int)Math.floor(Math.random() * 224.0) - 64;
        }
    }

    public void crash_part2(Graphics graphics) {
        int n;
        graphics.setColor(this.sky);
        graphics.fillRect(0, 0, 640, 480);
        graphics.drawImage(sprite[2], 150, Intro.ship_dst.y, null);
        graphics.drawImage(sprite[2], 450, Intro.ship_dst.y, null);
        graphics.drawImage(sprite[1], 150, Intro.ship_dst.y, null);
        graphics.drawImage(sprite[1], 450, Intro.ship_dst.y, null);
        for (n = 0; n < 20; ++n) {
            graphics.drawImage(sprite[7], Intro.stars[n].x, Intro.stars[n].y, null);
        }
        for (n = 0; n < 21; ++n) {
            graphics.drawImage(sprite[3], n * 32 - this.ofx, 416, null);
            graphics.drawImage(sprite[4], n * 32 - this.ofx, 448, null);
        }
        graphics.drawImage(sprite[0], Intro.ship_dst.x, Intro.ship_dst.y, Intro.ship_dst.x + Intro.ship_dst.width, Intro.ship_dst.y + Intro.ship_dst.height, Intro.ship_src.x, Intro.ship_src.y, Intro.ship_src.x + Intro.ship_src.width, Intro.ship_src.y + Intro.ship_src.height, null);
        for (n = 0; n < 4; ++n) {
            graphics.drawImage(sprite[1], Intro.ship_dst.x + n * 32, Intro.ship_dst.y, null);
        }
        this.tp.y = 20;
        this.tp.x = 6;
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.black);
        for (String string : this.txt) {
            if (string != null) {
                graphics.drawString(string, this.tp.x, this.tp.y);
            }
            this.tp.y += 20;
        }
        this.tp.y = 18;
        this.tp.x = 4;
        graphics.setColor(Color.yellow);
        for (String string : this.txt) {
            if (string != null) {
                graphics.drawString(string, this.tp.x, this.tp.y);
            }
            this.tp.y += 20;
        }
        if (this.done) {
            graphics.setColor(Color.green);
            graphics.drawString("Press Space to Continue", this.con_pt.x, this.con_pt.y);
        } else {
            for (int i = 0; i < 20; ++i) {
                --Intro.stars[i].x;
                if (Intro.stars[i].x > -128) continue;
                Intro.stars[i].x = 641;
                Intro.stars[i].y = (int)Math.floor(Math.random() * 224.0);
            }
            this.ofx += 2;
            if (this.ofx == 32) {
                this.ofx = 0;
            }
            Intro.ship_dst.y += 2;
            if (Intro.ship_dst.y >= 416) {
                if (clip_explosion != null) {
                    clip_explosion.setFramePosition(0);
                    clip_explosion.start();
                }
                this.done = true;
            }
        }
    }

    public void set_complete_part1() {
        Intro.ship_dst.x = 0;
        Intro.ship_dst.y = 224;
        Intro.ship_src.y = 0;
        this.txt[0] = "The rescued scientist were able to repair the recovered";
        this.txt[1] = "satellites and with your ship now working, you are able to put";
        this.txt[2] = "them in orbit of the planet!";
        this.done = false;
    }

    public void complete_part1(Graphics graphics) {
        for (Point object : stars) {
            graphics.drawImage(sprite[6], object.x, object.y, null);
        }
        if (Intro.ship_dst.x > 100) {
            graphics.drawImage(sprite[2], 100, Intro.ship_dst.y, null);
        }
        if (Intro.ship_dst.x > 200) {
            graphics.drawImage(sprite[2], 200, Intro.ship_dst.y, null);
        }
        if (Intro.ship_dst.x > 300) {
            graphics.drawImage(sprite[2], 300, Intro.ship_dst.y, null);
        }
        if (Intro.ship_dst.x > 400) {
            graphics.drawImage(sprite[2], 400, Intro.ship_dst.y, null);
        }
        graphics.drawImage(sprite[0], Intro.ship_dst.x, Intro.ship_dst.y, Intro.ship_dst.x + Intro.ship_dst.width, Intro.ship_dst.y + Intro.ship_dst.height, Intro.ship_src.x, Intro.ship_src.y, Intro.ship_src.x + Intro.ship_src.width, Intro.ship_src.y + Intro.ship_src.height, null);
        if (clip_beep != null) {
            clip_beep.setFramePosition(0);
            if (Intro.ship_dst.x == 100) {
                clip_beep.start();
            }
            if (Intro.ship_dst.x == 200) {
                clip_beep.start();
            }
            if (Intro.ship_dst.x == 300) {
                clip_beep.start();
            }
            if (Intro.ship_dst.x == 400) {
                clip_beep.start();
            }
        }
        this.tp.y = 18;
        this.tp.x = 4;
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.white);
        for (String string : this.txt) {
            if (string != null) {
                graphics.drawString(string, this.tp.x, this.tp.y);
            }
            this.tp.y += 20;
        }
        if (this.done) {
            graphics.setColor(Color.green);
            graphics.drawString("Press Space to Continue", this.con_pt.x, this.con_pt.y);
        } else {
            for (int i = 0; i < stars.length; ++i) {
                --Intro.stars[i].x;
                if (Intro.stars[i].x >= 0) continue;
                Intro.stars[i].x = 642;
            }
            Intro.ship_dst.x += 2;
            if (Intro.ship_dst.x >= 640) {
                this.done = true;
            }
        }
    }

    public void set_complete_part2() {
        Intro.ship_src.y = 0;
        this.txt[0] = "With the satellites in orbit and broadcasting, the enemy drones";
        this.txt[1] = "stop functioning and the enemy is not able to portal in more!";
        this.txt[2] = "";
        this.txt[3] = "Well Done!";
        this.angle[0] = 0;
        this.angle[1] = 90;
        this.angle[2] = 180;
        this.angle[3] = 270;
        this.alt = 0;
        this.ring = 20;
        for (int i = 0; i < this.pts.length; ++i) {
            this.pts[i] = new Point();
        }
    }

    public void complete_part2(Graphics graphics) {
        for (Point point : stars) {
            graphics.drawImage(sprite[6], point.x, point.y, null);
        }
        graphics.drawImage(sprite[8], 220, 140, null);
        for (int i = 0; i < 4; ++i) {
            double d = Math.PI * (double)this.angle[i] / 180.0;
            double d2 = 320.0 + (Math.cos(d) * 130.0 - Math.sin(d) * 130.0);
            double d3 = 240.0 + (Math.sin(d) * 130.0 + Math.cos(d) * 130.0);
            graphics.drawImage(sprite[2], (int)d2 - 16, (int)d3 - 16, null);
            if (this.alt == 1) {
                int n = i;
                this.angle[n] = this.angle[n] + 1;
                if (this.angle[i] >= 360) {
                    this.angle[i] = 0;
                }
            }
            this.pts[i].x = (int)d2;
            this.pts[i].y = (int)d3;
        }
        graphics.setColor(Color.green);
        graphics.drawLine(this.pts[0].x, this.pts[0].y, this.pts[1].x, this.pts[1].y);
        graphics.drawLine(this.pts[1].x, this.pts[1].y, this.pts[2].x, this.pts[2].y);
        graphics.drawLine(this.pts[2].x, this.pts[2].y, this.pts[3].x, this.pts[3].y);
        graphics.drawLine(this.pts[3].x, this.pts[3].y, this.pts[0].x, this.pts[0].y);
        if (this.alt == 1) {
            this.ring += 2;
            if (this.ring >= 100) {
                this.ring = 20;
            }
        }
        this.alt = 1 - this.alt;
        this.tp.y = 18;
        this.tp.x = 4;
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.white);
        for (String string : this.txt) {
            if (string != null) {
                graphics.drawString(string, this.tp.x, this.tp.y);
            }
            this.tp.y += 20;
        }
        graphics.setColor(Color.green);
        graphics.drawString("Press Space to Continue", this.con_pt.x, this.con_pt.y);
    }

    static {
        ship_src = new Rectangle(0, 32, 128, 32);
        ship_dst = new Rectangle(0, 0, 128, 32);
    }
}

