/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

class Explosion {
    private static Image explosion_img = null;
    private static boolean gfxloaded = false;
    private static Clip sfx_explosion;
    ExpXY[] explo = new ExpXY[20];

    public Explosion() {
        if (!gfxloaded) {
            URL uRL;
            try {
                uRL = Explosion.class.getClassLoader().getResource("gfx/common/explosion.png");
                explosion_img = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Explosion sprites");
                System.out.println(exception);
            }
            try {
                sfx_explosion = AudioSystem.getClip();
                uRL = Map.class.getClassLoader().getResource("snd/explosion.wav");
                sfx_explosion.open(AudioSystem.getAudioInputStream(uRL));
            }
            catch (Exception exception) {
                System.out.println("Problem loading sound in Explosion");
                System.out.println(exception);
            }
            gfxloaded = true;
        }
        for (int i = 0; i < this.explo.length; ++i) {
            this.explo[i] = new ExpXY();
        }
    }

    public void reset() {
        for (int i = 0; i < this.explo.length; ++i) {
            this.explo[i].active = false;
        }
        if (sfx_explosion != null) {
            sfx_explosion.setFramePosition(0);
        }
    }

    public void add(int n, int n2) {
        for (int i = 0; i < this.explo.length; ++i) {
            if (this.explo[i].active) continue;
            this.explo[i].active = true;
            this.explo[i].x = n;
            this.explo[i].y = n2;
            this.explo[i].dist = 0;
            if (sfx_explosion == null) break;
            if (sfx_explosion.getFramePosition() == sfx_explosion.getFrameLength()) {
                sfx_explosion.setFramePosition(0);
            }
            if (sfx_explosion.getFramePosition() != 0) break;
            sfx_explosion.setFramePosition(0);
            sfx_explosion.start();
            break;
        }
    }

    public void add_silent(int n, int n2, boolean bl) {
        for (int i = 0; i < this.explo.length; ++i) {
            if (this.explo[i].active) continue;
            this.explo[i].active = true;
            this.explo[i].x = n;
            this.explo[i].y = n2;
            this.explo[i].dist = 0;
            if (!bl) break;
            this.explo[i].dist = (int)Math.floor(Math.random() * 16.0);
            break;
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        for (ExpXY expXY : this.explo) {
            if (!expXY.active) continue;
            int n3 = expXY.x - n;
            int n4 = expXY.y - n2;
            graphics.drawImage(explosion_img, n3, n4 + expXY.dist, null);
            graphics.drawImage(explosion_img, n3, n4 - expXY.dist, null);
            graphics.drawImage(explosion_img, n3 + expXY.dist, n4, null);
            graphics.drawImage(explosion_img, n3 - expXY.dist, n4, null);
            int n5 = expXY.dist * 3 / 4;
            graphics.drawImage(explosion_img, n3 + n5, n4 + n5, null);
            graphics.drawImage(explosion_img, n3 - n5, n4 - n5, null);
            graphics.drawImage(explosion_img, n3 + n5, n4 - n5, null);
            graphics.drawImage(explosion_img, n3 - n5, n4 + n5, null);
        }
    }

    public void update(int n) {
        for (int i = 0; i < this.explo.length; ++i) {
            if (!this.explo[i].active) continue;
            ++this.explo[i].dist;
            this.explo[i].x += n;
            this.explo[i].y += n;
            if (this.explo[i].dist < 16) continue;
            this.explo[i].active = false;
        }
    }

    public void update() {
        for (int i = 0; i < this.explo.length; ++i) {
            if (!this.explo[i].active) continue;
            ++this.explo[i].dist;
            if (this.explo[i].dist < 16) continue;
            this.explo[i].active = false;
        }
    }
}

