/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import javax.imageio.ImageIO;

class Dialog {
    public int conv = 0;
    String[] line = new String[10];
    private final Font bigFont = new Font("Arial", 0, 20);
    static Point[] stars = new Point[40];
    Image title_img;
    Image star_img;
    private FontMetrics fmetric;
    Color bg = new Color(0, 0, 0, 128);

    public Dialog() {
        try {
            URL uRL = Dialog.class.getClassLoader().getResource("gfx/title.png");
            this.title_img = ImageIO.read(uRL);
            uRL = Dialog.class.getClassLoader().getResource("gfx/intro/star.png");
            this.star_img = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading Dialog the sprites");
            System.out.println(exception);
        }
    }

    private void clear_lines() {
        for (int i = 0; i < this.line.length; ++i) {
            this.line[i] = null;
        }
    }

    public void set_title_text() {
        this.clear_lines();
        this.line[0] = "Answering a garbled distress call, you arrive at a research";
        this.line[1] = "space station doing top secret work...";
        this.line[2] = "";
        this.line[3] = "Move using the Arrow keys";
        this.line[4] = "Press X to Select, Z to Fire";
        this.line[5] = "";
        this.line[6] = "PRESS SPACE TO START (with intro)";
        this.line[7] = "";
        this.line[8] = "PRESS Z TO START (without intro)";
        for (int i = 0; i < stars.length; ++i) {
            int n = (int)Math.floor(Math.random() * 640.0);
            int n2 = (int)Math.floor(Math.random() * 480.0);
            Dialog.stars[i] = new Point(n, n2);
        }
    }

    public void title(Graphics graphics) {
        int n = this.title_img.getWidth(null);
        int n2 = this.title_img.getHeight(null);
        int n3 = 0;
        Point point = new Point();
        for (Point object : stars) {
            graphics.drawImage(this.star_img, object.x, object.y, null);
        }
        graphics.drawImage(this.title_img, (640 - n) / 2, 32, null);
        point.y = n2 + 64 + 14;
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        for (String string : this.line) {
            if (string != null) {
                int n4 = 640 - this.fmetric.stringWidth(string);
                point.x = n4 / 2;
                if (n3 >= 5) {
                    graphics.setColor(Color.yellow);
                } else {
                    graphics.setColor(Color.white);
                }
                graphics.drawString(string, point.x, point.y);
                ++n3;
            }
            point.y += 28;
        }
        this.draw_footer(graphics);
    }

    void draw_footer(Graphics graphics) {
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        int n = this.fmetric.stringWidth("v3.0a (06/10/2024)");
        int n2 = 640 - n;
        graphics.setColor(Color.yellow);
        graphics.drawString("v3.0a (06/10/2024)", n2, 476);
        graphics.drawString("https://ssjx.co.uk", 2, 476);
    }

    public void collected(Graphics graphics, int n) {
        this.clear_lines();
        switch (n) {
            case 1: {
                this.line[0] = "Access Keycard";
                this.line[1] = "Allows access to computer systems.";
                break;
            }
            case 2: {
                this.line[0] = "Modulus Armour!";
                this.line[1] = "You have found a prototype suit of armour!";
                this.line[2] = "This will help protect you from the enemy drones!";
                this.line[3] = "Press Z to fire!";
                break;
            }
            case 3: {
                this.line[0] = "Omni-Cog!";
                this.line[1] = "Advanced nano-tech capable of repairing";
                this.line[2] = "damaged devices such as teleporters!";
                break;
            }
            case 4: {
                this.line[0] = "The Scientists!";
                this.line[1] = "The scientist you rescue tells you that 3 more";
                this.line[2] = "teleported to this planet. If you can rescue them";
                this.line[3] = "all, they may be able to help stop this invasion!";
                break;
            }
            case 5: {
                this.line[0] = "Rockets";
                this.line[1] = "Rockets can be used to break boulders giving";
                this.line[2] = "access to more areas! Use sparingly as they";
                this.line[3] = "are limited in supply.";
                this.line[4] = "Press X to select.";
                break;
            }
            case 6: {
                this.line[0] = "Freeze Ray";
                this.line[1] = "This weapon can freeze water and lava giving";
                this.line[2] = "you access to more areas!";
                this.line[3] = "Press X to select.";
                break;
            }
            case 7: {
                this.line[0] = "Heat Gun";
                this.line[1] = "This weapon can generate extreme heat which can melt";
                this.line[2] = "super dense ice.";
                this.line[3] = "Press X to select.";
                break;
            }
            case 8: {
                this.line[0] = "Omni Blaster";
                this.line[1] = "The rescued scientists modify your suit weapons";
                this.line[2] = "and create the even more powerful Omni Blaster!";
                this.line[3] = "This has the abilities of all your weapons!";
                this.line[4] = "Use this and find the crashed satellites!";
                break;
            }
            case 9: {
                this.line[0] = "All Scientists Rescued!";
                this.line[1] = "You have rescued all the scientists! Head back";
                this.line[2] = "to your ship for further information.";
                break;
            }
            case 10: {
                this.line[0] = "All Satellites Recovered!";
                this.line[1] = "Head back to your ship to complete your mission!";
            }
        }
        this.show(graphics);
    }

    public void info(Graphics graphics, int n, Map.Location location) {
        this.clear_lines();
        switch (location) {
            case SPACE: {
                if (n == 1) {
                    this.line[0] = "Barrier Controls";
                    this.line[1] = "This Terminal requires an access card";
                }
                if (n == 2) {
                    this.line[0] = "Tetranet Satellite Network";
                    this.line[1] = "When operational, these satellites link to form a planet ";
                    this.line[2] = "wide barrier that will disrupt the drones and prevent";
                    this.line[3] = "the enemy from opening portals!";
                }
                if (n == 3) {
                    this.line[0] = "EXPLOSION!";
                    this.line[1] = "An explosion rocks the station and damages";
                    this.line[2] = "your ship! Find a way off this station now!";
                }
                if (n != 4) break;
                this.line[0] = "Broken Teleporter!";
                this.line[1] = "This device could send you to the planet below";
                this.line[2] = "but is currently broken!";
                break;
            }
            case FOREST: {
                if (n == 1) {
                    this.line[0] = "A Boulder";
                    this.line[1] = "Maybe a rocket will shatter this?";
                }
                if (n == 2) {
                    this.line[0] = "Your Damaged Ship";
                    this.line[1] = "You have found your ship! The crash has drained";
                    this.line[2] = "its power and requires 10 yellow diamonds to repair";
                    this.line[3] = "and restore its functions.";
                }
                if (n == 3) {
                    this.line[0] = "Crystal Barrier!";
                    this.line[1] = "A solid lump of crystal that is resistant to your weapons...";
                }
                if (n == 4) {
                    this.line[0] = "Ship Systems Restored!";
                    this.line[1] = "With the yellow diamonds you have collected, your ship";
                    this.line[2] = "is now fully functional. This includes the teleporter! ";
                    this.line[3] = "";
                    this.line[4] = "Find the all the scientists that escaped to this planet!";
                }
                if (n == 5) {
                    this.line[0] = "The Omni Blaster!";
                    this.line[1] = "The rescued scientists modify your suit weapon and create";
                    this.line[2] = "the Omni Blaster! Use this and find the four crashed satellites!";
                }
                if (n != 6) break;
                this.line[0] = "Find the Satellites";
                this.line[1] = "Find the 4 Tetranet Satellites that crashed into this planet! The rescued";
                this.line[2] = "scientists will be able to fix them for you to put into orbit and";
                this.line[3] = "stop this invasion!";
                break;
            }
            case LAKE: {
                if (n == 1) {
                    this.line[0] = "Crystal Barrier!";
                    this.line[1] = "A solid lump of crystal that is resistant to your weapons...";
                }
                if (n != 2) break;
                this.line[0] = "Great Lake";
                this.line[1] = "Your suit does not work well in water, if only";
                this.line[2] = "you could freeze it to walk across it...";
                break;
            }
            case MOUNTAIN: {
                if (n == 1) {
                    this.line[0] = "Crystal Barrier!";
                    this.line[1] = "A solid lump of crystal that is resistant to your weapons...";
                }
                if (n != 2) break;
                this.line[0] = "Lava!";
                this.line[1] = "This is too hot for your suit. Maybe";
                this.line[2] = "you can find a way cool it down?";
                break;
            }
            case ICE: {
                if (n != 1) break;
                this.line[0] = "Super Dense Ice";
                this.line[1] = "Extreme heat may melt it?";
                break;
            }
            case DESERT: {
                if (n == 1) {
                    this.line[0] = "Crystal Barrier!";
                    this.line[1] = "A solid lump of crystal that is resistant to your weapons...";
                }
                if (n != 2) break;
                this.line[0] = "Earthquake!";
                this.line[1] = "The ground shakes! The shifting rocks may have";
                this.line[2] = "opened some new paths!";
            }
        }
        switch (n) {
            case 89: {
                this.line[0] = "Find your ship!";
                this.line[1] = "You have teleported down to a strange planet! Find your";
                this.line[2] = "ship and find out what is going on!";
                break;
            }
            case 90: {
                this.line[0] = "You need to repair ship";
                this.line[1] = "Before you can get this scientist to safety,";
                this.line[2] = "you must first find and repair your ship.";
                this.line[3] = "Do this by collecting 10 yellow diamonds.";
                break;
            }
            case 91: {
                this.line[0] = "Task Update";
                this.line[1] = "You now have 10 yellow diamonds which you can";
                this.line[2] = "use to fix your ship. Return to your ship for";
                this.line[3] = "further information.";
                break;
            }
            case 92: {
                this.line[0] = "Tetranet Satellite";
                this.line[1] = "Part of the orbital barrier that was on the space station.";
                this.line[2] = "Looks like it was damaged in the impact?";
                break;
            }
            case 100: {
                this.line[0] = "Mission Failed!";
                this.line[1] = "Bad luck, you did not complete your mission this time.";
                this.line[2] = "Maybe try again?";
            }
        }
        this.show(graphics);
    }

    private void show(Graphics graphics) {
        int n;
        int n2 = 170;
        graphics.setColor(this.bg);
        graphics.fillRect(0, n2, 640, 140);
        graphics.setFont(this.bigFont);
        Point point = new Point();
        point.y = n2 + 16;
        boolean bl = false;
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        for (String string : this.line) {
            if (string == null) continue;
            n = this.fmetric.stringWidth(string);
            point.x = (640 - n) / 2;
            if (!bl) {
                graphics.setColor(Color.cyan);
                graphics.drawString(string, point.x, point.y);
                point.y += 8;
                bl = true;
            } else {
                graphics.setColor(Color.white);
                graphics.drawString(string, point.x, point.y);
            }
            point.y += 22;
        }
        String string = "Press Space to continue...";
        n = this.fmetric.stringWidth(string);
        point.x = (640 - n) / 2;
        point.y = n2 + 140 - 4;
        graphics.setColor(Color.green);
        graphics.drawString(string, point.x, point.y);
    }
}

