/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Another
extends JPanel
implements KeyListener {
    public static final String title = "Another Adventure";
    public static final String version = "v3.0a (06/10/2024)";
    public static final String url = "https://ssjx.co.uk";
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    int xd;
    int yd;
    Map mymap = new Map();
    Dialog mydialog = new Dialog();
    Intro myintro = new Intro();
    State gamestate = State.WELCOME;
    public static final int swidth = 640;
    public static final int sheight = 480;
    public static final long fpsdelay = 15L;
    int intropart = 0;
    boolean show_ad = true;

    public Another() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        this.setgamestate(State.WELCOME);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Another.this.update();
                    Another.this.repaint();
                    try {
                        Thread.sleep(15L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Another Adventure v3.0a (06/10/2024) https://ssjx.co.uk");
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Another());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void startgame() {
        this.up = false;
        this.down = false;
        this.left = false;
        this.right = false;
        this.mymap.reset();
        this.mymap.load_gfx();
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 480);
        switch (this.gamestate) {
            case MOVIE: 
            case INTRO: {
                if (this.intropart == 0) {
                    ++this.intropart;
                    this.myintro.set_space_part1();
                }
                if (this.intropart == 1) {
                    this.myintro.space_part1(graphics);
                }
                if (this.intropart == 2) {
                    this.myintro.space_part2(graphics);
                }
                if (this.intropart == 3) {
                    this.myintro.crash_part1(graphics);
                }
                if (this.intropart == 4) {
                    this.myintro.crash_part2(graphics);
                }
                if (this.intropart == 5) {
                    this.myintro.complete_part1(graphics);
                }
                if (this.intropart != 6) break;
                this.myintro.complete_part2(graphics);
                break;
            }
            case WELCOME: {
                this.mydialog.title(graphics);
                break;
            }
            case GAME: {
                this.mymap.update(this.xd, this.yd);
                this.xd = 0;
                this.yd = 0;
                if (this.mymap.movie != 0) {
                    this.intropart = this.mymap.movie;
                    this.setgamestate(State.INTRO);
                    return;
                }
                this.mymap.draw(graphics);
                if (this.mymap.collected > 0) {
                    this.gamestate = State.COLLECTED;
                }
                if (this.mymap.forceinfo > 0 && this.mymap.forceinfo < 100) {
                    this.mymap.moreinfo = this.mymap.forceinfo;
                    this.gamestate = State.INFORMATION;
                }
                if (this.mymap.forceinfo != 100) break;
                this.mymap.moreinfo = this.mymap.forceinfo;
                this.gamestate = State.OVER;
                break;
            }
            case COLLECTED: {
                this.mymap.draw(graphics);
                this.mydialog.collected(graphics, this.mymap.collected);
                break;
            }
            case INFORMATION: {
                this.mymap.draw(graphics);
                this.mydialog.info(graphics, this.mymap.moreinfo, this.mymap.level);
                break;
            }
            case OVER: {
                this.mymap.draw(graphics);
                this.mydialog.info(graphics, this.mymap.moreinfo, this.mymap.level);
            }
        }
    }

    public void setgamestate(State state) {
        switch (state) {
            case MOVIE: 
            case INTRO: {
                if (this.intropart == 1) {
                    this.myintro.set_space_part1();
                }
                if (this.intropart == 2) {
                    this.myintro.set_space_part2();
                }
                if (this.intropart == 3) {
                    this.myintro.set_crash_part1();
                }
                if (this.intropart == 4) {
                    this.myintro.set_crash_part2();
                }
                if (this.intropart == 5) {
                    this.myintro.set_complete_part1();
                }
                if (this.intropart != 6) break;
                this.myintro.set_complete_part2();
                break;
            }
            case WELCOME: {
                this.mydialog.set_title_text();
                break;
            }
            case GAME: {
                this.startgame();
            }
        }
        this.gamestate = state;
    }

    private void update() {
        if (this.gamestate == State.GAME) {
            if (!this.mymap.myplayer.hide) {
                this.xd = 0;
                this.yd = 0;
                if (this.left) {
                    this.xd = -1;
                }
                if (this.right) {
                    this.xd = 1;
                }
                if (this.up) {
                    this.yd = -1;
                }
                if (this.down) {
                    this.yd = 1;
                }
            }
        } else {
            this.up = false;
            this.down = false;
            this.left = false;
            this.right = false;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = false;
                    break;
                }
                case 40: {
                    this.down = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                    break;
                }
                case 88: {
                    this.mymap.myplayer.next_weapon();
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 90: {
                    if (this.mymap.myplayer.firedelay != 0) break;
                    this.mymap.addshot();
                    this.mymap.myplayer.firedelay = 15;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        block0 : switch (this.gamestate) {
            case MOVIE: {
                if (c != ' ') break;
                ++this.intropart;
                this.setgamestate(State.MOVIE);
                break;
            }
            case INTRO: {
                if (c != ' ') break;
                if (this.intropart == 1) {
                    this.myintro.set_space_part2();
                    ++this.intropart;
                } else if (this.intropart == 2) {
                    this.setgamestate(State.GAME);
                }
                if (this.intropart == 3) {
                    this.myintro.set_crash_part2();
                    ++this.intropart;
                } else if (this.intropart == 4) {
                    this.mymap.movie = -3;
                    this.gamestate = State.GAME;
                }
                if (this.intropart == 5) {
                    this.myintro.set_complete_part2();
                    ++this.intropart;
                    break;
                }
                if (this.intropart != 6) break;
                this.setgamestate(State.WELCOME);
                break;
            }
            case WELCOME: {
                switch (c) {
                    case ' ': {
                        this.intropart = 1;
                        this.setgamestate(State.INTRO);
                        break block0;
                    }
                    case 'z': {
                        this.setgamestate(State.GAME);
                        break block0;
                    }
                    case 'h': {
                        Welcome welcome = new Welcome(this);
                        break block0;
                    }
                    case 'm': {
                        this.setgamestate(State.MOVIE);
                        break block0;
                    }
                }
                break;
            }
            case GAME: {
                switch (c) {
                    case ' ': {
                        if (this.mymap.level == Map.Location.SPACE) {
                            if (this.mymap.facing == 6) {
                                if (this.mymap.myinventory.have("Omnicog")) {
                                    if (!this.mymap.myplayer.hide) {
                                        this.mymap.teleport_add(this.mymap.actualx, this.mymap.actualy);
                                        this.mymap.myplayer.hide = true;
                                        this.mymap.myinventory.add("AWAY");
                                        return;
                                    }
                                } else {
                                    this.mymap.moreinfo = 4;
                                    this.gamestate = State.INFORMATION;
                                }
                            }
                            if (this.mymap.facing == 7) {
                                if (this.mymap.myinventory.have("Keycard")) {
                                    this.mymap.set(this.mymap.actualx + 1, this.mymap.actualy + 0, 2);
                                    this.mymap.set(this.mymap.actualx + 1, this.mymap.actualy + 1, 2);
                                    this.mymap.set(this.mymap.actualx + 1, this.mymap.actualy + 2, 2);
                                    this.mymap.create_solid_map();
                                } else {
                                    this.mymap.moreinfo = 1;
                                    this.gamestate = State.INFORMATION;
                                }
                            }
                            if (this.mymap.facing == 13 && this.mymap.myinventory.have("Keycard")) {
                                this.mymap.moreinfo = 2;
                                this.gamestate = State.INFORMATION;
                            }
                        }
                        if (this.mymap.level == Map.Location.FOREST) {
                            if (this.mymap.facing == 3) {
                                this.mymap.moreinfo = 3;
                            }
                            if (this.mymap.facing == 4) {
                                this.mymap.moreinfo = 1;
                            }
                            if (this.mymap.facing == 11) {
                                switch (Map.mission) {
                                    case 0: {
                                        Map.mission = 1;
                                        this.mymap.moreinfo = 2;
                                        break;
                                    }
                                    case 1: {
                                        if (this.mymap.myplayer.diamonds == 10) {
                                            this.mymap.moreinfo = 4;
                                            Map.ship_src.y = 0;
                                            ++Map.mission;
                                            break;
                                        }
                                        this.mymap.moreinfo = 2;
                                        break;
                                    }
                                    case 2: {
                                        if (this.mymap.myinventory.count("Scientist") == 4) {
                                            this.mymap.moreinfo = 5;
                                            this.mymap.myplayer.omni_only();
                                            ++Map.mission;
                                            break;
                                        }
                                        this.mymap.moreinfo = 4;
                                        break;
                                    }
                                    case 3: {
                                        if (this.mymap.myinventory.count("Satellite") == 4) {
                                            this.intropart = 5;
                                            this.setgamestate(State.INTRO);
                                            break;
                                        }
                                        this.mymap.moreinfo = 6;
                                    }
                                }
                            }
                            if (this.mymap.moreinfo > 0) {
                                this.gamestate = State.INFORMATION;
                            }
                        }
                        if (this.mymap.level == Map.Location.LAKE) {
                            if (this.mymap.facing == 3) {
                                this.mymap.moreinfo = 1;
                            }
                            if (this.mymap.facing == 4) {
                                this.mymap.moreinfo = 2;
                            }
                            if (this.mymap.moreinfo > 0) {
                                this.gamestate = State.INFORMATION;
                            }
                        }
                        if (this.mymap.level == Map.Location.MOUNTAIN) {
                            if (this.mymap.facing == 3) {
                                this.mymap.moreinfo = 1;
                            }
                            if (this.mymap.facing == 4) {
                                this.mymap.moreinfo = 2;
                            }
                            if (this.mymap.moreinfo > 0) {
                                this.gamestate = State.INFORMATION;
                            }
                        }
                        if (this.mymap.level == Map.Location.DESERT) {
                            if (this.mymap.facing == 3) {
                                this.mymap.moreinfo = 2;
                            }
                            if (this.mymap.moreinfo > 0) {
                                this.gamestate = State.INFORMATION;
                            }
                        }
                        if (this.mymap.level != Map.Location.ICE) break;
                        if (this.mymap.facing == 1) {
                            this.mymap.moreinfo = 1;
                        }
                        if (this.mymap.moreinfo <= 0) break;
                        this.gamestate = State.INFORMATION;
                        break;
                    }
                    case 'I': {
                        this.mymap.myinventory.list();
                        break;
                    }
                    case '\u001b': {
                        if (this.gamestate != State.GAME) break;
                        this.setgamestate(State.WELCOME);
                    }
                }
                break;
            }
            case COLLECTED: {
                if (c != ' ') break;
                this.mymap.collected = 0;
                this.gamestate = State.GAME;
                break;
            }
            case INFORMATION: {
                if (c != ' ') break;
                this.mymap.forceinfo = 0;
                this.mymap.moreinfo = 0;
                this.gamestate = State.GAME;
                break;
            }
            case OVER: {
                if (c != ' ') break;
                this.mymap.forceinfo = 0;
                this.mymap.moreinfo = 0;
                this.setgamestate(State.WELCOME);
            }
        }
    }

    public static enum Direction {
        NONE,
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static enum State {
        INTRO,
        WELCOME,
        GAME,
        COLLECTED,
        INFORMATION,
        OVER,
        MOVIE;

    }
}

