'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''''
'' Draw Snow / Rain
''

type mysnow

private:		
	dim x(40) as integer
	dim y(40) as integer
	dim s(40) as integer
			
	dim sprite(5) as any ptr
	
public:
	dim as integer season

	declare constructor()
	declare sub reset()
	declare sub update()
	declare sub draw()
end type

constructor mysnow()

	dim as integer i
	
	'' Snow flake sprite	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 8, 8,rgb(100,255,100) )
	next i

	const path as string ="gfx\snow\"

	'' 8x8 sprites
	bload path+"flake.bmp",this.sprite(0)
	bload path+"rain.bmp",this.sprite(1)

	reset()
end constructor

sub mysnow.reset()
	dim as integer i
	''default positions!
	for i=0 to ubound(x)
		x(i)=int(rnd*800)
		y(i)=int(rnd*600)
		s(i)=0
	next i
end sub

'sub mysnow.load()
'end sub


sub mysnow.update()
	if season=SPRING or season=SUMMER then return
	
	dim as integer i

	for i=0 to ubound(x)
	
		y(i)+=1
		
		if season=AUTUMN then x(i)-=1
		
		if y(i)>600 then
			x(i)=int(rnd*800)
			y(i)=0
		end if
	
		if x(i)<0 then x(i)=800
			
	
	next i

end sub

sub mysnow.draw()

	if season=SPRING or season=SUMMER then return

	dim as integer i
	
	color rgb(255,255,255)
	
	for i=0 to ubound(x)
	
		if (season=WINTER) then	put (x(i),y(i)),sprite(0),trans
		if (season=AUTUMN) then	put (x(i),y(i)),sprite(1),trans
	
	next i
end sub


