'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''
'' Level Selector
''

type myselect

private:	
	dim as integer press(13)
	dim as integer key(13)
	dim mapwidth as integer
	dim mapheight as integer
	
	dim basemap(32*32) as ubyte 
	
	dim as integer level_high=1	'' hold high level if we swap view
	
	dim as integer mousex,mousey,mousebutton,mousedown,rightdown
	dim sprite(30) as any ptr
	
	dim as string path
	dim as integer row,ly,lx
	
public:
	dim as integer lvlsource=0
	dim as integer maxlevels

	dim as integer level	
	dim as integer high	'' furthest level
			
	declare constructor()

	declare sub show()
	declare function control() as integer
	declare sub thumb()
	declare sub source()
	
	declare function load(as integer) as integer
	declare sub flip()
end type

constructor myselect()
	key(0)=SC_UP
	key(1)=SC_DOWN
	key(2)=SC_LEFT
	key(3)=SC_RIGHT	
	key(4)=SC_1
	key(5)=SC_2
	key(6)=SC_COMMA
	key(7)=SC_PERIOD
	key(8)=SC_A
	key(9)=SC_E
	key(10)=SC_DELETE
	key(11)=SC_SPACE
	key(12)=SC_ESCAPE
	key(13)=SC_M
	
	path="levels\"
		
	'' Thumbnail sprite	
	dim as integer i
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 125, 95,rgb(100,255,100) )
	next i
	
	high=1
	level=1
	
	thumb()
	
end constructor

sub myselect.thumb()
	dim as integer lev,i,j
	dim as integer c,pos
	dim as uinteger col 
	dim as integer x,y

	for lev=1 to ubound(sprite)
	
	if (load(lev)<>-1) then
		
		'' Thumbnail background
		y=0
		for j=0 to 18
			col=rgb(j*13,j*13,255-(j*13))
			line sprite(lev),(0,y)-(124,y+5),col,bf 
			
			y+=5
		next j
		
		y=0
		for j=0 to 18
			x=0
			c=pos+(j*mapwidth) '' Needed as map is smaller than map bitmap!
			for i=0 to 24
		
			col=-1
			if basemap(c)=0 then  col=rgb(128,64,0)
			if basemap(c)=1 then  col=rgb(0,150,0)
			if basemap(c)=2 then  col=rgb(255,100,0)
			
			if basemap(c)=3 or basemap(c)=4 then col=rgb(0,200,255)	'' water
			
			if basemap(c)=7 or basemap(c)=16 then col=rgb(0,150,0)	'' Seeds
			
			if basemap(c)=9 then  col=rgb(0,64,0)		'' Break
			
			if basemap(c)=10 then  col=rgb(255,255,0)
			if basemap(c)=11 then  col=rgb(255,0,0)
			if basemap(c)=12 then  col=rgb(192,192,192)	'' Spikes
			
			if basemap(c)=13 then  col=rgb(128,128,128)	'' Spikes
			
			if basemap(c)=23 then  col=rgb(128,64,0)	'' Drop
			
			'if basemap(c)=255 then  col=rgb(0,100,255)
			
			if col<>-1 then	line sprite(lev),(x,y)-(x+5,y+5),col,bf 
			
			c+=1
			x+=5
			next i
			y+=5
		next j
	else
		exit for
	end if	
	next lev

	maxlevels=(lev-1)

end sub

sub myselect.source()

	'if (s<>-1) then	lvlsource=s
	
	
	select case as const lvlsource
	case 0:
		level_high=high
		path="levels\"
		thumb()
	case 1:
		path="user\"
		thumb()
		level_high=maxlevels
	end select

	level=1		'' Reset highlight box
	row=0
	ly=0
	lx=0
	'thumb()

end sub

function myselect.load(level as integer) as integer
	dim  header as bmphdr
	'' Load the map
		
	if  Open(path+str(level)+".bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,basemap()  
	        Close #1     
	              
	        mapwidth=header.w
		mapheight=header.h      
	              
	        flip()     
	        
	else
	'	print "Error! Could not load level "+str(level)		
		return -1 
	end if
	
	return 0
end function

sub myselect.flip()
	dim as integer i,j,c
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
		temp(i)=basemap(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			basemap(c+i)=temp((mapheight*( (mapheight-1)-j))+i)  '' 32*(31-j)
		next i
		c+=mapwidth	''32
	next j
	

end sub


sub myselect.show()

	dim as integer i,j,x,y=100,c

	const as integer pos=(800-(4*125))/5

	text.color(0,255,255)
	
	if lvlsource=0 then
	'	text.centre(60,"Main Game Levels")
		text.centre(500,"Click to select, Click again to start!")
		
	else
	'	text.centre(60,"User Created Levels")
		text.centre(500,"Left click to select , Right click to [E]dit, [A]dd, [Delete]")
	end if


	text.color(0,255,0)
	text.centre(540,"Escape to Return")
	
	text.color(255,255,255)

	c=1+(row*4)
	
	for j=0 to 2
		x=pos
		
		for i=0 to 3
		
			if c<=level_high then
			
				if level=c then
				
					line (x-3,y-3)-(x+127,y+97),rgb(255,0,0),bf 
			
					put (x,y),sprite(c),pset
				else
				
					put (x,y),sprite(c),pset
				end if
			
			
				text.show(x+30,y+95,"Level "+str(c))
		
			end if
			
			c+=1
			x+=(125+pos)
		next i
		
		y+=(95+30)
		
	next j

'	text.show(0,0,"Max:"+str(maxlevels)+" Hi:"+str(high))
'	draw string(0,20),"Level "+str(level)
'	draw string(0,40),"Row "+str(row)
'	draw string(0,60),"LX "+str(lx)+" LY "+str(ly)

end sub

function myselect.control() as integer
	dim as integer i,j,x,y=100,c=1
	dim as integer hitkey=0
	const as integer pos=(800-(4*125))/5	
	dim as integer opt=0
	''
	
	if getmouse(mousex,mousey,,mousebutton)=0 then		
		if mousebutton and 1 then
		mousedown=1	
		end if
		
		if lvlsource=1 then
			if mousebutton and 2 then
			rightdown=1	
			end if
		end if
		
			
	end if'
	
	if (mousebutton and 1)=0 and mousedown=1 then
		mousedown=0
		
			for j=0 to 2
				x=pos
				
				for i=0 to 3
				
				if c<=level_high then
					if mousex>x and mousex<x+125 then
						if mousey>y and mousey<y+95 then
						
						if level=c+(row*4) then
							'clicking already selected starts the level
							hitkey=SC_SPACE
						else
							level=c+(row*4)
						end if
						
						end if
					end if
				
					c+=1
					x+=(125+pos)
				else
					exit for
				end if
				next i
				
				y+=(95+30)
			next j	
		
	end if
	
	if (mousebutton and 2)=0 and rightdown=1 then
		rightdown=0	
	
			for j=0 to 2
				x=pos
				
				for i=0 to 3
				
				if c<=level_high then
					if mousex>x and mousex<x+125 then
						if mousey>y and mousey<y+95 then
						
							level=c+(row*4)
							hitkey=SC_E
						
						
						end if
					end if
				
					c+=1
					x+=(125+pos)
				else
					exit for
				end if
				next i
				
				y+=(95+30)
			next j
	
	end if
	
	
	'''
	for i=0 to ubound(key)
		'' Arrow Key 
		if  MultiKey( key(i) ) and press(i)=0 then
			press(i)=1 
		end if
		
		if  MultiKey(key(i) )=0 and press(i)=1  then
			press(i)=0
			hitkey=key(i)
			 
		end if
	next i
	
	'if hitkey=SC_COMMA or hitkey=SC_1 then lvlsource=0: source()
	'if hitkey=SC_PERIOD or hitkey=SC_2 then lvlsource=1: source()

	
	select case as const hitkey
	case SC_UP:
	
		if (ly=0 and row>0) then
			row-=1
		else
			if ly>0 then ly-=1
		end if
		
		if (level-4)>=1 then level-=4
		
	case SC_DOWN:
		if (ly=2) then
		
			if ((3+row)*4)<level_high then
				row+=1	
			end if
		else
			ly+=1
		end if
	
		if (level+4)<=level_high then
			level+=4
		else
			level=level_high
		
			'' if bottom row has less that 4 levels
			'' work out where 'x' position of box is
			'' E.g : 3 - (16 - 13)
			lx=3-(((3+row)*4)-level)
			
			
		end if
		
	case SC_LEFT:
		if level>1 then
			level-=1
			lx-=1
			if lx<0 then lx=3:ly-=1
		end if
		
		if level<=((3+row)*4)-12 then
			row-=1
			ly=0
		end if
		
		
	case SC_RIGHT:
		if level<level_high then
			level+=1	
			lx+=1
			if lx>3 then lx=0:ly+=1
		end if
	
		if (level>(3+row)*4) then
			row+=1
			ly=2	
		end if
	
		
	case SC_DELETE:
		if lvlsource=1 then
		
			dialog.reset()
			opt=dialog.show("Really delete this level!?","Yes, please!","No, thanks!")
			if opt=0 then
				kill("user\"+str(level)+".bmp")
			
				for i=level+1 to 12 
			
				If FileExists( "user\"+str(i)+".bmp" ) then
					name("user\"+str(i)+".bmp","user\"+str(i-1)+".bmp")
				else
					exit for
				end if
				
				next i
				
				'' Sort out thumb nails and update maxlevel counter
				thumb()
				level_high=maxlevels
			end if
			
		end if
	end select


	return hitkey
		
end function
