'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''
'' All new player handling! 
''

common shared inventory as myinventory
common shared map as mymap


type myplayer

private:	
	dim as integer jump,accel,fall
	dim as integer alt,spr	
	dim as integer x,y,ox,oy,xdir
	dim as integer spacepressed
	
	dim as integer commapressed
	dim as integer stoppressed
	
	dim as integer startx,starty
	dim as integer invincible
	dim as integer inwater

	dim sprite(15) as any ptr
	
	declare sub move(as integer)
	declare sub slide()	
	
public:
	dim as integer rings
	dim as integer done
	dim as integer health
	
	dim as integer score
	dim as integer leap
	
	declare constructor()
	declare sub reset()
	declare sub start(as integer,as integer)
	declare sub show()
	declare sub update()
	declare sub control()
	declare sub loadsprites()

	'' Only needed for screen transition...
	declare function curypos() as integer
	declare function curxpos() as integer
	declare function cursprite() as integer
	
	
	declare function insolid() as integer
end type

constructor myplayer()
	reset()
end constructor


sub myplayer.start(mx as integer,my as integer)
	startx=mx
	starty=my
	x=mx
	y=my
	ox=0
	oy=0
end sub

sub myplayer.reset()
	rings=0
	done=0
	alt=0
	spr=2
	invincible=0
	leap=5
	inwater=0
	'health=5
end sub

sub myplayer.loadsprites()

	dim i as integer	
	for i=0 to 9
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	for i=10 to ubound(sprite)
		sprite(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i

	'' Load
	dim path as string="gfx\player\"

	bload path+"left.bmp",sprite(0)
	bload path+"left_1.bmp",sprite(1)
	bload path+"right.bmp",sprite(2)
	bload path+"right_1.bmp",sprite(3)
	bload path+"up.bmp",sprite(4)
	bload path+"up_1.bmp",sprite(5)
	
	path="gfx\"
	bload path+"heart1.bmp",sprite(10)
	bload path+"heart2.bmp",sprite(11)	

	bload path+"orb1.bmp",sprite(12)
	bload path+"orb2.bmp",sprite(13)	

end sub

function myplayer.curxpos() as integer
	return (x*32)+ox
end function

function myplayer.curypos() as integer
	return (y*32)+oy
end function

function myplayer.cursprite() as integer
	return spr+alt
end function

sub myplayer.show()
	dim as integer i

	if (invincible>0) then
		'' flickery player...
		if (invincible mod 2)=0 then
			put ((x*32)+ox,(y*32)+oy),sprite(spr+alt),trans		
		end if
		
	else
		put ((x*32)+ox,(y*32)+oy),sprite(spr+alt),trans
	
	end if
	
	'' Guages for hearts / orbs
	for i=1 to 5
		'' Health hearts!
		if i<=health then
			put (450+((i-1)*24),0),sprite(11),trans
		else
			put (450+((i-1)*24),0),sprite(10),trans
		end if	
	
		'' Jump orbs
		if i<=leap then
			put (450+((i-1)*24),16),sprite(13),trans
		else
			put (450+((i-1)*24),16),sprite(12),trans
		end if	
	next i 
	
	''draw string(20,20),"Accel:"+str(accel)+" Jump:"+str(jump)
	
end sub

sub myplayer.update()
	dim as integer pos
	dim as integer xpos  '=(x*32)+ox
	dim as integer ypos  '=(y*32)+oy
	
	fall=0
	if jump=0 then
		'Falling!
				
		for i as integer=0 to 1
			xpos=(x shl 5)+ox	'' *32
			ypos=(y shl 5)+oy
		
		
			'' Not on a ladder ' '
			
			'if map.over(xpos,ypos+1,2)=0 and map.over(xpos,ypos+1,5)=0 and map.over(xpos,ypos+1,6)=0 then
	
			if map.oversolid(xpos,ypos+1,2)=0 then
				if map.hit(xpos,ypos+1)=0  then
					'' empty space/nothing
					oy+=1
					if oy>=32 then
						oy=0
						y+=1
						if y>18 then y=-1
					end if
					
					fall=1
				end if
			end if
		next i
		
	else
		jump-=1
		for i as integer=0 to 1
		
			xpos=(x shl 5)+ox	'' *32
			ypos=(y shl 5)+oy
		
			if map.hit(xpos,ypos-1)=0 then
				oy-=1
				if oy<=0 then y-=1:oy=32
			else 
				'' hit ceiling
				jump=0
				exit for
			end if
		next i
	end if
	
	'' Collected anything?
	
	'' Colleced a ring!
	pos=map.collect(xpos,ypos,10)
	if pos>-1 then
		FSOUND_PlaySound(FSOUND_FREE, sample(0))
		map.setpos(pos,255):rings+=1
		'score+=10
	end if
	
	'' Collected a bucket!
	pos=map.collect(xpos,ypos,21)
	if pos>-1 then
		FSOUND_PlaySound(FSOUND_FREE, sample(0))
		map.setpos(pos,255)
		inventory.add(4)
	end if
	
	'' Collected a heart!
	pos=map.collect(xpos,ypos,22)
	if pos>-1 then
		if health<5 then
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			map.setpos(pos,255)
			health+=1
		end if
	end if
	
	'' Collected Jump Orb
	pos=map.collect(xpos,ypos,24)
	if pos>-1 then
		if leap<5 then
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			map.setpos(pos,255)
			leap+=1
		end if
	end if
	
	
	
	
	
	'' On the exit sign!
	if map.over(xpos,ypos,11)=1 and rings=map.rings then done=1	

	'' In water
	if map.over(xpos,ypos,4)=1 then
		if inventory.count(4)=1 then
			inventory.remove(4)
			inventory.add(5)
		end if
		
		inwater+=1
		
		if inwater>(30*5) then
			health-=1
			invincible=60
			inwater=0
		end if
	else
		inwater=0
	end if

	'' On a SPIKE or similar
	if invincible=0 then
		if map.oversolid(xpos,ypos,3)=1 then
			
			'' Fire is really bad!
			if map.over(xpos,ypos,19)=1 then
				
				'' Bucket o' water!
				if inventory.count(5)=1 then
					inventory.remove(5)
					inventory.add(4)
					map.set(map.solidx,map.solidy,255)
					
					FSOUND_PlaySound(FSOUND_FREE, sample(7))
				else
					health-=3
					invincible=60
				end if
			
			else
				'' Spikes or something else...
				health-=1
				invincible=60
			end if
			
		end if
	else
		invincible-=1
	end if
	
	
end sub



sub myplayer.control()
dim as integer key=0


	if  MultiKey(SC_LEFT) then
		move(SC_LEFT)
		if jump=0 and fall=0 then accel-=5
		xdir=-1
		key=1
	end if
	
	if  MultiKey(SC_RIGHT) then
		move(SC_RIGHT)
		if jump=0 and fall=0 then accel+=5
		xdir=1
		key=1
	end if

	if  MultiKey(SC_UP) then
		move(SC_UP)
		xdir=0
		accel=0
	end if
	
	if  MultiKey(SC_DOWN) then
		move(SC_DOWN)
	end if
	
	'' Inventory Selection 
	if  MultiKey(SC_COMMA) and commapressed=0 then
		commapressed=1
	end if
	
	if  MultiKey(SC_COMMA)=0 and commapressed=1 then
		commapressed=0
		inventory.prv()
	end if
	
	
	if  MultiKey(SC_PERIOD) then
		stoppressed=1
	end if
	
	if  MultiKey(SC_PERIOD)=0 and stoppressed=1 then
		stoppressed=0
		inventory.nxt()
	end if
	'' End of inventory selection
	
	
	if  MultiKey(SC_SPACE) and spacepressed=0 then
		spacepressed=1
		move(SC_SPACE)
	end if
	
	if MultiKey(SC_SPACE)=0 and spacepressed=1 then
		spacepressed=0
		move(SC_SPACE)
	end if
	
'	if MultiKey(SC_SPACE)=0 and spacepressed=1 then spacepressed=0
	
	if accel>100 then accel=100
	if accel<-100 then accel=-100
	
	if accel>0 then accel-=1
	if accel<0 then accel+=1
	
	if  map.current_season=WINTER and accel<>0 and key=0 then
		slide()
	end if
end sub


sub myplayer.slide()
	dim as integer ax,ay
	
	ax=(x shl 5)+ox	'' <<*32
	ay=(y shl 5)+oy

	if xdir=-1 then
	'	xdir=-1
		if map.hit(ax-1,ay)=0 and ax-1>=0 then
			ox-=1
			if ox<=0 then x-=1:ox=32
			spr=0
		else
			xdir=0	
		end if
	end if
	
	
	if xdir=1 then
		'xdir=1
		if map.hit(ax+1,ay)=0 and ax+1<=800-32 then
			ox+=1
			if ox>=32 then x+=1:ox=0
			spr=2
		else
			xdir=0	
		end if
	
	end if

end sub

function myplayer.insolid() as integer
	dim as integer ax,ay
	
	ax=(x shl 5)+ox	'' <<*32
	ay=(y shl 5)+oy
	
	if map.oversolid(ax,ay,1)=1 then return 1	'' block etc..
	if map.oversolid(ax,ay,3)=1 then return 1	'' spike..
	
	return 0
end function



sub myplayer.move(dr as integer)
	dim as integer ax,ay,pos
	
	ax=(x shl 5)+ox	'' <<*32
	ay=(y shl 5)+oy

	select case as const dr
	case SC_LEFT:
		if map.hit(ax-2,ay)=0 and ax-2>=0 then
			ox-=2
			if ox<=0 then x-=1:ox=32
			alt=1-alt
			spr=0
		end if
		
		if xdir=1 then xdir=0 else xdir=-1
		
	case SC_RIGHT:
		if map.hit(ax+2,ay)=0 and ax+2<=800-32 then
			ox+=2
			if ox>=32 then x+=1:ox=0
			alt=1-alt
			spr=2
		end if
		
		if xdir=-1 then xdir=0 else xdir=1
		
	
	case SC_UP:
		'' Climbing...
	
		'' On a LADDER like
		if map.oversolid(ax,ay,2)=1 then
		
			'' Not SOLID above
			if map.oversolid(ax,ay-2,1)=0 then
				oy-=2
				if oy<0 then y-=1:oy=32
				alt=1-alt
				spr=4
			end if 
		end if
		
		'' Jump check if on the ground
		if map.hit(ax,ay+1)=1 then
			if map.oversolid(ax,ay,2)=0 then
				if jump=0 then
					jump=24
					FSOUND_PlaySound(FSOUND_FREE, sample(4))
				end if
			end if
		end if
		
		'' Jump check if on a ladder top
		'if map.over(ax,ay,2)=0 and map.over(ax,ay+1,2)=1 then
		
		''	NOT on LADDER    but  one is under player
		if map.oversolid(ax,ay,2)=0 and map.oversolid(ax,ay+1,2)=1 then
		
			''.. and not on a ladder base / plant
			 if jump=0 then jump=24
			
		end if
		
		
	case SC_DOWN:
		'' Solid '2' is a LADDER or similar (+1 is in case we are standing at the top)
		if map.oversolid(ax,ay+1,2)=1 then

			if map.oversolid(ax,ay+2,1)=0 then			
				oy+=2
				if oy>=32 then y+=1:oy=0
				alt=1-alt
				spr=4
			end if
		end if
		
	case SC_SPACE:
	
	''	Ignoring...
		
	end select


	
	if spacepressed=1 then
		
		'' Can't plant seeds in winter
		if ox>=16 then
		
			select case as const map.getmap(x+1,(y+1))
			case 1:
				'' Plant selected seed in the ground
				'' Normal seed is 7, down is 16
				if map.current_season<>WINTER then
				
					if inventory.current()=2 then
						map.set(x+1,y+1,7)
						inventory.remove(2)	
					end if
					
					if inventory.current()=3 then
						map.set(x+1,y+1,16)
						inventory.remove(3)	
					end if
					
				end if
			
			case 7:
				if map.getmap(x+1,y)<>5 and map.getmap(x,y)<>4 then '' was 255, 5 = stalk 4=water
					map.set(x+1,y+1,1)	'' remove seed if no plant above	
					inventory.add(2)	'' Add yellow seed
					FSOUND_PlaySound(FSOUND_FREE, sample(6))
				end if
			case 9:
				if map.over(ax,ay,4)=0 then map.set(x+1,y+1,255)	'' remove block if not underwater
			case 16:
				'' If there is not a root under the seed then remove
				if map.getmap(x+1,y+2)<>18 then
					map.set(x+1,y+1,1)	'' remove seed if no root below
					inventory.add(3)	'' Add red seed
					FSOUND_PlaySound(FSOUND_FREE, sample(6))
				end if
				'redseeds+=1
			end select
			
		else
			select case as const map.getmap(x,(y+1))
			case 1:
				'' Normal seed is 7, down is 16
				if map.current_season<>WINTER then
				
					if inventory.current()=2 then
						map.set(x,y+1,7)
						inventory.remove(2)	
					end if
					
					if inventory.current()=3 then
						map.set(x,y+1,16)
						inventory.remove(3)	
					end if
					
				end if
			case 7:
				if map.getmap(x,y)<>5 and map.getmap(x,y)<>4 then '' was 255, 5= stalk 4=water
					map.set(x,(y+1),1)	'' remove seed if no plant above
					inventory.add(2)	'' Add yellow seed
					FSOUND_PlaySound(FSOUND_FREE, sample(6))	
				end if
			case 9:
				if map.over(ax,ay,4)=0 then map.set(x,(y+1),255)'' remove block if not underwater
				
			case 16:
				'' If there is not a root under the seed then remove
				if map.getmap(x,y+2)<>18 then
					map.set(x,(y+1),1)	'' remove seed if no root below
					inventory.add(3)	'' Add red seed
					FSOUND_PlaySound(FSOUND_FREE, sample(6))
				
				'redseeds+=1
				end if
			end select
		end if
	end if

end sub


