'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''
'' All new map loader! 
''
'' OOP based, now uses 256 colour bitmaps so RGB translation bit not needed! 
''

type mymap

private:	
	dim mapwidth as integer
	dim mapheight as integer
	
	dim as integer counter,alt
	
	dim solid(32*32) as ubyte	'' Solid..
	dim basemap(32*32) as ubyte	'' Base map no season applied
	
	dim as integer rain_off		'' Whether rain is enabled (read pixel 0,31 for this)
	dim sprite(120) as any ptr	'' 4 Seasons x 30sprites

	dim playersprite(120) as any ptr
	
	declare sub flip()
	declare sub addwater()	
	declare sub slide()	
	declare function count(as integer) as integer
	declare sub fillsolid()
	declare function issolid(as integer,as integer) as integer
	
public:

	
	dim as integer rings		'' total number of rings on the level!

	dim map(32*32*4) as ubyte	'' Maps with season applied
	
	dim as integer startx,starty
	dim as integer current_season
	
	dim as integer solidx,solidy
	
	'' SUB and FUNCTIONS
	declare sub load(as integer,as integer)
	declare sub show()
	declare sub fade(as integer,as integer,as integer,as integer)
	declare sub loadsprites()
	declare sub debug()
	declare sub season(as integer)
	
	declare sub set(as integer,as integer,as integer)
	
	declare sub replace(as integer,as integer)
	
	declare function hit(as integer,as integer) as integer
	declare function over(as integer, as integer, as integer) as integer


	declare function oversolid(as integer, as integer, as integer) as integer

	declare function getmap(as integer,as integer) as integer
	declare function collect( as integer, as integer,  as integer) as integer
	declare sub setpos( as integer, as integer)
end type

'' --------- 



sub mymap.load(level as integer,src as integer)
	dim  header as bmphdr
	dim as integer i,j,c,pos,myseason
	dim as string path
	'' Load the map
	
	if src=1 then path="user\" else path="levels\"
		
	if  Open(path+str(level)+".bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,basemap()  
	        Close #1     
	              
	        mapwidth=header.w
		mapheight=header.h      
	              
	        flip()     
	        rings=count(10)	'' 10 is the item value of a ring
	        
	        '' Bar at the base prevents red seeds plant at the bottom
	        'for i=0 to 24
		'	basemap((15*32)+i)=10
		'next i
	        
	        ''
		'' Player start position
		''
		c=0
		for j=0 to mapheight-1
			for i=0 to mapwidth-1
				if basemap(c)=254 then
				startx=i
				starty=j
				basemap(c)=255
				end if
			c+=1
			next i
		next j
		
		''
		'' Copy the level to the rest of the array
		''
	        
	        for myseason=SPRING to WINTER
		        
			pos=myseason*1024
			for i=0 to ubound(basemap)-1
				map(pos+i)=basemap(i)
			next i
			
		next myseason
		
		''
		''
		''
		rain_off=0	'' rain on
		if map(31*32)=0 then rain_off=1
		
		''
		''
	
		current_season=SPRING
		fillsolid()
		''
		''
		''
	''	print "Level: "+str(level)
	''	print "Size : "+str(header.w)+" x "+str(header.h)
	else
		print "Error! Could not load level "+str(level)		
		 
	end if
end sub

sub mymap.flip()
	dim as integer i,j,c
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
	temp(i)=basemap(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			basemap(c+i)=temp((mapheight*( (mapheight-1)-j))+i)  '' 32*(31-j)
		next i
		c+=mapwidth	''32
	next j
	

end sub

sub mymap.fillsolid()
	dim as integer i
	dim as integer pos=(current_season*1024)

	for i=0 to ubound(basemap)-1
		solid(i)=0
	
		'' SOLID things
		if map(pos+i)=0 then solid(i)=1		'' Earth
		if map(pos+i)=1 then solid(i)=1		'' Grass
		if map(pos+i)=7 then solid(i)=1		'' Grass Seed
		if map(pos+i)=8 then solid(i)=1		'' Ice
		if map(pos+i)=9 then solid(i)=1		'' Breakable
		if map(pos+i)=12 then solid(i)=1	'' Concrete
		if map(pos+i)=16 then solid(i)=1	'' Down Grass Seed
		if map(pos+i)=23 then solid(i)=1	'' Landslide drop
		
		'' LADDER like
		if map(pos+i)=2 then solid(i)=2		'' Ladder
		if map(pos+i)=5 then solid(i)=2		'' Stalk
		if map(pos+i)=6 then solid(i)=2		'' Flower
		if map(pos+i)=18 then solid(i)=2	'' Root
		
		'' DANGER things
		if map(pos+i)=13 then solid(i)=3	'' Spike
		if map(pos+i)=14 then solid(i)=3	'' Spike		
		if map(pos+i)=19 then solid(i)=3	'' Fire
		if map(pos+i)=20 then solid(i)=3	'' Fire
	next i
	
end sub

function mymap.issolid(fx as integer,fy as integer) as integer

	dim as integer pos=(fy*32)+fx
	
	return solid(pos)

end function

''
'' Hit returns 0 is nothing hit
''
function mymap.oversolid(mx as integer,my as integer, item as integer) as integer

	dim as integer i,j,c
	dim as integer px,py
	const as integer pw=16

	mx+=8
	'pw=16

	for j=0 to 18
		c=j shl 5
		py=j shl 5 '' *32
		for i=0 to 24
			px=i shl 5
			 
			if (mx>=px and mx<=(px+31) ) or ((mx+pw)>=px and (mx+pw)<=(px+31) ) then
					
				if ( (my>=py and my<=(py+31)) or  ((my+31)>=py and (my+31)<=(py+31)) ) then
				
				if item=solid(c) then 
					
					solidx=i
					solidy=j
					return 1
				
				end if
			
				end if
			end if 
			
			c+=1	
		next i
	next j	

return 0
end function




function mymap.count(item as integer) as integer
	dim as integer i,c=0

	for i=0 to ubound(basemap)-1
	if basemap(i)=item then c+=1
	next i
	
	return c	

end function

sub mymap.set(fx as integer,fy as integer,fs as integer)

	dim as integer i
	dim as integer pos=(current_season*1024)+(fy*32)+fx
	
	for i=current_season to WINTER
		map(pos)=fs
		pos+=1024	
	next i
	
	'' Clear solid map too (only needed for fire really..)
	if (fs=255) then
		solid((fy*32)+fx)=0
	end if
		
end sub

function mymap.getmap(fx as integer,fy as integer) as integer

	dim as integer pos=(current_season*1024)+(fy*32)+fx
	
	return map(pos)

end function

sub mymap.show()
	dim as integer i,j,c=0
	dim as integer offset=(current_season*30)
	
	dim as integer pos=(current_season*1024)
	
	for j=0 to 18
		c=pos+(j*mapwidth) '' Needed as map is smaller than map bitmap!
		for i=0 to 24
			
			if map(c)<30 then 
			
				select case as const map(c)
				case 13:
					'' Spikes
					put (i*32,j*32),sprite(map(c)+offset+alt),trans
				case 19:
					'' Fire!
					put (i*32,j*32),sprite(map(c)+offset+alt),trans
				case else:
					put (i*32,j*32),sprite(map(c)+offset),trans	
				end select
					
			end if			
			c+=1	
		next i
	next j	
	
	if counter=20 then
		alt=1-alt 
		counter=0
	else 
		counter+=1
	end if
		
end sub




sub mymap.loadsprites()
	dim as integer offset

	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(255,100,100) )
	next i

	dim path as string

	path="gfx\"
	
	for i=0 to 3
		offset=(i*30)
		bload path+"ring.bmp",sprite(10+offset)
		bload path+"exit.bmp",sprite(11+offset)	
		
		bload path+"fire1.bmp",sprite(19+offset)
		bload path+"fire2.bmp",sprite(20+offset)
		
		bload path+"bucket.bmp",sprite(21+offset)
		bload path+"heart.bmp",sprite(22+offset)
		bload path+"orb.bmp",sprite(24+offset)
	next i
	
	
	
	
	'' normal 32x32 sprites
	path="gfx\spring\"
	bload path+"earth.bmp",sprite(0)	''solid.bmp
	bload path+"grass.bmp",sprite(1)
	bload path+"ladder.bmp",sprite(2)
	bload path+"water.bmp",sprite(3)
	bload path+"water2.bmp",sprite(4)
	bload path+"stalk.bmp",sprite(5)
	bload path+"flower.bmp",sprite(6)
	bload path+"grass-seed.bmp",sprite(7)
'	bload path+"ice.bmp",sprite(8)	
	bload path+"breakable.bmp",sprite(9)
	bload path+"concrete.bmp",sprite(12)
	bload path+"spikes1.bmp",sprite(13)
	bload path+"spikes2.bmp",sprite(14)	'' 2nd frame
	bload path+"egg.bmp",sprite(15)
	bload path+"grass-seed2.bmp",sprite(16)
'	bload path+"root.bmp",sprite(18)
	bload path+"earth2.bmp",sprite(23)



	path="gfx\summer\"
	bload path+"earth.bmp",sprite(30)
	bload path+"grass.bmp",sprite(31)
	bload path+"ladder.bmp",sprite(32)
	bload path+"water.bmp",sprite(33)
	bload path+"water2.bmp",sprite(34)
	bload path+"stalk.bmp",sprite(35)
	bload path+"flower.bmp",sprite(36)
	bload path+"grass-seed.bmp",sprite(37)	
'	bload path+"ice.bmp",sprite(38)	
	bload path+"breakable.bmp",sprite(39)
	bload path+"concrete.bmp",sprite(42)
	bload path+"spikes1.bmp",sprite(43)
	bload path+"spikes2.bmp",sprite(44)	'' 2nd frame
	bload path+"grass-seed2.bmp",sprite(46)
	'' red seed (17)
	bload path+"root.bmp",sprite(48)
	bload path+"earth2.bmp",sprite(53)	
		
	path="gfx\autumn\"
	bload path+"earth.bmp",sprite(60)
	bload path+"grass.bmp",sprite(61)
	bload path+"ladder.bmp",sprite(62)
	bload path+"water.bmp",sprite(63)
	bload path+"water2.bmp",sprite(64)
	bload path+"stalk.bmp",sprite(65)
	bload path+"flower.bmp",sprite(66)
	bload path+"grass-seed.bmp",sprite(67)	
'	bload path+"ice.bmp",sprite(68)	
	bload path+"breakable.bmp",sprite(69)
	bload path+"concrete.bmp",sprite(72)
	bload path+"spikes1.bmp",sprite(73)
	bload path+"spikes2.bmp",sprite(74)	'' 2nd frame
	bload path+"grass-seed2.bmp",sprite(76)
	bload path+"root.bmp",sprite(78)
	bload path+"earth2.bmp",sprite(83)
	
	path="gfx\winter\"
	bload path+"earth.bmp",sprite(90)
	bload path+"grass.bmp",sprite(91)
	bload path+"ladder.bmp",sprite(92)
	bload path+"water.bmp",sprite(93)
	bload path+"water2.bmp",sprite(94)
	'bload path+"stalk.bmp",sprite(65)
	'bload path+"flower.bmp",sprite(66)
	'bload path+"grass-seed.bmp",sprite(67)	
	bload path+"ice.bmp",sprite(98)	
	bload path+"breakable.bmp",sprite(99)
	bload path+"concrete.bmp",sprite(102)
	bload path+"spikes1.bmp",sprite(103)
	bload path+"spikes2.bmp",sprite(104)	'' 2nd frame
	bload path+"grass-seed2.bmp",sprite(106)
	bload path+"earth2.bmp",sprite(113)
	
	
	''
	'' Load player sprites - Duplicates player function but far less hassle this way...
	''	
'	dim i as integer	
	for i=0 to 5
		playersprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	'' Load
	path="gfx\player\"

	bload path+"left.bmp",playersprite(0)
	bload path+"left_1.bmp",playersprite(1)
	bload path+"right.bmp",playersprite(2)
	bload path+"right_1.bmp",playersprite(3)
	bload path+"up.bmp",playersprite(4)
	bload path+"up_1.bmp",playersprite(5)
	
	
end sub

''
'' Hit returns 0 is nothing hit
''
function mymap.hit(mx as integer,my as integer) as integer

	dim as integer i,j,c
	dim as integer px,py
	const as integer pw=16 '20

	dim as integer pos=(current_season*1024)

	mx+=8
	'pw=16

	for j=0 to 18
		c=j shl 5
		py=j shl 5 '' *32
		for i=0 to 24
			if map(pos+c)<255 then
				px=i shl 5
				 
				if (mx>=px and mx<=(px+31) ) or ((mx+pw)>=px and (mx+pw)<=(px+31) ) then
					
					if (my>=py and my<=(py+31) or  (my+31)>=py and (my+31)<=(py+31) ) then
					
						'' solid things block,ground,ice
						'if map(pos+c)=0 or map(pos+c)=1 or map(pos+c)=7 or map(pos+c)=8 or map(pos+c)=9  or map(pos+c)=12 then return 1
						
						if solid(c)=1 then return 1
						
					end if
					
				end if 
			end if	
			c+=1	
		next i
	next j	

return 0
end function

''
'' Hit returns 0 is nothing hit
''
function mymap.over(mx as integer,my as integer, item as integer) as integer

	dim as integer i,j,c
	dim as integer px,py
	const as integer pw=16

	dim as integer pos=(current_season*1024)

	mx+=8
	'pw=16

	for j=0 to 18
		c=j shl 5
		py=j shl 5 '' *32
		for i=0 to 24
			if map(pos+c)<255 then
				px=i shl 5
				 
				if (mx>=px and mx<=(px+31) ) or ((mx+pw)>=px and (mx+pw)<=(px+31) ) then
						
					if ( (my>=py and my<=(py+31)) or  ((my+31)>=py and (my+31)<=(py+31)) ) then
					
					if item=map(pos+c) then return 1
				
					end if
				end if 
			end if	
			c+=1	
		next i
	next j	

return 0
end function

''
'' Return is over a item and return it's map location so we can erase
''
function mymap.collect(mx as integer,my as integer, item as integer) as integer

	dim as integer i,j,c
	dim as integer px,py
	const as integer pw=16

	dim as integer pos=(current_season*1024)

	mx+=8
	'pw=16

	for j=0 to 18
		c=j shl 5
		py=j shl 5 '' *32
		for i=0 to 24
			if map(pos+c)<255 then
				px=i shl 5
				 
				if (mx>=px and mx<=(px+31) ) or ((mx+pw)>=px and (mx+pw)<=(px+31) ) then
						
					if ( (my>=py and my<=(py+31)) or  ((my+31)>=py and (my+31)<=(py+31)) ) then
					
					if item=map(pos+c) then return c
				
					end if
				end if 
			end if	
			c+=1	
		next i
	next j	

return -1
end function



''

sub mymap.season(new_season as integer)
	dim as integer i,j,c,pos,ht
	
		current_season=new_season
		pos=(current_season*1024)
		
		'' remove stalks/flowers so they do not stick when seeds removed
		replace(5,255)
		replace(6,255)
		replace(18,255)	'' Root
		
		'' remove all water
		if current_season>SPRING then
			replace(4,255)
		end if
		
		replace(8,255) '' Remove any ice
		
		fillsolid()
		
		select case as const current_season
		case SPRING:
			'' default / start
			'' nothing to change...
		case SUMMER:
			
			'' Any seeds?
			for i=0 to ubound(basemap)-1
			
				'' Regular yellow seeds
				if map(pos+i-1024)=7 then
				
					ht=0
					for j=1 to 5
						'' stop growing if hit block
						if solid(i-(j*32))=0  and map(pos+i-(j*32))<>10  then
							map(pos+i-(j*32))=5
							ht+=1
						else
							exit for
						end if
					next j
					
					'' flower at the top
					if ht>1 then
						map(pos+i-((j-1)*32))=6
					end if
				end if
				
				'' Downward red seed
				if map(pos+i-1024)=16 then
				
					for j=1 to 5
						'' stop growing if hit block
						if solid(i+(j*32))=0  and map(pos+i+(j*32))<>10  then
							map(pos+i+(j*32))=18
						else
							exit for
						end if
					next j
					
				end if
				
				
			next i
			
		case AUTUMN:
			'' Remove fire (wet..)
			replace(19,255)
		
			slide()
			fillsolid()	'' Do again as fire blocks water..
					
			'' Any seeds? (no flower as it's autumn)
			for i=0 to ubound(basemap)-1
				if map(pos+i-1024)=7 then
				
					ht=5	'' planted in summer
				
					if map(pos+i-2048)=7 then ht=10 'planted in spring
				
					for j=1 to ht-1
						'' stop growing if hit block
						if solid(i-(j*32))=0 and map(pos+i-(j*32))<>10 then
							map(pos+i-(j*32))=5	'' Stalk
						else
							exit for
						end if
					next j
					
					'' no flower at the top
					
				end if
				
				'' Downward red seed
				if map(pos+i-1024)=16 then
				
					ht=5	'' planted in summer
				
					if map(pos+i-2048)=16 then ht=10 'planted in spring
				
					for j=1 to ht-1
						'' stop growing if hit block
						if solid(i+(j*32))=0  and map(pos+i+(j*32))<>10  then
							map(pos+i+(j*32))=18 '' Root
						else
							exit for
						end if
					next j
					
				end if
				
			next i
			
			if rain_off=0 then
				addwater()
			end if
			
		case WINTER:
			'' remove seeds
			replace(7,1)	'' yellow	
			replace(16,1)	'' red
		
			'' Remove fire (wet..)
			replace(19,255)
			
			slide()
			
			if rain_off=0 then
				fillsolid()	'' Do again as fire blocks water..
				addwater()
				replace(4,8) '' water to solid ice
			end if
			
		end select
		
	fillsolid()	


end sub


sub mymap.addwater()

	dim as integer i,rc=0,done=0
	dim as integer rainx=24,rainy=0,xa
	
	'' Work out better exit method!
	'do
	for i=0 to 200
	
		'' ladder
		'if getmap(rainx,rainy)=2 then exit for
	
		''  DOWN :   solid				water
		if issolid(rainx,rainy+1)=0 and  getmap(rainx,rainy+1)<>4 then
			rainy+=1
		else
			'' solid					ladder
			if issolid(rainx-1,rainy)=0 and getmap(rainx-1,rainy)<>2 then
				rainx-=1
			else
				rc+=1
				
				if done=0 then
					for xa=rainx to 25
						'' block/grass/ladder		'' Spikes
						'if getmap(xa,rainy)<3 or   getmap(xa,rainy)=13 then
						
						if issolid(xa,rainy)=1 or   getmap(xa,rainy)=13 then
							exit for
						else
							set(xa,rainy,4)
						end if 
					next xa
				end if
				
				rainx=24
				rainy=0
			end if
		
		
		end if
		
		'' 2 rows of water
		if rc=2 or done=1 then exit for
	next i	
end sub

sub mymap.replace(fa as integer,fb as integer)
	dim as integer i,pos
	
	pos=current_season*1024

	for i=0 to ubound(basemap)-1
		if map(pos+i)=fa then map(pos+i)=fb 
	next i
	
end sub

sub mymap.setpos(fa as integer,fb as integer)
	dim as integer i
	
	for i=SPRING to WINTER
		map(fa)=fb 
		fa+=1024
	next i
end sub

sub mymap.slide()
	dim as integer i,j,ty
	dim as integer pos=(current_season*1024)

	'' If fire is removed in summer, rocks fall in autumn, however
	'' if then removed in spring autumn rocks are wiped away as they
	'' are now in the same place! We reset the rocks!
	
	replace(23,255)
	for i=0 to ubound(basemap)-1
	if basemap(i)=23 then map(pos+i)=23
	next i

	'' drop rocks

	for j=18 to 0 step -1
		
		for i=0 to 24
		if getmap(i,j)=23 then
			set(i,j,255)
		
			for ty=j to 18
			
			if getmap(i,ty+1)<>255 then
				set(i,ty,23)
				exit for
			end if
			
			next ty
		
		end if
		
		next i
	next j
end sub

sub mymap.fade(nseason as  integer,sx as integer,sy as integer,ss as integer)

	''' Draw next screen
	dim nscreen as any ptr
	nscreen=ImageCreate( 800, 600,0 )
	
	
	dim as integer i,j,c=0
	dim as integer offset=(nseason*30)	
	dim as integer pos=(nseason*1024)
	
	select case as const nseason
		case SPRING
			for j=0 to 39
				'' *32 = shl 5
				'' Blue > Yellow
				line nscreen,(0,(j shl 4)) -(800,(j+1) shl 4),rgb(j*6,j*6,255-(j*6)),bf
			next j
		
		case SUMMER
		 	for j=0 to 39
		 		'' Red > Yellow
				line nscreen,(0,(j shl 4)) -(800,(j+1) shl 4),rgb(255,j*6,0),bf
			next j
		
		case AUTUMN
			for j=0 to 39
				'' Dark Grey > White
				line nscreen,(0,(j shl 4)) -(800,(j+1) shl 4),rgb(j*6,j*6,j*6),bf
			next j
		case WINTER:
			for j=0 to 39
				'' Light Blue > White
				line nscreen,(0,(j shl 4)) -(800,(j+1) shl 4),rgb(50+(j shl 2),150+(j shl 1),250),bf
			next j
		end select
	
	
	
	for j=0 to 18
		c=pos+(j*mapwidth) '' Needed as map is smaller than map bitmap!
		for i=0 to 24
			
			if map(c)<30 then 
			
				select case as const map(c)
				case 13:
					'' Spikes
					put nscreen,(i*32,j*32),sprite(map(c)+offset+alt),trans
				case 19:
					'' Fire!
					put nscreen,(i*32,j*32),sprite(map(c)+offset+alt),trans
				case else:
					put nscreen,(i*32,j*32),sprite(map(c)+offset),trans	
				end select
					
			end if			
			c+=1	
		next i
	next j	
	
	put nscreen,(sx,sy),playersprite(ss),trans
	
	const as integer bsize=50
	
	'' Combine
	for i=0 to 15
		put (i*bsize,33),nscreen,(i*bsize,33)-((i*bsize)+bsize,(j*bsize)+bsize),pset
		sleep 10,1
	next i
	
		
end sub

