'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''

type myinventory

private:		
	dim item(5) as integer
	dim no(5) as integer

	dim sprite(10) as any ptr
	dim as integer selected		
public:

	declare sub reset()
	declare sub loadsprites()
	declare sub add(as integer)
	declare sub remove(as integer)
	declare function count(as integer) as integer
	declare sub draw()
	
	declare sub nxt()
	declare sub prv()
	declare function current() as integer
end type


sub myinventory.reset()
	dim as integer i
	
	for i=0 to ubound(item)
		item(i)=-1
		no(i)=0
	next i
	
	selected=0
end sub

sub myinventory.loadsprites()	
	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	const path as string="gfx\inventory\"

	bload path+"frame-yellow.bmp",sprite(0)
	bload path+"frame-red.bmp",sprite(1)
	bload path+"seed-yellow.bmp",sprite(2)
	bload path+"seed-red.bmp",sprite(3)
	bload path+"bucket-empty.bmp",sprite(4)
	bload path+"bucket-water.bmp",sprite(5)

end sub


sub myinventory.add(newitem as integer)
	dim as integer i
	
	for i=0 to ubound(item)
		if item(i)=newitem then no(i)+=1 :return
	next i
	
	'' if this far, then new item!
	for i=0 to ubound(item)
		if item(i)=-1 then item(i)=newitem : no(i)=1 :exit for
	next i
end sub

sub myinventory.remove(newitem as integer)
	dim as integer i
	
	for i=0 to ubound(item)
		if item(i)=newitem then
			no(i)-=1
			if no(i)<=0 then item(i)=-1	'' remove entirely
			return
		end if
	next i
	
end sub

function myinventory.count(newitem as integer) as integer
	dim as integer i
	
	for i=0 to ubound(item)
		if item(i)=newitem then return no(i)
	next i
	
	return -1
end function

sub myinventory.draw()
	dim as integer i
	const as integer x=800-(6*32)
	const as integer y=0

	for i=0 to ubound(item)
		if item(i)<>-1 then
			put (x+(i*32),y),sprite(item(i)),trans	
		else
			put (x+(i*32),y),sprite(0),trans	
		end if
		
		if i=selected then
			put (x+(i*32),y),sprite(1),trans
		end if
	next i

end sub

sub myinventory.nxt()
	selected+=1
	if selected>5 then selected=0
end sub

sub myinventory.prv()
	selected-=1
	if selected<0 then selected=5
end sub

function myinventory.current() as integer
	
	return item(selected)

end function

