'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''
type myfont

private:	
	dim comic12w as any ptr
	dim As uinteger Ptr pixdata	
	declare function txtwidth( as string) as integer
public:

	declare sub load()
	declare sub color(as integer,as integer,as integer)
	declare sub centre(as integer,as string)
	declare sub show(as integer, as integer,as string)		
end type

sub myfont.load()
	const as integer fontwidth=1073
	const as integer fontheight=24
	
	comic12w=ImageCreate( fontwidth, fontheight )
	bload "fonts\arial_16_white.bmp", comic12w
end sub


sub myfont.color(r as integer,g as integer,b as integer)
  dim as integer success,i,j,pos
  dim as integer w,h,bpp,pitch
  dim as uinteger ptr pixdata
  
	success = ImageInfo(comic12w, w, h, bpp, pitch, pixdata)
  
  'print "w:"+str(w)+" h:"+str(h)+" bpp:"+str(bpp)+" pitch:"+str(pitch)
  'print "0:"+hex(pixdata[pitch])+" 1:"+hex(pixdata[pitch+1])
    
  if success=0 then
     '' first line has all the font info so we will skip it
    pos=(pitch/bpp)
    for j=1 to h-1
      'print "> "+hex(pixdata[pos])
      
      for i=0 to (pitch/bpp) 
            if pixdata[pos+i]<>&h00ff00ff then pixdata[pos+i]=(r shl 16)+(g shl 8)+b
      next i
      pos+=(pitch/bpp)
    next j
    
  else
    print "Font error!"
    print "w:"+str(w)+" h:"+str(h)+" pitch:"+str(pitch)
    print ""+hex(pixdata[pitch])
  end if
end sub

function myfont.txtwidth(word as string) as integer
	dim as integer i,wid,aval
	Dim As UByte Ptr p
	
	ImageInfo( comic12w, , , , , p )
	
	for i=1 to len(word)	
		aval=asc(mid(word,i,1))
		wid+=p[3 + aval  -32] 
	next i
	
	return wid
end function



sub myfont.centre(y as integer,t as string)
	dim as integer x

	x=(800-txtwidth(t))/2
	
	draw string(x,y),t,,comic12w
	
end sub

'' this sub was called 'draw' but it caused problems...
sub myfont.show(x as integer, y as integer,t as string)
	
	draw string(x,y),t,,comic12w
	
end sub
