'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''
'' Level Editor
''

type myeditor

private:	
'	dim dialog as mydialog

	dim as integer press(11)
	dim as integer key(11)

	const mapwidth as integer=32
	const mapheight as integer=32
	
	dim basemap((32*32)-1) as ubyte 
	dim as integer pos
	
	dim as integer mx,my
	dim as integer icon(16)
	dim as string txt(16)
		
	dim as integer item
	
	dim as integer editlevel
	
	dim as integer mousex,mousey,mousebutton
	dim as integer opt=-1
	dim sprite(30) as any ptr
public:


		
	declare constructor()

	declare sub show()
	declare function control() as integer

	declare sub clr()
		
	declare sub load(as integer)
	declare sub save()
	
	declare sub loadsprites()
	
	declare sub flip()
end type

constructor myeditor()
	key(0)=SC_UP
	key(1)=SC_DOWN
	key(2)=SC_LEFT
	key(3)=SC_RIGHT
	key(4)=SC_COMMA
	key(5)=SC_PERIOD
	key(6)=SC_SPACE
	key(7)=SC_DELETE
	key(8)=SC_S
	key(9)=SC_ESCAPE
	key(10)=SC_M
	key(11)=SC_F	'' Flood
end constructor

sub myeditor.clr()
	dim as integer i

	item=0
	pos=0
	
	for i=0 to ubound(basemap)
		basemap(i) =255
	next i
end sub

sub myeditor.loadsprites()
	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 16, 16,rgb(255,100,100) )
	next i

	'' Load
	const path as string="gfx\title\"

	bload path+"earth.bmp",sprite(0)	''solid.bmp
	bload path+"grass.bmp",sprite(1)
	bload path+"ladder.bmp",sprite(2)
'	bload path+"water.bmp",sprite(3)
	bload path+"water2.bmp",sprite(4)
'	bload path+"stalk.bmp",sprite(5)
'	bload path+"flower.bmp",sprite(6)
	bload path+"grass-seed.bmp",sprite(7)
'	bload path+"ice.bmp",sprite(8)	
	bload path+"breakable.bmp",sprite(9)
	bload path+"ring.bmp",sprite(10)
	bload path+"exit.bmp",sprite(11)
	bload path+"concrete.bmp",sprite(12)
	bload path+"spikes1.bmp",sprite(13)
'	bload path+"spikes2.bmp",sprite(14)	'' 2nd frame

	bload path+"grass-seed2.bmp",sprite(16)
	bload path+"fire1.bmp",sprite(19)
	bload path+"bucket.bmp",sprite(21)
	bload path+"heart.bmp",sprite(22)	
	bload path+"earth2.bmp",sprite(23)
	bload path+"orb.bmp",sprite(24)	
	

	
	bload path+"player.bmp",sprite(26)
	bload path+"border.bmp",sprite(27)
	bload path+"border2.bmp",sprite(28)
		
	icon(0)=0
	txt(0)="Solid block of earth"
	
	icon(1)=1
	txt(1)="Earth with grass on top"
	
	icon(2)=2
	txt(2)="Ladder"

	icon(3)=4
	txt(3)="Water (Frozen in Winter)"
	
	icon(4)=7
	txt(4)="Yellow seed (Upward Vine)"
	
	icon(5)=16
	txt(5)="Red seed (Downward Root)"
	
	icon(6)=9
	txt(6)="Breakable block"
		
	icon(7)=10
	txt(7)="Ring (Need at least one of these)"
	
	icon(8)=11
	txt(8)="Exit (Need at least one of these)"
	
	icon(9)=12
	txt(9)="Concrete (Cannot plant a seed)"
	
	
	icon(10)=13
	txt(10)="Spike (Removes 1 health heart)"
		
	icon(11)=19
	txt(11)="Fire (Removes 3 health hearts)"
	
	icon(12)=23
	txt(12)="Landslide block (Drops in Autumn)"
	
	icon(13)=21
	txt(13)="Bucket (Used to carry water)"

	icon(14)=22
	txt(14)="Heart (1 Life Point)"
		
	icon(15)=24
	txt(15)="Orb (1 Season Jump)"		
		
	icon(16)=26
	txt(16)="Player start position (required)"

end sub

sub myeditor.load(level as integer)
	dim  header as bmphdr
	dim as integer i,j,c,pos,myseason
	'' Load the map
		
	if  Open("user\"+str(level)+".bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,basemap()  
	        Close #1     
	        flip()     
	        
	else
	' print "Error! Could not load level "+str(level)		
	' Probably a new level
	clr()
	end if
	
	editlevel=level
end sub

sub myeditor.save()
	dim  header(1077) as ubyte
	
	'' Being lazy, just grabbing the header from a known good level
	if  Open("levels\1.bmp" For binary access read As #1)=0 then
		get #1,,header()	
		Close #1     
	else
	'	print "Error! Could not load level "+str(level)		
		 
	end if


	flip()
	if Open("user\"+str(editlevel)+".bmp" For Binary Access write As #1)=0 then
	  	put #1, ,header() 
	 	put #1, ,basemap() 
		Close #1
	end if

	flip()
end sub


sub myeditor.flip()
	dim as integer i,j,c
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
		temp(i)=basemap(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			basemap(c+i)=temp((mapheight*( (mapheight-1)-j))+i)  '' 32*(31-j)
		next i
		c+=mapwidth	''32
	next j
	

end sub


sub myeditor.show()

	dim as integer i,j,c=1

	dim as integer x=(800-(25*16))/2
	const as integer y=64
	
	
	text.color(255,255,255)
	text.centre(440,txt(item))
	
	text.color(0,255,255)
	
	if basemap(31*32)=0 then 
		'' Level will flood
		text.centre(480,"< > Select a block, [S]ave, [F]looding is OFF")
	else
	
		'' Level will not flood
		text.centre(480,"< > Select a block, [S]ave, [F]looding is ON")
	end if
	
	text.centre(500,"Left Click - Place block / Right Click - Remove block")
	
	text.color(255,255,255)

	'' Main map grid
	for j=0 to 18
	
		c=(j*32)
		
		for i=0 to 24
			
			if basemap(c)<27 then
				put (x+(i*16),y+(j*16)),sprite(basemap(c)),trans
			else
				if basemap(c)=254 then
					'' player start pos
					put (x+(i*16),y+(j*16)),sprite(26),trans
				else
					'' empty border
					put (x+(i*16),y+(j*16)),sprite(27),trans
				end if
			end if	
			
			if c=pos then
				put (x+(i*16),y+(j*16)),sprite(28),trans
			end if
					
			c+=1	
		next i
	next j	

	'' Icon blocks
	x=800-(16*(ubound(icon)+1))-(16*ubound(icon))
	x=x shr 1
	
	for i=0 to ubound(icon)		
		if (item=i) then
			line (x+(i*32)-2,400-2)-(x+(i*32)+18,400+18),rgb(255,0,0),bf 
		end if

		put (x+(i*32),400 ),sprite(icon(i)),trans		
	next i


end sub

function myeditor.control() as integer
	dim as integer i,j
	dim as integer hitkey=-1
	
	dim as integer x=(800-(25*16))/2
	const as integer y=64
		
	if getmouse(mousex,mousey,,mousebutton)=0 then
		
		if mousebutton and 1 then
		
			for j=0 to 18
			for i=0 to 24
		
			if (mousex>x+(i*16) and mousex<x+(i*16)+16 ) then
				if (mousey>y+(j*16) and mousey<y+(j*16)+16 ) then
			
					mx=i
					my=j
					pos=(my*32)+mx
					hitkey=SC_SPACE
					
				end if 
			end if
			
			next i
			next j
			
			'' Icon blocks
			x=800-(16*(ubound(icon)+1))-(16*ubound(icon))
			x=x shr 1
			
			for i=0 to ubound(icon)	
			
				if (mousex>x+(i*32) and mousex<x+(i*32)+16 ) then
					if (mousey>400 and mousey<400+16 ) then
				
						item=i
						
					end if 
				end if
				
						
			next i
			
			
		end if
		
		if mousebutton and 2 then
			
			for j=0 to 18
			for i=0 to 24
		
			if (mousex>x+(i*16) and mousex<x+(i*16)+16 ) then
				if (mousey>y+(j*16) and mousey<y+(j*16)+16 ) then
			
					'pos=(j*32)+i
					
					mx=i
					my=j
					
					pos=(my*32)+mx
					hitkey=SC_DELETE
					
				end if 
			end if
			
			next i
			next j
		end if
	end if
	
	
	for i=0 to ubound(key)
		'' Arrow Key 
		if  MultiKey( key(i) ) and press(i)=0 then
			press(i)=1 
		end if
		
		if  MultiKey(key(i) )=0 and press(i)=1  then
			press(i)=0
			hitkey=key(i) '(i+1)
		end if
	next i
	
	'if hitkey>0 then mylevel+=1
	select case as const hitkey
	case SC_UP:
		if my>0 then my-=1
		pos=(my*32)+mx
		
	case SC_DOWN:
		if my<18 then my+=1
		pos=(my*32)+mx
		
	case SC_LEFT:
		if mx>0 then mx-=1
		pos=(my*32)+mx
		
	case SC_RIGHT:
		if mx<24 then mx+=1
		pos=(my*32)+mx
	
	case SC_COMMA: 
		item-=1
		if item<0 then item=ubound(icon)
	
	case SC_PERIOD:
		item+=1
		if item>ubound(icon) then item=0
	
	case SC_DELETE:
		basemap(pos)=255	
	
	case SC_S:
		save()
		dialog.reset()
		opt=dialog.show("Level Saved!","Thanks!","")
	
	case SC_F:
		'' Rain on or off
		if basemap(31*32)=0 then basemap(31*32)=255 else basemap(31*32)=0
		
	case SC_SPACE:
		if icon(item)=26 then
	 		'' player
			basemap(pos)=254
		else
			basemap(pos)=icon(item)
		end if
	
	case SC_ESCAPE:
		opt=-1
		dialog.reset()
		opt=dialog.show("Save Changes?","Yes","No")
		if opt=0 then save()	
	end select
	

return hitkey	
	
end function
