'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''
'' Moving background
''

type mybackground

private:		
	Const PI As Double = 3.1415926535897932

	dim x(26*22) as integer
	dim y(26*22) as integer
			
	dim ring_spr as any ptr
	dim banner_spr as any ptr
	dim gold_spr as any ptr
	
	dim as integer offset,alt,rot
public:
	declare constructor()
	declare sub show()
	declare sub update()
	declare sub spin()
end type

constructor mybackground()

	const path as string ="gfx\snow\"
	ring_spr= ImageCreate( 32, 32,rgb(100,255,100) )
	
	banner_spr= ImageCreate( 300, 80,rgb(100,255,100) )
	
	gold_spr= ImageCreate( 32, 32,rgb(100,255,100) )
	
	bload path+"darkring.bmp",this.ring_spr
	bload path+"banner.bmp",this.banner_spr
	
	bload "gfx\ring.bmp",this.gold_spr
	
	''default positions!
	dim as integer i,j,c=0
	for j=-1 to 20
		for i=-1 to 24
			x(c)=(i*32)+32
			y(c)=(j*32)-32
			c+=1
		next i
	next j
	
	'''
	offset=0
	alt=0
	rot=0
end constructor


sub mybackground.show()
	dim as integer i,j,c=0
	
	color ,rgb(0,0,50)
	cls
	
	for j=-1 to 20
		for i=-1 to 24
			
			put (x(c)-offset,y(c)+offset),ring_spr,trans
		c+=1
		next i
	next j
	
	put (250,5),banner_spr,trans
	
	
end sub


sub mybackground.update()

	if alt=1 then
		offset+=1
		if offset=31 then offset=0
	end if
	
	alt=1-alt

end sub

sub mybackground.spin()
	
	dim as integer a,c,x,y 
	dim as integer angle
	dim r As Double
	
	color ,rgb(0,0,50)
	cls
		
	for a=0 to 27
		for c=0 to 3
		angle=(a*10)+(c*90)+rot
	
		r = (angle * PI) / 180    'Convert the degrees to Radians
		
		x=400+sin(r)*(a*10)
		y=300+cos(r)*(a*10)
		
		put (x,y),gold_spr,trans
		next c
	next a

	'if alt=1 then
		rot+=2
		if rot>360 then rot=0
	'end if
	alt=1-alt
	
end sub





