'' FBGD 2012 Entry by ssjx [http://ssjx.co.uk]
'' ===========================================
''
'' Spring Forward!
''

#include "file.bi"
#include "fmod.bi"



dim as integer i,j

'' -- Sound ---
FSOUND_Init(44100, 8, 0) 

common shared sample() As Integer
dim sample(10) As Integer

for i=0 to 7
	sample(i) = FSOUND_Sample_Load(FSOUND_FREE,"wav\"+str(i)+".mp3", FSOUND_HW3D, 0, 0) 
next i
'' -- End of  Sound ---

dim as integer playmusic=0,music_off

dim as integer titlemusic,intromusic,gamemusic,fanfare

titlemusic = FMUSIC_LoadSong("music\title.mid")
FMUSIC_SetMasterVolume(titlemusic, 100)

gamemusic = FMUSIC_LoadSong("music\tune1.mid")
FMUSIC_SetMasterVolume(gamemusic, 100)



''
#include "header.bi"

#include "font.bi"
common shared text as myfont

#include "dialog.bi"
common shared dialog as mydialog

#include "bmp.bi"

#include "inventory.bi"

#include "map.bi"

#include "player.bi"
dim player as myplayer


#include "snow.bi"


#include "title.bi"

#include "select.bi"
#include "editor.bi"
#include "background.bi"

windowtitle GAMETITLE+" ["+VERSION+"]"
screen 19,32,1'''  ,&h01

dim as integer hitkey=-1
dim as integer press(10)
dim as integer key(10)

key(0)=SC_UP
key(1)=SC_DOWN
key(2)=SC_1
key(3)=SC_2
key(4)=SC_C
key(5)=SC_E
key(6)=SC_SPACE
key(7)=SC_ESCAPE
key(8)=SC_S
key(9)=SC_R
key(10)=SC_M


dim snow as mysnow
dim title as mytitle
dim levelselect as myselect
dim editor as myeditor

dim background as mybackground

dim as integer ext=0
dim as integer current_season=SPRING,new_season
dim as integer change=0
dim as string seasons(3)={"SPRING","SUMMER","AUTUMN","WINTER"}
dim as uinteger seasons_colour(3)={rgb (0,255,0),rgb (255,204,0),rgb(150,75,0),rgb(0,255,255)}



dim as integer state=GAME_TITLE,spacepressed=0,escapepressed=0,mpressed=0
dim as integer sel=0,level,opt,thealth
dim as integer mousex,mousey,mousebutton,mousedown
dim as integer highscore
'
dim as integer drawnow=1

''
''
''
editor.loadsprites()

text.load()

map.loadsprites()
player.loadsprites()

'snow.season=AUTUMN

inventory.loadsprites()
inventory.reset()

''

'' Load savegame
if Open("save.dat" For Binary Access read As #1)=0 then
  	get #1, ,level
    	get #1, ,highscore
	Close #1
	
	levelselect.high=level
end if

''


do


	if music_off=0 then
		if playmusic=0 then
			FMUSIC_StopAllSongs()
		
			select case as const state
			case GAME_TITLE:
				FMUSIC_PlaySong(titlemusic)
			case GAME_SELECT:
				FMUSIC_PlaySong(titlemusic)
			case GAME_READY:
				FMUSIC_PlaySong(titlemusic)
			case GAME_MAIN:
				FMUSIC_PlaySong(gamemusic)

			end select
			playmusic=1
		end if
	end if



select case as const state
case GAME_TITLE:

	'drawnow=1
	'if drawnow=1 then

	screenlock	
	background.show()	
		'text.color(255,255,0)
		'text.centre(20,GAMETITLE)

		text.color(0,255,255)		
		text.centre(200,"High Score : "+str(highscore))

		text.color(255,255,255)		
		text.centre(120,"Collect the rings on each level by manipulating the seasons!")
		text.centre(140,"Seeds grow into vines that can be climbed, water can be")
		text.centre(160,"directed to form ice bridges in the winter!")
	
	
		
	'	text.color(255,255,255)	
		text.centre(260,"Arrows  - Move")
		text.centre(280,"1,2,3,4 - Jump to Spring, Summer, Autumn, Winter")
		
		text.centre(300,"< >    - Select an item")
		text.centre(320,"Space  - Use item. (Plant/Remove seed)")
		text.centre(340,"R  - Restart a level")
		if music_off=0 then
			text.centre(360,"M - Music Off")
		else
		
			text.centre(360,"M - Music On")
		end if
		text.color(0,255,0)
		text.centre(240,"Controls:")
		
		text.centre(400,"Choose:")
		
		
		if sel=0 then
			text.color(255,255,0)	
			text.centre(440,"> Play the main game <")
		else
			text.color(255,255,255)	
			text.centre(440,"Play the main game")
		end if
		
		if sel=1 then
			text.color(255,255,0)
			text.centre(480,"> Play or create your own levels! <")
		else 
			text.color(255,255,255)	
			text.centre(480,"Play or create your own levels!")
		end if
		
		
		text.color(0,255,0)	'' 40 Space
		text.centre(540,"Space to Start / Escape to Exit")
	
		text.color(50,50,50)
		text.show(625,575,"http://ssjx.co.uk")
	
	screenunlock
	'
	'drawnow=0
	'end if
	background.update()

	hitkey=-1
	
	'' Mouse control (sends a key press on mouse up...)
	if getmouse(mousex,mousey,,mousebutton)=0 then		
		if mousebutton and 1 then
			mousedown=1	
		end if
		
		if (mousebutton and 1)=0 and mousedown=1 then
			mousedown=0
		
			if (mousey>440 and mousey<480) or (mousey>480 and mousey<510) then
				mousedown=0
				hitkey=SC_SPACE
			end if
		end if
		
		if (mousey>440 and mousey<480) and sel<>0 then sel=0:drawnow=1
		if (mousey>480 and mousey<510) and sel<>1 then sel=1:drawnow=1	
	end if
	''
	
	
	for i=0 to ubound(key)
		if  MultiKey( key(i) ) and press(i)=0 then
			press(i)=1 
		end if
		
		if  MultiKey(key(i) )=0 and press(i)=1  then
			press(i)=0
			hitkey=key(i) '(i+1)
		end if
	next i
	
	'' Cheat!
	
'	if hitkey=SC_C then levelselect.high=12
'	if hitkey=SC_R then state=GAME_COMPLETE

	if hitkey=SC_UP then sel=0 :drawnow=1
	if hitkey=SC_DOWN then sel=1 :drawnow=1

	if hitkey=SC_SPACE then
		levelselect.lvlsource=sel
		levelselect.source()
		
		player.health=5
		player.score=0
		
		state=GAME_SELECT
	end if

		
	if hitkey=SC_ESCAPE then ext=1

	'' Exit through x
	if inkey()=chr(255)+"k" then ext=1
	While Inkey <> "": Wend

case GAME_SELECT:
	screenlock
		background.show()
		levelselect.show()	
	screenunlock
	
	background.update()
		
	hitkey=levelselect.control()

	if hitkey=SC_SPACE then
		level=levelselect.level
		map.load(level,levelselect.lvlsource)
		state=GAME_READY
		drawnow=1
	end if
	
	if hitkey=SC_ESCAPE then
		state=GAME_TITLE
		playmusic=0
		drawnow=1
	end if

	if hitkey=SC_E then
		state=GAME_EDITOR
		editor.load(levelselect.level)
		drawnow=1
	end if
	
	if hitkey=SC_A then
		state=GAME_EDITOR
		editor.load(levelselect.maxlevels+1)
		drawnow=1
	end if

case GAME_EDITOR:
	screenlock
		cls
	'	text.color(255,255,0)
		'text.centre(20,GAMETITLE)
		
		'text.centre(60,"Level Editor")
		
		editor.show()
		
		text.color(0,255,0)
		
		text.centre(540,"Escape to Return")
		
	screenunlock
	
	hitkey=editor.control()

	'' Escape to exit 
	if hitkey=SC_ESCAPE then
		levelselect.source()
		state=GAME_SELECT
		drawnow=1
	end if


case GAME_READY:
	'if drawnow=1 then
	'
	screenlock
		background.show()
	
		'text.color(255,255,0)
		'text.centre(20,GAMETITLE)
		
		text.color(255,0,0)
		text.centre(400,"Level "+str(level))
		
		'' Level Hints / Comments
		text.color(255,255,255)
		
		if levelselect.lvlsource=0 then
		
		select case as const level
		case 0:
			text.centre(440,"Level used for testing, nothing to see here...")
				
		case 1:
			text.centre(440,"Simple! Move the seed and jump ahead!")
		
		case 2:
			text.centre(440,"Careful! Landslides can occur in Autumn!")
			text.centre(460,"Note - You can't jump to an unsafe area!")
		
		case 3:
			text.centre(440,"Red seeds have very very long roots that can be climbed...")
		
		case 4:
			text.centre(440,"Fire = Bad! Try filling the bucket with water!")
			text.centre(460,"If you have a full bucket, walk through the fire!")
		
		case 5:
			text.centre(440,"If only you could reach that ladder...")
			text.centre(460,"Some blocks can be broken, press space when on or near..")
		
		case 6:
			text.centre(440,"Plants and ice needed here! Probably...")
		
		case 7:
			text.centre(440,"Argh! Spikes! Red seeds grow long roots,")
			text.centre(460,"Use the <> keys to select them once collected.")
		
		case 8:	
			text.centre(440,"A bit of everything!")
		
		case 9:	
			text.centre(440,"Looks easy enough...")
		
		case 10:	
			text.centre(440,"What to do first?")
					
		case 11:	
			text.centre(440,"Freefall Fun!")
			
		case 12:	
			text.centre(440,"More rings, more fire..")	
		
		case else:
			text.centre(440,"")
		end select
		''
		else
			text.centre(440,"User created level!")
		end if
	
			
		text.color(0,255,255)
		text.centre(500,"Current Score : "+str(player.score))
	
	
		text.color(0,255,0)
	
		text.centre(540,"Press Space to start! ")
	
		title.draw()
	
	screenunlock
	'
	'drawnow=0
	'end if
	background.update()
	
	'' Mouse control (sends a key press on mouse up...)
	if getmouse(mousex,mousey,,mousebutton)=0 then		
		if mousebutton and 1 then
			mousedown=1	
		end if
		
		if (mousebutton and 1)=0 and mousedown=1 then
			mousedown=0
			hitkey=SC_SPACE
			spacepressed=1
		end if
		
	end if
	''
	
	
	'' Space to play 
'	key=0
	if  MultiKey(SC_SPACE) then
		spacepressed=1
	end if	

	if MultiKey(SC_SPACE)=0 and spacepressed=1 then
		spacepressed=0
		
		'' if it's a new highest game level set it as the high level
		if levelselect.lvlsource=0 then
			if (level>levelselect.high) then
			
			levelselect.high=level
		
			end if
		end if
	
		state=GAME_MAIN
		
		'' if no score, assume player has just start so being music
		if player.score=0 then
			playmusic=0	'' Change song!
		end if
		
		current_season=SPRING
		map.season(current_season)
		snow.season=current_season
		snow.reset()
		inventory.reset()
		player.start(map.startx,map.starty)
		player.reset()
		
		thealth=player.health
		
	end if
	
	'' Escape to exit 
	if  MultiKey(SC_ESCAPE) then escapepressed=1

	if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
		escapepressed=0
	
		if player.score>0 then
			dialog.reset()
			opt=dialog.show("Going to the Level Select screen will reset your score","Okay","Cancel!")
		else
			'' No score so back to the menu page
			opt=0
		end if
		
		if opt=0 then	
			levelselect.source()
			state=GAME_SELECT
			drawnow=1
		end if
	
	end if
	
case GAME_COMPLETE:
'	if drawnow=1 then
	'
	screenlock
		background.show()
		
	'background.spin()
		
		text.color(0,255,0)
		
		text.centre(140,"Well Done!")
		
		text.color(255,255,255)
		text.centre(180,"You have collected")
		text.centre(200,"all of the rings and")
		text.centre(220,"saved the world again!")
		
		text.color(0,255,255)
		text.centre(260,"Your final score is "+str(player.score))
		
		text.color(0,255,0)
		text.centre(300,"Your next task..")
		
		text.color(255,255,255)
		text.centre(340,".. is to create some brilliant")
		text.centre(360,"levels using the editor!")
		
		text.color(255,255,0)
		text.centre(440,"THANKS FOR PLAYING!")
		
		
		text.color(0,255,0)
		text.centre(540,"Press Space to continue")
		
		text.color(50,50,50)
		text.show(625,575,"http://ssjx.co.uk")
		
	screenunlock
	
	background.update()
	
	if  MultiKey(SC_SPACE) then
		spacepressed=1
	end if	

	if MultiKey(SC_SPACE)=0 and spacepressed=1 then
		spacepressed=0
		
		state=GAME_TITLE
		playmusic=0	'' Change song!
		drawnow=1
	end if

case GAME_OVER:

		dialog.reset()
		opt=dialog.show("Game over! Bad luck... Score:"+str(player.score),"Retry this level","Back to the title screen")

		if opt=0 then
		'' Retry
			map.load(level,levelselect.lvlsource)	''reload
			
			player.leap=5
			player.health=thealth	'' Saved from Ready Screen
			state=GAME_READY
		else
		
			'' new high score!
			if levelselect.lvlsource=0 then
				if player.score>highscore then
					highscore=player.score
				end if
			end if
				
			state=GAME_TITLE
			playmusic=0	'' Change song!
			drawnow=1
		end if
		
case GAME_MAIN:
''
'' === START OF MAIN GAME ===
''
	
	screenlock
		
		select case as const current_season
		case SPRING
			for j=0 to 39
				'' *32 = shl 5
				'' Blue > Yellow
				line (0,(j shl 4)) -(800,(j+1) shl 4),rgb(j*6,j*6,255-(j*6)),bf
			next j
		
		case SUMMER
		 	for j=0 to 39
		 		'' Red > Yellow
				line (0,(j shl 4)) -(800,(j+1) shl 4),rgb(255,j*6,0),bf
			next j
		
		case AUTUMN
			for j=0 to 39
				'' Dark Grey > White
				line (0,(j shl 4)) -(800,(j+1) shl 4),rgb(j*6,j*6,j*6),bf
			next j
		case WINTER:
			for j=0 to 39
				'' Light Blue > White
				line (0,(j shl 4)) -(800,(j+1) shl 4),rgb(50+(j shl 2),150+(j shl 1),250),bf
			next j
		end select			
		
		line (0,0) -(800,32),rgb(0,0,0),bf
		line (0,32) -(800,32),rgb(255,255,255)
		
		map.show()
		player.show()
		snow.draw()
		
		for i=0 to 3
			
			if current_season=i then
				color rgb(255,255,0)
				draw string (i*100,2),"_________"
			end if
			
			if player.leap>0 or current_season=i then
				color seasons_colour(i)
			else
				color rgb(50,50,50)
			end if
			
			draw string (i*100,0),str(i+1)+". "+seasons(i)
			
		next i
		
		'text.color(255,255,0)
		'text.show(0,32,"Leaps: "+str(player.leap))	
	
		inventory.draw()
			
	screenunlock
	
	snow.update()
	
	player.update()
	player.control()
	
	if player.done=1 then
		level+=1
		
		''
		dialog.reset()
		opt=dialog.show("Ring Score: "+str((player.rings)*10)+" Jump Bonus:"+str((player.leap)*10),"Continue","")
				
		player.score+=(player.leap)*10
		player.score+=(player.rings)*10
		
		''
		
		if level>levelselect.maxlevels then
			state=GAME_COMPLETE
			
			'' new high score!
			if levelselect.lvlsource=0 then
				if player.score>highscore then
					highscore=player.score
				end if
			end if
		else
			map.load(level,levelselect.lvlsource)
			state=GAME_READY
		end if
	end if
	
	if player.health<=0 then
			state=GAME_OVER
			
	end if
	
	
	'' Other Game Keys
	hitkey=-1	
	for i=0 to ubound(key)
		if  MultiKey( key(i) ) and press(i)=0 then
			press(i)=1 
		end if
		
		if  MultiKey(key(i) )=0 and press(i)=1  then
			press(i)=0
			hitkey=key(i) '(i+1)
		end if
	next i
	
	if hitkey=SC_ESCAPE then
		dialog.reset()
		opt=dialog.show("Are you sure you want to quit?","Yes","No")
		if opt=0 then 
			state=GAME_OVER
		end if
	end if
	
	if hitkey=SC_R then
		dialog.reset()
		opt=dialog.show("Restart this level?","Yes","No")
		if opt=0 then 
			map.load(level,levelselect.lvlsource)	''reload
			
			player.leap=5
			player.health=thealth	'' Saved from Ready Screen
			state=GAME_READY
		end if	
	end if
	
	
	'' Change the season
	change=0
	if  MultiKey(SC_1) and current_season<>SPRING then new_season=SPRING	:change=1
	if  MultiKey(SC_2) and current_season<>SUMMER then new_season=SUMMER	:change=1	
	if  MultiKey(SC_3) and current_season<>AUTUMN then new_season=AUTUMN	:change=1
	if  MultiKey(SC_4) and current_season<>WINTER then new_season=WINTER	:change=1
	
	if change=1 then
	
		if player.leap>0 then
			
			map.season(new_season)
				
			if player.insolid()=1 then
				'' Abort jump!
				dialog.reset()
				opt=dialog.show("Unsafe Season Jump! Aborted!","Phew...","")
				
				new_season=current_season
				map.season(new_season)
			else
				'' Successful leap!
				
				player.leap-=1
				snow.season=new_season
				current_season=new_season
				snow.reset()
				
				FSOUND_PlaySound(FSOUND_FREE, sample(5))
				map.fade(new_season,player.curxpos(),player.curypos(),player.cursprite())
			
			end if
		else
			dialog.reset()
			opt=dialog.show("Your jump device is out of power...","Continue anyway","Restart the level")
			if opt=1 then
				map.load(level,levelselect.lvlsource)	''reload
				state=GAME_READY
			end if
			
		end if	
		
	end if
	''
	
	'' Take a screen shot	
	if multikey(SC_S) then
		bsave "screen.bmp",0
	end if

'' === END OF MAIN GAME ===

end select


'' Music On/Off (on key release)
if  MultiKey(SC_M) then
	mpressed=1
end if	

if MultiKey(SC_M)=0 and mpressed=1 then
	mpressed=0
	music_off=1-music_off
	if music_off=1 then FMUSIC_StopAllSongs()
	playmusic=0
end if

'draw string (20,20),"Music "+str(music_off)


sleep 10,1
loop until ext=1

if Open("save.dat" For Binary Access write As #1)=0 then
  	put #1, ,levelselect.high 
  	put #1, ,highscore 
  	
	Close #1
end if

FSOUND_Close()


