''
'' ????Racer
''
'' FBGD RetroComp Aug/Sept 2008 Entry by ssjx (http://ssjx.co.uk)
''
''
''

#include "header.bi"
#include "fmod.bi"

#define SC_LEFT &h4B
#define SC_RIGHT &h4D
#define SC_S &h1F
#define SC_ESCAPE &h01

'' in gfx.bas
declare sub block(as integer ,as integer, as integer)
declare sub draw_tunnel(as integer,as integer,as integer)
declare sub draw_sprite( as integer,  as integer, spr() as integer)
declare sub blockprint(x as integer, y as integer,text as string, spr() as integer,as integer)
declare sub draw_halfsprite(x as integer, y as integer, spr() as integer)
declare sub square(x as integer,y as integer,w as integer,c as integer)

''in score.bas
declare function loadscore() as integer
declare sub savescore(score as integer)

'' used to copy vehicle to player
sub vcopy(dest() as integer,src() as integer)
	for j as integer=0 to 7
		for i as integer=0 to 7
		dest(i,j)=src(i,j)
		next i
	next j
end sub


randomize timer

screen 12
width 80,60

dim as integer c,i,j,a,alt=0,sky=0,roadtype=0
dim as integer px,quit=0,fc=0,fcmax,dist,totaldist
dim as integer release
dim as integer bestdist=0,vehicle,bonus
dim as string k


dim as integer xpos(5)={8,18,30,40,54,64}
dim as integer ypos(5)={2,5,9,14,20,27}

dim as integer alpha(96*8,12)
dim as integer number(10*8,12)

dim as integer gridpos(5,5)

dim as integer bike(8,8) 
dim as integer car(8,8),bluecar(8,8),blackcar(8,8)
dim as integer tree(8,8)
dim as integer snowman(8,8)
dim as integer sun(8,8)
dim as integer moon(8,8)
dim as integer cloud(8,8)
dim as integer player(8,8)
'dim as integer ptr player
 
common shared stars() as point
dim as point stars(STARCOUNT)

dim as integer road(5,5)

'' -- Timer related --

dim as integer minf=99999,maxf=0
Dim As Double start,rad, current,av
Dim As Double realfps
Dim As Double last = Timer,t
Const as Double oneFrame = 1/FPS '1/?th of a second

''' ------------------

''
'' Sound..
''
FSOUND_Init(44100, 8, 0) 

Dim sample(10) As Integer
for i=0 to 1
	sample(i) = FSOUND_Sample_Load(FSOUND_FREE,"wav\"+str(i)+".mp3", FSOUND_HW3D, 0, 0) 
next i


''' --------------
'' set up the giant text/font

color 5,0
Dim buffer As Any Ptr
buffer = ImageCreate( 640,16)
for i=0 to 25
	draw string buffer,(i*8,0),chr(65+i)
	'draw string (i*8,0),chr(65+i)
next i

for i=0 to 10
	draw string buffer,((26*8)+(i*8),0),chr(48+i)
	'draw string ((i+26)*8,0),chr(48+i)
next i

for j=0 to 7
for i=0 to 40*8
if point(i,j,buffer)<>0 then alpha(i,j)=14 else alpha(i,j)=-1
next i
next j
ImageDestroy buffer
''
'sleep


restore bikepos
for j=0 to 5
	for i=0 to 5
	read a
	gridpos(i,j)=a
	next i
next j


'''
restore bikeimage
for j=0 to 7
	for i=0 to 7
	read a
	bike(i,j)=a
	next i
next j

restore carimage
for j=0 to 7
	for i=0 to 7
	read a
	''default is green car
	car(i,j)=a
	bluecar(i,j)=a
	blackcar(i,j)=a
	
	if a=2 then
		bluecar(i,j)=1
		blackcar(i,j)=0
	end if
	next i
next j

'''
restore treeimage
for j=0 to 7
	for i=0 to 7
	read a
	tree(i,j)=a
	next i
next j

'''
restore snowmanimage
for j=0 to 7
	for i=0 to 7
	read a
	snowman(i,j)=a
	next i
next j

'''
restore sunimage
for j=0 to 7
	for i=0 to 7
	read a
	sun(i,j)=a
	next i
next j

'''
restore moonimage
for j=0 to 7
	for i=0 to 7
	read a
	moon(i,j)=a
	next i
next j

'''
restore cloudimage
for j=0 to 7
	for i=0 to 7
	read a
	cloud(i,j)=a
	next i
next j
''
''
''
bestdist=loadscore()

''
'' Main game
''
do
''
'' title screen
''
quit=0

	draw_tunnel(0,1,0)

	blockprint(20,4,"Racer",alpha(),14 )
	blockprint(21,5,"racer",alpha(),4 )
	
	blockprint(6,14,"best dist",alpha(),14 )
	blockprint(7,15,"best dist",alpha(),4 )
	
	blockprint(40-len(str(bestdist))*4,24,str(bestdist),alpha(),3 )
	blockprint(41-len(str(bestdist))*4,25,str(bestdist),alpha(),1 )

	blockprint(20,34,"press",alpha(),3 )
	blockprint(21,35,"press",alpha(),14 )
	blockprint(20,44,"space",alpha(),3 )
	blockprint(21,45,"space",alpha(),14 )
	
	''corner initials
	restore ssjximage:
	for j=0 to 4
		for i=0 to 14
		read a
		if a=1 then block(65+i,55+j,14)
		next i
	next j
	
	
	While Inkey <> "": Wend
	
	do
	sleep 10
	
	if MultiKey(SC_ESCAPE) then
		FSOUND_Close
		end
	end if
	
	loop until inkey=" "

''
'' By bike or car?
''
bonus=0
if bestdist>150 then bonus+=1  '' green car
if bestdist>250 then bonus+=1  '' snowman
if bestdist>350 then bonus+=1  '' tree
if bestdist>400 then bonus+=1  '' cloud


	vehicle=0
	release=0
	do
	
		screenlock
		draw_tunnel(0,1,0)
	
		blockprint(16,4,"choose",alpha(),3 )
		blockprint(17,5,"choose",alpha(),14 )
	
		blockprint(24,14,"your",alpha(),3 )
		blockprint(25,15,"your",alpha(),14 )
	
		blockprint(12,24,"vehicle",alpha(),3 )
		blockprint(13,25,"vehicle",alpha(),14 )
	
		draw_sprite(xpos(0),48,bike() )
		draw_sprite(xpos(1),48,blackcar() )
		
		if bonus>0 then
			draw_sprite(xpos(2),48,car() )
		end if
		
		if bonus>1 then
			draw_sprite(xpos(3),48,snowman() )
		end if	
		
		if bonus>2 then
			draw_sprite(xpos(4),48,tree() )
		end if	
	
		if bonus>3 then
			draw_sprite(xpos(5),48,cloud() )
		end if
	
		''box around selected
		square(xpos(vehicle)-1,48-1,10,14 )
		
		screenunlock
		
		While Inkey <> "": Wend
		do	
		
		FSOUND_Update
		k=inkey
		if MultiKey(SC_LEFT) and vehicle>0 and release=0 then
			vehicle-=1
			release=1
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
		end if
		
		if MultiKey(SC_RIGHT) and (vehicle<(1+bonus)) and release=0 then
			vehicle+=1
			release=1	
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
		end if	
		
		if MultiKey(SC_ESCAPE) then
			k=" "
		end if
		
		''
		if MultiKey(SC_LEFT)=0 and MultiKey(SC_RIGHT)=0 then release=0
		sleep 10
		loop until k<>""
		
	loop until k=" "


''
select case as const vehicle
case 0: vcopy(player(),bike())
case 1: vcopy(player(),blackcar())
case 2: vcopy(player(),car())
case 3: vcopy(player(),snowman())
case 4: vcopy(player(),tree())
case 5: vcopy(player(),cloud())
end select



''
''reset things
''

'' clear road
for j=0 to 5
	for i=0 to 5
	road(i,j)=0
	next i
next j

'' star positions (also used for clouds)
for i=0 to STARCOUNT
stars(i).x=int(rnd*80)
stars(i).y=int(rnd*29)
next i

px=3
fcmax=15
dist=0
totaldist=0
road( int(rnd*6),0)=1
sky=0
roadtype=0
	
do
	''
	'' Controls...
	''		
			
	if  MultiKey(SC_LEFT) and release=0 then
		px-=1
		if px<0 then px=0
		release=1
	end if 
	
	if  MultiKey(SC_RIGHT) and release=0 then
		px+=1
		if px>5 then px=5	
		release=1
	end if
	
	if MultiKey(SC_LEFT)=0 and MultiKey(SC_RIGHT)=0 then release=0
	
	if MultiKey(SC_ESCAPE) then
		quit=2
	end if
	
	
	'' Screenshot
	if MultiKey(SC_S) then
	        bsave "screen.bmp",0
	end if
	
		

	
	''
	'' update track and item positions
	''
	fc+=1
	if fc>=fcmax then
		''move road
		alt=1-alt
		
		'' shift obstacles down		
		for j=5 to 1 step -1
			for i=0 to 5
			road(i,j)=road(i,j-1)
			next i
		next j
		
		for i=0 to 5
			road(i,0)=0
		next i
		
		'' add a car
		if (rnd*100)>60 then
		road( int(rnd*6),0)=1+int(rnd*3)
		end if
		
		'' maybe add another car
		if totaldist>50 then
			if (rnd*100)>60 then
			road( int(rnd*6),0)=1+int(rnd*3)
			end if
		end if
		
		''
		fc=0
		
		'' adjust speed depending on distance travelled
		dist+=1
		totaldist+=1	
		if dist=18 then
		
			dist=0
			
			if fcmax>5 then
			fcmax-=1
			end if
			
			
			'' change the time of day
			sky+=1
			if sky>2 then sky=0
			
			if sky=2 then
				'' stars
				for i=0 to STARCOUNT
				stars(i).x=int(rnd*80)
				stars(i).y=int(rnd*29)
				next i
			end if
			
			'' change the type of road
			'roadtype+=1
			'if roadtype>2 then roadtype=0
			roadtype=int(rnd*3)
			
			
		end if
						
	end if	
	



	''
	'' Draw everything
	''
	screenlock
	'cls
	draw_tunnel(alt,sky,roadtype)
	
	select case as const sky
	''case 0: draw_sprite(70,10,sun() )
	case 1:
		draw_sprite(70,2,sun() )
		draw_sprite(stars(0).x,2,cloud() )
		draw_sprite(stars(1).x,10,cloud() )
		draw_sprite(stars(2).x,11,cloud() )
		
	case 2: draw_sprite(70,2,moon() )
	end select
	
	'' corner score
	blockprint(0,0,str(totaldist),alpha(),14 )
		
	for j=0 to 5
		for i=0 to 5
		color 1,0
	'	print road(i,j);
		
		''
		'' Road has cars on
		''
		
		if roadtype=0 then
		
		select case as const road(i,j)
		
			case 1:	
				if j<2 then
					draw_halfsprite(gridpos(i,j),21+ypos(j),car() )	
				else
					draw_sprite(gridpos(i,j),21+ypos(j),car() )
				end if
			case 2:
				if j<2 then
					draw_halfsprite(gridpos(i,j),21+ypos(j),bluecar() )	
				else
					draw_sprite(gridpos(i,j),21+ypos(j),bluecar() )
				end if
			
			case 3: 
				if j<2 then
					draw_halfsprite(gridpos(i,j),21+ypos(j),blackcar() )	
				else
					draw_sprite(gridpos(i,j),21+ypos(j),blackcar() )
				end if	
				
			end select
		
		end if
		
		''
		'' Grassy has trees
		''
		
		if roadtype=1 then
			if road(i,j)>0 then
				if j<2 then
					draw_halfsprite(gridpos(i,j),21+ypos(j),tree() )	
				else
					draw_sprite(gridpos(i,j),21+ypos(j),tree() )
				end if
			end if
		end if
		
		''
		'' Cold
		''
		
			if roadtype=2 then
			if road(i,j)>0 then
				if j<2 then
					draw_halfsprite(gridpos(i,j),21+ypos(j),snowman() )	
				else
					draw_sprite(gridpos(i,j),21+ypos(j),snowman() )
				end if
			end if
		end if
		
		next i
	'	print ""
	next j
	'print "--"
	
	
	'' draw player
	draw_sprite(xpos(px),48,player() )
	
	
	'color 4
	'print fcmax,fc,dist
	screenunlock
	''
	'' End of drawing
	''

	'' check for player collision
	if road(px,5)<>0 then
		quit=2
		FSOUND_PlaySound(FSOUND_FREE, sample(1))	
	end if

	' Clear input buffer
	
	'sleep 1000/30
	
	''' ---------- TIMER ---------
	

	#if DEBUG=1
		Locate 10, 1          
		av+=realfps
		av=av/2                       '
		
		if int(realfps)<minf then minf=int(realfps)
		if int(realfps)>maxf then maxf=int(realfps)
			
		color 1,2
		print ""
		print "target : "+str(FPS)
		print "actual : ";int(realfps)
		print "average: ";int(av)
		print "min: ";minf
		print "max: ";maxf	
		print "speed: ";fcmax	
		
	#endif
	
	'' Frame rate control 
	'while (( timer-start)<=(1/FPS))
	'sleep 1
	'wend 
	if Timer < (start + oneFrame) Then Sleep ((start + oneFrame) - Timer)* 1000	
	realfps = 1 / (Timer-start)
	start=timer
	''' ---------- TIMER ---------
	
	
loop until quit<>0

	
if quit=2 then

	'' draw explosion
	for j as integer=0 to 7
		for i as integer=0 to 7
		
		if (rnd*10)>5 then
		block(xpos(px)+i,21+ypos(5)+j, 14) ''
		end if
		next i
	next j

	'' draw scores
	blockprint(8,4,"gameover",alpha(),14 )
	blockprint(9,5,"gameover",alpha(),4 )

	blockprint(8,14,"distance",alpha(),14 )
	blockprint(9,15,"distance",alpha(),4 )
	
	blockprint(40-len(str(totaldist))*4,24,str(totaldist),alpha(),3 )
	blockprint(41-len(str(totaldist))*4,25,str(totaldist),alpha(),1 )
	

	'' update best score
	if totaldist>bestdist then
		bestdist=totaldist
		
		blockprint(8,34,"new best",alpha(),14 )
		blockprint(9,35,"new best",alpha(),3 )
		
		savescore(bestdist)
	else
		blockprint(24,34,"best",alpha(),14 )
		blockprint(25,35,"best",alpha(),4 )
		
		blockprint(40-len(str(bestdist))*4,44,str(bestdist),alpha(),3 )
		blockprint(40-len(str(bestdist))*4,45,str(bestdist),alpha(),1 )			
	end if
	

	While Inkey <> "": Wend
	
	do
	sleep 10
	loop until inkey=" "
end if

loop until quit=1

FSOUND_Close
end

'' xpos per stripe
bikepos:
data 25,28,34,39,44,49
data 23,28,34,40,45,52
data 18,25,33,40,46,54
data 16,22,32,40,48,56
data 12,20,31,40,52,60
data  8,18,30,40,54,64

'' -1 = transparent and does not get displayed
bikeimage:
data -1,-1,-1,8,8,-1,-1,-1
data -1,-1,8,8,8,8,-1,-1
data -1,-1,-1,8,8,-1,-1,-1
data -1,-1,8,8,8,8,-1,-1
data -1,-1,8,0,0,8,-1,-1
data -1,-1,8,0,0,8,-1,-1
data -1,-1,8,0,0,8,-1,-1
data -1,-1,-1,0,0,-1,-1,-1

carimage:
data -1,-1,-1,-1,-1,-1,-1,-1
data -1,-1,2,2,2,2,-1,-1
data -1,2,3,3,3,3,2,-1
data 2,3,3,3,3,3,3,2
data 2,2,2,2,2,2,2,2
data 2,2,2,2,2,2,2,2
data -1,0,0,-1,-1,0,0,-1
data -1,0,0,-1,-1,0,0,-1

treeimage:
data -1,2,10,2,10, 2,10,-1
data 2,10,2,10,2,10,2,10
data 10,2,10,2,4,2,10,2
data 2,4,2,10,2,10,2,10
data 10,2,10,2,10,4,10,2
data -1,10,2,10,2,10,2,-1
data -1,-1,-1,0,0,-1,-1,-1
data -1,-1,-1,0,0,-1,-1,-1

ssjximage:
data 1,1,1,0,1,1,1,0,1,1,1,0,1,0,1
data 1,0,0,0,1,0,0,0,0,0,1,0,1,0,1
data 1,1,1,0,1,1,1,0,1,0,1,0,0,1,0
data 0,0,1,0,0,0,1,0,1,0,1,0,1,0,1
data 1,1,1,0,1,1,1,0,1,1,1,0,1,0,1

snowmanimage:
data -1,-1,15,15,15,-1,-1,-1
data -1,15,0,15,0,15,-1,-1
data -1,15,15,14,15,15,-1,-1
data -1,-1,15,15,15,-1,-1,-1
data -1,15,15,0,15,15,-1,-1
data 15,15,15,15,15,15,15,-1
data 15,15,15,0,15,15,15,-1
data 15,15,15,15,15,15,15,-1

sunimage:
data -1,14,14,14,14,-1,-1,-1
data 14,14,14,14,14,14,-1,-1
data 14,14,14,14,14,14,-1,-1
data 14,14,14,14,14,14,-1,-1
data 14,14,14,14,14,14,-1,-1
data -1,14,14,14,14,-1,-1,-1
data -1,-1,-1,-1,-1,-1,-1,-1
data -1,-1,-1,-1,-1,-1,-1,-1

moonimage:
data -1,14,14,14,-1,-1,-1,-1
data 14,14,14,-1,-1,-1,-1,-1
data 14,14,-1,-1,-1,-1,-1,-1
data 14,14,-1,-1,-1,-1,-1,-1
data 14,14,14,-1,-1,-1,-1,-1
data -1,14,14,14,-1,-1,-1,-1
data -1,-1,-1,-1,-1,-1,-1,-1
data -1,-1,-1,-1,-1,-1,-1,-1


cloudimage:

data -1,15,15,-1,15,15,15,-1
data 15,15,15,15,15,15,15,15
data 15,15,15,15,15,15,15,15
data -1,15,15,15,-1,15,15,-1
data -1,15,15,15,15,-1,-1,-1
data -1,-1,-1,-1,-1,-1,-1,-1
data -1,-1,-1,-1,-1,-1,-1,-1
data -1,-1,-1,-1,-1,-1,-1,-1




