''
'' Pac-Man : Ghosts Revenge by ssjx 26/11/9 (http://ssjx.co.uk)
''
'' * pacman not smart enough yet, should be better at avoiding walking into ghosts
'' * add ghost sweep to clear screen
'' * make the players ghost as fast as pac man
'' * 'ZZZzzz' bubbles to pause screens
'' * alert bubbles when ghost/pac spot things
'' * bonus fruit that reduce score (negative score!)
'' * add various title, help, highscore....
'' * sounds..
'' * speed up ghosts on later levels
''
#include "fbgfx.bi"
#include "header.bi"
#include "fmod.bi"

randomize timer

'' in zcollide.bas
declare function collide( as integer, as integer, as integer, as integer) as integer

'' in scoretable.bas
declare sub inittable()
declare sub addname(as integer)
declare sub showtable()

'' in stats
declare sub showstats()
''
''
'' in save

declare sub save_state()
declare function load_state() as integer
''
''
declare sub loadmap(as integer)
declare function drawmap() as integer

''
''
''

dim shared as ubyte map(30,30)
dim shared as ubyte col(30,30)

dim shared as any ptr level_spr(20)	''blocks etc..

common shared ghost_spr() as any ptr  
dim shared as any ptr ghost_spr(20) 

common shared pac_spr() as any ptr  
dim shared as any ptr pac_spr(20) 	''

dim shared as any ptr fruit_spr(20) 	''

dim shared as any ptr arrow 

common shared arial24y as any ptr
''dim shared as any ptr arial24y

dim shared as integer swidth,sheight,sdepth
dim shared as integer mapwidth,mapheight

'' not much difference between ghost and pacman really..
common shared pacman as ghostpos 
'dim as ghostpos pacman

common shared ghost() as ghostpos 
dim ghost(4) as ghostpos 

'' if pac eats all the dots then the player has lost
dim shared as integer maxdots

dim shared as string txt(20)


''
''

function charwidth(word as string) as integer
	dim as integer i,wid,aval
	Dim As UByte Ptr p
	
	ImageInfo( arial24y, , , , , p )
	
	for i=1 to len(word)	
		aval=asc(mid(word,i,1))
		if aval=32 then
			wid+=7
		else
			wid+=p[3 + aval -32 ]
		endif 
	next i
	
	return wid
end function


sub clrtxt()
	for i as integer=0 to 19
		txt(i)=""
	next i
end sub

function title() as integer
	dim as integer i,j,xpos,ext,px=320,py=500,pxd=2,psc=0,alt=0
	dim as string key
	
	dim gh(4) as integer = { 0, 0, 0, 0 }
	dim ghd(4) as integer = { -1, 1, -1, 1 }
	
	
	''
	ext=0
	''clear key buffer	
	While Inkey <> "": Wend
		
	do	
		cls
		
		for i=0 to 19
			xpos=(swidth-charwidth(txt(i)))/2
			draw string(xpos,50+(i*28)),txt(i),,arial24y
		next i
		
		'if alt=0 then
			for i=0 to 3
				gh(i)+=ghd(i)
			
				if gh(i)=16 then ghd(i)=-1
				if gh(i)=-16 then ghd(i)=1	
				'end if
				'if ()
			next i
		'end if
		
		
		'' draw ghosts
		for i=0 to 3
		'	put ((swidth/2)-64+(i*32),300+gh(i)),ghost_spr(i),trans
			put ((swidth/2)-112+(i*64),290+gh(i)),ghost_spr(i),trans
		next i
		
		''
		if pxd=2 then
			put (px,py),pac_spr(0+alt),trans
		else
			put (px,py),pac_spr(2+alt),trans
		end if
		
		
		px+=pxd
		psc+=1
		
		'' change direction
		if (px=0 or px=(swidth-32)) then
			pxd=pxd*-1
			
		end if
		
		'' update sprite
		if psc=8 then
			psc=0
			alt=1-alt
		end if
		
		
		''
		key=inkey
	
		if multikey(SC_ESCAPE) then
			save_state()
			end
		end if
		
		if ucase(key)=" " then ext=1 '' game
		if ucase(key)="H" then ext=2 '' hi scores
		if ucase(key)="S" then ext=3 '' stats
		
		''
		screencopy
		sleep 10	
	loop while ext=0
	
	return ext
	
end function


function dif() as integer
	dim as integer i,j,xpos,ext
	dim as string key
	
	'color ,rgb(200,200,200)
	color rgb(255,255,0)
		
	cls
	
	for i=0 to 19
		xpos=(swidth-charwidth(txt(i)))/2
		draw string(xpos,50+(i*28)),txt(i),,arial24y
	next i
		
	'' draw pacman
	for i=0 to 0
		put ((swidth/2)-16+(i*32),54+(4*28)),pac_spr(0),trans
	next i

	for i=0 to 2
		put ((swidth/2)-48+(i*32),54+(7*28)),pac_spr(0),trans
	next i
	
	for i=0 to 3
		put ((swidth/2)-64+(i*32),54+(10*28)),pac_spr(0),trans
	next i	
	screencopy	
	
	''clear key buffer	
	While Inkey <> "": Wend
	
	''
	ext=-1
	do
		key=inkey
		
	'	if multikey(SC_ESCAPE) then
	'		ext=0
	'	end if
		if ucase(key)="B" then ext=0 '' game
		if ucase(key)="1" then ext=1 '' game
		if ucase(key)="2" or key=" " then ext=3 '' 
		if ucase(key)="3" then ext=4 '' stats
		
		sleep 10
	loop while ext=-1
	
	return ext
	
end function


sub infobox(txta as string)
	dim as integer w=400,h=120,xpos
	dim as integer x1,y1,x2,y2
	dim as string key
	
	x1=(swidth-w)/2
	y1=(sheight-h)/2
	x2=(swidth+w)/2
	y2=(sheight+h)/2

	color rgb(255,200,0)
	line(x1-5,y1-5)-(x2+5,y2+5),,bf	
	
	color rgb(0,0,0)
	line(x1,y1)-(x2,y2),,bf

	txt(3)="Press Space"

	for i as integer=0 to 3
		xpos=(swidth-charwidth(txt(i)))/2
		draw string(xpos,(sheight/2)-64+(i*28)),txt(i),,arial24y
	next i
	
	screencopy
	While Inkey <> "": Wend
		
	do
	key=inkey
	sleep 10
	loop while key<>" "

end sub

''
'' Yes or No box
'' Returns 1 = yes, 2 = no
function yesno(txta as string) as integer
	dim as integer w=400,h=120,xpos,ext
	dim as integer x1,y1,x2,y2
	dim as string key
	
	x1=(swidth-w)/2
	y1=(sheight-h)/2
	x2=(swidth+w)/2
	y2=(sheight+h)/2

	color rgb(255,200,0)
	line(x1-5,y1-5)-(x2+5,y2+5),,bf	
	
	color rgb(0,0,0)
	line(x1,y1)-(x2,y2),,bf

	txt(3)="(Y)es / (N)o"

	for i as integer=0 to 3
		xpos=(swidth-charwidth(txt(i)))/2
		draw string(xpos,(sheight/2)-64+(i*28)),txt(i),,arial24y
	next i
	
	screencopy
	While Inkey <> "": Wend
	
	ext=0	
	do
		key=inkey
		sleep 10
		if key="y" then ext=1:
		if key="n" or key=" " then ext=2
		
	loop while ext=0

return ext

end function


''
'' simple non scrolly map display
''
function drawmap() as integer
	dim as integer i,j,c
	cls
	''
	'' Draw level
	''
	for j=0 to mapheight-1
	for i=0 to mapwidth-1
		if (map(i,j)>0) then
		put (i*32,j*32),level_spr(map(i,j)),trans
		end if
		
		if (map(i,j)=2) then c+=10
		if (map(i,j)=3) then c+=20
		
	next i
	next j
	return c
end function

function dotcount() as integer
	dim as integer c,i,j
	for j=0 to mapheight-1
	for i=0 to mapwidth-1

		if (map(i,j)=2 or map(i,j)=3) then c+=1
		
	next i
	next j
	return c
end function


sub addfruit()
	dim as integer fpos,c=0,i,j
	
	fpos=int(rnd * (mapheight*mapwidth))

	for j=1 to mapheight-1
	for i=0 to mapwidth-1

		if (map(i,j)=0 and c>fpos) then
			map(i,j)=11+int(rnd * 4)
			return
		end if
	c+=1
	next i
	next j

end sub

'' change a yellow dot to a red dot
sub extra_reddot(cnt as integer)
	dim as integer fpos,c,dots,i,j
	
	for dots=1 to cnt
		c=0
		fpos=int(rnd * (mapheight*mapwidth))
	
		for j=1 to mapheight-1
		for i=0 to mapwidth-1
	
			if (map(i,j)=2 and c>fpos) then
				map(i,j)=3
				'return
				goto nextdot
			end if
		c+=1
		next i
		next j
		
		nextdot:
	next dots

end sub

'' change a yellow dot to a wall
sub extra_wall()
	dim as integer fpos,c,dots,i,j
	
		c=0
		fpos=int(rnd * (mapheight*mapwidth))
	
		for j=1 to mapheight-1
		for i=0 to mapwidth-1
	
			if (map(i,j)=2 and c>fpos) then
				map(i,j)=10
				col(i,j)=1
				return
			end if
		c+=1
		next i
		next j
		

end sub


sub loadmap(lev as integer)
	dim as ubyte r,g,b,ghostc=0
	dim as integer i,j
	dim header as bmphdr
	
	''clear the map and collision array
 	for j=0 to (30-1)
		for i=0 to (30-1) 
		map(i,j)=0
		col(i,j)=0
		next i
	next j	
	
	''
	'' Load the map
		
	if  Open("maps\map"+str(lev)+".bmp" For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				''green=dot
				if (r=0 and g=255 and b=0) then	map(i,j)=2:map(i,j)=2	
				
				''blue=dot
				if (r=0 and g=0 and b=255) then	map(i,j)=3:map(i,j)=3
				
				''black= wall	
				if (r=0 and g=0 and b=0) then map(i,j)=4 : col(i,j)=1
				if (r=64 and g=0 and b=0) then map(i,j)=5 : col(i,j)=1
				
				if (r=128 and g=0 and b=0) then map(i,j)=6 : col(i,j)=1
				if (r=128 and g=64 and b=64) then map(i,j)=7 : col(i,j)=1
				
				if (r=128 and g=128 and b=0) then map(i,j)=8 : col(i,j)=1
				if (r=128 and g=64 and b=0) then map(i,j)=9 : col(i,j)=1
				
				'' 11,12,13,14 = fruit
			
				
				
					
				''yellow pac start
				if (r=255 and g=255 and b=0) then	
				
					with pacman
						.active=2
						.x=i
						.y=j
						.sx=.x
						.sy=.y
					end with
				end if
				
				
				''red=ghost start
				if (r=255 and g=0 and b=0) then
				
					'map(i,j)=2	
					
					with ghost(ghostc)
						.active=2
						.x=i
						.y=j
						.sx=.x
						.sy=.y
					end with
					
					ghostc+=1
					
				end if
				
				
			next i
			
			'' padding as the bitmap does not end on a 4byte boundary..
			get #1, ,r,1
		next j
		    
	        Close #1     
	end if
end sub

''
'' 
''

'function dir_clear(x as integer,y as integer) as integer

'	if map(x,y)=1 then return 1
	
'	return 0

'end function


''
'' Ghosts tasks will be to chase pacman or to run from him
''

sub ghost_dir(x as integer,y as integer,byref xdir as integer,byref ydir as integer)
	dim as integer i,d,tmp,superdir=-1
	dim as integer done=0

	dim as integer mydir(3)

	'' pacman in sight?
	for d=0 to 3
	
		if d=0 then xdir=0:ydir=-1 ''up
		if d=1 then xdir=0:ydir=1 ''down
		if d=2 then xdir=-1:ydir=0 ''left
		if d=3 then xdir=1:ydir=0 ''right
	
		for i=1 to 25
			if col(x+(xdir*i),y+(ydir*i))<>1 then
				'' pacman in view!
				if pacman.x=x+(xdir*i) and pacman.y=y+(ydir*i) then
				
					if pacman.super=0 then
						superdir=d
						done=1
						exit for
					end if
				
				end if
			
			else
				'' hit a wall
				exit for
			end if
		
		next i
		
		if done=1 then exit for
	next d
	
	'' not chosen a direction then just go random..
	if done=0 then
	
		for i=0 to 3
		mydir(i)=0
		next i

		if col(x,y-1)<>1 then mydir(0)=1 ''up
		if col(x,y+1)<>1 then mydir(1)=1 ''down
		if col(x-1,y)<>1 then mydir(2)=1 ''left
		if col(x+1,y)<>1 then mydir(3)=1 ''right
		
		'' if super pac is in the direction, do not chose it!
		if superdir<>-1 then
			mydir(superdir)=0
		end if
		
		
		d=-1 
		do
		tmp=int(rnd * 4)
		if mydir(tmp)=1 then
			d=tmp	
		end if
		loop until d<>-1	
		
		if d=0 then xdir=0:ydir=-1 ''up
		if d=1 then xdir=0:ydir=1 ''down
		if d=2 then xdir=-1:ydir=0 ''left
		if d=3 then xdir=1:ydir=0 ''right
		
	end if
	
		
end sub

''
'' Pacmans tasks will be 
'' * collecting dots (done!),
'' * running from ghosts
'' * chasing ghosts if supercharged!
''
''

sub pacman_dir(x as integer,y as integer,byref xdir as integer,byref ydir as integer)
	dim as integer ra,rb,rt,i,d,g,r,tmp,gdist,bestdir
	dim as integer ad
	dim as integer done=0
	dim as integer mydir(3)	
	dim as integer dirlist(3)
	dim as integer ghostdist(3)
	dim as integer txdir,tydir
	
	const as integer gdanger=10
	
	txdir=xdir
	tydir=ydir
	
	#if DEBUG=1
	color rgb(255,255,255)
	locate 10,1	
	#endif
	
	''
	'' Make a randon direction list to prevent always defaulting to a particular
	'' direction
	
	for d=0 to 3
		dirlist(d)=d
	next d
	
	for i=0 to 10
		ra=int(rnd*4)
		rb=int(rnd*4)
		
		rt=dirlist(ra)
		dirlist(ra)=dirlist(rb)
		dirlist(rb)=rt
	next i
	
	''
	'' find out how far ghost are in each direction
	''
	for d=0 to 3
	
		if d=0 then xdir=0:ydir=-1 ''up
		if d=1 then xdir=0:ydir=1 ''down
		if d=2 then xdir=-1:ydir=0 ''left
		if d=3 then xdir=1:ydir=0 ''right
	
		''
		'' get distance of closest ghost in this direction
		''
		ghostdist(d)=99
		for g=0 to 3
			if ghost(g).active=0 then continue for
		
			for i=1 to 25
				'' hit a wall
				if col(x+(xdir*i),y+(ydir*i))=1 then
					exit for
				end if
						
				'' ghost in path..
				if (x+(xdir*i))=ghost(g).x and (y+(ydir*i))=ghost(g).y then
					ghost(g).seen=i
					if i<ghostdist(d) then ghostdist(d)=i	
					exit for					
				end if
			next i
		next g
	
	next d
	
	
	
	''
	'' If super charged, only task is eating ghosts! 
	'' Head toward closest ghost!
	''
	
	if pacman.super>0 then
		#if DEBUG=1
	
		print "========== Super Pacman"
		#endif
	
		bestdir=-1
		gdist=99
		
		'' find direction with the closest ghost
		for d=0 to 3
			if ghostdist(d)<gdist then bestdir=d
		next d
		
		'' we have our best direction
		if bestdir<>-1 then 
			d=bestdir
		
			if d=0 then xdir=0:ydir=-1 ''up
			if d=1 then xdir=0:ydir=1 ''down
			if d=2 then xdir=-1:ydir=0 ''left
			if d=3 then xdir=1:ydir=0 ''right
	
			return
		end if
	
	end if
		

	''
	'' end of super pac bit...
	''
	
	'' look for close dots?
	
	for ad=0 to 3
		d=dirlist(ad)
		#if DEBUG=1
		print "========== Looking for CLOSE dots "+str(d)
		#endif
		if d=0 then xdir=0:ydir=-1 ''up
		if d=1 then xdir=0:ydir=1 ''down
		if d=2 then xdir=-1:ydir=0 ''left
		if d=3 then xdir=1:ydir=0 ''right
	
		'' ghostdist(d)>10
		if ghostdist(d)>gdanger then
		
			''follow a dot trail if next to one
			if map(x+xdir,y+ydir)=2 or map(x+xdir,y+ydir)=3 then
				'done=1
				return
			end if
		end if
	next ad
	
	''if done=1 then return
	
	'' look for far dots?
	
	''
	
	for ad=0 to 3
		d=dirlist(ad)
		
		#if DEBUG=1
		print "Looking for FAR dots ===== "+str(d)
		#endif
		if d=0 then xdir=0:ydir=-1 ''up
		if d=1 then xdir=0:ydir=1 ''down
		if d=2 then xdir=-1:ydir=0 ''left
		if d=3 then xdir=1:ydir=0 ''right
	
		'' ghostdist(d)>10
		if ghostdist(d)>gdanger then		
			'' look for further away dots
			'if done=0 then
				for i=1 to 25
					'' hit a wall
					if col(x+(xdir*i),y+(ydir*i))=1 then
						exit for
					end if
				
					'' spotted a dot!
					if map(x+(xdir*i),y+(ydir*i))=2 or map(x+(xdir*i),y+(ydir*i))=3 then
						done=1
						exit for
					end if
				
				next i
			'end if
			
		end if
		if done>0 then exit for
	next ad
	
	''
	'' If not found a better direction see if we can just carry on in the
	'' current one
	''
	if done=0 then	
		'' if we hit a wall dir is 0!
		if txdir<>0 or tydir<>0 then 
			if txdir=0 and tydir=-1 then d=0 ''up
			if txdir=0 and tydir=1 then d=1 ''down
			if txdir=-1 and tydir=0 then d=2 ''left
			if txdir=1 and tydir=0 then d=3 ''right
			
			if ghostdist(d)>gdanger and col(x+txdir,y+tydir)<>1 then
				xdir=txdir
				ydir=tydir
				done=1
			end if
			
			#if DEBUG=1
			print ">>>>>>> Continuing dir "+Str(d)
			#endif			
		end if
	end if
	
	''
	'' by this point guess there are ghosts in the way, just look for an exit!
	''
	if done=0 then
	
		#if DEBUG=1
			print "-------- Looking for an exit"
		#endif
		
		for ad=0 to 3
			d=dirlist(ad)
			if d=0 then xdir=0:ydir=-1 ''up
			if d=1 then xdir=0:ydir=1 ''down
			if d=2 then xdir=-1:ydir=0 ''left
			if d=3 then xdir=1:ydir=0 ''right
			
			if ghostdist(d)>gdanger and col(x+xdir,y+ydir)<>1 then
				done=1
				exit for
			end if
			
		next ad
	
	end if
	''
	''	
	pacman.seen=d	
	

		
	'' not still chosen a direction then just go random (already jumbled)..
	if done=0 then
		#if DEBUG=1
			print "============ Random dir"
		#endif
	 
		 for ad=0 to 3
			d=dirlist(ad)
			
			if d=0 then xdir=0:ydir=-1 ''up
			if d=1 then xdir=0:ydir=1 ''down
			if d=2 then xdir=-1:ydir=0 ''left
			if d=3 then xdir=1:ydir=0 ''right
			
			if col(x,y-1)<>1 then exit for
			
		next ad
		
	end if


			
end sub


''
''
''
function set_ghostcon(myghost as integer) as integer
dim as integer g,prev

	'' get the number of the currently controlled ghost
	for g=0 to 3
	if ghost(g).active=1 then prev=g
	next g

	'' make sure the new ghost is still in play
	if ghost(myghost).active>0 then
	
		''set all in play ghosts to cpu control
		for g=0 to 3
			if ghost(g).active>0 then 
			ghost(g).active=2
			ghost(g).speed=1
			end if	
		next g
		
		'' take control of our new ghost
		ghost(myghost).active=1
		ghost(myghost).speed=2
		
	else
		'' return the old ghost if new one is not playable
		return prev	
	end if	

return myghost

end function

''
''
''

function set_nextghost() as integer
dim as integer g

	'' 
	for g=0 to 3
		if ghost(g).active=2 then 
		ghost(g).active=1
		ghost(g).speed=2
		exit for
		end if
	next g

return g

end function


''
function active_ghosts() as integer
	dim as integer c,g

	for g=0 to 3
	if ghost(g).active>0 then c+=1
	next g
	
	return c
end function
''
''
''

'' put ghost and pac back in starting places

sub resetplaces()
dim as integer g
	for g=0 to 3
		with ghost(g) 
			if .active<>0 then .active=2	'' all active compter controlled			
			.x=.sx
			.y=.sy
			.ox=0
			.oy=0
			.xdir=0
			.ydir=0
			.speed=1
		end with
	next g
	
	
	with pacman
	
		.x=.sx
		.y=.sy
		.ox=0
		.oy=0
		.xdir=0
		.ydir=0
		.super=0
	end with
	
end sub

'
' Create light versions of the ghost (saves making more images)
'

sub dimghost(no as integer)
dim as integer pix=0
	
	Dim buffer As UByte Ptr = ghost_spr(no) 

	pix=32
	
	for i as integer=0 to (32*32)-1
	
	if buffer[pix]=255 and buffer[pix+1]=0 and buffer[pix+2]=255 and buffer[pix+3]=255 then 
	'' don't dim magic pink colour...
	else
		for j as integer=0 to 2
		if buffer[pix+j]=0 then buffer[pix+j]=120
		next j
		
	       'buffer[pix]=255-buffer[pix]
	       'buffer[pix+1]=255-buffer[pix+1]
	       'buffer[pix+2]=255-buffer[pix+2] 'shl 2
	       'buffer[pix+3]=255-buffer[pix+3] ' shl 2
	       
	end if
	      pix+=4
	next i	
end sub

'
' Create red versions of pac
'

sub redpac(no as integer)
dim as integer pix=0
	
	Dim buffer As UByte Ptr = pac_spr(no) 

	pix=32
	
	for i as integer=0 to (32*32)-1
	
	if buffer[pix]=255 and buffer[pix+1]=0 and buffer[pix+2]=255 and buffer[pix+3]=255 then 
	'' don't dim magic pink colour...
	else
	
		'' yellow to red BGRA
		if buffer[pix]=0 and buffer[pix+1]=255 and buffer[pix+2]=255 and buffer[pix+3]=255 then
			buffer[pix]=0 'B
			buffer[pix+1]=0 'G
			buffer[pix+2]=255	''R
		end if
	
		'' dark yellow mouth to dark red
	       if buffer[pix]=0 and buffer[pix+1]=200 and buffer[pix+2]=200 and buffer[pix+3]=255 then
			buffer[pix]=0
			buffer[pix+1]=0
			buffer[pix+2]=200	
		end if
	       
	       
	end if
	      pix+=4
	next i	
end sub

''
'' Main program
''


'screen 18,16,2 '',&h01
screenres 800,600,32,2
screeninfo swidth,sheight,sdepth

screenset 0,1

dim as integer i,j, x,y,ext,alt=0,spritedir,lc=0,sc=0
dim as integer tim,level,curmap,hiscore=0,lives,paclives,near
dim as integer ghostcon,g,showplayer,ghostsleep,supertime
dim as string mess
dim as integer score,bonus,totalscore



'' -- Timer related --

dim as integer minf=99999,maxf=0
Dim As Double start,rad, current,av
Dim As Double realfps
Dim As Double last = Timer,t
Const as Double oneFrame = 1/FPS '1/?th of a second

''' ------------------

''' -- Sound ---

FSOUND_Init(44100, 8, 0) 

Dim sample(10) As Integer
for i=0 to 2
	sample(i) = FSOUND_Sample_Load(FSOUND_FREE,"wav\"+str(i)+".mp3", FSOUND_HW3D, 0, 0) 
next i


''' --------------

'' create our sprites
for i=0 to 20
	level_spr(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	pac_spr(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	ghost_spr(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	fruit_spr(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	
	
next i

	arrow = ImageCreate( 32, 32,rgb(100,255,100) )

''
''bload "gfx\",level_spr(0)
bload "gfx\block.bmp",level_spr(1)
bload "gfx\dot.bmp",level_spr(2)
bload "gfx\bigdot.bmp",level_spr(3)

bload "gfx\walls\block-vertical.bmp",level_spr(4)
bload "gfx\walls\block-horizontal.bmp",level_spr(5)
bload "gfx\walls\block-tl.bmp",level_spr(6)
bload "gfx\walls\block-tr.bmp",level_spr(7)
bload "gfx\walls\block-bl.bmp",level_spr(8)
bload "gfx\walls\block-br.bmp",level_spr(9)
bload "gfx\walls\block.bmp",level_spr(10)



bload "gfx\fruit\cherry.bmp",level_spr(11)
bload "gfx\fruit\green_apple.bmp",level_spr(12)
bload "gfx\fruit\red_apple.bmp",level_spr(13)
bload "gfx\fruit\strawberry.bmp",level_spr(14)


bload "gfx\arrow.bmp",arrow

'' players
bload "gfx\pac\pac_r.bmp",pac_spr(0)
bload "gfx\pac\pac_r1.bmp",pac_spr(1)
bload "gfx\pac\pac_l.bmp",pac_spr(2)
bload "gfx\pac\pac_l1.bmp",pac_spr(3)
bload "gfx\pac\pac_u.bmp",pac_spr(4)
bload "gfx\pac\pac_u1.bmp",pac_spr(5)
bload "gfx\pac\pac_d.bmp",pac_spr(6)
bload "gfx\pac\pac_d1.bmp",pac_spr(7)

'' make a red pac man
for i=0 to 7
put pac_spr(10+i),(0,0),pac_spr(i),pset
redpac(10+i)
next i

''load ghosts..
bload "gfx\ghosts\ghost.bmp",ghost_spr(0)
bload "gfx\ghosts\ghost2.bmp",ghost_spr(1)
bload "gfx\ghosts\ghost3.bmp",ghost_spr(2)
bload "gfx\ghosts\ghost4.bmp",ghost_spr(3)
bload "gfx\ghosts\ghost_dead.bmp",ghost_spr(4)

'' ..copy them..
put ghost_spr(5),(0,0),ghost_spr(0),pset
put ghost_spr(6),(0,0),ghost_spr(1),pset
put ghost_spr(7),(0,0),ghost_spr(2),pset
put ghost_spr(8),(0,0),ghost_spr(3),pset

'' ..create light coloured versions
dimghost(5)
dimghost(6)
dimghost(7)
dimghost(8)

'' load our font
'arial24y=ImageCreate( 1235, 27 )
'bload "fonts\arial_18_yellow.bmp", arial24y

arial24y=ImageCreate( 1473, 38 )
bload "fonts\comic_20_yellow.bmp", arial24y


'' add some color to fonts

'' cyan symbols
for j=0 to 38
	for i=0 to 205
		'print ">",hex(point(i,j,arial24y)),"<"	
		if point(i,j,arial24y)=&hffff00 then		
			pset arial24y,(i,j),rgb(0,100,255)
		end if
	
	next i
next j

'' green numbers
for j=0 to 38
	for i=205 to 452
		'print ">",hex(point(i,j,arial24y)),"<"	
		if point(i,j,arial24y)=&hffff00 then		
			pset arial24y,(i,j),rgb(0,255,0)
		end if
	
	next i
next j

'' striped letters
for j=0 to 19 '27
	for i=453 to 1473
		'print ">",hex(point(i,j,arial24y)),"<"	
		if point(i,j,arial24y)=&hffff00 then		
			pset arial24y,(i,j),rgb(255,100,55)
		end if
	
	next i
next j
''
'screencopy
'sleep
pacman.name="Pac-Man"
ghost(0).name="Slimer" 'green'
ghost(1).name="Jacob" 'red'
ghost(2).name="Blu" 'blue'
ghost(3).name="Marley" 'orange'

if (load_state()=1) then
	''this means there is no save file..
	inittable()
end if

''
do
	'' title screen
	clrtxt()
	ext=0
	do 
		txt(0)=GAMETITLE
		txt(1)="by ssjx"
		txt(2)=""
		txt(3)="Controls"
		txt(4)="Arrows  - Move"
		txt(5)="1,2,3,4 - Select a ghost"
		txt(6)="P - Pause"
		txt(7)=""
		txt(8)=""
		txt(9)=""
		txt(10)=""
		
		txt(11)="Press [H] to view hi-scores"
		txt(12)="Press [S] for game stats"
		
		txt(13)="[Space] to Start"
		txt(14)="[Escape] to Quit"
		
		txt(17)="FBGD Nov 2009 Competition Entry"
		txt(18)=VERSION+"      "+SITEURL
		
		ext=title()

		select case as const ext
		
		case 1:
			'' set  difficulty level
			clrtxt()
			txt(0)=GAMETITLE
			txt(1)="Difficulty Select"
			txt(2)=""
			txt(3)="1. Easy"
			txt(6)="2. Normal"
			txt(9)="3. Hard"
			
			
			txt(12)="Use the number keys or"  
			txt(13)="[Space] to Start"
			txt(14)="[B] to go back to the menu"
		
			txt(17)="FBGD Nov 2009 Competition Entry"
			txt(18)=VERSION+"      "+SITEURL
		
			paclives=dif()
			
			if paclives>0 then ext=4
		
		case 2:
			'' high score table
			showtable()
		case 3:
			showstats()
		end select
		

	loop until ext=4



'' set up at game start




level=1
curmap=1
totalscore=0
bonus=0		'' this is pacs bonus from collecting the fruit
supertime=10 	''this is the length of time the red dots effect pac

''
do
	ext=0
	lives=paclives '' Pacmans lives not the players (reset on each level)
	loadmap(curmap)
	
	''
	extra_reddot(level-1)
	if level>1 then extra_wall()
	''
	
	resetplaces()
	ghostcon=set_nextghost()	'' ghost the player is current controlling
	ghostsleep=(15*FPS)		'' if a ghost is idle for 15 seconds, cpu takes over.
	
	'' draw screen
	Screenlock
		color ,rgb(0,0,0) ',rgb(0,180,220)'	
		cls
		drawmap()
	Screenunlock
	''
	clrtxt()
	txt(0)="Level "+str(level)+"."+str(curmap)
	txt(1)="Get Ready!"
		
	infobox("")
	
	'infobox("Level "+str(level))


	do
		FSOUND_Update
		
		'' display the map, score is the number of dots still on screen
		score=drawmap()
		
		'' add frut to the map
		if (int(rnd*1000)=5) then
			addfruit()
		end if
		
		''draw ghost
		for i=0 to 3
		
			if ghost(i).active=0 then continue for
			
			with ghost(i)
			
			if pacman.super=0 then
				put ((.x*32)+.ox,(.y*32)+.oy),ghost_spr(i),trans
			else
				put ((.x*32)+.ox,(.y*32)+.oy),ghost_spr(i+5),trans
			end if
			
			''
			'' if stopped, cpu player looks for a direction
			''
			if .active=2 then	
				if (.xdir=0 and .ydir=0) then
					ghost_dir(.x,.y,.xdir,.ydir)		
				end if	
			end if
			
			''
			'' hit a wall
			''
			if (col(.x+.xdir,.y+.ydir)=1) then
					.xdir=0
					.ydir=0
				else
					.ox+=(.xdir*.speed)
					.oy+=(.ydir*.speed)
					
					'' see if we are at a junction point
					if abs(.ox)>=32 or abs(.oy)>=32 then
					
						.x+=.xdir
						.y+=.ydir
						.ox=0
						.oy=0
						
						
						if .active=2 then
						
						if .xdir=0 then
						'' move up and down
							if col(.x+1,.y)<>1 or col(.x-1,.y)<>1 then
								.xdir=0
								.ydir=0
							end if
						end if
						
						if .ydir=0 then	
						'' must be moving left or right
							if col(.x,.y+1)<>1 or col(.x,.y-1)<>1 then
								.xdir=0
								.ydir=0
							end if	
						end if
						
						end if
					end if
			end if
			
			
			end with
		next i
		
		'' pac movement
		with pacman
		
			''at the start so we need to pick a direction to begin with
			if (.xdir=0 and .ydir=0) then
				pacman_dir(.x,.y,.xdir,.ydir)		
			end if
		
			''pick a direction on each 'square'
			if (.ox=0 and .oy=0) then
				pacman_dir(.x,.y,.xdir,.ydir)		
			end if
		
		
			if .super>0 then
				'' super ghost eating pacman
				'put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(2),trans
				
				if .xdir=1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(10+.alt),trans
				if .xdir=-1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(12+.alt),trans
				if .ydir=-1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(14+.alt),trans
				if .ydir=1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(16+.alt),trans
			
				
			else
				'' regular pacman
				if .xdir=1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(0+.alt),trans
				if .xdir=-1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(2+.alt),trans
				if .ydir=-1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(4+.alt),trans
				if .ydir=1 then put ((.x*32)+.ox,(.y*32)+.oy),pac_spr(6+.alt),trans
				
				
			end if
			
			if .sc=8 then
				.alt=1-.alt
				.sc=0
			else
				.sc+=1
			end if
			
		
			
			''
			'' Check for colliding with walls
			''
			if (col(.x+.xdir,.y+.ydir)=1) then
				.xdir=0
				.ydir=0
			else
				.ox+=(.xdir*2)
				.oy+=(.ydir*2)
				
				if abs(.ox)=32 or abs(.oy)=32 then
				.ox=0
				.oy=0
				.x+=.xdir
				.y+=.ydir
				
				'' if moving and there is an entrance, stop
				if .xdir=0 then
				'' move up and down
					if col(.x+1,.y)<>1 or col(.x-1,.y)<>1 then
				'		.xdir=0
				'		.ydir=0
					end if
				end if
				
				if .ydir=0 then	
				'' must be moving left or right
					if col(.x,.y+1)<>1 or col(.x,.y-1)<>1 then
				'		.xdir=0
				'		.ydir=0
					end if	
				end if
				''
				
				
				end if
				
				
			end if
		
			'' regular dot
			if map(.x,.y)=2 then
				map(.x,.y)=0 
				.ydots+=1	'' used for fun stats
				
				if (.x<=12) then 
				''left bloop
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
				else
				'' right bloop (or vice versa..)
				FSOUND_PlaySound(FSOUND_FREE, sample(1))
				end if
				
				
			end if
			
			'' super dot
			if map(.x,.y)=3 then
				map(.x,.y)=0 
				.super+=(supertime*FPS)
				.rdots+=1	'' used for fun stats
				
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
				
				'if (.x<=12) then 
				'FSOUND_PlaySound(FSOUND_FREE, sample(0))
				'else
				'FSOUND_PlaySound(FSOUND_FREE, sample(1))
				'end if
			end if
		
			'' fruit
			if map(.x,.y)>=11 and map(.x,.y)<=14 then
				map(.x,.y)=0 
				bonus+=50
				.fruit+=1	'' used for fun stats
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
		
		
		
		end with
		
		''
		'' Check the keys
		''
		
		if  (MultiKey(SC_1)) then ghostcon=set_ghostcon(0):showplayer=5*FPS
		if  (MultiKey(SC_2)) then ghostcon=set_ghostcon(1):showplayer=5*FPS
		if  (MultiKey(SC_3)) then ghostcon=set_ghostcon(2):showplayer=5*FPS
		if  (MultiKey(SC_4)) then ghostcon=set_ghostcon(3):showplayer=5*FPS
				
		if  (MultiKey(SC_P)) then
		
			''
			'' draw ghosts
			
			draw string (100,-4),"HELP: ",,arial24y
			
			for i=0 to 3
			
				if ghost(i).active>0 then
					draw string (200+(i*100),-4),str(i+1)+" = ",,arial24y			
					put (200+(i*100)+50,0),ghost_spr(i),trans
				end if
			next i
			
			''
		
			txt(0)="Game Paused!"
			'txt(1)=""
		
			txt(1)="Level Score: "+str(score-bonus)
			txt(2)="Total Score: "+str(totalscore)
	
		
		
			infobox("")
		
		 
		end if		
		
		with ghost(ghostcon)		
			'if .xdir=0 and .ydir=0 then
			if .ox=0 and .oy=0 then
			
				if  (MultiKey(SC_LEFT)) and col(.x-1,.y)=0 then
					.ydir=0
					.xdir=-1
				end if
				
				if  (MultiKey(SC_RIGHT)) and col(.x+1,.y)=0 then	
					.ydir=0	
					.xdir=1
				end if	
				
				if  (MultiKey(SC_UP)) and col(.x,.y-1)=0 then
					.xdir=0	
					.ydir=-1
				end if
				
				if  (MultiKey(SC_DOWN)) and col(.x,.y+1)=0 then
					.xdir=0		
					.ydir=1
				end if	
			end if	
		end with
		''
		'' If the player has not moved in a while then the computer
		'' takes over. Prevents the player just sitting on a dot.
		''
		
		if ghost(ghostcon).ydir=0 and ghost(ghostcon).xdir=0 then
			ghostsleep-=1	
		else
			ghostsleep=(15*FPS)
		end if
		
		if ghostsleep=0 then
			ghost(ghostcon).active=2
			ghost(ghostcon).speed=1
		end if
		
		'' check for collisions
		for g=0 to 3
		
			if ghost(g).active=0 then continue for
					
			with ghost(g)	
				if (collide((.x*32)+.ox,(.y*32)+.oy,(pacman.x*32)+pacman.ox,(pacman.y*32)+pacman.oy)>0) then
				 
				 	'' ghost eaten...
					if pacman.super>0 and ghost(g).active>0 then
						 ghost(g).active=0
						 ghost(g).eatenbypac+=1
						 FSOUND_PlaySound(FSOUND_FREE, sample(2))
						 ''players ghost
						 if (g=ghostcon) then
						 	ghostcon=set_nextghost()
						 	showplayer=5*FPS
						 end if
			 		end if
					 
					 '' pacman eaten!
					 if pacman.super=0 then
						ghost(g).atepac+=1				 
					 	lives-=1
						if lives>0 then
						 	resetplaces()
						 	ghostcon=set_nextghost()
						 	'
							'' infobox("Get Ready!")
							clrtxt()
							txt(0)="Pacman now has"
							
							if (lives>1) then
								txt(1)=str(lives)+" lives remaining!"
							else
								txt(1)=str(lives)+" life remaining!"
							end if
							 
							infobox("")
							 
							 
					 	end if
					 end if
					  
				
				end if
			end with
		
		
		next g 
		
		if showplayer>0 then
			''put an arrow above players ghost
			with ghost(ghostcon)
			put ((.x*32)+.ox, (.y*32)+.oy-32),arrow,trans
			end with
			showplayer-=1
		end if
		
		if pacman.super>0 then pacman.super-=1
		
		''
		'' TOP DISPLAY
		''
		color rgb(255,0,255)
		draw string (130,-4),"SCORE: "+str(score-bonus),,arial24y
		draw string (400,-4),"TOTAL: "+str(totalscore),,arial24y
	
		for i=0 to (lives-1)
			
			put ((i*32),0),pac_spr(0),trans
			'draw string (0,0),str(pacman.seen)
			
		next i
	
	
		''draw ghost row and selection
		color rgb(255,255,255)
		for i=0 to 3
			if ghost(i).active>0 then
				put (swidth-(4*32)+(i*32),0),ghost_spr(i),trans
				
				#if DEBUG=1
				'	if ghost(i).seen>0 then 
						draw string (swidth-(4*32)+(i*32),0),str(ghost(i).seen)
				'	end if
				
					draw string (swidth-(4*32)+(i*32),20),str(ghost(i).x)+","+str(ghost(i).y)
				#endif
			else
				put (swidth-(4*32)+(i*32),0),ghost_spr(4),trans
					
			end if
		next i
	

	
		'' Screenshot
		if inkey="s" then
		        bsave "screen.bmp",0
		end if
	
		
		'' Game timer
		'sleep (1000/FPS),1

		
		
		''if Timer < (start + oneFrame) Then Sleep ((start + oneFrame) - Timer)* 1000
			
		'' if pacman has lost his live - you win!
		if lives=0 then ext=1
		
		'' no dots = you lose
		if dotcount=0 then ext=2
		
		'' no ghosts = you lose..
		if active_ghosts()=0 then ext=3
	
		if multikey(SC_ESCAPE) then
			
			clrtxt()
			txt(0)="Are you sure"
			txt(1)="you want to quit?"
	
			if yesno("")=1 then
				ext=4
				lives=0
			end if
		
		end if
		
		''' ---------- TIMER ---------
	

		#if DEBUG=2
			Locate 10, 1          
			av+=realfps
			av=av/2                       '
			
			if int(realfps)<minf then minf=int(realfps)
			if int(realfps)>maxf then maxf=int(realfps)
				
			color rgb(255,255,255)
			print ""
			print "target : "+str(FPS)
			print "actual : ";int(realfps)
			print "average: ";int(av)
			print "min: ";minf
			print "max: ";maxf	
			'print "speed: ";fcmax	
			
		#endif
		
		screencopy
		
		'' Frame rate control 
		if Timer < (start + oneFrame) Then Sleep ((start + oneFrame) - Timer)* 1000,1	
		realfps = 1 / (Timer-start)
		start=timer
		''' ---------- TIMER ---------	
		
		
		

	

		
	loop while ext=0
	
	clrtxt()
	
	if ext=1 then
	
		txt(0)="Pac Man has lost all of his lives!"
		txt(1)="Well Done!"
	
		infobox("")
		totalscore+=(score-bonus)
		
		''
			
		curmap+=1
				
		if curmap>MAPS then
			curmap=1
			level+=1
			if supertime<30 then supertime+=5
		end if
		
		
		'if level>MAXLEVELS then
		'	infobox("You have completed all the levels!")
		'	ext=5
		'else
		'	infobox("Get Read for level "+str(level)+"!")
		'end if
				
	end if
	
	if ext=2 then
		txt(0)="Pac Man collected all the dots!"
		txt(1)="Final Score : "+str(totalscore)
		infobox("")
	end if
	
	if ext=3 then		
		txt(0)="All of your ghosts were eaten!"
		txt(1)="Final Score : "+str(totalscore)
		infobox("")
	end if
	
	if ext=4 then
		txt(0)="Player Quits!"
		txt(1)="Final Score : "+str(totalscore)
		infobox("")
	end if

	if ext=5 then
		'' player comleted all levels..
	end if


loop while ext=1 

	''
	'' Players score does not count if they quit (seeing as score starts high)
	''
	'if ext<>4 then
	addname(totalscore)
		'infobox("Final Score: "+str(totalscore))
		'if totalscore>hiscore then hiscore=totalscore
	'end if
	

	
loop

