'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''
'' User Interface Dialogs
''

#include "header.bi"

common shared ui_modes() As mybutton

''
declare sub player_qdraw(x as integer,y as integer)
declare sub enemy_qdraw(x as integer,y as integer,s as integer)

declare sub ui_mousewait()

const as integer swidth=640,sheight=480-128

sub ui_init()
	dim as integer w
	
	w=int(swidth/6)
	
	ui_modes(0).txt="1:Roll"
	ui_modes(1).txt="2:Scan"
	ui_modes(2).txt="3:Move"
	ui_modes(3).txt="4:Attack"
	ui_modes(4).txt="5:Teleport"
	ui_modes(5).txt="6:Done"
	
'	draw string(0,380),"MX:"+str(mx)+" MY:"+str(my)
		
	for i as integer=0 to ubound(ui_modes)
		ui_modes(i).state=1
		ui_modes(i).x=i*w '128
		ui_modes(i).y=480-128
		
		'' As 640 does not divide by 6 equally, make the last button bigger...
		if i=ubound(ui_modes) then
		w=swidth-(5*w)
		end if
		
		ui_modes(i).w=w-1'	127	
		ui_modes(i).h=32
	next i
end sub

sub ui_window(x as integer,y as integer,w as integer,h as integer,title as string)
	color rgb(0,0,0)
	line (x,y)-(x+w,y+h),,bf
	
	color rgb(255,0,0)
	line (x,y)-(x+w,y+h),,b	
	line (x,y+16)-(x+w,y+16)
	
	color rgb(255,200,0)
	draw string(x+2,y+1),title
	
end sub


sub ui_twindow(x as integer,y as integer,w as integer,h as integer,title as string)

'' Transparent window 
	Dim As Integer we, he, bypp, pitch
	Dim buffer As any Ptr = ScreenPtr()

	dim as integer i,j,ps
	ScreenInfo we, he, , bypp, pitch

	Dim As Ubyte Ptr pixel = buffer

	for j=0 to h
	for i=0 to (w*4)-1
		ps=(y+j)*(pitch)+(x*4)+i
		pixel[ps]=pixel[ps] shr 1
	next i
	next j
	
	color rgb(255,0,0)
	line (x,y)-(x+w,y+h),,b	
	
	color rgb(255,200,0)
	draw string(x+2,y+1),title
	
end sub


sub ui_button(x as integer,y as integer,w as integer,h as integer,txt as string,over as integer,hover as integer,hi as integer)
	color rgb(0,0,0)
	line (x,y)-(x+w,y+h),,bf
		
	select case as const over
	case 0:
		color rgb(64,64,64)	'' Not available
		
	
	case 1:
		color rgb(0,200,255)	'' Available
		
		if hover=1 then 
		'	color rgb(255,255,200)
		'	line (x,y)-(x+w,y+h),,bf
		''	
			color rgb(255,200,0)	'' Available
		end if
		
		if hi=1 then 
			color rgb(255,200,0)
			line (x+1,y+1)-(x+w-1,y+h-1),,b
		end if
		
	end select

	line (x,y)-(x+w,y+h),,b
	line (x+1,y+1)-(x+w-1,y+h-1),,b
	
	draw string(16+x,y+9),txt
	
	color rgb(0,0,0)
	pset (x,y)
	pset (x+w,y)
	pset (x,y+h)
	pset (x+w,y+h)
	
end sub

sub ui_diceroll(num as integer)
	dim as string txt(20)
	
	const as integer aw=352
	const as integer ah=192
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
	

	ui_window(ax,ay,aw,ah,"Dice Roll")
	
	color rgb(255,255,255)
	txt(0)="You rolled a "+str(num)
	txt(1)=""
	txt(2)="With these "+str(num)+" action point(s), you can"
	txt(3)="either MOVE around or ATTACK the enemy."
	txt(4)=""
	txt(5)="You can SCAN objects / creatures without "
	txt(6)="any action points. When you have used all"
	txt(7)="of your action points, click on DONE."
	
	color rgb(255,200,0)
	for i as integer =0 to 1
		draw string(16+ax,8+ay+18+(i*14)),txt(i)
	next i	
	
	draw string(ax+16,ay+ah-16),"Click to continue!"
	
	color rgb(255,255,255)
	for i as integer =2 to 7
		draw string(16+ax,8+ay+18+(i*14)),txt(i)
	next i	
	
'	ui_mousewait()
	
end sub




sub ui_info(item as integer)
	dim as string txt(20) 

	const as integer aw=352
	const as integer ah=240
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
	
	
	dim as integer i,sx,sy,l

	ui_window(ax,ay,aw,ah,"Information Scan #"+str(item))
		
	for i=0 to ubound(txt)
		txt(i)=""
	next i	
		
	if item=13 or item=33 then item=3	'' Barrier
	if item=15 or item=25 or item=35 then item=5	'' Beacon Off
	if item=16 or item=26 or item=36 then item=6	'' Beacon On
	if item=17 or item=27 or item=37 then item=7	'' Computer
		
	
	if item=18 then item=8	'' tree	
		
		
	select case as const item
	case 0
	case 1
		txt(0)="Ship Wall"
		txt(1)="========="
		txt(2)="Not very interesting..."
	case 2
		txt(0)="Ship Floor"
		txt(1)="=========="
		txt(2)="Not very interesting, best get"
		txt(3)="on with the task of saving people.."
		
	
	case 8
		txt(0)="Tree"
		txt(1)="===="
		txt(2)="One of many fine trees!"
	
	case 11
		txt(0)="Tree.."
	case 12
		txt(0)="Grass.."
	
		
	case 3
		txt(0)="Barrier"
		txt(1)="======="
		txt(2)="Find a computer terminal to "
		txt(3)="shut down these barriers."
		txt(4)=""
	
	case 4
	
	case 5
		txt(0)="Teleport Beacon (Off)"
		txt(1)="====================="
		txt(2)="Stand next to this beacon and then"
		txt(3)="SCAN it to activate."
		txt(4)=""
		txt(5)="When activated and with access to"
		txt(6)="a teleport device, you can jump "
		txt(7)="directly to this point."
	
	case 6
		txt(0)="Teleport Beacon (On)"
		txt(1)="===================="
		txt(2)="Using your teleporter, you can now"
		txt(3)="jump directly to this point!"
		txt(4)=""
		
	case 7
		txt(0)="Computer Terminal"
		txt(1)="================="
		txt(2)="Stand in front of this console"
		txt(3)="and SCAN it to use."
		txt(4)=""
		txt(5)="Terminals like this are used"
		txt(6)="to deactivate barriers and"
		txt(7)="open doors"
		txt(8)=""
		txt(9)="They are usually encrypted."
	
	case 21
		txt(0)="Solid Rock"
		txt(1)="=========="
		txt(2)="Solid volcanic rock..."
	
	case 28
		txt(0)="Lava!"
		txt(1)="====="
		txt(2)="Extremely hot molten rock!"
		txt(3)=""
		txt(4)="You cannot walk on it, maybe you"
		txt(5)="can find something that will help?"
		
	case 38
		txt(0)="Solid Ice Block"
		txt(1)="==============="
		txt(2)="Very hard block of ice..."
		
	case 100
		txt(0)="Space Jelly Fish"
		txt(1)="================"
		txt(2)="Cloned from native lifeforms and modified"
		txt(3)="for land by the Enemy. Slow and weak but"
		txt(4)="can be trouble in swarms."
		txt(5)=""
		txt(6)=" Movement   : Up,Down,Left,Right"
		txt(7)=" Speed      : 1"
		txt(8)=" Health     : /1"
		
	case 101
		txt(0)="Space Aliens"
		txt(1)="============"
		txt(2)="Standard Enemy troopers, quick and"
		txt(3)="dangerous."
		txt(4)=""
		txt(5)=" Movement   : All directions"
		txt(6)=" Speed      : 1"
		txt(7)=" Health     : /2"
	
	case 102
		txt(0)="Elite Aliens"
		txt(1)="============"
		txt(2)="Enhanced troopers, faster and"
		txt(3)="stronger than standard troopers!"
		txt(4)=""
		txt(5)=" Movement   : All directions"
		txt(6)=" Speed      : 2"
		txt(7)=" Health     : /3"
	
	
	case 200
		txt(0)="Teleporting"
		txt(1)="============"
		txt(2)="Rolling an 8 or higher means you"
		txt(3)="can access your ships teleporter."
		txt(4)=""
		txt(5)="It allows you to jump directly to"
		txt(6)="either your ship or an active"
		txt(7)="teleport beacon."
		txt(8)=""
		txt(9)="It does use all of your points though."
	
	case 1002
		txt(0)="Civilian"
		txt(1)="========"
		txt(2)="One of this planets natives in need"
		txt(3)="of rescue!"
		txt(4)=""
		txt(5)="To save them, you just need to walk"
		txt(6)="up to them and they will be tagged"
		txt(7)="and teleported to safety!"		
	
	case 1003
		txt(0)="Ice Weapon Upgrade"
		txt(1)="=================="
		txt(2)="Doubles your attack points"
		txt(3)="and can freeze lava allowing"
		txt(4)="you to access more areas!"
		txt(5)=""
	
	case 1004
		txt(0)="Movement Upgrade"
		txt(1)="=================="
		txt(2)="Allows you to move diagonally!"
		txt(3)=""
		
	case 1005
		txt(0)="Health"
		txt(1)="======"
		txt(2)="Restores 1 unit of health!"
		txt(3)=""
	
	end select
	
	sx=16+ax
	sy=8+ay+18
	
	color rgb(0,200,0)
	draw string(sx,sy),txt(0)
		
	for i as integer =1 to ubound(txt)
		if left(txt(i),1)="=" then
			color rgb(0,200,0)
			l=len(txt(i-1))*8
			line(sx,sy+13)-(sx+l,sy+13)
			line(sx,sy+15)-(sx+l,sy+15)
		else
			color rgb(255,255,255)
			draw string(sx,sy+(i*14)),txt(i)
		end if
	next i
	
	color rgb(255,200,0)
	draw string(sx,ay+ah-16),"Click to continue!"
	
end sub


sub ui_collected(item as integer)
	if item=5 then return	'' No point as is health upgrade...
	
	dim as string txt(10) 

	const as integer aw=352
	const as integer ah=240
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
	
	dim as integer sx,sy,l
	
	ui_window(ax,ay,aw,ah,"Item Collected! ") '+str(item))
		
	for i as integer=0 to ubound(txt)
		txt(i)=""
	next i

	select case as const item
	case 1
		txt(0)="Magic Orb!"
		txt(1)="=========="
		txt(2)="You have collected one of the orbs!"
		
	case 2:	
		txt(0)="Rescued a civilian!"
		txt(1)="==================="
		txt(2)="This person was teleported to safety!"
		
	case 3:	
		txt(0)="Ice Weapon Upgrade"
		txt(1)="=================="
		txt(2)="Switch to ATTACK and click on lava,"
		txt(3)="this will freeze the lava enabling"
		txt(4)="You to walk across it."
		txt(5)=""
		txt(6)="Attacks now deal 2 amounts of damage."
	
	case 4:	
		txt(0)="Movement Upgrade"
		txt(1)="=================="
		txt(2)="You can now move diagonally!"
		txt(3)=""
		txt(4)="This means you can travel quickly"
		txt(5)="and get to previously inaccessable"
		txt(6)="area"
		txt(7)=""
		txt(8)="Numpad keys (7,9,1,3) can be used"
		txt(9)="to move diagonally"
	
		
	end select
	
	
	'''
	sx=16+ax
	sy=8+ay+18
	
	color rgb(0,200,0)
	draw string(sx,sy),txt(0)
		
	for i as integer =1 to ubound(txt)
		if left(txt(i),1)="=" then
			color rgb(0,200,0)
			l=len(txt(i-1))*8
			line(sx,sy+13)-(sx+l,sy+13)
			line(sx,sy+15)-(sx+l,sy+15)
		else
			color rgb(255,255,255)
			draw string(sx,sy+(i*14)),txt(i)
		end if
	next i
	''	

	color rgb(255,200,0)
	draw string(ax+16,ay+ah-16),"Click to continue!"
	
'	ui_mousewait()
end sub


sub ui_hover(x as const integer,y as const integer,item as const integer)
	dim as integer ax,ay

	ax=(x*32)+16
	ay=(y*32)+16

	dim as string obj(50),alien(5),bonus(5),txt="???"
		
	obj(0)="Grass"
	obj(1)="Wall"
	obj(2)="Floor"
	obj(3)="Force Barrier"
	obj(4)="???"
	obj(5)="Beacon (Off)"
	obj(6)="Beacon (On)"
	obj(7)="Computer Console"
	obj(8)="Tree"
	
	obj(10)="Grass"
	obj(11)="Wall"
	obj(12)="Floor"
	obj(13)="Force Barrier"
	obj(14)="???"
	obj(15)="Beacon (Off)"
	obj(16)="Beacon (On)"
	obj(17)="Computer Console"
	obj(18)="Tree"
	
	obj(21)="Solid Rock"
	obj(22)="Rock path"
	obj(23)="Boulder"
	obj(24)="???"
	obj(25)="Beacon (Off)"
	obj(26)="Beacon (On)"
	obj(27)="Computer Console"
	obj(28)="Lava!"
	
	obj(31)="Solid Ice Block"
	obj(32)="Icy path"
	obj(33)="Force Barrier"
	obj(34)="???"
	obj(35)="Beacon (Off)"
	obj(36)="Beacon (On)"
	obj(37)="Computer Console"
	obj(38)="Solid Ice Block"
	
	
	alien(0)="Space Jelly"
	alien(1)="Space Alien"
	alien(2)="Elite Alien"
	
	bonus(0)="Unknown"
	bonus(1)="Crystal"
	bonus(2)="Civilian"
	bonus(3)="Ice Weapon Upgrade"
	bonus(4)="Movement Upgrade"
	bonus(5)="Health"
	
	if (item<100) then
	
		if item<ubound(obj) then
			txt=obj(item)+" " '+str(item)
		else
			txt="Unknown object ("+str(item)+")..."
		end if
	
	else
		if (item>1000) then
			txt=bonus(item-1000) ' +" "+str(item)
		else	
			txt=alien(item-100) '+" "+str(item)
		end if
	end if

	if (ax+192)>swidth then ax=swidth-192
	if (ay+32)>352 then ay=352-32
	
	ui_twindow(ax,ay,192,32,txt)

	color rgb(255,255,255)
	draw string(ax+2,ay+16),"Click for more info.."
end sub

sub ui_enemyhover(x as integer,y as integer,tmp_enemy as myenemy)
	dim as integer ax,ay

	ax=(x*32)+16
	ay=(y*32)+16

	if (ax+192)>swidth then ax=swidth-192
	if (ay+48)>352 then ay=352-48

	ui_twindow(ax,ay,192,48,tmp_enemy.txt)

	color rgb(255,255,255)
	draw string(ax+2,ay+16),"Health:"+str(tmp_enemy.h)
	draw string(ax+2,ay+32),"Click to attack!"
	
end sub


sub ui_command(mx as integer,my as integer,mo as integer)
	dim as integer x,y,hi=-1

'	draw string(0,380),"MX:"+str(mx)+" MY:"+str(my)
	
	for i as integer=0 to ubound(ui_modes)
		x=ui_modes(i).x
		y=ui_modes(i).y
		
		ui_modes(i).hover=0
		
		if mx>x and mx<(x+ui_modes(i).w) then
			if my>y and my<y+32 then
				ui_modes(i).hover=1
				
			end if		
		end if
		
		hi=-1
		if i=1 and mo=MODE_SCAN then hi=1
		if i=2 and mo=MODE_MOVE then hi=1
		if i=3 and mo=MODE_TARGET then hi=1
		
		with ui_modes(i)
		ui_button(.x,.y,.w,.h,.txt,.state,.hover,hi)
		end with
	next i

	''
	color rgb(255,0,0)
	
	line (0,352+32+2)-(640-1,480-1),,b
	line (0+1,352+32+2+1)-(640-2,480-2),,b
	
	line (600,352+32+2)-(601,480),,b
	

end sub

function ui_command_hit(mx as const integer,my as const integer) as integer
	dim as integer x,y
	
	for i as integer=0 to ubound(ui_modes)
		x=ui_modes(i).x
		y=ui_modes(i).y
		
		if mx>x and mx<x+ui_modes(i).w then
			if my>y and my<y+32 then
			
				'' Is the button active?
				if ui_modes(i).state=1 then return i
			
			end if		
		end if
		
	next i
	return -1
end function

sub ui_warning(txt as string)

	const as integer aw=340
	const as integer ah=128
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
		
	ui_window(ax,ay,aw,ah,"Attention!")
	
	color rgb(255,255,255)
	draw string(ax+16,ay+ah-64),txt
	
	color rgb(255,200,0)
	draw string(ax+16,ay+ah-32),"Click to continue!"
	
	ui_mousewait() 
end sub


function ui_yesno(txt as string) as integer

	dim as integer m,mx,my,mb,leftdown,over,hover,prev
	dim as integer i,ext
	dim as integer opt=1	'' default to No
	
	dim key as mykeys
	
	const as integer aw=240
	const as integer ah=96
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
		
	dim but(2) as mybutton
	
	with but(0)
		.txt="Yes"
		.state=1
		.x=ax+16
		.y=ay+ah-32-8
		.w=64	
		.h=32
	end with
	
	with but(1)
		.txt="No"
		.state=1
		.w=64	
		.h=32
		.x=ax+aw-16-.w
		.y=ay+ah-32-8
		
	end with

	
	''
	do
	m = GetMouse (mx, my, , mb)
	
	screenlock
		ui_window(ax,ay,aw,ah,"Confirmation")
	
		color rgb(255,255,255)
		draw string(ax+16,ay+ah-64),txt
	
		''
		'' Buttons
		''
		prev=over
		over=-1
		for i=0 to ubound(but)
			with but(i)
				hover=0	
				if my>.y and my<.y+.h then	
					if mx>.x and mx<.x+.w then
						hover=1
						over=i
						if over>-1 and over<>prev then
							opt=i
						end if
					end if
				end if
				
				hover=0
				
				if i=opt then hover=1
				ui_button(.x,.y,.w,.h,.txt,1,hover,0)
				
			end with
		next i
		
		''
		'' Keyboard Yes <> No
		''
		if MultiKey(SC_RIGHT) and key.r=0  then key.r=1:opt=1	
		if MultiKey(SC_RIGHT)=0 and key.r=1 then key.r=0
		
		if MultiKey(SC_LEFT) and key.l=0  then key.l=1:opt=0
		if MultiKey(SC_LEFT)=0 and key.l=1 then key.l=0

		if MultiKey(SC_Y) and key.y=0  then key.y=1:opt=0:ext=1	
		if MultiKey(SC_Y)=0 and key.y=1 then key.y=0
		
		if MultiKey(SC_N) and key.n=0  then key.n=1:opt=1:ext=1
		if MultiKey(SC_N)=0 and key.n=1 then key.n=0
			
		'' Space / Enter react to a key UP otherwise it would probably hold for the next menu...
		if  MultiKey(SC_SPACE) and key.space=0 then key.space=1
			
		if MultiKey(SC_SPACE)=0 and key.space=1 then
			key.space=0
			ext=1
		end if
		
		if  MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then
			key.enter=0
			ext=1
		end if
		''
		'' Click
		''
		
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				if over>-1 then ext=1
			end if
		end if
		
	screenunlock
	loop while ext=0
	
	'' Clear keyboard buffer
	While Inkey <> "": Wend	
	
	if opt=0 then return 1
	
	return 0
	'ui_mousewait() 
end function


sub ui_welldone()
	dim as string txt(10) 

	const as integer aw=340
	const as integer ah=128
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
	dim as integer sx,sy,l
		
	txt(0)="Congratulations!"
	txt(1)="================"
	txt(2)="Everyone has been rescued and the"
	txt(3)="invaders have been defeated."
	txt(4)="All thanks to your hard work!"	
		
	ui_window(ax,ay,aw,ah,"Well Done!")
		
	'''
	sx=16+ax
	sy=8+ay+18
	
	color rgb(0,200,0)
	draw string(sx,sy),txt(0)
		
	for i as integer =1 to ubound(txt)
		if left(txt(i),1)="=" then
			color rgb(0,200,0)
			l=len(txt(i-1))*8
			line(sx,sy+13)-(sx+l,sy+13)
			line(sx,sy+15)-(sx+l,sy+15)
		else
			color rgb(255,255,255)
			draw string(sx,sy+(i*14)),txt(i)
		end if
	next i
	''	
	
	color rgb(255,200,0)
	draw string(ax+16,ay+ah-16),"Click to continue!"
	
	ui_mousewait() 
end sub

'' Red failed background!

sub ui_red()
	'' 
	Dim As Integer we, he, bypp, pitch
	Dim buffer As any Ptr = ScreenPtr()

	dim as integer i,j,ps
	ScreenInfo we, he, , bypp, pitch

	Dim As Ubyte Ptr pixel = buffer

	dim as ubyte red

	for j=0 to 352-1
	for i=0 to (640*4)-1 step 4
		ps=(j*pitch)+i
			
		red=(pixel[ps]+pixel[ps+1]+pixel[ps+2])/3	
			
		pixel[ps]=0
		pixel[ps+1]=0
		pixel[ps+2]=red
		
	next i
	next j
	
end sub

sub ui_defeated()
	dim as string txt(10) 

	const as integer aw=320
	const as integer ah=128
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
	dim as integer sx,sy,l
		
	txt(0)="Mission Failed!"
	txt(1)="==============="
	txt(2)="You did not defeat the enemy"
	txt(3)="invaders this time..."
	txt(4)=""	
		
	ui_window(ax,ay,aw,ah,"Game Over!")
		
	'''
	sx=16+ax
	sy=8+ay+18
	
	color rgb(0,200,0)
	draw string(sx,sy),txt(0)
		
	for i as integer =1 to ubound(txt)
		if left(txt(i),1)="=" then
			color rgb(0,200,0)
			l=len(txt(i-1))*8
			line(sx,sy+13)-(sx+l,sy+13)
			line(sx,sy+15)-(sx+l,sy+15)
		else
			color rgb(255,255,255)
			draw string(sx,sy+(i*14)),txt(i)
		end if
	next i
	''	
	
	color rgb(255,200,0)
	draw string(ax+16,ay+ah-16),"Click to continue!"
	
	ui_mousewait() 
end sub


sub ui_guage(x as integer,y as integer,num as integer,max as integer,txt as string)
	dim i as integer

	color rgb(255,255,255)
	draw string(x-80,y+1),txt

	color rgb(50,50,50)
	for i=0 to max-1
		Line (x+(i*16),y)-(x+(i*16)+14,y+14),,bf
	next i
	
	color rgb(255,200,0)
	for i=0 to num-1
		Line (x+(i*16),y)-(x+(i*16)+14,y+14),,bf
	next i
end sub

sub ui_mousewait()
	dim as integer i,m,mx,my,mb
	dim as integer leftdown
	dim as integer ext=0
'	dim as string k
	dim key as mykeys
	
	'' Clear keyboard buffer
	While Inkey <> "": Wend	
	
	do	
		m = GetMouse (mx, my, , mb)
	
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				ext=1
			end if
		end if
		
		'' Keys!
		'' Space / Enter react to a key UP otherwise it would probably hold for the next menu...
		if  MultiKey(SC_SPACE) and key.space=0 then key.space=1
			
		if MultiKey(SC_SPACE)=0 and key.space=1 then
			key.space=0
			ext=1
		end if
		
		if  MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then
			key.enter=0
			ext=1
		end if
		
		sleep 10,1
	loop while ext=0
	
	'' Clear keyboard buffer
	While Inkey <> "": Wend	
end sub

