'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''
'' Title / Intro screens...
''
#include "header.bi"
#include "fmod.bi"

common shared sample() As Integer	'' sounds...

'' So we can set the difficulty
common shared player as myplayer

''
'' Fonts
''

common shared comic12w as any ptr

declare sub font_color(as integer,as integer,as integer)
declare sub font_centre(as integer,as string)
declare sub font_show(as integer, as integer,as string)	

''
''


declare sub explosion_draw()
declare sub explosion_add(x as integer, y as integer,d as integer)
''
declare sub ui_warning(txt as string)
declare sub ui_mousewait()
declare sub ui_window(x as integer,y as integer,w as integer,h as integer,title as string)
declare sub ui_button(x as integer,y as integer,w as integer,h as integer,txt as string,over as integer,hover as integer,hi as integer)

declare sub stars_draw()

const as integer swidth=640,sheight=480

dim shared sprite(6) as any ptr

dim shared logo as any ptr

dim shared scrollx as integer

sub title_init()
	const path as string="gfx\"

	sprite(0) = ImageCreate( 128, 64,rgb(100,255,100) )

	for i as integer=1 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	bload path+"intro\ship.bmp",sprite(0)	
	bload path+"intro\grass.bmp",sprite(1)	
	bload path+"intro\tree.bmp",sprite(2)
	bload path+"enemy\jelly.bmp",sprite(3)
	bload path+"enemy\spider.bmp",sprite(4)
	bload path+"enemy\elite.bmp",sprite(5)
	
	''
	logo= ImageCreate( 300, 100,rgb(100,255,100) )
	
	bload path+"logo.bmp",logo
	'''
	scrollx=0
	
	for e as integer=0 to 5
	explosion_add(rnd*640, rnd*(480-128),rnd*100)
	next e
	
end sub

sub title_bg()
	dim as integer i,j
	for j=0 to 14
		for i=-1 to (19+1)
			put (i*32+scrollx,j*32),sprite(0),pset
		next i
	next j
	
	scrollx-=1
	if scrollx<0 then scrollx=31
end sub

sub title()
	dim options(3) as string = { "Start Game - Easy","Start Game - Normal","Start Game - Hard","Quit Game!"}
	
	dim as string txt(20),k
	dim as integer i,ext
	dim as integer m,mx,my,mb,leftdown,over,hover,prev
		
	dim as integer sx,sy,y,cx
	
	dim key as mykeys
	dim as integer opt,done=0
	
	const as integer aw=400 '352
	const as integer ah=400 '192
	
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
		
	txt(0)="The planet Numeria has been invaded!"
	txt(1)=""
	txt(2)="Use your maths ability to defeat the"
	txt(3)="invading forces and rescue the people!"
	txt(4)=""
	txt(5)="Play using the mouse and arrow keys!"
	txt(6)=""
	
			
	ext=0
	
	cls
	do
		FSOUND_Update
		
		m = GetMouse (mx, my, , mb)
			
		screenlock()		
			stars_draw()		
			''
			
			put (170,10),logo,trans
			
			''
			font_color(192,192,192)
			for i as integer =0 to 6
				font_centre(128+(i*18),txt(i))	'32'
			next i	
			
			color rgb(255,200,0)
			
			#if CHEAT=1
				draw string(2,2),"CHEAT MODE ENABLED!"
			#endif
			
			draw string(2,sheight-32),"FBGD June 2014 Competition Entry"
			draw string(2,sheight-16),VERSION
			
			draw string(swidth-150,sheight-16),SITEURL
			
			'' Buttons
			prev=over
			over=-1
			for i=0 to ubound(options)
				sx=ax+16
				sy=ay+(i*48)+216 '160
				
				if mx>sx and mx<sx+aw-32 then
					if my>sy and my<sy+32 then
					
					over=i	
					if over>-1 and over<>prev then
						'' play sound
						opt=over
						FSOUND_PlaySound(FSOUND_FREE, sample(0))
					end if
					
					end if
				end if
				
				''
				hover=0
				if i=opt then 
					hover=1
				endif
				
				ui_button(sx,sy,aw-32,32,options(i),1,hover,0)
					
				y+=64
			next i	
		screenunlock()
				
		if multikey(SC_ESCAPE) then ext=2
		
		
		''
		'' Key controls!
		''
		if  MultiKey(SC_UP) and key.u=0  then
			opt-=1
			if opt<0 then opt=ubound(options)
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			key.u=1
		end if
			
		if MultiKey(SC_UP)=0 and key.u=1 then key.u=0
		
		if  MultiKey(SC_DOWN) and key.d=0  then
			opt+=1
			if opt>ubound(options) then opt=0
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			key.d=1
		end if
			
		if MultiKey(SC_DOWN)=0 and key.d=1 then key.d=0
		
		'' React to a key UP 
		if MultiKey(SC_SPACE) and key.space=0 then key.space=1		
		if MultiKey(SC_SPACE)=0 and key.space=1 then key.space=0:done=1
		
		if MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then key.enter=0:done=1
		''
		''
		''
		
		
		'' Click
		m = GetMouse (mx, my, , mb)
	
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				'ext=1
				if over>-1 then
					opt=over
					done=1
				end if
			end if
		end if
			
			
		if done=1 then
			select case as const opt
			case 0
				'' Play - Easy
				player.difficulty=EASY
				ext=1
			case 1
				'' Play - Normal
				player.difficulty=NORMAL
				ext=1
			case 2
				'' Play - Hard
				player.difficulty=HARD
				ext=1
			case 3
				'' Quit
				ext=2
			
			end select
		end if	
		
		if inkey=chr(255)+"k" then
			ext=2
		end if
		
			
		sleep 10,1

	loop while ext=0

	'' Clear keyboard buffer
	While Inkey <> "": Wend	
						
	FSOUND_PlaySound(FSOUND_FREE, sample(0))

	if ext=2 then
		FSOUND_Close()
		end
	end if

end sub

sub title_intro()
	dim as integer i,j,m,mx,my,mb
	dim as integer leftdown
	dim as integer ext=0
	dim as string txt(5)
	dim as integer shipx=0,shipy=0,sx=0,alienx=0
	dim as integer ct=0,tc=0
	dim key as mykeys
	''
	''
	''
	
	txt(0)="Heading home from a successful mission..."
	txt(1)="...you suddenly pick up a distress call from the planet Numeria!"
	txt(2)="It seems a small invasion force has descended upon them!"
	txt(3)="Time to take a detour..."
	txt(4)=".."
	
	''
	'' Ship in space
	''
	ext=0
	shipx=0
	font_color(0,200,0)
	do
		screenlock
			stars_draw()
			put (shipx,160+shipy),sprite(0),trans
			font_show(2,2,txt(tc))
		screenunlock
	
		ct+=1
		if ct>125 then tc+=1:ct=0
	
		shipx+=1
		if shipx=500 then ext=1
		
		if tc>2 then shipy+=1
		
		'' Space key
		'k=inkey
		'if k=" " then ext=1
		
		'' Space / Enter react to a key UP otherwise it would probably hold for the next menu...
		if  MultiKey(SC_SPACE) and key.space=0 then key.space=1
			
		if MultiKey(SC_SPACE)=0 and key.space=1 then
			key.space=0
			ext=1
		end if
		
		if  MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then
			key.enter=0
			ext=1
		end if
		
		
		'' Mouse
		m = GetMouse (mx, my, , mb)
	
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				ext=1
			end if
		end if
		
		sleep 10,1
	loop while ext=0
		
		
	'' Ship over ground
	txt(0)="Welcome to Numeria!"
	txt(1)="A green and peaceful planet..."
	txt(2)="...now, with some unwanted visitors!"
	txt(3)="Rescue the people! Defeat the invaders!"
	txt(4)=""
	
	tc=0
	ct=0
	shipx=0
	ext=0
	color  rgb(255,255,255),rgb(0,150,255)
	
	font_color(255,255,255)
	do
		screenlock
		
			for j=0 to 20
				'' *32 = shl 5
				'' Blue > Yellow
				line (0,(j*24)) -(640,(j+1)*24),rgb(j*12,j*12,255-(j*12)),bf
			next j
		
			'
			'cls 
			put (shipx,160),sprite(0),trans
		
			for i=-1 to (19+1)
				put (i*32+sx,sheight-64),sprite(2),trans
			
				put (i*32+sx,sheight-32),sprite(1),pset
			next i
		
		
			if tc>=2 then
				put (640+-alienx,sheight-64),sprite(3),trans
				
				put (640+64-alienx,sheight-64),sprite(4),trans
				
				put (640+128-alienx,sheight-64),sprite(5),trans
				
				
				alienx+=1
			end if
			
			font_show(2,2,txt(tc))
		screenunlock
	
		ct+=1
		if ct>125 then tc+=1:ct=0
	
		shipx+=1
	
		sx-=1
		if sx<0 then sx=31
		''
		if shipx=500 then ext=1
		
		'' Space key
		'k=inkey
		'if k=" " then ext=1
		
		'' Space / Enter react to a key UP otherwise it would probably hold for the next menu...
		if  MultiKey(SC_SPACE) and key.space=0 then key.space=1
			
		if MultiKey(SC_SPACE)=0 and key.space=1 then
			key.space=0
			ext=1
		end if
		
		if  MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then
			key.enter=0
			ext=1
		end if
		
		
		'' Mouse
		m = GetMouse (mx, my, , mb)
	
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				ext=1
			end if
		end if
		
		sleep 10,1
	
	loop while ext=0	
	'' Ship landing
	
	color ,rgb(0,0,0)

end sub 

sub title_outro()	
	dim as integer m,mx,my,mb,leftdown
	dim as integer ext
	dim as string k,txt(5)
	dim as integer shipx=0,shipy=sheight-128,sx=0,i
	dim as integer ct=0,tc=0


	txt(0)="Well done! You have saved everyone and defeated the invaders!"
	txt(1)="Well done! You have saved everyone and defeated the invaders!"
	txt(2)="Time to leave this planet and finally head home..."
	txt(3)="...unless you pick up another distress call!"
	txt(4)=""

	ext=0
	cls

	font_color(255,255,255)
	do
		m = GetMouse (mx, my, , mb)
		
		screenlock()
			stars_draw()
			explosion_draw()
			
			put (shipx,shipy),sprite(0),trans
		
			for i=-1 to (19+1)
				put (i*32+sx,(sheight-64)),sprite(2),trans
			
				put (i*32+sx,(sheight-32)),sprite(1),pset
			next i
			
			font_show(2,2,txt(tc))
		screenunlock()
	
		ct+=1
		if ct>125 then tc+=1:ct=0
	
		shipx+=1
		if (shipx MOD 2)=0 then shipy-=1
	
		sx-=1
		if sx<0 then sx=31
		if shipx=500 then ext=1
		''
	
	
		'' Space key
		k=inkey
		if k=" " then ext=1
		
		'' Click
		m = GetMouse (mx, my, , mb)
	
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				ext=1
			end if
		end if
		
		sleep 10,1

	loop while ext=0
	
	dim as integer cx
	
	cls
	

	txt(0)="Thank you for playing!"	
	font_color(255,255,0)
	font_centre(240-8,txt(0))
	
	
	txt(0)="Click to return to the main menu..."
	font_color(128,128,128)
	font_centre(sheight-20,txt(0))
	
	ui_mousewait()
	
	
end sub
