'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''
'' Question / Answer
''
#include "header.bi"
#include "fmod.bi"

common shared player as myplayer	'' difficulty setting...
common shared sample() As Integer	'' sounds...

declare sub player_qdraw(x as integer,y as integer)
declare sub enemy_qdraw(x as integer,y as integer,s as integer)

declare sub ui_button(x as integer,y as integer,w as integer,h as integer,txt as string,over as integer,hover as integer,hi as integer)
declare sub ui_window(x as integer,y as integer,w as integer,h as integer,title as string)
declare sub ui_warning(txt as string)
declare sub ui_mousewait()
declare function ui_yesno(txt as string) as integer

''
const as integer swidth=640,sheight=480-128


function question_attack(tmp_enemy as myenemy) as integer
	dim as integer qt,qa,qb,qc
	dim as integer ax,ay,ext,tmp
	dim as string k,panswer,txt

	dim key as mykeys

	dim as integer ra,rs,re	'' Question ranges

	const as integer aw=352
	const as integer ah=240
	ax=(swidth-aw)/2
	ay=(sheight-ah)/2
	
	qt=int(rnd*4)
	
	ra=tmp_enemy.s
	if player.difficulty=EASY then ra=0	'' Always low range questions
	if player.difficulty=HARD then ra=2	'' Always hard questions
	
	'' Make our question
	select case as const qt
	
	case 0
		if ra=0 then rs=1:re=12
		if ra=1 then rs=12:re=24
		if ra=2 then rs=10:re=100
	
		qa=rs+int(rnd*re)
		qb=rs+int(rnd*re)
		qc=qa+qb
		
		txt=str(qa)+" + "+str(qb)
	
	case 1
		if ra=0 then rs=1:re=12
		if ra=1 then rs=12:re=24
		if ra=2 then rs=10:re=100
	
		qa=rs+int(rnd*re)
		qb=rs+int(rnd*re)
	
		if qb>qa then
			tmp=qa
			qa=qb
			qb=tmp	
		end if
	
		txt=str(qa)+" - "+str(qb)
	
		qc=qa-qb
	case 2
		if ra=0 then rs=1:re=12
		if ra=1 then rs=6:re=15
		if ra=2 then rs=10:re=24
	
		qa=rs+int(rnd*re)
		qb=rs+int(rnd*re)
		
		qc=qa*qb
		txt=str(qa)+" x "+str(qb)
	
	
	case 3
		'' div
		'' a / b = c 
		'' 6 / 2 = 3
		
		qb=1+int(rnd*6)
		qc=1+int(rnd*12)
		qa=qb*qc
		
		txt=str(qa)+" "+chr(246)+" "+str(qb)	'' /
	
	case else
		qa=int(rnd*12)
		qb=int(rnd*12)
		qc=qa+qb
	end select
	
	'' Draw everything
	ext=0
	do
		screenlock
			ui_window(ax,ay,aw,ah,"Player Attacks!") '+str(tmp_enemy.id))
		
			player_qdraw(ax+16,ay+32)
			enemy_qdraw(ax+aw-16-32,ay+32,tmp_enemy.s)
			
			color rgb(255,255,255)
			draw string(ax+16,ay+80),"Get this question correct to hit enemy,"
			draw string(ax+16,ay+96),"an incorrect answer means you miss!"
				
			color rgb(255,200,0)
			draw string(ax+16,ay+128),txt+" = "+panswer
		screenunlock
		'draw string(ax+16,ay+160),panswer
		
		'' Keys!
		k=inkey
		if k>="0" and k<="9" then panswer+=k     
		
		'' Backspace
		if asc(k)=8 then panswer=left(panswer,len(panswer)-1)
	
		'' Enter
		'if asc(k)=13 then ext=1     
		
		if  MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then
			key.enter=0
			ext=1
		end if
		
		
		
		sleep 10,1
	loop until ext=1
	
	'' Clear keyboard buffer
		While Inkey <> "": Wend	
	
	'' Check answer
	
		screenlock
			ui_window(ax,ay,aw,ah,"Player Attacks!")
			
			player_qdraw(ax+16,ay+32)
			enemy_qdraw(ax+aw-16-32,ay+32,tmp_enemy.s)
			
			color rgb(255,255,255)
			draw string(ax+16,ay+80),"Get this question correct to hit enemy,"
			draw string(ax+16,ay+96),"an incorrect answer means you miss!"
				
			color rgb(255,200,0)
			draw string(ax+16,ay+ah-32),"Click to continue!"
		screenunlock
		
		if val(panswer)=qc then
			color rgb(0,200,0)
			draw string(ax+16,ay+128),txt+" = "+panswer
			
			draw string(ax+16,ay+128+32),"Attack hit!"
			ui_mousewait()
		
			return 1
		else
			color rgb(200,0,0)
			draw string(ax+16,ay+128),txt+" = "+panswer
			
			draw string(ax+16,ay+128+32),"Attack missed!"
			draw string(ax+16,ay+128+48),"The correct answer was "+str(qc)
			
			ui_mousewait()
			return 0
		end if	
			
end function

''
'' Defend = Alien attacks Player
''

function question_defend(tmp_enemy as myenemy) as integer
	dim as integer qt,qa,qb,qc
	dim as integer ax,ay,ext,tmp
	dim as string k,panswer,txt
	
	const as integer aw=352
	const as integer ah=240
		dim key as mykeys
	ax=(swidth-aw)/2
	ay=(sheight-ah)/2
	
	dim as integer ra,rs,re	'' Question ranges
	
	qt=int(rnd*4)
	
	
	ra=tmp_enemy.s
	
	if player.difficulty=EASY then ra=0	'' Always low range questions
	if player.difficulty=HARD then ra=2	'' Always hard questions
	
	'' Make our question
	select case as const qt
	
	case 0
		if ra=0 then rs=1:re=12
		if ra=1 then rs=12:re=24
		if ra=2 then rs=10:re=100
	
	
		qa=rs+int(rnd*re)
		qb=rs+int(rnd*re)
		qc=qa+qb
		
		txt=str(qa)+" + "+str(qb)
	
	case 1
		if ra=0 then rs=1:re=12
		if ra=1 then rs=12:re=24
		if ra=2 then rs=10:re=100
	
		qa=rs+int(rnd*re)
		qb=rs+int(rnd*re)
	
		if qb>qa then
			tmp=qa
			qa=qb
			qb=tmp	
		end if
	
		txt=str(qa)+" - "+str(qb)
	
		qc=qa-qb
	case 2
	
		if ra=0 then rs=1:re=12
		if ra=1 then rs=6:re=15
		if ra=2 then rs=10:re=24
	
		qa=rs+int(rnd*re)
		qb=rs+int(rnd*re)
	
		qc=qa*qb
		txt=str(qa)+" x "+str(qb)
	
	
	case 3
		'' div
		'' a / b = c 
		'' 6 / 2 = 3
		
		qb=1+int(rnd*6)
		qc=1+int(rnd*12)
		qa=qb*qc
		
		txt=str(qa)+" "+chr(246)+" "+str(qb)	'' /
	end select
	
	'' Draw everything
	ext=0
	do
		screenlock
			ui_window(ax,ay,aw,ah,"Enemy Attacks!") '+str(player.difficulty))
			
			enemy_qdraw(ax+16,ay+32,tmp_enemy.s)
			player_qdraw(ax+aw-16-32,ay+32)
			
			color rgb(255,255,255)
			draw string(ax+16,ay+80),"Get this question correct to block"
			draw string(ax+16,ay+96),"the enemy attack! Failure means"
			draw string(ax+16,ay+112),"you lose a health point!"
				
			color rgb(255,200,0)
			draw string(ax+16,ay+144),txt+" = "+panswer
		screenunlock
		'draw string(ax+16,ay+176),panswer
		
		'' Keys!
		k=inkey
		if k>="0" and k<="9" then panswer+=k     
		
		'' Backspace
		if asc(k)=8 then panswer=left(panswer,len(panswer)-1)
	
		'' Enter
		'if asc(k)=13 then ext=1     
		if  MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then
			key.enter=0
			ext=1
		end if
		
		
		'' Clear keyboard buffer
		While Inkey <> "": Wend	
		sleep 10,1
	loop until ext=1
	
	'' Check answer
	screenlock
		ui_window(ax,ay,aw,ah,"Enemy Attacks!")
	
		enemy_qdraw(ax+16,ay+32,tmp_enemy.s)
		player_qdraw(ax+aw-16-32,ay+32)
		
		color rgb(255,255,255)
		draw string(ax+16,ay+80),"Get this question correct to block"
		draw string(ax+16,ay+96),"the enemy attack! Failure means"
		draw string(ax+16,ay+112),"you lose a health point!"
			
		color rgb(255,200,0)
		draw string(ax+16,ay+ah-32),"Click to continue!"
	screenunlock
		
		if val(panswer)=qc then
			color rgb(0,200,0)
			draw string(ax+16,ay+144),txt+" = "+panswer
			draw string(ax+16,ay+144+32),"Sucessfully blocked!"
			ui_mousewait()
		
			return 1
		else
			color rgb(200,0,0)
			draw string(ax+16,ay+144),txt+" = "+panswer
			draw string(ax+16,ay+144+32),"Block failed! Correct answer : "+str(qc)
			
			ui_mousewait()
			return 0
		end if	
end function



function question_hack() as integer

	dim as integer qa(3),qb(3),qc(3)

	dim as integer order
	dim as integer answer(3)
	dim as integer correct
	
	dim as integer i,m,mx,my,mb
	dim as integer hover,over,prev,opt,pick
	
	dim key as mykeys
	
	dim as integer leftdown,current,tmp
	
	dim as string txt(10)
	dim as string intro(10)
	
	dim as integer sx,sy,ext,l
	
	dim as integer ax,ay
	
	const as integer aw=352
	const as integer ah=240
	ax=(swidth-aw)/2
	ay=(sheight-ah)/2
	
	
	dim as string sym(4)
	sym(0)="+"
	sym(1)="-"
	sym(2)="x"
	sym(3)=chr(246)	' "/"
	
	
	for i=0 to ubound(answer)
		answer(i)=0
		order=int(rnd*4)
		
		select case as const order
	
		case 0
		
			qa(i)=1+int(rnd*12)
			qb(i)=1+int(rnd*12)
			qc(i)=qa(i)+qb(i)
		
		case 1
			qa(i)=1+int(rnd*12)
			qb(i)=1+int(rnd*12)
		
			if qb(i)>qa(i) then
				tmp=qa(i)
				qa(i)=qb(i)
				qb(i)=tmp	
			end if
		
			qc(i)=qa(i)-qb(i)
		case 2
			qa(i)=1+int(rnd*12)
			qb(i)=1+int(rnd*12)
			qc(i)=qa(i)*qb(i)
		
		case 3
			'' div
			'' a / b = c 
			'' 6 / 2 = 3
			
			qb(i)=1+int(rnd*6)
			qc(i)=1+int(rnd*12)
			qa(i)=qb(i)*qc(i)

		end select
	
		txt(i)=str(qa(i))+" ? "+str(qb(i))+" = "+str(qc(i))
		'draw string(32,32+(i*16) ),str(qa)+" ? "+str(qb)+" = "+str(qc)
	next i

	'' Show 4 questions
	current=0
	ext=0
	correct=0
	
	intro(0)="Terminal Access"
	intro(1)="==============="
	intro(2)="To access this terminal, click on the"
	intro(3)="missing symbol for each question."
		
	do
		FSOUND_Update
		
		''
		'' Check Mouse
		''
		m = GetMouse (mx, my, , mb)
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				
				if over>-1 then
					opt=over
					pick=1
				end if
			end if
		end if
	
		''
		'' Check Keys
		''
		if  MultiKey(SC_LEFT) and key.l=0  then
			opt-=1
			if opt<0 then opt=(ubound(sym)-1)
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			key.l=1
		end if
			
		if MultiKey(SC_LEFT)=0 and key.l=1 then key.l=0
		
		if  MultiKey(SC_RIGHT) and key.r=0  then
			opt+=1
			if opt=ubound(sym) then opt=0
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			key.r=1
		end if
			
		if MultiKey(SC_RIGHT)=0 and key.r=1 then key.r=0
		
		'' React to a key UP 
		if MultiKey(SC_SPACE) and key.space=0 then key.space=1		
		if MultiKey(SC_SPACE)=0 and key.space=1 then key.space=0:pick=1
		
		if MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then key.enter=0:pick=1
		
		''
		'' Hit / Click symbol
		''
		if pick=1 then
			pick=0
			answer(current)=-1
					
			'' do this in case of questions like 2 ? 2 = 4 (could be + or *)
			select case as const opt
			case 0
				if qa(current)+qb(current)=qc(current) then correct+=1:answer(current)=1
				
			case 1
				if qa(current)-qb(current)=qc(current) then correct+=1:answer(current)=1
			
			case 2
				if qa(current)*qb(current)=qc(current) then correct+=1:answer(current)=1
				
			case 3
				if qa(current)/qb(current)=qc(current) then correct+=1:answer(current)=1
				
			end select
			FSOUND_PlaySound(FSOUND_FREE, sample(1))
			current+=1
					
			if current=4 then ext=1
		end if
		
		''
		''
	
		
	
		screenlock
			ui_window(ax,ay,aw,ah,"Connecting...")
			
			'' -- Intro text
			sx=16+ax
			sy=8+ay+18
			
			color rgb(0,200,0)
			draw string(sx,sy),intro(0)
				
			for i as integer =1 to ubound(intro)
				if left(intro(i),1)="=" then
					color rgb(0,200,0)
					l=len(intro(i-1))*8
					line(sx,sy+13)-(sx+l,sy+13)
					line(sx,sy+15)-(sx+l,sy+15)
				else
					color rgb(255,255,255)
					draw string(sx,sy+(i*14)),intro(i)
				end if
			next i
			'' --	
			
			
			'' draw 4 buttons
			prev=over
			over=-1
			for i=0 to 3
								
				sx=ax+16+(32+16)*i
				sy=ay+200
					
				if mx>sx and mx<sx+32 then
					if my>sy and my<sy+32 then

						over=i
						if over<>prev then
							prev=i
						'	hover=1
							opt=over
						end if
					
					end if
				end if
				
				hover=0
				if opt=i then hover=1
				ui_button(sx,sy,32,32,sym(i),1,hover,0)
			next i
		
		
			''
			for i=0 to ubound(answer)
			
				if answer(i)=0 then 
					'' not answered
					if i=current then
						'' current
						color rgb(255,255,255)
					else
						'' next
						color rgb(100,100,100)
					end if
					
				else	
				
					if answer(i)=1 then 
						'' correct
						color rgb(0,200,0) 
					else 
						'' wrong
						color rgb(200,0,0)
					end if
				
				end if
				
				if current=i then
					draw string(ax+32,ay+96+(i*16) ),">> "+txt(i)
				else
					draw string(ax+32,ay+96+(i*16) ),txt(i)
				end if
				
			next i
		screenunlock	
	
	sleep 10,1
	loop while ext=0
	
	''
	'' Were we successful?
	''
	screenlock
		ui_window(ax,ay,aw,ah,"Connecting...")
		
		'' Draw
		'' -- Intro text
		sx=16+ax
		sy=8+ay+18
		
		color rgb(0,200,0)
		draw string(sx,sy),intro(0)
			
		for i as integer =1 to ubound(intro)
			if left(intro(i),1)="=" then
				color rgb(0,200,0)
				l=len(intro(i-1))*8
				line(sx,sy+13)-(sx+l,sy+13)
				line(sx,sy+15)-(sx+l,sy+15)
			else
				color rgb(255,255,255)
				draw string(sx,sy+(i*14)),intro(i)
			end if
		next i
		'' --		
		for i=0 to ubound(answer)
		
			if answer(i)=1 then 
				'' correct
				color rgb(0,200,0) 
			else 
				'' wrong
				color rgb(200,0,0)
			end if
			
			draw string(ax+32,ay+96+(i*16) ),txt(i)
			
		next i
		
		if correct=4 then
			color rgb(0,200,0) 
			draw string(ax+16,ay+ah-64),"Terminal access GRANTED!"
	
		else
			color rgb(200,0,0)
			draw string(ax+16,ay+ah-64),"Terminal access DENIED."	
		end if
		
		''
		sx=ax+16
		sy=ay+ah-32-8
		ui_button(sx,sy,aw-32,32,"Continue...",1,1,0)
			
	screenunlock
		
	ui_mousewait()
	
	if correct=4 then return 1
	
	return 0
end function


function question_teleport() as integer
	dim as string intro(5)
	
	dim as integer active(16)
	
	dim as integer i,j,c,ct
	dim as integer m,mx,my,mb
	dim as integer hover,over
	dim as integer ext=0,success
	
	dim as integer top,bot=16
	dim as string help=""
	
	dim as integer leftdown,current,tmp,answer
	dim as integer opt,prev
	
	dim as integer sx,sy,l
	
	dim pnt as xy
	dim key as mykeys
	
	const as integer aw=368
	const as integer ah=320
	const as integer ax=(swidth-aw)/2
	const as integer ay=(sheight-ah)/2
	
	''
	top=1+int(rnd*16)
	answer=top
			
	dim divider(3) as integer ={16,8,4,2}
	dim as integer okay,tp,bt
	
	for j=0 to ubound(divider)
		okay=0
		
		if (top mod divider(j)=0) then
			tp=top/divider(j)
			okay+=1
		end if
		
		if (bot mod divider(j)=0) then
			bt=bot/divider(j)
			okay+=1
		end if
		
		if (okay=2) then
			top=tp
			bot=bt
			exit for
		end if
	next j
	
	if tp=1 and bt=2 then help="(half)"
	if tp=1 and bt=4 then help="(quarter)"
	if tp=3 and bt=4 then help="(three quarters)"
	
	
	intro(0)="Teleport Activation"
	intro(1)="==================="
	intro(2)="To teleport, highlight the following amount"
	intro(3)="of squares : "+str(top)+" / "+str(bot)+" "+help
	intro(4)=""
	
	c=0
	for j=0 to 3
		for i=0 to 3
		active(c)=0
		c+=1
		next i
	next j
	
	
	do
		FSOUND_Update
	
		screenlock
			ui_window(ax,ay,aw,ah,"Connecting to ship teleporter...")
			
			'' -- Intro text
			sx=16+ax
			sy=8+ay+18
			
			color rgb(0,200,0)
			draw string(sx,sy),intro(0)
				
			for i as integer =1 to ubound(intro)
				if left(intro(i),1)="=" then
					color rgb(0,200,0)
					l=len(intro(i-1))*8
					line(sx,sy+13)-(sx+l,sy+13)
					line(sx,sy+15)-(sx+l,sy+15)
				else
					color rgb(255,255,255)
					draw string(sx,sy+(i*14)),intro(i)
				end if
			next i
			'' --	
			
			draw string(ax+16,ay+ah-80),"Press Connect after you have highlighted"
			draw string(ax+16,ay+ah-64),"the correct amount of squares!"
			''	
			m = GetMouse (mx, my, , mb)
			
			c=0
			prev=over
			over=-1
			for j=0 to 3
			
				for i=0 to 3
				
					sx=ax+((aw-128)/2)+(i*32)'	ax+(i*32)+64
					sy=ay+(j*32)+64+32+8
					hover=0
					if mx>sx and mx<sx+32 then
						if my>sy and my<sy+32 then
						
						over=c
						if prev<>over then
							'hover=c
							prev=c
							'over=c
							opt=c		
							pnt.x=i
							pnt.y=j
						end if
						
						end if
					end if
				
					'' Highlighted square (yellow)
					if active(c)=1 then
						color rgb(255,200,0)
						line (sx,sy)-(sx+31,sy+31),,bf
					end if
					
					color rgb(255,0,0)
					if opt=c then color rgb(255,200,0) '' Hovering
					line (sx,sy)-(sx+31,sy+31),,b
					
					c+=1
				next i
			next j
		
			'' Check button
			sx=ax+16
			sy=ay+ah-32-8
			hover=0
			
			if mx>sx and mx<sx+(aw-32) then
				if my>sy and my<sy+32 then
				hover=1
				over=-2
				end if
			end if
			ui_button(sx,sy,aw-32,32,"Connect...",1,hover,0)
		screenunlock
		''
		''
		''
		
		
			if  MultiKey(SC_UP) and key.u=0  then
				if (opt-4)>=0 then opt-=4
				key.u=1
			end if
			
			if MultiKey(SC_UP)=0 and key.u=1 then key.u=0
			
			'' Move RIGHT
			if  MultiKey(SC_RIGHT) and key.r=0  then
				if opt+1<16 then opt+=1
				key.r=1
			end if
			if MultiKey(SC_RIGHT)=0 and key.r=1 then key.r=0
			
			
			'' Move DOWN
			if  MultiKey(SC_DOWN) and key.d=0 then
				if opt+4<16 then opt+=4	''21
				key.d=1
			end if
			if MultiKey(SC_DOWN)=0 and key.d=1 then key.d=0
			
			
			'' Move LEFT
			if  MultiKey(SC_LEFT) and key.l=0  then
				if opt>0 then opt-=1
				key.l=1
			end if
			if MultiKey(SC_LEFT)=0 and key.l=1 then key.l=0
	
			'' Select ALL / Clear
			if  MultiKey(SC_A) and key.a=0  then
				key.a=1
				
				ct=0
				for i=0 to ubound(active)-1
					if active(i)=1 then ct+=1
				next i
				
				if ct<16 then
					'' Select ALL
					for c=0 to ubound(active)-1	
						active(c)=1
					next c
				else
					'' Clear
					for c=0 to ubound(active)-1	
						active(c)=0
					next c
				end if
				
				
				
			end if
			if MultiKey(SC_A)=0 and key.a=1 then key.a=0
	
	
	
	
			'' React to a key UP 
			if MultiKey(SC_SPACE) and key.space=0 then key.space=1		
			if MultiKey(SC_SPACE)=0 and key.space=1 then
				key.space=0
			
				if opt>-1 then
					active(opt)=1-active(opt)
					FSOUND_PlaySound(FSOUND_FREE, sample(1))
				end if
			
			end if
			
			if MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
			if MultiKey(SC_ENTER)=0 and key.enter=1 then
				key.enter=0
			
				if ui_yesno("Attempt connection?")=1 then
					ext=2
				end if
			end if
		''
		''
		''
	
		if m=0 then
			'' Left Button
			if mb and 1 then leftdown=1
	
			if (mb and 1)=0 and leftdown=1 then
				leftdown=0
				
				if over>-1 then
					opt=over
					active(opt)=1-active(opt)
					FSOUND_PlaySound(FSOUND_FREE, sample(1))
				end if
				
				if over=-2 then ext=1
			end if
		end if
	
	
		
		''
		sleep 10,1
	loop while ext=0
	
	''
	'' Check answer
	''
	c=0
	for i=0 to ubound(active)
		if active(i)=1 then c+=1
	next i	
		
	''
	''
	
	success=0
	screenlock
		if c=answer then
			success=1
			ui_window(ax,ay,aw,ah,"Teleporter link established...")
			'' Correct
			c=0
			for j=0 to 3
				for i=0 to 3
					'sx=ax+(i*32)+64
					sx=ax+((aw-128)/2)+(i*32)
					sy=ay+(j*32)+64+32+8
					
					if active(c)=1 then
						color rgb(0,200,0)
						line (sx,sy)-(sx+31,sy+31),,bf
						
					end if
					
					color rgb(255,0,0)
					line (sx,sy)-(sx+31,sy+31),,b
					c+=1
				next i
			next j
		
			color rgb(0,200,0) 
			draw string(ax+16,ay+ah-80),"Teleporter access GRANTED!"
			draw string(ax+16,ay+ah-64),str(answer)+" squares were required."
			
			sx=ax+16
			sy=ay+ah-32-8
			ui_button(sx,sy,aw-32,32,"Teleport",1,1,0)
	
		else	
			ui_window(ax,ay,aw,ah,"Failed to connect to teleporter...")
			'' Incorrect
			c=0
			ct=0
			for j=0 to 3
				for i=0 to 3
					'sx=ax+(i*32)+64
					sx=ax+((aw-128)/2)+(i*32)
					sy=ay+(j*32)+64+32+8
					
					if active(c)=1 then
						color rgb(200,0,0)
						line (sx,sy)-(sx+31,sy+31),,bf
						ct+=1
					end if
					
					color rgb(255,0,0)
					line (sx,sy)-(sx+31,sy+31),,b
					c+=1
				next i
			next j
			
			color rgb(200,0,0)
			draw string(ax+16,ay+ah-80),"Teleporter access DENIED. "
			draw string(ax+16,ay+ah-64),str(answer)+" squares were required ("+str(ct)+" selected)."	
		
			sx=ax+16
			sy=ay+ah-32-8
			ui_button(sx,sy,aw-32,32,"Continue...",1,1,0)
		
		end if
		
		'' -- Intro text
		sx=16+ax
		sy=8+ay+18
		
		color rgb(0,200,0)
		draw string(sx,sy),intro(0)
			
		for i as integer =1 to ubound(intro)
			if left(intro(i),1)="=" then
				color rgb(0,200,0)
				l=len(intro(i-1))*8
				line(sx,sy+13)-(sx+l,sy+13)
				line(sx,sy+15)-(sx+l,sy+15)
			else
				color rgb(255,255,255)
				draw string(sx,sy+(i*14)),intro(i)
			end if
		next i
		'' --
		
		
	screenunlock	
		
	ui_mousewait()	
		
return success
end function



