'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''

#include "header.bi"

common shared player as myplayer
common shared scan as myplayer

declare function map_hit(x as integer,y as integer) as integer

dim shared tmp_player as myplayer

dim shared sprite(10) as any ptr

dim shared as integer alt=0 

sub player_init()
	const path as string="gfx/"

	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	'' normal 32x32 sprites
	bload path+"player/player.bmp",sprite(0)	
	bload path+"outline.bmp",sprite(1)
	bload path+"arrows/up.bmp",sprite(2)
	bload path+"arrows/down.bmp",sprite(3)
	bload path+"arrows/left.bmp",sprite(4)
	bload path+"arrows/right.bmp",sprite(5)
	bload path+"arrows/diag.bmp",sprite(6)
	bload path+"arrows/diag2.bmp",sprite(7)
	bload path+"player/player2.bmp",sprite(8)
	
end sub

sub player_reset()
	with player
		.health=3
		.mx=0
		.my=0
	'	.t=1
		.x=8
		.y=4
		
		.rescue=0
		.move=0
		.ice=0
		
		
	'	.difficulty=NORMAL	'' Set via title screen
	end with
end sub

sub player_draw()
	dim as integer spr
	if alt=0 then spr=0 else spr=8

	with player
		put (.x*32,.y*32),sprite(spr),trans
		
		'draw string(8,8),"ply : "+str(.mx)+","+str(.my)+" | "+str(.x)+","+str(.y)
	end with

end sub

sub player_fixeddraw()
	dim as integer sx,sy
	dim as integer spr
	if alt=0 then spr=0 else spr=8
	
	with player
		sx=(.x+player.mx-scan.mx )
		sy=(.y+player.my-scan.my )
		
		if sy<11 then
			put (sx*32,sy*32),sprite(spr),trans
		end if
	
	'draw string(8,8),"ply : "+str(.mx)+","+str(.my)+" | "+str(.x)+","+str(.y)
	end with	
end sub

sub player_qdraw(x as integer,y as integer)
	dim as integer spr
	if alt=0 then spr=0 else spr=8
	
	put (x,y),sprite(spr),trans
end sub

'' Move directions
sub player_up()
	if (player.y>=4) then
		player.y-=1
	else
		if player.my>0 then
			player.my-=1
		else
			player.y-=1
		end if
	end if
end sub

sub player_right()
	if (player.x<=12) then
		player.x+=1
	else
		if player.mx<12 then
			player.mx+=1
		else
			player.x+=1
		end if
	end if
end sub

sub player_down()
	if (player.y<6) then
		player.y+=1
	
	else
		if player.my<5 then
			player.my+=1
		else
			player.y+=1
		end if
	end if	
end sub

sub player_left()
	if (player.x>4) then
		player.x-=1
	else
		if player.mx>0 then
			player.mx-=1
		else
			player.x-=1
		end if
	end if	
end sub


function player_move(d as integer) as integer

	select case as const d
	case 0
		'' up
		if map_hit(0,-1)=0 then
			player_up()		
			alt=1-alt
			return 1
		end if
		
	case 1
		'' right
		if map_hit(1,0)=0 then
			player_right()		
			alt=1-alt
			return 1
		end if
	case 2
		'' down
		if map_hit(0,1)=0 then
			player_down()		
			alt=1-alt
			return 1
		end if
	
	case 3
		'' left
		if map_hit(-1,0)=0 then
			player_left()		
			alt=1-alt
			return 1
		end if


	case 4
		' / Up Right
		
		if map_hit(1,-1)=0 then
			player_up()
			player_right()		
			alt=1-alt
			return 1
		end if
	case 5 
		'\ Down Right
		if map_hit(1,1)=0 then
			player_down()
			player_right()		
			alt=1-alt
			return 1
		end if
	case 6
		' / Down Left
		if map_hit(-1,1)=0 then
			player_down()
			player_left()		
			alt=1-alt
			return 1
		end if
		
	case 7	'\ Up Left'
		if map_hit(-1,-1)=0 then
			player_up()
			player_left()		
			alt=1-alt
			return 1
		end if
	


	end select

return -1

end function


sub player_showmove(num as integer)
dim as integer i

if num<=0 then return

	'' right
	for i=1 to num
		if map_hit(i,0)=0 then
			put ((player.x+i)*32,(player.y)*32),sprite(5),trans
		else
			exit for
		end if
	next i

	'' left
	for i=1 to num
		if map_hit(-i,0)=0 then
			put ((player.x-i)*32,(player.y)*32),sprite(4),trans
		else
			exit for
		end if
	next i
	
	'' down
	for i=1 to num
		if map_hit(0,i)=0 and (player.y+i)<11 then
			put ((player.x)*32,(player.y+i)*32),sprite(3),trans
		else
			exit for
		end if
	next i
	
	''' up
	for i=1 to num
		if map_hit(0,-i)=0 then
			put ((player.x)*32,(player.y-i)*32),sprite(2),trans
		else
			exit for
		end if
	next i
	
	
	'' If we have movement upgrade!
	if player.move=1 then
		'' Down right
		for i=1 to num
			if map_hit(i,i)=0  and (player.y+i)<11 then
				put ((player.x+i)*32,(player.y+i)*32),sprite(6),trans
			else
				exit for
			end if
		next i
	
		'' Up left
		for i=1 to num
			if map_hit(-i,-i)=0 then
				put ((player.x-i)*32,(player.y-i)*32),sprite(6),trans
			else
				exit for
			end if
		next i
		
		'' down Left
		for i=1 to num
			if map_hit(-i,i)=0 and (player.y+i)<11 then
				put ((player.x-i)*32,(player.y+i)*32),sprite(7),trans
			else
				exit for
			end if
		next i
		
		''' Up Right
		for i=1 to num
			if map_hit(i,-i)=0 then
				put ((player.x+i)*32,(player.y-i)*32),sprite(7),trans
			else
				exit for
			end if
		next i
	
	
	end if
	
	
	
	

end sub

function in_box(x as integer,y as integer,bx as integer,by as integer) as integer

	if x>bx and x<bx+32 then
		if y>by and y<by+32 then
		return 1
		end if
	end if

	return 0
end function

function player_movedir(mx as integer,my as integer,num as integer) as integer

	dim as integer ax,ay
	dim as integer i

	'' Up
	for i=1 to num
		if map_hit(0,-i)=0 then
			ax=(player.x)*32
			ay=(player.y-i)*32
			if in_box(mx,my,ax,ay)=1 then return 0
		else
			exit for
		end if
	next i
	
	'' Right
	for i=1 to num
		if map_hit(i,0)=0 then
			ax=(player.x+i)*32
			ay=(player.y)*32
			if in_box(mx,my,ax,ay)=1 then return 1
		else
			exit for
		end if
	next i
	
	'' Down
	for i=1 to num
		
		if map_hit(0,i)=0 and (player.y+i)<11 then
			ax=(player.x)*32
			ay=(player.y+i)*32
			if in_box(mx,my,ax,ay)=1 then return 2
		else
			exit for
		end if
	next i
		
	'' Left
	for i=1 to num
		if map_hit(-i,0)=0 then
			ax=(player.x-i)*32
			ay=(player.y)*32
			if in_box(mx,my,ax,ay)=1 then return 3
		else
			exit for
		end if
	next i

	'' 
	'' If player has MOVEMENT upgrade
	''
	if player.move=1 then
		'' / Up Right
		for i=1 to num
			if map_hit(i,-i)=0 then
				ax=(player.x+i)*32
				ay=(player.y-i)*32
				if in_box(mx,my,ax,ay)=1 then return 4
			else
				exit for
			end if
		next i
		
		'' \ Down Right
		for i=1 to num
			if map_hit(i,i)=0  and (player.y+i)<11 then
				ax=(player.x+i)*32
				ay=(player.y+i)*32
				if in_box(mx,my,ax,ay)=1 then return 5
			else
				exit for
			end if
		next i
		
		'' / Down Left
		for i=1 to num
			if map_hit(-i,i)=0  and (player.y+i)<11 then
				ax=(player.x-i)*32
				ay=(player.y+i)*32
				if in_box(mx,my,ax,ay)=1 then return 6
			else
				exit for
			end if
		next i
		
		'' / Up Left
		for i=1 to num
			if map_hit(-i,-i)=0 then
				ax=(player.x-i)*32
				ay=(player.y-i)*32
				if in_box(mx,my,ax,ay)=1 then return 7
			else
				exit for
			end if
		next i
	end if
	
return -1
end function

''
'' Is player next to an object
''
function player_next(sx as integer,sy as integer) as integer
	dim as integer i,j
	dim as integer px,py
	
	px=player.mx+player.x
	py=player.my+player.y
	
	for j=-1 to 1
		for i=-1 to 1
			if (px+i)=sx and (py+j)=sy then return 1			
		next i
	next j
	
	return 0
end function


sub player_guage()
	dim as integer i

	with player
		color rgb(255,0,0)
		for i=0 to 8
			Line ((i*8),460)-((i*8)+6,466),,bf
		next i
		
		color rgb(0,255,255)
		for i=0 to 8
			Line ((i*8),470)-((i*8)+6,476),,bf
		next i
	end with

end sub

