'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''

#include "bmp.bi"
#include "header.bi"

''
''

declare sub enemy_elite()
declare sub ui_warning(txt as string)

''
''
''
common shared rescue as integer

common shared map() as myblock
common shared player as myplayer
common shared scan as myplayer

''
declare sub map_flip()
declare sub map_raw()
declare sub map_rotsprite(no as integer)

dim shared sprite(60) as any ptr
dim shared as integer alt=0,ct=0 

dim shared basemap(64*32) as ubyte	'' Basemap

dim shared mapwidth as integer
dim shared mapheight as integer

dim shared as integer currentarea
dim shared area(6) as xy


const as integer awidth=32
'' --------- 

sub map_init()
	const path as string="gfx\"

	dim i as integer	

	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
		
	next i

	'' ship / forest normal 32x32 sprites	
	bload path+"forest\grass.bmp",sprite(0)	
	bload path+"ship\wall.bmp",sprite(1)	
	bload path+"ship\floor.bmp",sprite(2)	'' 
	bload path+"ship\barrier.bmp",sprite(3)	'' 
	bload path+"forest\beacon_off.bmp",sprite(5)
	bload path+"forest\beacon_on.bmp",sprite(6)
	bload path+"ship\console.bmp",sprite(7)
	bload path+"forest\tree.bmp",sprite(8)	

	'' forest normal 32x32 sprites	
	bload path+"forest\grass.bmp",sprite(10)	
	bload path+"ship\wall.bmp",sprite(11)	
	bload path+"forest\grass.bmp",sprite(12)	'' 
	bload path+"forest\barrier.bmp",sprite(13)	'' 
	bload path+"forest\beacon_off.bmp",sprite(15)
	bload path+"forest\beacon_on.bmp",sprite(16)
	bload path+"ship\console.bmp",sprite(17)
	bload path+"forest\tree.bmp",sprite(18)


	'' lava	
	bload path+"lava\path.bmp",sprite(20)	'' 
	bload path+"lava\wall.bmp",sprite(21)	
	bload path+"lava\path.bmp",sprite(22)	'' 
	bload path+"lava\beacon_off.bmp",sprite(25)
	bload path+"lava\beacon_on.bmp",sprite(26)
	bload path+"ship\console.bmp",sprite(27)
	bload path+"lava\lava.bmp",sprite(28)
	
	
	'' ice	
	bload path+"ice\path.bmp",sprite(30)	'' 
	bload path+"ice\wall.bmp",sprite(31)	
	bload path+"ice\path.bmp",sprite(32)	'' 
	bload path+"ice\barrier.bmp",sprite(33)	'' 
	bload path+"ice\beacon_off.bmp",sprite(35)
	bload path+"ice\beacon_on.bmp",sprite(36)
	bload path+"ship\console.bmp",sprite(37)
	bload path+"ice\wall.bmp",sprite(38)
	
	bload path+"items\health.bmp",sprite(45)	''  Collectable	
	bload path+"items\move.bmp",sprite(46)	''  Collectable		
	bload path+"items\ice.bmp",sprite(47)	''  Collectable	
	'bload path+"npc\female.bmp",sprite(48)
	bload path+"npc\male.bmp",sprite(49)
	bload path+"scan.bmp",sprite(50)	'' 
	
	bload path+"ship\console2.bmp",sprite(57)	'' 
	
	
	'for i=0 to 4
	'	put(i*32,0),sprite(i),trans
	'next i
	'sleep 1000
	currentarea=0
	
	area(0).x=0
	area(0).y=0
	
	area(1).x=0
	area(1).y=16
	
	area(2).x=32
	area(2).y=0
	
	area(3).x=32
	area(3).y=16
	
	
end sub

sub map_area(num as integer)
	currentarea=num	
end sub

sub map_load(level as integer)

	dim as integer i,j,c,t
	dim header as bmphdr

	rescue=0

	const path as string="map\"

	if  Open(path+str(level)+".bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,basemap()  
	        Close #1     
	              
	        mapwidth=header.w
		mapheight=header.h      
	              
	        map_flip()  
	        
	        '' Convert flat map array...
		c=0
		for j=0 to mapheight-1
		 	for i=0 to mapwidth-1
		 		
		 		with map(i,j)
				 	.s=basemap(c)
				 	.visible=1	
					.item=0
					.solid=0
					if .s=1 then .solid=1:pset(i,300+j),rgb(255,255,0)	'' Wall
					if .s=3 then .solid=1	'' barrier
					if .s=5 then .solid=1	'' beacon
					if .s=7 then .solid=1	'' Can't walk through console
					if .s=8 then .solid=1	' tree'
					'draw string(i*8,j*8),str(.s)
					
					if .s=6 then
						.s=map(i-1,j).s	'' ground tile to left of person
						.item=2	'' person!
						rescue+=1
					end if
					
					if .s=4 then
						.s=map(i-1,j).s
						.item=3	'' Ice Gun
					end if
					
					if .s=9 then
						.s=map(i-1,j).s
						.item=4	'' Ice Gun
					end if
					
				end with
		 	
		 		c+=1
			next i
		next j     
		
		
		'map_raw()
	'	draw string(8,128),"Size: "+str(mapwidth)+","+str(mapheight)
	'	sleep 100*10      
	              
	else
		draw string(8,128),"Could not load map "+str(level)
		sleep 100*10 
	end if
	
end sub

sub map_flip()
	dim as integer i,j,c
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
	temp(i)=basemap(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			basemap(c+i)=temp((mapwidth*( (mapheight-1)-j))+i)  '' 32*(31-j)
		next i
		c+=mapwidth	''32
	next j
	

end sub

sub item_set(num as integer)
	dim as integer sx,sy,i,e,done
	
	for i=0 to 4	
		done=0
		do
			sx=int(rnd*64)
			sy=int(rnd*32)
			
			with map(sx,sy)
				if .s=0 and .item=0 then
					.item=num
					done=1
				end if
			end with
		loop until done=1
	next i

end sub



function item_check() as integer
	dim as integer sx,sy
	dim as integer tmp
	
	sx=area(currentarea).x+player.mx+player.x
	sy=area(currentarea).y+player.my+player.y

	with map(sx,sy)
		if .item>0 then
			tmp=.item
			if .item=1 then	player.crystal+=1
			if .item=2 then	player.rescue+=1
			
			if .item=3 then
				player.ice=1
			end if
				
			if .item=4 then
				player.move=1
			end if
			
			if .item=5 then
				player.health+=1
			end if
			
			
			.item=0
			
			return tmp
		end if
	end with


	return -1
end function

function item_over(x as integer,y as integer) as integer
	return map(x,y).item
end function

sub map_draw()
	dim as integer c,s
	dim as integer x,y
	dim as integer sx,sy
	dim as integer cx,cy
	
	dim as integer spr
	
	cx=area(currentarea).x+player.mx
	cy=area(currentarea).y+player.my
	
	for y=0 to 10
		for x=0 to 19
			with map(cx+x,cy+y)
				
				sx=x*32
				sy=y*32
				
				spr=.s+(currentarea*10)
				
				select case as const .s	
				case 7	
					if alt=1 then spr=57	'' blinky console
				end select
				
				put (sx,sy),sprite(spr),trans
				
				if .item=1 then put (sx,sy),sprite(47),trans
				if .item=2 then put (sx,sy),sprite(49),trans	'' person
				if .item=3 then put (sx,sy),sprite(47),trans	'' ice orb
				if .item=4 then put (sx,sy),sprite(46),trans	'' movement
				if .item=5 then put (sx,sy),sprite(45),trans	'' movement
				
			'	draw string(sx,sy),str(.s)
			'	draw string(x*32,(y*32)+12),str(.zone)
			end with
		next x
	next y


	'' Move lava
	if currentarea=2 then 
		if (ct mod 5)=0 then map_rotsprite(28)
	end if
	
	'' alternate frames
	ct+=1
	if ct>20 then ct=0:alt=1-alt	
end sub


'' 
'' Allow player to move around only show visible areas
''
sub map_scan()
	dim as integer c,s
	dim as integer x,y
	dim as integer sx,sy
	
	dim as integer cx,cy
	dim as integer spr
	
	cx=area(currentarea).x+scan.mx
	cy=area(currentarea).y+scan.my
	
	for y=0 to 10
		for x=0 to 19
			with map(cx+x,cy+y)
				
				sx=x*32
				sy=y*32
				
				spr=.s+(currentarea*10)
				
				select case as const .s	
				case 7	
					if alt=1 then spr=57
				end select
				
				put (sx,sy),sprite(spr),trans
				
				if .item=1 then put (sx,sy),sprite(47),trans
				if .item=2 then put (sx,sy),sprite(49),trans
				if .item=3 then put (sx,sy),sprite(47),trans
				if .item=4 then put (sx,sy),sprite(46),trans
				if .item=5 then put (sx,sy),sprite(45),trans	'' movement	
				
			'	draw string(x*32,y*32),str(.s)
			'	draw string(x*32,(y*32)+12),str(.zone)
			end with
		next x
	next y

	'' Move lava
	if currentarea=2 then 
		if (ct mod 5)=0 then map_rotsprite(28)
	end if
	
	'' alternate frames
	'draw string(8,8),"ALT:"+str(alt)
	ct+=1
	if ct>20 then ct=0:alt=1-alt
			
end sub


sub map_raw()
	dim as integer i,j

	for j=0 to mapheight-1
	 	for i=0 to mapwidth-1
	 		
	 		with map(i,j)
				draw string(i*8,j*8),str(.s)
			end with
		next i
	next j 
end sub

sub map_replace(a as integer,b as integer)
	dim as integer x,y
	dim as integer sx,sy
	
	dim as integer cx,cy
	
	cx=area(currentarea).x
	cy=area(currentarea).y
	
	
	for y=0 to 15
		for x=0 to 31
			with map(cx+x,cy+y)
				if .s=a then 
					.s=b
					.solid=0
				end if
			end with
		next x
	next y
end sub




function map_hit(x as integer,y as integer) as integer
	dim as integer sx,sy
	
	sx=area(currentarea).x+player.mx+player.x+x
	sy=area(currentarea).y+player.y+player.my+y

	if map(sx,sy).solid=0 then return 0
	
	return 1

end function

function map_solid(x as integer,y as integer) as integer
	dim as integer sx,sy
	
	sx=area(currentarea).x'+player.mx+player.x+x
	sy=area(currentarea).y'+player.y+player.my+y


	if map(x,y).solid=0 then return 0	
	return 1
end function


''
'' rotate sprite horizontally
''

sub map_rotsprite(no as integer)
	dim as integer pix=0
	
	Dim buffer As UByte Ptr = sprite(no) 
	dim temp(5) as ubyte
	
	pix=32
   	for j as integer=0 to 31
	   
	        for i as integer=0 to 3 	'
	       		temp(i)=buffer[pix+i]
	       	next i
		 
	        for i as integer=0 to 123 	
	       		buffer[pix+i]=buffer[pix+i+4]
	       	next i
	       	
	       	for i as integer=0  to 3
			buffer[pix+124+i]=temp(i)
	       	next i
	       	''
	       	pix+=128
	
	next j
	
end sub

