'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''

#include "header.bi"
#include "fmod.bi"

''
'' -- Sound ---
''
'' 4 = Pickup
'' 
'' 6 = Explosion
'' 7 = Hit

FSOUND_Init(44100, 8, 0) 

common shared sample() As Integer
dim sample(10) As Integer

for i as integer=0 to 7
	sample(i) = FSOUND_Sample_Load(FSOUND_FREE,"snd\"+str(i)+".mp3", FSOUND_HW3D, 0, 0) 
next i

dim as integer music=1
dim as integer gamemusic

gamemusic = FMUSIC_LoadSong("music\tune.mid")
FMUSIC_SetMasterVolume(gamemusic, 60)

''
'' -- End of  Sound ---
''

windowtitle GAMETITLE+" ["+VERSION+"] "+SITEURL
screen 18,32,1'''  ,&h01
randomize

''
declare sub snow_init()
declare sub snow_draw()

'' Fonts
common shared comic12w as any ptr

declare sub font_load()
declare sub font_color(as integer,as integer,as integer)
declare sub font_centre(as integer,as string)
declare sub font_show(as integer, as integer,as string)	


'' teleport.bas
common shared location() as tele
dim location(3) as tele

declare sub tele_clear()
declare sub tele_add(area as integer, x as integer,y as integer,mx as integer,my as integer)
declare function tele_select() as integer

declare sub fx_teleport_in()
declare sub fx_teleport_out()

'' title.bas
declare sub title()
declare sub title_outro()
declare sub title_init()
declare sub title_intro()

''
'' In Stars
''
declare sub stars_init()
declare sub stars_draw()

''
'' In map.bas
''
common shared rescue as integer

common shared map() as myblock
dim map(64,32) as myblock

declare sub map_init()
declare sub map_load(level as integer)
declare sub map_draw()
declare sub map_scan()
declare sub map_area(as integer)
declare function map_hit(x as integer,y as integer) as integer

declare sub map_replace(as integer, as integer)

declare sub item_set(as integer)
declare function item_check() as integer
declare function item_over(x as integer,y as integer) as integer

'' In player.bas
common shared player as myplayer
common shared scan as myplayer

declare sub player_init()
declare sub player_draw()
declare sub player_fixeddraw()
declare function player_movedir(as integer,as integer,as integer) as integer
declare sub player_showmove(num as integer)
declare function player_move(d as integer) as integer
declare function player_next(as integer,as integer) as integer
declare sub player_reset()

'' In enemy.bas
common shared enemy() As myenemy
dim enemy(30) as myenemy

dim tmp_enemy as myenemy
dim as integer enemies,enemy_max

declare sub enemy_init()
declare sub enemy_set()
declare sub enemy_draw()
declare sub enemy_fixeddraw()
declare sub enemy_update(as integer)
declare function enemy_mouse(as integer,as integer) as integer
declare function enemy_health(x as integer, y as integer) as myenemy
declare function enemy_id(mx as integer, my as integer) as integer
declare function enemy_over(mx as integer, my as integer) as integer
declare sub enemy_area(as integer)
declare sub enemy_elite()
declare function enemy_count() as integer
declare sub enemy_clear()
''
'' In ui.bas
common shared ui_modes() As mybutton
dim ui_modes(5) as mybutton

declare sub ui_init()
declare sub ui_info(as integer)
declare sub ui_hover(x as integer,y as integer,item as integer)
declare sub ui_command(x as integer,y as integer,as integer)
declare function ui_command_hit(mx as integer,my as integer) as integer
declare sub ui_diceroll(num as integer)
declare sub ui_guage(x as integer,y as integer,num as integer,max as integer,as string)
declare sub ui_enemyhover(x as integer,y as integer,tmp_enemy as myenemy)

declare sub ui_collected(item as integer)
'declare sub ui_window(x as integer,y as integer,w as integer,h as integer,title as string)

declare sub ui_warning(txt as string)
declare sub ui_welldone()
declare sub ui_mousewait()
declare function ui_yesno(txt as string) as integer
declare sub ui_defeated()
declare sub ui_red()
''

declare function question_hack() as integer
declare function question_attack(tmp_enemy as myenemy) as integer
declare function question_defend(tmp_enemy as myenemy) as integer
declare function question_teleport() as integer

'' In this file
dim shared mkey as mykeys
	
declare sub mouse_box()
declare sub scan_box()
declare sub set_mode(num as integer)

''=================


const path as string="gfx\"
dim shared sprite(10) as any ptr

dim shared as integer ec
dim as integer sx,sy

dim key as mykeys

dim target as shotxy 

'dim as integer viewx,viewy
dim shared as integer mode
dim shared as integer dice=0,show_dice=0
dim shared as integer show_tele
dim as integer show_intro=1

dim shared as integer qa,qb,qt,correct
dim shared as string panswer

dim shared mouse_over as myblock
dim as integer leftdown=0,rightdown=0

dim shared as integer m,mb,mx,my,mv

dim shared as integer attack,look
dim shared cur as xy
dim as string k

dim as integer myitem
dim shared as integer cursor
dim as integer quit=0,ext=0
dim as integer moved=0
dim as integer ts	'' teleport select
''
dim shared as integer currentarea
dim shared area(6) as xy

dim as integer uicom


area(0).x=0
area(0).y=0

area(1).x=0
area(1).y=16

area(2).x=32
area(2).y=0

area(3).x=32
area(3).y=16
''	
	


'' Start of main game

for i as integer=0 to ubound(sprite)
sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
next i

bload path+"cursors\outline.bmp",sprite(0)
bload path+"cursors\target.bmp",sprite(1)

bload path+"items\move.bmp",sprite(5)
bload path+"items\ice.bmp",sprite(6)

font_load()
stars_init()
ui_init()
player_init()
snow_init()

tele_clear()

enemy_init()
map_init()
title_init()
''
player.difficulty=1

'question_teleport()
'title_intro()
'title_outro()
'question_hack()
'if ui_yesno("Play game?")=0 then
'	end
'end if


FMUSIC_PlaySong(gamemusic)
do 
	FSOUND_Update
	
	
	if music=0 then
		FMUSIC_StopAllSongs()
	end if
	
	title()
	
	'FSOUND_PlaySound(FSOUND_FREE, sample(0))
	
	if show_intro>0 then
		show_intro-=1
		title_intro()
	end if
		
	''
	'' Game Starts
	''
	map_load(0)
	item_set(5)
	enemy_set()	'' do after map
	
	enemies=enemy_count()
	enemy_max=enemies
	
	''
	'' Get player ready
	''
	tele_clear()
	player_reset()
	
	with player
		tele_add(0,.x,.y,.mx,.my)
		#if CHEAT=1
		tele_add(1,.x,.y,.mx,.my)
		.move=1
		.ice=1
		#endif
	end with
	
	scan.mx=player.mx
	scan.my=player.my
		
	attack=0
	look=0
	
	''
	'' Get map ready
	''
	
	currentarea=0
	map_draw()	'' Do this to fill in visible bits
	map_area(currentarea)
	enemy_area(currentarea)
	
	''
	''
	if player.difficulty=EASY then 
		dice=6+int(rnd*7) '' 6 to 12	
	else
		dice=2+int(rnd*11) '' 2 to 12
	end if
	
	''
	
	for i as integer=0 to ubound(ui_modes)
		ui_modes(i).state=1
	next i
	
	ui_modes(0).state=0
	mode=MODE_DICE
	
	show_dice=2
	show_tele=1

	quit=0

	do	
	FSOUND_Update

	screenlock()
		cls
			
		select case as const mode
		case MODE_SCAN	
		'	draw string(0,0),"Scan"
			map_scan()
		
			player_fixeddraw()
			enemy_fixeddraw()
			scan_box()
			
			if (mouse_over.s>0) then
			
				if mouse_over.s<100 then
					'' Tile
					ui_hover(cur.x,cur.y,mouse_over.s+(currentarea*10))
				else
					'' Monster
					ui_hover(cur.x,cur.y,mouse_over.s)
				end if
			end if
			
			if my>0 and my<16 and scan.my>0 then scan.my-=1
			
			if my>0 and my<352 then
				if mx>0 and mx<16 and scan.mx>0 then scan.mx-=1
				if mx>640-16 and mx<640 and scan.mx<12 then scan.mx+=1
			end if
			
			'if my>320 and my<352 and scan.my<5 then scan.my+=1
			
			'with scan
			'draw string(8,24),"scn : "+str(.mx)+","+str(.my)+" | "+str(.x)+","+str(.y)
			'end with
			if currentarea=3 then snow_draw()
			
		case MODE_MOVE	
		'	draw string(0,0),"Move"
			map_draw()
			player_draw()
			player_showmove(dice)
			enemy_draw()
			mouse_box()
			
			if currentarea=3 then snow_draw()
			
		case MODE_TARGET
		'	draw string(0,0),"Target"
		
			map_draw()
			player_draw()
			enemy_draw()
			
			mouse_box()
			if (mouse_over.s>99 and mouse_over.s<200) then
				'' Find particular alien
				'tmp_enemy=enemy_health(mouse_over.x,mouse_over.y)	
				'ui_enemyhover(mouse_over.x,mouse_over.y,tmp_enemy)
				
				'''
				tmp_enemy=enemy_health(cur.x,cur.y)	
				ui_enemyhover(cur.x,cur.y,tmp_enemy)
			end if
			if currentarea=3 then snow_draw()
		''
		'' ^^ Display modes
		''
		
		case MODE_INFO
			map_scan()
			player_fixeddraw()
			enemy_fixeddraw()
			
			if mouse_over.s<100 then
				ui_info(mouse_over.s+(currentarea*10) )
			else
				ui_info(mouse_over.s )
			end if
			
		case MODE_DICE
			map_draw()
			player_draw()
			enemy_draw()
			
			if show_dice>0 then
				ui_diceroll(dice)
			end if
		
		case MODE_ITEM
			map_draw()
			player_draw()
			enemy_draw()
			
		case MODE_ENEMY
			'' Enemy moving...
			map_draw()
			player_draw()
			enemy_draw()
			
			if currentarea=3 then snow_draw()
			
		case MODE_ATTACK
		'' == Player attacks enemy
			map_draw()
			player_draw()
			enemy_draw()
	
		case MODE_ENEMYATTACK
		'' == Enemy attacks player
			map_draw()
			player_draw()
			enemy_draw()
			
		case MODE_TELEPORT
			map_draw()
			player_draw()
			enemy_draw()
		
		end select
		
		ui_command(mx,my,mode)
		
		ui_guage(88,400,dice,12,"ACTION:")
		ui_guage(88,400+16,player.health,12,"HEALTH:")
		ui_guage(88,400+32,player.rescue,rescue,"RESCUED:")
		ui_guage(88,400+48,enemies,enemy_max,"INVADERS:")
		
	'	draw string(88,464),str(enemies)+" / "+str(enemy_max)
		
		
		if player.move=1 then put (604,400),sprite(5),trans
		if player.ice=1 then put (604,400+32),sprite(6),trans
		
	screenunlock()

	''
	#if CHEAT=1
	
	if  MultiKey(SC_SPACE) and key.space=0  then key.space=1
		
	if MultiKey(SC_SPACE)=0 and key.space=1 then 
		key.space=0
		currentarea+=1
		if currentarea>3 then currentarea=0
		map_area(currentarea)
		enemy_area(currentarea)
	end if
	
	if  MultiKey(SC_C) and key.c=0  then key.c=1
		
	if MultiKey(SC_C)=0 and key.c=1 then
		key.c=0
		enemy_clear()
		enemies=enemy_count()
		player.rescue=(rescue)
	end if	
	#endif
	''

	
	select case as const mode
		case MODE_SCAN
			if  MultiKey(SC_UP) and key.u=0  then
			 	if cur.y>0 then 
					cur.y-=1
				else
					if scan.my>0 then scan.my-=1
				end if
				key.u=1
			end if
			
			if MultiKey(SC_UP)=0 and key.u=1 then key.u=0
			
			'' Move RIGHT
			if  MultiKey(SC_RIGHT) and key.r=0  then
			
				if cur.x<19 then
					cur.x+=1
				else
					if scan.mx<12 then scan.mx+=1
				end if
				key.r=1
			end if
			if MultiKey(SC_RIGHT)=0 and key.r=1 then key.r=0
			
			
			'' Move DOWN
			if  MultiKey(SC_DOWN) and key.d=0 then
				if cur.y<10 then 
					cur.y+=1
				else
					if scan.my<5 then scan.my+=1	''21
				end if
				key.d=1
			end if
			if MultiKey(SC_DOWN)=0 and key.d=1 then key.d=0
			
			
			'' Move LEFT
			if  MultiKey(SC_LEFT) and key.l=0  then
				if cur.x>0 then
					cur.x-=1
				else
					if scan.mx>0 then scan.mx-=1
				end if
				key.l=1
			end if
			if MultiKey(SC_LEFT)=0 and key.l=1 then key.l=0
		
		
			'' React to a key UP 
			if MultiKey(SC_SPACE) and key.space=0 then key.space=1		
			if MultiKey(SC_SPACE)=0 and key.space=1 then key.space=0:look=1
			
			if MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
			if MultiKey(SC_ENTER)=0 and key.enter=1 then key.enter=0:look=1
			
			'' Look because Scan is already in use...
			if look=1 then
				look=0
				if mouse_over.s>0 then 
					
					if (player.mx+player.x)=(scan.mx+cur.x) then
						if (player.my+player.y-1)=(scan.my+cur.y) then
						
							'' console
							if  mouse_over.s=7 then
								mode=MODE_HACK	
								FSOUND_PlaySound(FSOUND_FREE, sample(0))
							end if
						end if
					
					end if
				
					'' Beacon (Do not have to be in front)
					if  mouse_over.s=5 then
						
						'ui_warning("Beacon!")
						sx=scan.mx+cur.x
						sy=scan.my+cur.y
						
						if player_next(sx,sy)=1 then
							mouse_over.s=6
							
							with player
								tele_add(currentarea,.x,.y,.mx,.my)
							end with
													
							
							map(area(currentarea).x+sx,area(currentarea).y+sy).s=6
						end if
					end if
				
					if mode=MODE_SCAN then
						mode=MODE_INFO
						FSOUND_PlaySound(FSOUND_FREE, sample(0))
					end if
				end if
			end if
		
	
		case MODE_MOVE	
			if dice>0 then
			
				moved=0
				
				'' Move UP
				if  MultiKey(SC_UP) and key.u=0  then
					if player_move(0)=1 then dice-=1
					moved=1
					key.u=1
				end if
				
				if MultiKey(SC_UP)=0 and key.u=1 then key.u=0
				
				'' Move RIGHT
				if  MultiKey(SC_RIGHT) and key.r=0  then
					if player_move(1)=1 then dice-=1
					moved=1
					key.r=1
				end if
				if MultiKey(SC_RIGHT)=0 and key.r=1 then key.r=0
				
				
				'' Move DOWN
				if  MultiKey(SC_DOWN) and key.d=0 then
					if player_move(2)=1 then dice-=1
					moved=1
					key.d=1
				end if
				if MultiKey(SC_DOWN)=0 and key.d=1 then key.d=0
				
				
				'' Move LEFT
				if  MultiKey(SC_LEFT) and key.l=0  then
					if player_move(3)=1 then dice-=1
					moved=1
					key.l=1
				end if
				if MultiKey(SC_LEFT)=0 and key.l=1 then key.l=0
			
				'' Move UP + RIGHT
				if  MultiKey(SC_PAGEUP) and key.pgup=0  then
					if player_move(4)=1 then dice-=1
					moved=1
					key.pgup=1
				end if
				if MultiKey(SC_PAGEUP)=0 and key.pgup=1 then key.pgup=0
				
				'' Move DOWN + RIGHT
				if  MultiKey(SC_PAGEDOWN) and key.pgdn=0  then
					if player_move(5)=1 then dice-=1
					moved=1
					key.pgdn=1
				end if
				if MultiKey(SC_PAGEDOWN)=0 and key.pgdn=1 then key.pgdn=0
				
				
				'' Move DOWN + LEFT
				if  MultiKey(SC_END) and key.ed=0  then
					if player_move(6)=1 then dice-=1
					moved=1
					key.ed=1
				end if
				if MultiKey(SC_END)=0 and key.ed=1 then key.ed=0
				
				'' Move LEFT + UP
				if  MultiKey(SC_HOME) and key.home=0  then
					if player_move(7)=1 then dice-=1
					moved=1
					key.home=1
				end if
				if MultiKey(SC_HOME)=0 and key.home=1 then key.home=0
				
				
			
				'' 
				'' Landed on enemy or item?
				''
				if moved=1 then
					myitem=item_check()
					if myitem>-1 then mode=MODE_ITEM
					
					ec=enemy_over(player.x,player.y)
					if ec>-1 then
						tmp_enemy=enemy(ec)
						if question_defend(tmp_enemy)=0 then player.health-=1
					end if
				end if
			
			end if
			
		
		
		''------
	case MODE_ENEMY
		
		''
		'' Update enemies 1 per loop
		''
		for i as integer=1 to enemy(ec).spd
			enemy_update(ec)
			'' Attack player if landed on him!
			with enemy(ec)	
				if .active=1 and .area=currentarea then
					sy=.y-player.my-area(currentarea).y
					sx=.x-player.mx-area(currentarea).x
					
					if sx=player.x and sy=player.y then
						tmp_enemy=enemy(ec)
						mode=MODE_ENEMYATTACK
						
						'' Clear keyboard buffer
						While Inkey <> "": Wend	
						exit for
					end if
				end if
			
			end with
		next i
		
		
		ec+=1
		if ec>ubound(enemy) then
			ec=0
			scan.mx=player.mx
			scan.my=player.my
			mode=MODE_SCAN
			
			for i as integer=0 to ubound(ui_modes)
				ui_modes(i).state=0
			next i
			
			ui_modes(0).state=1
			ui_modes(1).state=1
			
		end if
	case MODE_TARGET	
		'' React to a key UP 
		if MultiKey(SC_SPACE) and key.space=0 then key.space=1		
		if MultiKey(SC_SPACE)=0 and key.space=1 then key.space=0:attack=1
		
		if MultiKey(SC_ENTER) and key.enter=0 then key.enter=1		
		if MultiKey(SC_ENTER)=0 and key.enter=1 then key.enter=0:attack=1
		
		if attack=1 then
			attack=0
			if dice>0 then
				
					if currentarea=2 then
						'' freeze lava!
						if mouse_over.s=8 and player.ice=1 then
						dice-=1
						map(area(currentarea).x+player.mx+cur.x,area(currentarea).y+player.my+cur.y).s=2
						map(area(currentarea).x+player.mx+cur.x,area(currentarea).y+player.my+cur.y).solid=0
						FSOUND_PlaySound(FSOUND_FREE, sample(7))
						end if
					
					end if
				
					if mouse_over.s>99 then 
						dice-=1
						target.active=enemy_id((cur.x*32)+8,(cur.y*32)+8)
						
						'ui_warning("Enemy:"+str(target.active)+" H:"+str(enemy(target.active).h))
						
						mode=MODE_ATTACK
						
						'' Clear keyboard buffer
						While Inkey <> "": Wend	
		
					end if
				end if
		
		end if
		
		
		
	case MODE_DICE
		if show_dice>0 then
			ui_mousewait()
		end if
		
		if (dice>=8 and show_tele>0) then
			show_tele-=1
			ui_info(200)
			ui_mousewait()
		end if
	
		scan.mx=player.mx
		scan.my=player.my
		mode=MODE_SCAN
		
	case MODE_HACK
		'' Access a terminal
		map_draw()
		player_draw()
		enemy_draw()
			
		if question_hack()=1 then
			'' remove
			FSOUND_PlaySound(FSOUND_FREE, sample(5))
			map_replace(3,2)	'' barrier with floor
		end if	
		
		mode=MODE_SCAN

		
	case MODE_INFO
		ui_mousewait()	
		mode=MODE_SCAN
			
	case MODE_ITEM	
		FSOUND_PlaySound(FSOUND_FREE, sample(4))
			
		ui_collected(myitem)
		if myitem<>5 then ui_mousewait()
		
		if (myitem=3) then
			map_draw()
			player_draw()
			enemy_draw()
			ui_warning("Enemy teleport detected!")	
			enemy_elite()
			
			'' Back to full again...
			enemies=enemy_count()
			enemy_max=enemies

		end if 
		mode=MODE_MOVE
				
	case MODE_ATTACK
			
		if question_attack(tmp_enemy)=1 then
				with enemy(target.active)
					.h-=1
					if player.ice=1 then .h-=1	'' has ice gun!
					
					FSOUND_PlaySound(FSOUND_FREE, sample(7))
					
			        	if .h<=0 then
						.active=0
						
						FSOUND_PlaySound(FSOUND_FREE, sample(6))
						enemies=enemy_count()
					end if
					
					'ui_warning("Enemy:"+str(target.active)+" H:"+str(.h))
		        	end with
		end if	
		
		if enemy(target.active).h>0 and dice>0 then
			if ui_yesno("Attack again?") then
				dice-=1
				mode=MODE_ATTACK
			else	
				mode=MODE_TARGET
			end if
		else
			mode=MODE_TARGET
		end if

	case MODE_ENEMYATTACK
		''
		'' Enemy attacks player
		''
			
		if question_defend(tmp_enemy)=0 then
			player.health-=1
			FSOUND_PlaySound(FSOUND_FREE, sample(7))
		end if
		mode=MODE_ENEMY
		
	case MODE_TELEPORT
		
		ts=tele_select()	
		if ts>-1 then
		
			'' do something...
			if question_teleport()=1 then
			
				fx_teleport_out()
				
				with location(ts)
					currentarea=.area
					player.mx=.mx
					player.my=.my
					player.x=.x
					player.y=.y
				end with
				
				map_area(currentarea)
				enemy_area(currentarea)
			
				fx_teleport_in()
				
				dice=0
				mode=MODE_MOVE	'' only so later everything will be disable
			' else
			'	ui_warning("Teleport Failed...")
				'ui_warning("Teleport : "+str(ts))
			end if
		else
			scan.mx=player.mx
			scan.my=player.my
			mode=MODE_SCAN	
		end if	
		
	end select	
	
		
	''
	'' Mouse
	''	
	m = GetMouse (mx, my, , mb)
	if m=0 then
		'' Left Button
		if mb and 1 then leftdown=1

		if (mb and 1)=0 and leftdown=1 then
			leftdown=0
			
			'' Click a game tile
			select case as const mode
			case MODE_MOVE
			
				mv=player_movedir(mx,my,dice)
				if mv>-1 then
					if player_move(mv)=1 then
						dice-=1
						myitem=item_check()
						if myitem>-1 then mode=MODE_ITEM
						
						ec=enemy_over(player.x,player.y)
						if ec>-1 then
							tmp_enemy=enemy(ec)
							if question_defend(tmp_enemy)=0 then player.health-=1
						end if
						
					end if
				end if
			
			
			case MODE_SCAN
				if mouse_over.s>0 then 
				
					if (player.mx+player.x)=(scan.mx+mouse_over.x) then
						if (player.my+player.y-1)=(scan.my+mouse_over.y) then
						
							'' console
							if  mouse_over.s=7 then
								mode=MODE_HACK	
								FSOUND_PlaySound(FSOUND_FREE, sample(0))
							end if
						end if
					
					end if
				
					'' Beacon (Do not have to be in front)
					if  mouse_over.s=5 then
						
						'ui_warning("Beacon!")
						sx=scan.mx+mouse_over.x
						sy=scan.my+mouse_over.y
						
						if player_next(sx,sy)=1 then
							mouse_over.s=6
							
							with player
								tele_add(currentarea,.x,.y,.mx,.my)
							end with
													
							
							map(area(currentarea).x+sx,area(currentarea).y+sy).s=6
						end if
					end if
				
					if mode=MODE_SCAN then
						mode=MODE_INFO
						FSOUND_PlaySound(FSOUND_FREE, sample(0))
					end if
				end if
				
			case MODE_TARGET
				if dice>0 then
				
					if currentarea=2 then
						'' freeze lava!
						if mouse_over.s=8 and player.ice=1 then
						dice-=1
						map(area(currentarea).x+player.mx+mouse_over.x,area(currentarea).y+player.my+mouse_over.y).s=2
						map(area(currentarea).x+player.mx+mouse_over.x,area(currentarea).y+player.my+mouse_over.y).solid=0
						
						FSOUND_PlaySound(FSOUND_FREE, sample(7))
						
						end if
					
					end if
				
					if mouse_over.s>99 then 
						dice-=1
						target.active=enemy_id(mx,my)
						
						'ui_warning("Enemy:"+str(target.active)+" H:"+str(enemy(target.active).h))
						
						mode=MODE_ATTACK
						
						'' Clear keyboard buffer
						While Inkey <> "": Wend	
		
					end if
				end if
			end select
			
			''
			'' Command button click
			''
			uicom=ui_command_hit(mx,my)
			if uicom>-1 then set_mode(uicom)
			
		end if
		
		'' Right Button
		if mb and 2 then
			rightdown=1	
		end if

		'' Scan > Move > Target
		
		if (mb and 2)=0 and rightdown=1 then
			rightdown=0
		
			if dice>0 then
				'dice-=1
				rightdown=0
				
				mode+=1
				
				if mode>5 then mode=3
				'' Right click to alternate between move/target
				if mode=MODE_MOVE then cursor=0
				if mode=MODE_SCAN then
					cursor=0
					scan.mx=player.mx
					scan.my=player.my
				end if
				if mode=MODE_TARGET then cursor=1
				
			end if
			
		end if
		
	end if
	
	
	
	
	
	
	''
	'' Move to new area
	''
	if mode=MODE_MOVE then
	
		'' bottom
		if (player.my+player.y)=15 then
			'' Ship to Forest , Lava to Ice
			currentarea+=1
				
			map_area(currentarea)
			enemy_area(currentarea)
		
			player.my=0
			player.y=1
		end if
	
		'' At top of screen
		if (player.my+player.y)=0 then
			'' Forest to Ship, Lava to Ice
			currentarea-=1
			
			map_area(currentarea)
			enemy_area(currentarea)
		
			player.my=5
			player.y=9
		end if
		
		'' Right side
		if (player.mx+player.x)=31 then
			'' Ship to Lava , Forest to Ice
			currentarea+=2
			
			map_area(currentarea)
			enemy_area(currentarea)
		
			player.mx=0
			player.x=1
		end if
		
		''
		'' Left
		if (player.mx+player.x)=0 then
			'' Lava to Ship , Ice to Forest
			currentarea-=2
			
			map_area(currentarea)
			enemy_area(currentarea)
		
			player.mx=12
			player.x=18
		end if
	
	end if
	
	''
	'' Disable teleport button..
	''
	if dice<8 then
		ui_modes(4).state=0
	end if
	
	''
	'' DICE is zero, almost computers turn!
	''
	if mode=MODE_MOVE or mode=MODE_TARGET then		
		if dice=0 then
			'' Disable all buttons
			for i as integer=0 to ubound(ui_modes)
				ui_modes(i).state=0
			next i
			'' Enable
			ui_modes(1).state=1	'' Scan
			ui_modes(5).state=1	'' Done
			
			scan.mx=player.mx
			scan.my=player.my
			mode=MODE_SCAN
			cursor=0
		end if
	end if
	
	''
	'' Screenshot
	k=inkey
	
	if k="1" then set_mode(0)
	if k="2" then set_mode(1)
	if k="3" then set_mode(2)
	if k="4" then set_mode(3)
	if k="5" then set_mode(4)	'' Teleport
	if k="6" then set_mode(5)	'' Done
	
	if k="s" then
	        bsave "screen.bmp",0
	end if
	
	''
	''
	if player.rescue=rescue and enemies=0 then
		quit=2
	end if
	
	''
	''
	''
	if  MultiKey(SC_M) and key.m=0  then key.m=1
	
	if MultiKey(SC_M)=0 and key.m=1 then 
		key.m=0
		if music=1 then
			music=0
			FMUSIC_StopAllSongs()
		else
			music=1
			FMUSIC_PlaySong(gamemusic)
		end if
	end if
	
	''
	''
	''
	if player.health<=0 then
		quit=3
	end if	
	''
	'' Always able to exit!
	''			
	if  MultiKey(SC_ESCAPE) and key.escape=0  then key.escape=1
	
	if MultiKey(SC_ESCAPE)=0 and key.escape=1 then 
		key.escape=0
		quit=1
	end if
	
	if quit=1 then
		if ui_yesno("Quit this game?")=0 then quit=0
	end if
	
	
	'' Exit through x
	if k=chr(255)+"k" then
		if ui_yesno("Exit the game?")=1 then
			quit=1
			ext=1
		end if
	end if
	
	
	'' Clear keyboard buffer
	While Inkey <> "": Wend		
		
			
	sleep 10,1		
	loop while quit=0 
		
	''
	'' Game Over....
	''
	
	if quit=3 then
		screenlock()
			map_draw()
			player_draw()
			enemy_draw()
			ui_red()
			ui_guage(88,400+16,player.health,12,"HEALTH:")
		screenunlock()
		
			
		ui_defeated()
	'	title_outro()
	end if
	
	''
	'' Rescued everyone?
	''
	if quit=2 then
		ui_guage(88,400+32,player.rescue,rescue,"RESCUED:")
		ui_guage(88,400+48,enemies,enemy_max,"INVADERS:")
		ui_welldone()
		title_outro()
	end if

loop while ext=0	

FSOUND_Close()

end
'''
''
''
sub set_mode(num as integer)
	if ui_modes(num).state=0 then return

	select case as const num
	case 0:
		if player.difficulty=EASY then 
			dice=6+int(rnd*7) '' 6 to 12	
		else
			dice=2+int(rnd*11) '' 2 to 12
		end if
		
		#if CHEAT=1
		dice=12
		#endif
		
		player.ap=dice
		
		for i as integer=0 to ubound(ui_modes)
			ui_modes(i).state=1
		next i
		
		ui_modes(0).state=0
		mode=MODE_SCAN
		
		if dice>=8 and show_tele>0 then
		'	show_tele-=1
			mode=MODE_DICE
		end if	
		
		if show_dice>0 then
			'' don't show all the time...
			show_dice-=1
			mode=MODE_DICE
		end if
			
		cursor=0
	case 1: 
		scan.mx=player.mx
		scan.my=player.my
		
		mode=MODE_SCAN
		cursor=0
	case 2:
		mode=MODE_MOVE
		cursor=0
	
	case 3:
		mode=MODE_TARGET
		cursor=1
		
	case 4:
		mode=MODE_TELEPORT	
		cursor=0
		
	case 5:
		'' Done button
		mode=MODE_ENEMY
		cursor=0
		ec=0

		
	end select


end sub

sub mouse_box()
	dim as integer x,y,e
	dim as integer sx,sy

	mouse_over.s=-1


	for y=0 to 10
		for x=0 to 19
		
			if (my>(y*32) and my<((y+1)*32)) then
				if (mx>(x*32) and mx<((x+1)*32)) then
					
					
					if x<>mouse_over.x or y<>mouse_over.y then
						cur.x=x
						cur.y=y
						
						mouse_over.x=x
						mouse_over.y=y
						
					end if
					
				end if
			
			end if
			
		next x
	next y
	
	''
	'' Check for keys (not when in move mode though!)
	''
	if mode<>MODE_MOVE and mode<>MODE_SCAN then
			if  MultiKey(SC_UP) and mkey.u=0  then
				if cur.y>0 then cur.y-=1
				mkey.u=1
			end if
			
			if MultiKey(SC_UP)=0 and mkey.u=1 then mkey.u=0
			
			'' Move RIGHT
			if  MultiKey(SC_RIGHT) and mkey.r=0  then
				if cur.x<19 then cur.x+=1
				mkey.r=1
			end if
			if MultiKey(SC_RIGHT)=0 and mkey.r=1 then mkey.r=0
			
			
			'' Move DOWN
			if  MultiKey(SC_DOWN) and mkey.d=0 then
				if cur.y<10 then cur.y+=1	''21
				mkey.d=1
			end if
			if MultiKey(SC_DOWN)=0 and mkey.d=1 then mkey.d=0
			
			
			'' Move LEFT
			if  MultiKey(SC_LEFT) and mkey.l=0  then
				if cur.x>0 then cur.x-=1
				mkey.l=1
			end if
			if MultiKey(SC_LEFT)=0 and mkey.l=1 then mkey.l=0
	end if
	''
	'' Update selected items
	''
	sx=area(currentarea).x+player.mx+cur.x
	sy=area(currentarea).y+player.my+cur.y
	
	put (cur.x*32,cur.y*32),sprite(cursor),trans
	
	mouse_over.s=map(sx,sy).s
	''
	e=enemy_mouse(sx,sy)
	if e>-1 then
		mouse_over.s=(100+e)
	end if
	
	e=item_over(sx,sy)
	if e>0 then
		mouse_over.s=(1000+e)
	end if
	
end sub


sub scan_box()
	dim as integer x,y,e
	dim as integer sx,sy
	
	mouse_over.s=-1

	for y=0 to 10
		for x=0 to 19
		
			if (my>(y*32) and my<((y+1)*32)) then
				if (mx>(x*32) and mx<((x+1)*32)) then
					if x<>mouse_over.x or y<>mouse_over.y then
						cur.x=x
						cur.y=y
						mouse_over.x=cur.x
						mouse_over.y=cur.y
					end if
				end if
			
			end if
		
			
		next x
	next y
	
	''
	put (cur.x*32,cur.y*32),sprite(cursor),trans
	
	sx=area(currentarea).x+scan.mx+cur.x
	sy=area(currentarea).y+scan.my+cur.y
	
	mouse_over.s=map(sx,sy).s
	''
	e=enemy_mouse(sx,sy)
	if e>-1 then
		mouse_over.s=(100+e)
	end if
	
	e=item_over(sx,sy)
	if e>0 then
		mouse_over.s=(1000+e)
	end if
	
end sub

