'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''
'' Explosion / Fireworks
''

type expo
        active as integer
        dist as integer
        x as integer
        y as integer
        startx as integer
        starty as integer
        particle(100) as integer
        r as integer
        g as integer
        b as integer
end type


declare sub explosion_clr()
declare sub explosion_draw()
declare sub explosion_add(x as integer, y as integer,d as integer)
''
const as integer swidth=640,sheight=480-128

dim shared explosion(10) as expo

dim shared as integer alt=0
const as integer pcount=40

sub explosion_clr()
	dim as integer e
	
	for e=0 to ubound(explosion)
		explosion(e).active=0
		explosion(e).dist=0
	next e
end sub

sub explosion_add(x as integer, y as integer,d as integer)
	dim as integer e,f
	
	for e=0 to ubound(explosion)
		with explosion(e)
	  	if .active=0 then
	
	                .active=1
	                .startx=x
	                .starty=y
	                .dist=d
	                for f=0 to pcount
	                	.particle(f)=180+int(rnd*180)
	                
	                next f	
	                
			.r=int(rnd*255)+1
			.g=int(rnd*255)+1
			.b=int(rnd*255)+1
			                   
	                exit for
	                
		end if 
		end with
	next e
end sub

''
''
''
sub explosion_draw()
	dim as integer i,f,sd,d,dc
	
	for i=0 to ubound(explosion)
	  
	        with explosion(i)
		        if .active=1 then
		        	color rgb(.r,.g,.b)
		                .dist+=1
		                
		                d=.dist
		                sd=d-20
		                
		                if sd<0 then sd=0
		                
				'' Inner firework trails                
		            	color rgb(.r/4,.g/4,.b/4)
			
		            	for f=0 to pcount
		            		for dc=sd to d-1 step 4
			            	        .x=.startx+(cos(.particle(f))*dc)
			            	        .y=.starty+(sin(.particle(f))*dc)
			                        pset(.x,.y)                        	
			                        pset(.x,.y+1)
						pset(.x+1,.y)
						pset(.x+1,.y+1)   
					next dc                                                                                         
		                next f
		                
		                '' Outer fireworks
		                color rgb(.r,.g,.b)
		                
				for f=0 to pcount
	                 		.x=.startx+(cos(.particle(f))*.dist)
		            	        .y=.starty+(sin(.particle(f))*.dist)
		                        pset(.x,.y)                        	
		                        pset(.x,.y+1)
					pset(.x+1,.y)
					pset(.x+1,.y+1) 
		                
				next f
		                              
		        	if .dist>=80 then
					.active=0
					explosion_add(int(rnd*swidth),int(rnd*sheight),0)
				end if
		        end if
	        end with
	next i
end sub
