'' FBGD 2014 Entry - Numeria
'' by ssjx (June 2014) [http://ssjx.co.uk]
'' ==============================================================
''

#include "header.bi"


''
'' In map.bas
''
declare function map_solid(x as integer,y as integer) as integer

''
common shared enemy() As myenemy
common shared player as myplayer
common shared scan as myplayer

common shared map() as myblock

dim shared sprite(7) as any ptr

dim shared as integer currentarea
dim shared area(6) as xy

dim shared as integer alt=0,ct=0
''

sub enemy_init()
	const path as string="gfx\enemy\"

	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	'' normal 32x32 sprites
	bload path+"jelly.bmp",sprite(0)
	bload path+"spider.bmp",sprite(1)
	bload path+"elite.bmp",sprite(2)
	
	bload path+"jelly2.bmp",sprite(3)
	bload path+"spider2.bmp",sprite(4)
	bload path+"elite2.bmp",sprite(5)
	
	currentarea=0
	
	area(0).x=0
	area(0).y=0
	
	area(1).x=0
	area(1).y=16
	
	area(2).x=32
	area(2).y=0
	
	area(3).x=32
	area(3).y=16	

end sub

sub enemy_area(num as integer)
	currentarea=num
end sub


sub enemy_clear()
	for e as integer=0 to ubound(enemy)
		enemy(e).active=0
	next e		
end sub

sub enemy_set()
	dim as integer i,e,a,done
	dim as integer x,y
	dim as integer sx,sy
		
	''
	dim as integer qty
	if player.difficulty=EASY then qty=2
	if player.difficulty=NORMAL then qty=5
	if player.difficulty=HARD then qty=5
	''	
		
	enemy_clear()
		
	for a=0 to 3
			
			for i=0 to qty
				with enemy(e)
					.area=a
					.active=1
					.id=e
					.s=int(rnd*2)
					.spd=1
					
					if .s=0 then .txt="Space Jelly"
					if .s=1 then .txt="Space Alien"
					
					done=0
					do
						.x=area(a).x+int(rnd*32)
						.y=area(a).y+int(rnd*16)
						
						if map(.x,.y).s=2 then done=1
						if map(.x,.y).s=0 then done=1
					loop until done=1
					
					if .s=0 then .h=1
					if .s=1 then .h=2
				end with
				
				e+=1
			next i
		
		
	next a
end sub

sub enemy_elite()
	dim as integer i,e,a,done
	dim as integer x,y
	dim as integer sx,sy
		
	''
	dim as integer qty
	if player.difficulty=EASY then qty=2
	if player.difficulty=NORMAL then qty=5
	if player.difficulty=HARD then qty=5
	''	
	
		
	for a=0 to 3
		for i=0 to qty
			with enemy(e)
				'' Replace jelly fish and defeated
				if .s=0 or .active=0 then
					.area=a
					.active=1
					.id=e
					.s=2	'' sprite
					.h=3	'' health
					.spd=2  '' speed
					.txt="Elite Alien"
					
					done=0
					do
						.x=area(a).x+int(rnd*32)
						.y=area(a).y+int(rnd*16)
						
						if map(.x,.y).s=2 then done=1
						if map(.x,.y).s=0 then done=1
					loop until done=1
				end if
			end with
			
			e+=1
		next i
	next a
end sub


sub enemy_draw()
	dim as integer i,sx,sy,spr
		
	for i=0 to ubound(enemy)
		with enemy(i)
			if .active=1 and .area=currentarea then
				sy=.y-player.my-area(currentarea).y
				sx=.x-player.mx-area(currentarea).x
				
				if sy>=0 and sy<=10 then
					spr=.s
					if alt=1 then spr+=3
				
					put (sx*32,sy*32),sprite(spr),trans
				end if
			end if
		end with
	next i
	
	'' alternate frames
	ct+=1
	if ct>20 then ct=0:alt=1-alt
end sub

'' fixed = scan draw
sub enemy_fixeddraw()
	dim as integer i,sx,sy,spr
		
	for i=0 to ubound(enemy)
		with enemy(i)
			if .active=1 and .area=currentarea then
				sy=.y-scan.my-area(currentarea).y
				sx=.x-scan.mx-area(currentarea).x
				
				if sy>=0 and sy<=10 then
					spr=.s
					if alt=1 then spr+=3
					
					put (sx*32,sy*32),sprite(spr),trans
				end if
			end if
		end with
	next i
	
	'' alternate frames
	ct+=1
	if ct>20 then ct=0:alt=1-alt
end sub

sub enemy_qdraw(x as integer,y as integer,s as integer)
	put (x,y),sprite(s),trans
end sub

sub enemy_update(e as integer)
	dim as integer px,py
	dim i as integer
	dim moved as integer	
	
	''
	''
	
	px=area(currentarea).x+player.mx+player.x
	py=area(currentarea).y+player.my+player.y	
	
	if enemy(e).active=0 then return
	
	''
	'' Make a randon direction list to prevent always defaulting to a particular
	'' direction
	dim as integer dirlist(3)
	dim as integer d,ra,rb,rt
	
	for d=0 to ubound(dirlist)
		dirlist(d)=d
	next d
	
	for i=0 to 10
		ra=int(rnd*4)
		rb=int(rnd*4)
		
		rt=dirlist(ra)
		dirlist(ra)=dirlist(rb)
		dirlist(rb)=rt
	next i
	
	moved=0
	'' Randomize the direction order...
	with enemy(e)
	
		if .active=1 and .area=currentarea then
		
			.ox=.x
			.oy=.y
		 	'' Spider monsters can move diagonally (if possible)
			 if .s>0 then
			 
			 	for i=0 to ubound(dirlist)
				 	select case as const dirlist(i)
				 	case 0:
						if map_solid(.x+1,.y+1)=0 then
							if .x<px and .y<py then .x+=1:.y+=1:moved=1
					 	end if
					 	
					case 1:
						if map_solid(.x+1,.y-1)=0 then
							if .x<px and .y>py then .x+=1:.y-=1:moved=1
					 	end if
					 
					case 2:
						if map_solid(.x-1,.y+1)=0 then
							if .x>px and .y<py then .x-=1:.y+=1:moved=1
					 	end if
					
					case 3:
						if map_solid(.x-1,.y-1)=0 then
							if .x>px and .y>py then .x-=1:.y-=1:moved=1
					 	end if
					end select
					
					if moved=1 then return
				next i
				
			 end if
			 
			 '' Jelly's can only move lr ud (or if aliens cannot move in diagonals)
			 
			 for i=0 to ubound(dirlist)
				select case as const dirlist(i)
				case 0:
			 		if .x<px and map_solid(.x+1,.y)=0 then .x+=1:moved=1
			 	
				 case 1:
				 	if .x>px and map_solid(.x-1,.y)=0 then .x-=1:moved=1
			 	
				 case 2:
				 	if .y<py and map_solid(.x,.y+1)=0 then .y+=1:moved=1
			 	
				 case 3:
					if .y>py and map_solid(.x,.y-1)=0 then .y-=1:moved=1
		 		end select
		 		
		 		if moved=1 then exit for
		 	next i
		 end if	 
	end with


end sub


function enemy_mouse(x as integer, y as integer) as integer
	dim as integer i,sx,sy
		
	for i=0 to ubound(enemy)
		with enemy(i)
			if .active=1 then
				sy=.y
				sx=.x
				
				if sx=x and sy=y then return .s	'' Jelly fish...
			end if
		end with
	next i
return -1
end function


function enemy_id(mx as integer, my as integer) as integer
	dim as integer i,sx,sy,tx,ty
	dim as integer x,y
		
	'' Mouse grid position
	for y=0 to 10
		for x=0 to 19
			if (my>(y*32) and my<((y+1)*32)) then
				if (mx>(x*32) and mx<((x+1)*32)) then
				tx=x
				ty=y	
				end if		
			end if			
		next x
	next y	
		
	'' Alien hit	
	for i=0 to ubound(enemy)
		with enemy(i)
			if .active=1 and .area=currentarea then
				sy=(.y-player.my)-area(currentarea).y
				sx=(.x-player.mx)-area(currentarea).x
				
				if sx=tx and sy=ty then return i	'' J
			end if
		end with
	next i
	
return -1
end function



function enemy_over(mx as integer, my as integer) as integer
	dim as integer i,sx,sy
	dim as integer x,y
	
	'' Alien hit	
	for i=0 to ubound(enemy)
		with enemy(i)
			if .active=1 then
				sy=(.y-player.my)-area(currentarea).y
				sx=(.x-player.mx)-area(currentarea).x
				
				if sx=mx and sy=my then return i	'' J
			end if
		end with
	next i
return -1
end function



function enemy_health(x as integer, y as integer) as myenemy
	dim as integer i,sx,sy
		
	dim r as myenemy	'' blank return value
	r.s=-1	
		
	for i=0 to ubound(enemy)
		with enemy(i)
			if .active=1 then
				sy=(.y-player.my)-area(currentarea).y
				sx=(.x-player.mx)-area(currentarea).x
				
				if sx=x and sy=y then return enemy(i)	'' Jelly fish...
			end if
		end with
	next i
return r
end function

function enemy_count() as integer
	dim as integer i,c

	for i=0 to ubound(enemy)
		if enemy(i).active=1 then c+=1	
	next i

	return c
end function

