'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''

#include "header.bi"

common shared player as myplayer


common shared viewx as integer
common shared viewy as integer

common shared stats as gamestats
common shared inventory() as item

common shared txt() as string

common shared ui_wait as integer

dim shared sprite(10) as any ptr

'' fonts
common shared comic12y as any ptr
common shared comic12w as any ptr

sub ui_init()
	dim i as integer
	dim path as string
		
	'' 16x16 sprites
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i
	
	path="gfx/ui/"	
	bload path+"heart1.bmp",sprite(0)
	bload path+"heart2.bmp",sprite(1)
	bload path+"orb.bmp",sprite(2)
	bload path+"ghost.bmp",sprite(3)
	bload path+"spider.bmp",sprite(4)
	bload path+"people.bmp",sprite(5)
	bload path+"portal.bmp",sprite(6)
		
	bload path+"ore.bmp",sprite(7)
	bload path+"key.bmp",sprite(8)

comic12y=ImageCreate( 882, 23 )
bload "fonts\comic_12_yellow.bmp", comic12y

comic12w=ImageCreate( 882, 23 )
bload "fonts\comic_12_white.bmp", comic12w

end sub

''
''
''

function txt_width(word as string) as integer
	dim as integer i,wid,aval
	Dim As UByte Ptr p
	
	ImageInfo( comic12y, , , , , p )
	
	for i=1 to len(word)	
		aval=asc(mid(word,i,1))
		wid+=p[3 + aval  -32] 
	next i
	
	return wid
end function

''
'' Return 1 if space is pressed
''        2 if escape 

function ui_waitspace() as integer
	dim as integer ext=0,spacepressed=0,escapepressed
	
	'' wait for space/escape up
	do
		''
		'' Space Pressed
		''
		if  MultiKey(SC_SPACE) then
			spacepressed=1
		end if
		
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			ext=1
		end if	
		
		''
		'' Escape Pressed
		''
		
		if  MultiKey(SC_ESCAPE) then
			escapepressed=1
		end if
		
		if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
			ext=2
		end if
			
		sleep 10
	loop until ext>0
	
	'' clear key buffer
	While Inkey <> "": Wend

	return ext
end function	

function ui_space() as integer
	dim as integer ext=0,spacepressed=0,escapepressed
	
	''
	'' Space Pressed
	''
	if  MultiKey(SC_SPACE) then
		spacepressed=1
	end if
	
	if MultiKey(SC_SPACE)=0 and spacepressed=1 then
		ext=1
	end if	
	
	''
	'' Escape Pressed
	''
	
	if  MultiKey(SC_ESCAPE) then
		escapepressed=1
	end if
	
	if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
		ext=2
	end if
		
	'' clear key buffer
	While Inkey <> "": Wend

	return ext
end function	



sub ui_inventory()
	dim as integer i,spr,iqty,x,y
	dim as string iname
	
	x=300
	
	for i=0 to 10
		iqty=0
		with inventory(i)
			if .name="Ore" then spr=7 :  iqty=.quantity
			if .name="Key" then spr=8 :  iqty=.quantity
			if .name="Orb" then spr=2 :  iqty=.quantity
		end with
		
		if iqty>0 then
			'color rgb(255,255,255)
			put (x-24,16),sprite(spr),trans
			draw string(x,16-4),"x "+Str(iqty),,comic12w
			x+=100
		end if
		
	next i
end sub


sub ui_screentop
	dim i as integer
	
	'' clear area
	 line (0,0)-(swidth,34),rgb(0,0,0),bf
	 
	 '' white horiz bars
	 color rgb(255,255,255)
	 line (0,32)-(swidth,32)
	 line (0,34)-(swidth,34)
	
	
	for i=0 to 4
		if (i+1)>player.life then
			put (0+(i*16),0),sprite(0),trans
		else
			put (0+(i*16),0),sprite(1),trans
		end if
		
	next i
	
	
'	for i=0 to player.orbs-1
'		put (0+(i*16),16),sprite(2),trans
'	next i
	
	
	with player
		draw string(2,16-4),Str(.score),,comic12y
	end with
	
	color rgb(255,255,255)
	with stats
		put (300-24,0),sprite(3),trans
		draw string(300,-4),"x "+Str(.ghosts),,comic12w
		
		put (400-24,0),sprite(4),trans
		draw string(400,-4),"x "+Str(.spiders),,comic12w
		
		put (500-24,0),sprite(5),trans
		draw string(500,-4),"x "+Str(.people),,comic12w
		
		put (600-24,0),sprite(6),trans
		draw string(600,-4),"x "+Str(.portals),,comic12w
	end with
		
	
	ui_inventory()
end sub

sub ui_bubble(x as integer, y as integer)
	const as integer fontheight=14

	dim as integer i,w=0,h=0,tmp,ya
	
	x=(x*32)+viewx
	y=(y*32)+viewy
	
	ya=y
	
	for i=0 to ubound(txt) 
		'' count the lines
		
		tmp=len(txt(i))
		if tmp>w then w=tmp
		
		if txt(i)="#" then
			exit for
		else
			h+=fontheight '12'
		end if	
	next i
	
	w=w*8
	
	y=y-h-32
	
	'' draw a box
	line (x-5,y-5)-(x+w+10,y+h+10 ),rgb(0,0,0),bf
	line (x-5,y-5)-(x+w+10,y+h+10 ),rgb(255,255,255),b ' bubble border 
	
	'' bubble point
	color rgb(255,255,255)
	line (x+16,y+h+10)-(x+16,ya-2)
	line (x+32,y+h+10)-(x+16,ya-2)
	
	
	color rgb(0,0,0)
	
	'' space between bubble point
	line (x+16+1,y+h+10)-(x+32-1,y+h+10)
	
	'' take away pointy corners
	pset (x-5,y-5)
	pset (x-5,y+h+10)
	pset (x+w+10,y-5)
	pset (x+w+10,y+h+10 )
	
	
	'' draw our text txt
	for i=0 to  ubound(txt)  		 
		if txt(i)="#" then exit for
		''draw string (x,y+(i*13)),txt(i),rgb(255,255,255)
		draw string (x,y+(i*fontheight)),txt(i),,comic12w	
	next i


end sub

sub ui_clrtxt()
	dim as integer i

	for i=0 to ubound(txt)
	txt(i)="#"
	next i 

end sub

sub ui_centre(y as integer,t as string)
	dim as integer x,g=0
	
	if left(t,1)="$" then
		t=mid(t,2,len(t)-1)
		g=1
	end if
	
	x=(swidth-txt_width(t))/2
	
	if g=0 then
		draw string(x,y),t,,comic12y
	else
		draw string(x,y),t,,comic12w
	
	end if
end sub


sub ui_box(w as integer,h as integer)
	const as integer fontheight=14
	
	dim as integer i,tmp,ya
	
	w=0
	h=0
	
	for i=0 to ubound(txt) 
		'' count the lines
		
		tmp=len(txt(i))
		if tmp>w then w=tmp
		
		if txt(i)="#" then
			exit for
		else
			h+=fontheight
		end if	
	next i
	
	w=w*8
	
	
	dim as integer x=(swidth-w)/2
	dim as integer y=(sheight-h)/2
	
	'' draw a box
	line (x-5,y-5)-(x+w+10,y+h+10 ),rgb(0,0,0),bf
	line (x-5,y-5)-(x+w+10,y+h+10 ),rgb(255,255,255),b ' bubble border 
	
	'corners
	color rgb(0,0,0)	
	pset (x-5,y-5)
	pset (x-5,y+h+10)
	pset (x+w+10,y-5)
	pset (x+w+10,y+h+10 )
	
	
	'' draw our text txt
	color rgb(255,255,0)
	for i=0 to  ubound(txt)  		 
		if txt(i)="#" then exit for
		ui_centre(y+(i*fontheight),txt(i) )	
	next i


end sub

