
'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''
#include "header.bi"
#include "bmp.bi"

declare sub title_init()
declare sub title_drawmap()
declare sub title_loadmap()
declare sub title_drawcol()

'' ui.bas
declare function txt_width(word as string) as integer

dim shared map(20,13) as integer
dim shared sprite(40) as any ptr
dim shared xpos as integer
dim shared xpos_dir as integer

dim shared count as integer

dim shared colmap as any ptr

'' --- Font ----
common shared comic12y as any ptr
common shared comic12w as any ptr



sub title_init()
	dim i as integer
	dim as string path
		
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i

	colmap=ImageCreate( swidth, sheight,rgb(0,0,0) )

	'' mono
	path="gfx/mono/"
	bload path+"solid.bmp",sprite(1)
	bload path+"grass.bmp",sprite(2)
	bload path+"earth.bmp",sprite(3)
	bload path+"water.bmp",sprite(4)
	bload path+"water2.bmp",sprite(5)
	bload path+"stalk.bmp",sprite(6)
	bload path+"flower.bmp",sprite(7)
	bload path+"ladder.bmp",sprite(8)
	bload path+"sleeper1.bmp",sprite(9)
	bload path+"crystal.bmp",sprite(10)
	bload path+"table.bmp",sprite(11)
	bload path+"painting.bmp",sprite(12)
	
	'' mono
	path="gfx/colour/"
	bload path+"solid.bmp",sprite(21)
	bload path+"grass.bmp",sprite(22)
	bload path+"earth.bmp",sprite(23)
	bload path+"water.bmp",sprite(24)
	bload path+"water2.bmp",sprite(25)
	bload path+"stalk.bmp",sprite(26)
	bload path+"flower.bmp",sprite(27)
	bload path+"ladder.bmp",sprite(28)
	bload path+"awake1.bmp",sprite(29)
	bload path+"crystal.bmp",sprite(30)
	bload path+"table.bmp",sprite(31)
	bload path+"painting.bmp",sprite(32)
		
	xpos=0
	count=0
	xpos_dir=1
end sub

sub title_loadmap()
	const path as string="gfx/title/"
	
	dim as ubyte r,g,b
	dim as integer i,j,spr
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight

	'' load the map
	if  Open(path+"map.bmp" For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				spr=0
				'' block
				if (r=192 and g=192 and b=192) then spr=0
				
				'' block
				if (r=128 and g=128 and b=128) then spr=1
				
				'' grass
				if (r=0 and g=64 and b=0) then spr=2
				
				'' earth
				if (r=128 and g=64 and b=0) then spr=3
				
				'' water
				if (r=0 and g=0 and b=255) then spr=4
				
				'' water
				if (r=0 and g=0 and b=128) then spr=5
				
				'' stalk
				if (r=0 and g=128 and b=0) then spr=6
				
				'' flower
				if (r=0 and g=255 and b=0) then spr=7
				
				'' ladder
				if (r=255 and g=255 and b=0) then spr=8
				
				
				'' person
				if (r=0 and g=128 and b=255) then spr=9
				
				'' crystal
				if (r=128 and g=255 and b=0) then spr=10
				
				
				'' Table
				if (r=0 and g=32 and b=0) then spr=11
				
				'' Painting
				if (r=200 and g=0 and b=0) then spr=12
				
				
				'' Put our sprite on the map!
				map(i,(mapheight-1)-j)=spr
					
			next i
		next j
		
			
	        Close #1 
		
		title_drawcol()   
	else
		print "Could not load title map..."
	end if


end sub

sub title_drawcol()
	dim as integer i,j,s

	''ui_centre(480-64,"FBGD 2011 Competition Entry")	'' 64
	
	dim as integer x,g=0
	const as string t="FBGD 2011 Competition Entry"
	const as integer y=(480-64)
	
	x=(swidth-txt_width(t))/2
	
	for j=0 to 12
		for i=0 to 19
			'put (i*32,j*32),sprite(0),pset
			s=map(i,j)
			
			if s>0 then				
				put colmap,(i*32,(j*32)+32),sprite(s+20),trans '' map(i,j),trans
			end if
		next i
	next j
	
	''yellow text
	draw string colmap,(x,y),t,,comic12y
end sub


sub title_drawmap()
	dim as integer i,j,d,s
	
	dim as integer x,g=0
	const as string t="FBGD 2011 Competition Entry"
	const as integer y=(480-64)
	
	x=(swidth-txt_width(t))/2
		
	for j=0 to 12
		for i=0 to 19
			
			'put (i*32,j*32),sprite(0),pset
			
			s=map(i,j)
			
			if s>0 then				
				put (i*32,(j*32)+32),sprite(s),trans '' map(i,j),trans
			end if
		next i
	next j	
	
	'' white text
	draw string (x,y),t,,comic12w
	
	'' Draw colour stripe
	put (xpos,0),colmap,(xpos,0)-((xpos)+64,sheight),PSet
	
	'' move colour stripe
	xpos+=xpos_dir
	if (xpos+64)>=swidth or xpos<=0 then xpos_dir*=-1
	

	
end sub

'sub title_drawmap_old()
'	dim as integer i,j,d,s
		
'	for j=0 to 12
'		for i=0 to 19
'			
'			'put (i*32,j*32),sprite(0),pset
'			
'			s=map(i,j)
'			
'			if s>0 then
'				if i=xpos or i=(xpos+1) then s+=20				
'				put (i*32,(j*32)+32),sprite(s),trans '' map(i,j),trans
'			end if
'		next i
'	next j	
'	
'	if count>=15 then
'		count=0
'		xpos+=1
'		if xpos>19 then xpos=-1
'	else
'		count+=1
'	end if
		
'end sub



