''
''
''
'' Player shot handling
#include "header.bi"

common shared stats as gamestats
common shared player as myplayer

'' map.bas
declare function map_pointhit(x as integer,y as integer) as integer
declare sub map_add(x as integer,y as integer,s as integer)

'' enemy.bas
declare function enemy_hit(x as integer, y as integer) as integer

common shared viewx as integer
common shared viewy as integer

common shared shot() as shotxy
dim shared sprite(5) as any ptr

sub shot_init()
	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i
	
	dim path as string="gfx/shots/"

	'' 16x16 sprites	
	bload path+"1.bmp",sprite(0)

end sub


sub shot_update()
dim as integer ehit=0

	for i as integer=0 to ubound(shot)
		with shot(i)
			if .active=1 then
				.x+=(.xdir shl 2) '' *2
				.y-=.ydir
				
				'' distance travelled
				.dis-=1
				if .dis<=0 then
					.active=0
					continue for
				end if
				
				'' hit a wall
				if map_pointhit(.x+8,.y+8)>-1 then
					.active=0
					continue for
				end if
				
				'' hit enemy?
				ehit=enemy_hit(.x,.y)
				
				select case as const ehit
				case 1:
					'' Ghost
					'' drop a crystal
					map_add(.x/32,.y/32,60)
					
					stats.ghosts-=1
					player.score+=50
					'' disable shot
					.active=0
				case 2:
					'' Spider LR
					'' drop a crystal
					map_add(.x/32,.y/32,60)
					
					stats.spiders-=1
					player.score+=10
					'' disable shot
					.active=0
				case 3:	
					'' Spider UD
					'' drop a crystal
					map_add(.x/32,.y/32,60)
					
					stats.spiders-=1
					player.score+=15
					'' disable shot
					.active=0
				end select
				
				
			end if
			
			
			
			
		end with
	next i
	
	'' shot hit enemy?
	
	
	'' shot hit player'
	
end sub

sub shot_add(x as integer,y as integer,xdir as integer,ydir as integer)
	for i as integer=0 to ubound(shot)
		with shot(i)		
			if .active=0 then
				.active=1
			
				.x=x+8
				.y=y+8
				
				.xdir=xdir shl 1 ''shot is twice as fast as player movement
				.ydir=ydir shl 1
				.dis=40 ' was 80 when speed was *2
				exit for
			end if
		end with
	next i
end sub

sub shot_draw()
	dim as integer c
	dim as integer xp,yp
	
	for c=0 to ubound(shot)
		with shot(c)
			if .active>0 then
			
				xp=.x+viewx
				yp=.y+viewy
				
				
				put (xp,yp),sprite(0),trans
				
				#if DEBUG>0
					locate 7+c,1
					print str(c)+":"+str(.x)+","+str(.y)
				#endif
				
			end if
		end with
		
	next c

end sub
