'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''

#include "header.bi"
#include "fmod.bi"


common shared viewx as integer
common shared viewy as integer

common shared blocks as integer

common shared player as myplayer
common shared map() as xypos

common shared stats as gamestats

'' Sound samples
common shared sample() As Integer

'' shot.bas
declare sub shot_init()
declare sub shot_update()
declare sub shot_add(as integer, as integer, as integer, as integer)
declare sub shot_draw()

'' player.bas
declare function player_collide(as integer,as integer,as integer) as integer
declare function player_collide2(as integer,as integer,as integer) as integer
declare function player_over( as integer,as integer, as integer) as integer
declare function player_front( as integer) as integer
declare sub player_reset()
declare sub player_draw()

'' map.bas
declare function map_move( as integer, as integer,  as integer) as integer
declare function map_hscroll( as integer) as integer
declare function map_vscroll( as integer) as integer
declare sub map_grow( as integer,as integer)
declare sub map_change( as integer, as integer, as integer)
declare sub map_add(as integer, as integer, as integer)
declare sub map_swap(a as integer, b as integer)
declare sub map_draw()

'' enemy.bas
declare function enemy_playerhit(x as integer, y as integer) as integer
declare sub enemy_draw()

'' in inventory.bas
declare sub inventory_add(item as string)
declare function inventory_count(item as string) as integer
declare sub inventory_remove(item as string,qty as integer)

'' in npc.bas
declare sub npc_add(as integer, as integer)
declare sub npc_draw()

'' in ui.bas
common shared txt() as string
common shared ui_wait as integer

declare sub ui_bubble(as integer,as integer)
declare sub ui_clrtxt()
declare sub ui_screentop()




''
''
''
dim shared sprite(20) as any ptr
dim shared alt as integer
dim shared flash as integer=0
dim shared spacepressed as integer
dim shared jump as integer

const  speed as integer=4

const  ofx as integer=8
const  wid as integer=16

dim shared as integer moveleft,moveright
dim shared inertia as integer


sub player_init()
	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
	
	
	const path as string="gfx/player/"

	'' normal 32x32 sprites	
	bload path+"left.bmp",sprite(0)
	bload path+"left_1.bmp",sprite(1)
	bload path+"right.bmp",sprite(2)
	bload path+"right_1.bmp",sprite(3)
	bload path+"up.bmp",sprite(4)
	bload path+"up_1.bmp",sprite(5)

	''
	''
	player_reset()
end sub

sub player_reset()

	with player
		.x=480-64
		.y=480-96 '' ==
		.s=0
	''	.orbs=0
		.life=5
		.xdir=-1
		.score=0
	end with
	
	moveright=0
	moveleft=0
	inertia=0
	
	#if CHEAT=1
	'	player.orbs=0
		inventory_add("Orb")
		inventory_add("Orb")
		inventory_add("Orb")
		inventory_add("Orb")
		inventory_add("Orb")
		inventory_add("Orb")
		inventory_add("Key")
		inventory_add("Ore")
	#endif
end sub

sub player_loadsprites()


end sub


sub player_update()
	dim as integer hit,hitb,block,c,tmp	
	dim as integer onladder,orbs
	dim as integer fire
	''
	'' Player controls
	''
	
	with player
		'' If we have just hit something
		if .invincible>0 then .invincible-=1
		
	
		'' Actual ladder
		onladder=player_over(2,0,0)
		
		'' Yellow ladder?
		if onladder=-1 then
			onladder=player_over(32,0,0)
		end if
		
		'' If not on a ladder, how about a green stalk?
		if onladder=-1 then
			onladder=player_over(34,0,0)
		end if
		
		'' Got an orb?
		hit=player_over(60,0,0)
		if hit>-1 then
			map(hit).s=-1
			''.orbs+=1
			
			inventory_add("Orb")
			
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
		end if
		
		'' Got an Heart?
		hit=player_over(59,0,0)
		if hit>-1 then
			if .life<5 then
				map(hit).s=-1
				.life+=1
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
			end if
		end if
		
		'' Spike!
		if .invincible=0 then
			hit=player_over(13,0,0)
			if hit>-1 then
				.life-=1
				
				if .life>0 then
					.invincible=(5*30)	'' 5 seconds
				end if
			end if
			
			'' Collide with an enemy?
			if enemy_playerhit(.x-viewx,.y-viewy)  then
				.life-=1
				
				if .life>0 then
					.invincible=(5*30)	'' 5 seconds
				end if
			end if
		
		end if
		''
			
		if  MultiKey(SC_UP) then
			inertia=0
			hit=player_collide(0,0,-speed)
			
			
			if hit=-1 then 
				
				if onladder>-1 then
					'.y-=speed
					
					if (.y<=(64+32)) then
						map_vscroll(speed)
					else
						.y-=speed
					end if
					
					
					.s=4
					alt=1-alt
					goto eokeys:
				else
					'' are we on the ground if so then jump!
					if player_collide(0,0,1)>-1 and jump=0 then
						jump=24 ''was 16
					end if
				end if	
			
			end if
		end if
		
		if  MultiKey(SC_DOWN)then
			inertia=0
			hit=player_collide(0,0,speed)
			
			if hit=-1  and onladder>-1 then
				'.y+=speed
				
				if (.y>=(416-32) ) then
					map_vscroll(-speed)
				else
					.y+=speed
				end if
				
				.s=4
				alt=1-alt
				goto eokeys:
			end if
		end if
		
		if  MultiKey(SC_LEFT) then
		
			if moveleft=0 then
				inertia=0
				moveleft=1
			else
				moveleft+=1
				if moveleft>16 then
					if inertia>-8 then
					inertia-=1
					end if
				end if
			end if
		else
			moveleft=0
		end if	
		
		if moveleft=0 and inertia<0 then
			inertia+=1
			moveleft=1
		end if
		
		if moveleft>0 then
			hit=player_collide(0,-speed,0)
			.xdir=-1
			.s=0
			
			
			if hit=-1 then
				'' If we have not hit a block, walk
				
				if (.x<=160) then
					map_hscroll(speed)
				else
					.x-=speed
				end if
					
				alt=1-alt
			'	goto eokeys:
			else
				'' Is it a Door?
				with map(hit)
					'' Is it a locked door, do we have a key?
					if .s=22 then
						if inventory_count("Key")>0 then
	 						'' remove door
							 .solid=0
	 						.s=-1
	 						'' update inventory
						 	inventory_remove("Key",1)
							FSOUND_PlaySound(FSOUND_FREE, sample(0))
	 					end if
						
					end if
				end with
				
			
				'' Is it a block we can push?
				hitb=player_collide2(0,-speed,0)
				if hitb=-1 then
					'' If hit, can we push block?
					if map_move(hit,-speed,0)=1 then
						''.x-=speed
						
						if (.x<=160) then
							map_hscroll(speed)
						else
							.x-=speed
						end if
						
						alt=1-alt
					end if
				end if
				
			end if
		end if
		
		if  MultiKey(SC_RIGHT)then
			
			if moveright=0 then
				inertia=0
				moveright=1
			else
			
				moveright+=1
				if moveright>16 then
					if inertia<8 then
					inertia+=1
					end if
				end if
				
			end if
		else
			moveright=0
		end if	
		
		if moveright=0 and inertia>0 then
			inertia-=1
			moveright=1
		end if
		
		
		if moveright>0 then
			hit=player_collide(0,speed,0)
			.s=2
			.xdir=1
			
			if hit=-1 then
				'' No obstacles
				if (.x>=448) then
					map_hscroll(-speed)
				else
					.x+=speed
				end if
				
				alt=1-alt
				'goto eokeys:
			else
				'' Is it a Door?
				with map(hit)
					'' Is it a locked door, do we have a key?
					if .s=22 then
						if inventory_count("Key")>0 then
	 						'' remove door
							 .solid=0
	 						.s=-1
	 						'' update inventory
						 	inventory_remove("Key",1)
							FSOUND_PlaySound(FSOUND_FREE, sample(0))
	 					end if
						
					end if
				end with
				
				'' Is it a block we can push?
				hitb=player_collide2(0,speed,0)
				if hitb=-1 then
					if map_move(hit,speed,0)=1 then
							
						if (.x>=448) then
							map_hscroll(-speed)
						else
							.x+=speed
						end if
					
						alt=1-alt
					end if
				end if
			end if
		end if
		
		if  MultiKey(SC_SPACE) then
			spacepressed=1
			
		end if
		
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			spacepressed=0
			
			'' find the block number we are in front of e.g. #1279
			hit=player_front(0)
			
			fire=1
			
			if hit>-1 then
				'' find out what sort of block it is e.g. #1279 = block type 4 = stalk
				block=map(hit).s
				
				orbs=inventory_count("Orb")
				
				select case as const block
				case 4:
					'' plant stalk
					if orbs>0 then
						map_grow(hit,4)	
						fire=0
						inventory_remove("Orb",1)
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
						
						player.score+=10			
					end if
				
				case 6:
					'' water (top/wave)
					if orbs>0 then
						inventory_remove("Orb",1)	
						map_grow(hit,6)
						fire=0
						
						map_add(map(hit).mx,map(hit).my-1,59)
						
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
						
						player.score+=10
					end if
				
				case 9:
					'' Crystal (Vertical moving platform)
					if orbs>0 then
						with map(hit)
							.s=39
							map_change(.mx-1,.my+1,38)
							map_change(.mx-2,.my+1,38)
							map_change(.mx-3,.my+1,38)
						end with
						fire=0
						inventory_remove("Orb",1)
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
						
						player.score+=10
					end if
					
				case 11:
					'' Crystal (Horizontal moving platform)
					if orbs>0 then
						with map(hit)
							.s=41	'' crystal
							map_change(.mx-1,.my+1,40)
						end with
						fire=0
						inventory_remove("Orb",1)
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
						
						player.score+=10
					end if
			
				case 12:	
					'' water (lower)
					if orbs>0 then
						map_grow(hit,12)
						fire=0
						inventory_remove("Orb",1)
						map_add(map(hit).mx,map(hit).my-1,59)
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
						player.score+=10
					end if
			
					
				case 14:
					'' Standing on half height block so we can fire!	
					fire=1
					
				case 15:
					'' off switch (change position and raise left barrier)
					fire=0
					with map(hit)
						.s=16
						
						map_change(.mx-3,.my,-1)
						map_change(.mx-3,.my-1,-1)
						map_change(.mx-3,.my-2,-1)
						
						map_add(.mx-3,.my-5,17)
						map_add(.mx-3,.my-6,17)
						map_add(.mx-3,.my-7,17)
					end with
				
					'' bloop!
					FSOUND_PlaySound(FSOUND_FREE, sample(0))
					
				case 18:	
					'' Ore (white)
					if orbs>0 then
					
						fire=0
						with map(hit)
						.s=48	
						end with
						player.score+=10
						'' fanfare!
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
					end if
					
				case 19:	
					'' Sleeper (usual)
					if orbs>0 then
					
						fire=0
						
						with map(hit)
							.s=49
							
							inventory_remove("Orb",1)
							
							'' Redraw ALL to show revived player
							'' otherwise ZZzz remain on screen!
							
							cls
							map_draw()
							player_draw()
							enemy_draw()
							shot_draw()
							npc_draw()
							ui_screentop()
							
							''
							ui_clrtxt()
							txt(0)="Thanks for waking me!"
							txt(1)="Now back to my work!"
							txt(2)="#"
							
							.s=-1
							
							npc_add(.mx,.my)
							
							ui_bubble(.mx,.my)
							ui_wait=1
						
						end with
						
						stats.people-=1
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
					
						player.score+=20	
						
						
					end if
					
				case 21:	
					'' Mono portal
					if orbs>0 then
					
						fire=0
						
						with map(hit)
						.s=51
						
						end with
					
						stats.portals-=1
						
						'' Close all portals restore land!
						if stats.portals=0 then
							map_swap(0,30)	'' Solid block
							map_swap(1,31)	'' * Movable
							map_swap(2,32)	'' Ladder
							map_swap(3,33)	'' Grass
							map_swap(7,37)	'' Mud
							
							map_swap(3,33)	'' Grass
							map_swap(7,37)	'' Mud
							
							map_swap(26,56)	'' Painting
							map_swap(28,58)	'' Table
							
						end if
						
						inventory_remove("Orb",1)
						
						player.score+=20
						
						'' bloop!
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
					end if	
				
				case 23:
				
				
					fire=0
						
					'' Info (locked door) sign	
					''
					ui_clrtxt()
					txt(0)="SIGN: Vault"
					txt(1)="This door needs a key!"
					txt(2)="#"
					
					with map(hit)
					ui_bubble(.mx,.my)
					end with
					
					ui_wait=1
					
				case 24:
				
				
					fire=0
						
					'' Key sign	
					''
					ui_clrtxt()
					txt(0)="SIGN: Key maker!"
					txt(1)="Yellow Ore = Keys!"
					txt(2)="#"
					
					with map(hit)
					ui_bubble(.mx,.my)
					end with
					
					ui_wait=1
					
				case 25:	
					'' Sleeper (Key maker)
					if orbs>0 then
					
						fire=0
						
						with map(hit)
							.s=55
						end with
						
						inventory_remove("Orb",1)
						
						cls
						map_draw()
						player_draw()
						enemy_draw()
						shot_draw()
						npc_draw()
						ui_screentop()
						
						''
						ui_clrtxt()
						txt(0)="Yawn! Thanks for the wake up!"
						txt(1)="If you need any keys, just give me some Yellow Ore"
						txt(2)="and I will make them for you for free!"
						
						txt(3)="#"
						
						with map(hit)
							ui_bubble(.mx,.my)
						end with
						
						ui_wait=1
						
						stats.people-=1
						
						player.score+=20
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
					end if	
				
				case 55:
					'' Awake (Key maker)
				
					fire=0
						
					tmp=inventory_count("Ore")
					if tmp=0 then
					
						ui_clrtxt()
						txt(0)="Hi friend!"
						txt(1)="If you had some Yellow Ore,"
						txt(2)="I would be giving you a key!"
						txt(3)=""
						txt(4)="You can usually find Yellow Ore,"
						txt(5)="in the mountains to the left!"
						
						txt(6)="#"
						
						with map(hit)
							ui_bubble(.mx,.my)
						end with
						
						ui_wait=1
					
					else
					
						ui_clrtxt()
						txt(0)="Hi friend!"
						txt(1)="Here's a key for you!"	
						txt(2)="#"
						
						with map(hit)
							ui_bubble(.mx,.my)
						end with
						
							
						ui_wait=1
					
						inventory_remove("Ore",1)
						inventory_add("Key")
						FSOUND_PlaySound(FSOUND_FREE, sample(0))
						
					end if
				
						
				case 48
					
					
					fire=0
					'' Ore yellow!
					map(hit).s=-1
					inventory_add("Ore")
					player.score+=10
					'' bloop!
					FSOUND_PlaySound(FSOUND_FREE, sample(0))
				end select
			end if
			
				
			'' Not activating anything so shoot!
			if fire=1 then
				dim as integer px=-viewx+player.x
				dim as integer py=-viewy+player.y
				
				shot_add(px,py,player.xdir,player.ydir)
				
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
			'' ==========
			
		
			
			
		end if
		
		'if .xdir=1 then .s=0 else 
		eokeys:
	end with
	
	''
	''
	
	''
	'' Falling
	'' =======
	'' Check in 1 pixel increments due to jumping off u/d moving
	'' platform interfering with landing offset
	''
	if onladder=-1 and jump=0 then
		for c=0 to 3
			if player_collide(0,0,1)=-1 then  
				with player
					if (.y>=(416-32)) then
						map_vscroll(-1)
					else
						.y+=1
					end if
				end with
				
			end if
		next c
	end if
	
	'' player on a movable block (player is slightly above block...)
	hit=player_over(38,0,1)
	if hit>-1 then		
		with player
			if (.y<=(64+32)) then
				map_vscroll(1)
			else
				.y-=1
			end if
		end with
	end if
	
	
	if jump>0 then
	
		dim as integer fallspeed
	
		if player_collide(0,0,-2)=-1 then
		
			'' jump slows near top of jump 'was 8 , 12
			if jump>8 then
				fallspeed=speed
			else
				fallspeed=1 '2'
			end if
		
			with player
				if (.y<=(64+32)) then
					map_vscroll(fallspeed)
				else
					.y-=fallspeed
				end if
			end with
		
			jump-=1
		else
			jump=0
		end if
		
		
	end if
	
	'' Move 	
	
end sub

function player_front(no as integer) as integer

	dim as integer i
	
	dim as integer px=player.x-viewx
	dim as integer py=player.y-viewy

	for i=0 to blocks-1
	
		with map(i)
			''
			if (px>=.x and px<=(.x+31) ) or  ((px+31)>=.x and (px+31)<=(.x+31) ) then
				
				if (py>=.y and py<=(.y+31) ) then return i
			
				if ( (py+31)>=.y and (py+31)<=(.y+31) ) then return i
				
			end if 
		
		end with
	next i
	
	return -1
end function


function player_over(no as integer,x as integer,y as integer) as integer

	dim as integer i
	
	dim as integer px=player.x-viewx+x
	dim as integer py=player.y-viewy+y

	px+=ofx

	for i=0 to blocks-1
	
		with map(i)
			if .s=no then
			
				'' first check
				if (px>=.x and px<=(.x+31) ) or ((px+wid)>=.x and (px+wid)<=(.x+31) ) then
					
					if (py>=.y and py<=(.y+31) ) then return i
				
					if ( (py+31)>=.y and (py+31)<=(.y+31) ) then return i
				
				end if 
		
			
			end if
		end with
	next i
	
	return -1
end function



'' see if player has/will hit anything 
function player_collide(no as integer,x as integer,y as integer) as integer
	'' move blocks
	dim as integer i,oy,h

	dim as integer px=(player.x-viewx)+x
	dim as integer py=(player.y-viewy)+y
	
	px+=ofx
	
	for i=0 to blocks-1
	
		with map(i)
	
			''if .s=0 or .s=1 or .s=3 or .s=8 or .s=14 or.s=28 or .s=10 or .s=30 then
			
			if .solid=1 then
			
				'' adjust block offsets if half height block
				if .s=14 then
					oy=16
					h=15
				else
					oy=0
					h=31
				end if
			
			
				
			
			
				'' first check
				if (px>=.x and px<=(.x+31) ) or ((px+wid)>=.x and (px+wid)<=(.x+31) ) then
					
					'' '=' on the first bit causes the player to be slightly off the ground
					if (py>=(.y+oy) and py<=(.y+h+oy) ) then return i
					if ( (py+31)>=(.y+oy) and (py+31)<=(.y+h+oy) ) then return i
				end if 
			
			end if 
		end with
	next i

					
	return -1	
end function

'' see if player has/will hit anything (non-moving)
function player_collide2(no as integer,x as integer,y as integer) as integer
	'' move blocks
	dim as integer i,oy,h

	dim as integer px=(player.x-viewx)+x
	dim as integer py=(player.y-viewy)+y
	
	px+=ofx
		
	for i=0 to blocks-1
	
		with map(i)
	
			if .s=0 then ''or .s=3 or .s=8 or .s=28 or .s=10 or .s=30 then
		
			'' adjust block offsets if half height block	
				if .s=14 then
					oy=16
					h=15
				else
					oy=0
					h=31
				end if
			
			if (px>=.x and px<=(.x+31) ) or ((px+wid)>=.x and (px+wid)<=(.x+31) ) then
					
					'' '=' on the first bit causes the player to be slightly off the ground
					if (py>=(.y+oy) and py<=(.y+h+oy) ) then return i
				
					if ( (py+31)>=(.y+oy) and (py+31)<=(.y+h+oy) ) then return i
				
				end if 
			
			end if 
		end with
	next i

					
	return -1	
end function



sub player_draw()

'	color rgb(0,255,0)
'	print "Over "+str(player_front(0))

'	color rgb(0,255,0)
'	locate 4,4
'	print "Inertia: "+str(inertia)


	with player
	if .invincible=0 then
	
		put (.x,.y),sprite(.s+alt),trans
	else
	
		if flash=1 then
			put (.x,.y),sprite(.s+alt),trans
			
		end if
		flash=1-flash
	end if
	
	end with
	
end sub

''
''
''
function player_complete(level as integer) as integer

	if (level=1) then 
	
		with stats
			if .portals=0 and .spiders=0 and .people=0 then return 1
		end with
	end if
	return 0
end function


