
'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''
#include "header.bi"
#include "bmp.bi"

declare sub outro_init()
declare sub outro_drawmap()
declare sub outro_loadmap()


'' in ui.bas
common shared txt() as string
common shared ui_wait as integer

declare function ui_waitspace() as integer
declare sub ui_bubble(as integer,as integer)
declare sub ui_clrtxt()
declare sub ui_centre( as integer, as string)

dim shared person(5) as xypos

dim shared map(20,13) as integer
dim shared sprite(20) as any ptr

common shared viewx as integer
common shared viewy as integer

''

const skiptext as string="** You Have Completed Your Mission - Well Done!"
const centerx=(640-(len(skiptext)*8))/2

sub outro_init()
	dim i as integer
	dim as string path
		
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i
	
	'' mono
	path="gfx/colour/"
	bload path+"grass.bmp",sprite(1)
	bload path+"earth.bmp",sprite(2)
	bload path+"stalk.bmp",sprite(3)
	bload path+"flower.bmp",sprite(4)
	bload path+"awake1.bmp",sprite(5)


	path="gfx/outro/"
	bload path+"table.bmp",sprite(10)
	
	path="gfx/intro/"
	bload path+"red_apple.bmp",sprite(11)
	bload path+"milk.bmp",sprite(12)
	
	outro_loadmap()
	
end sub

sub outro_loadmap()
	const path as string="gfx/outro/"
	
	dim as ubyte r,g,b
	dim as integer i,j,spr
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight
	dim as integer pc=0

	'' load the map
	if  Open(path+"map.bmp" For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				spr=0
				'' block
				if (r=192 and g=192 and b=192) then spr=0
				
				'' grass
				if (r=0 and g=64 and b=0) then spr=1
				
				'' earth
				if (r=128 and g=64 and b=0) then spr=2
				
				'' stalk
				if (r=0 and g=128 and b=0) then spr=3
				
				'' flower
				if (r=0 and g=255 and b=0) then spr=4
				
				'' awake person!
				if (r=0 and g=128 and b=255) then
					spr=5
					with person(pc)
						.x=i
						.y=(mapheight-1)-j
					end with
					pc+=1
				end if
					
					
				'' table
				if (r=170 and g=85 and b=0) then spr=10
				
				'' apple
				if (r=0 and g=255 and b=64) then spr=11
				
				'' milk
				if (r=128 and g=255 and b=255) then spr=12
				
				
				
				'' Put our sprite on the map!
				map(i,(mapheight-1)-j)=spr
					
			next i
		next j
		
			
	        Close #1    
	else
		print "Could not load title map..."
	end if


end sub


sub outro_drawmap()
	dim as integer i,j,s
	
	'' This is neededso that the bubbles show in the correct place!	
	viewx=0
	viewy=0
	
	for j=0 to 12
		for i=0 to 19
			s=map(i,j)
			
			if s>0 then
				put (i*32,j*32),sprite(s),trans '' map(i,j),trans
			end if
		next i
	next j	
	
	txt(0)="Thank you!"
	txt(1)="#"
		
	for i=0 to 5
		
		with person(i)
			ui_bubble(.x,.y)
		end with
	next i

color rgb(255,255,0)
ui_centre(424,"** You Saved Everyone! Well Done! **")	'' 424
ui_centre(458,"Press [Space] to continue...")		'' 440
	
	
end sub



