'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''

#include "header.bi"

common shared viewx as integer
common shared viewy as integer
common shared npc() as ghost

declare function map_hit(as integer, as integer) as integer

declare sub npc_reset()

dim shared sprite(5) as any ptr

dim shared alt as integer=0
dim shared count as integer=0

dim shared npccount as integer=0

sub npc_init()

	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
	
	const path as string="gfx/npc/"

	'' normal 32x32 sprites
	bload path+"sleeper1.bmp",sprite(0)
	bload path+"awake1.bmp",sprite(1)
		
	bload path+"left.bmp",sprite(2)
	bload path+"left_1.bmp",sprite(3)
	bload path+"right.bmp",sprite(4)
	bload path+"right_1.bmp",sprite(5)
	
	npc_reset()

end sub

sub npc_reset()
	dim c as integer

	for c=0 to ubound(npc)
	with npc(c)
		.active=-1
	end with
	
	next c
	
	npccount=0
end sub



sub npc_add(x as integer, y as integer)

	with npc(npccount)
		.active=1	'' sleeping	
		
		.s=2 	'' ghost
		.x=x*32
		.y=y*32
		
		.xdir=1
		
		.ydir=0
	end with

	npccount+=1

end sub

sub npc_update()
	dim as integer c

	for c=0 to ubound(npc)
		'put (.x,.y),sprite(.s+alt),trans
			
		with npc(c)
			'' Walker
			if .active=1 then
				.x+=.xdir
				
				if (map_hit(.x,.y)>-1) or (map_hit(.x+(32*.xdir),.y+2)=-1) then 
					.xdir*=-1
				end if
				
			end if	
			
			if .active=-1 then exit for
			
		end with
	
		
	
	next c

''
	count+=1
	if count>=10 then
		count=0
		alt=1-alt
	end if

end sub

sub npc_draw()
	dim as integer c

	#if DEBUG=1
		locate 5,5
		print "Ghost Count:"+str(ghostcount)
	#endif

	for c=0 to ubound(npc)
		with npc(c)
		
		if .active>-1 then
		
			if .xdir<0 then put (.x+viewx,.y+viewy),sprite(2+alt),trans
			
			if .xdir>0 then put (.x+viewx,.y+viewy),sprite(4+alt),trans
			
			
		end if
		end with
	next c

end sub





