'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
''
''
''

#include "bmp.bi"
#include "header.bi"


common shared viewx as integer
common shared viewy as integer
common shared blocks as integer

common shared map() as xypos
common shared player as myplayer

common shared stats as gamestats

declare function map_collide(as integer,as integer,as integer) as integer

declare function map_collide16(as integer,as integer,as integer) as integer

declare function map_hitplayer( as integer,as integer,as integer) as integer

declare function map_hit(as integer, as integer) as integer

declare function map_find(x as integer, y as integer) as integer

declare sub rotsprite(no as integer)
declare sub vrotsprite(no as integer)

declare sub enemy_add( as integer, as integer, as integer)

declare sub enemy_hmove(xdir as integer)
''
''
''

dim shared sprite(70) as any ptr
 
dim shared portal_spr(5) as any ptr
dim shared spike_spr(5) as any ptr

dim shared as integer alt=0
dim shared as integer count=0,altb=0,portal_count=0,spike_count=0 

dim shared as integer exitx=0 
'' --------- 

sub map_initsprites()
	dim i as integer	
	for i=0 to 59
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
	
	for i=60 to 70
		sprite(i) = ImageCreate( 16, 16,rgb(255,255,100) )
	next i
	
	for i=0 to ubound(portal_spr)
		portal_spr(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	for i=0 to ubound(spike_spr)
		spike_spr(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
	
	viewx=0
end sub

sub map_loadsprites()

	dim path as string
	dim i as integer

	path="gfx/mono/"
	
	'' normal 32x32 sprites
	bload path+"solid.bmp",sprite(0)	
	bload path+"block.bmp",sprite(1)	'' movable
	bload path+"ladder.bmp",sprite(2)	
	
	bload path+"grass.bmp",sprite(3)
	bload path+"stalk.bmp",sprite(4)
	bload path+"flower.bmp",sprite(5)
	bload path+"water.bmp",sprite(6)
	bload path+"earth.bmp",sprite(7)
	bload path+"moving-v.bmp",sprite(8)	'' U/D moving
	bload path+"crystal.bmp",sprite(9)
	bload path+"moving-h.bmp",sprite(10)	'' L/R moving
	bload path+"crystal.bmp",sprite(11)
	bload path+"water2.bmp",sprite(12)
	bload path+"spikes.bmp",sprite(13)
	bload path+"half.bmp",sprite(14)
	
	bload path+"switch_off.bmp",sprite(15)
	bload path+"switch_on.bmp",sprite(16)
	bload path+"gate.bmp",sprite(17)
	bload path+"ore.bmp",sprite(18)
	bload path+"sleeper1.bmp",sprite(19)
	bload path+"sleeper2.bmp",sprite(20)
		
	bload path+"portal1.bmp",sprite(21)
	bload path+"door.bmp",sprite(22)
	bload path+"sign_info.bmp",sprite(23)
	bload path+"sign_keys.bmp",sprite(24)
	
	bload path+"sleeper.bmp",sprite(25)	'' Key maker
	bload path+"painting.bmp",sprite(26)
	bload path+"keys.bmp",sprite(27)	
	bload path+"table.bmp",sprite(28)	''

	for i=1 to 5
		bload path+"portal0"+str(i)+".bmp",portal_spr(i-1)
	next i
	
	for i=1 to 2
		bload path+"spikes"+str(i)+".bmp",spike_spr(i-1)
	next i
		
	path="gfx/colour/"
	
	'' normal 32x32 sprites
	bload path+"solid.bmp",sprite(30)
	bload path+"block.bmp",sprite(31)
	bload path+"ladder.bmp",sprite(32)	
	bload path+"grass.bmp",sprite(33)	
	
''	bload path+"yellow.bmp",sprite(33)
	bload path+"stalk.bmp",sprite(34)
	bload path+"flower.bmp",sprite(35)
	bload path+"water.bmp",sprite(36)
	bload path+"earth.bmp",sprite(37)
		
	bload path+"moving-v.bmp",sprite(38)	'' U/D
	bload path+"crystal.bmp",sprite(39)
	bload path+"moving-h.bmp",sprite(40)	'' 
	bload path+"crystal.bmp",sprite(41)	''
	bload path+"water2.bmp",sprite(42)
	
	bload path+"ore.bmp",sprite(48)
	bload path+"awake1.bmp",sprite(49)
	bload path+"portal1.bmp",sprite(51)
	
	
	bload path+"awake.bmp",sprite(55)	'' Key maker
	
	bload path+"painting.bmp",sprite(56)
	
	bload path+"transporter.bmp",sprite(57)	
	
	bload path+"table.bmp",sprite(58)
	
	bload path+"heart.bmp",sprite(59)
	
	'' Smaller 16x16 gfx
	path="gfx/items/"		
	bload path+"orb.bmp",sprite(60)	
	

end sub

sub map_loadmap(level as integer)
	dim as ubyte r,g,b
	dim as integer i,j,c
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight
	dim path as string="map\"+str(level)+".bmp"

	''clear the entire map array
 	for c=0 to (mapw*maph)-1
		with map(c)
		'' Default empty block and position		
		.s=-1
		.x=0
		.y=0
		.xdir=0
		.ydir=0
		.solid=0
		end with
	next c

	with stats
		.ghosts=0
		.spiders=0
		.people=0
		.portals=0
	end with

	'' load the map
	if  Open(path For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		blocks=0
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				with map(blocks)
					
					''if .s=0 or .s=1 or .s=3 or .s=8 or .s=14 or.s=28 or .s=10 or .s=30 then
			
					'' Solid block (these do not move)
					if (r=128 and g=128 and b=128) then .s=0:.solid=1
					
					'' Basic white block (these can fall)	
					if (r=0 and g=0 and b=0) then .s=1 : .solid=1
					
					'' ladder
					if (r=255 and g=255 and b=0) then .s=2
					
					'' Grass
					if (r=0 and g=64 and b=0) then .s=3 : .solid=1
					
					'' Stalk
					if (r=0 and g=128 and b=0) then .s=4
					
					'' Flower
					if (r=0 and g=255 and b=0) then .s=5
					
					'' Water
					if (r=0 and g=0 and b=255) then .s=6
					
					'' Earth
					if (r=128 and g=64 and b=0) then .s=7  : .solid=1
					
					'' Moving
					if (r=192 and g=192 and b=192) then .s=8  : .solid=1
					
					'' Crystal
					if (r=128 and g=255 and b=0) then .s=9
					
					'' Moving  (Horizontal)
					if (r=128 and g=255 and b=255) then .s=10  : .solid=1
					
					'' Crystal  (Horizontal)
					if (r=0 and g=255 and b=255) then .s=11
					
					'' Water 2
					if (r=0 and g=0 and b=128) then .s=12
					
					'' Spike
					if (r=128 and g=128 and b=0) then .s=13
					
					'' Half height block
					if (r=64 and g=0 and b=64) then .s=14  : .solid=1
					
					'' Switch
					if (r=64 and g=0 and b=128) then .s=15
					
					'' Gate
					if (r=255 and g=128 and b=192) then .s=17  : .solid=1
					
					'' Ore
					if (r=255 and g=255 and b=128) then .s=18
					
					'' people
					if (r=0 and g=128 and b=255) then .s=19 :stats.people+=1
					
					'' Portal
					if (r=128 and g=128 and b=192) then .s=21: stats.portals+=1
					
					'' Door
					if (r=128 and g=128 and b=64) then .s=22 : .solid=1
					
					'' Sign - Info
					if (r=0 and g=64 and b=64) then .s=23
					
					'' Sign - Keys
					if (r=0 and g=66 and b=66) then .s=24
					
					'' Sleeper (Key maker)
					if (r=50 and g=50 and b=50) then .s=25 : stats.people+=1
					
					'' PAinting
					if (r=200 and g=0 and b=0) then .s=26
					
					'' Keys Hanging
					if (r=40 and g=0 and b=40) then .s=27
					
					'' Table
					if (r=0 and g=32 and b=0) then .s=28
					
					'' Active block so give it a position
					if .s>-1 then
						'' map grid position
						.mx=i
						.my=(mapheight-1)-j
						''
						.x=.mx*32 '(i*32)
						.y=.my*32 '((mapheight-1)-j)*32	
						blocks+=1				
					end if
					
				end with
				''
				'' NON SCENERY THINGS
				''
				
				'' Ghost
				if (r=255 and g=128 and b=0) then
					enemy_add(i*32,((mapheight-1)-j)*32,1)
					stats.ghosts+=1
				end if
				
				'' Spider (LR)
				if (r=255 and g=0 and b=0) then
					enemy_add(i*32,((mapheight-1)-j)*32,2)
					stats.spiders+=1
				end if
				
				
				'' Spider (UD)
				if (r=50 and g=0 and b=0) then
					enemy_add(i*32,((mapheight-1)-j)*32,3)
					stats.spiders+=1
				end if
				
				'' Player
				if (r=255 and g=0 and b=255) then
					
				'	player.x=(i*32)
				'	player.y=((mapheight-1)-j)*32
					
					viewx=-(i*32)+player.x 'player.x
					viewy=-(((mapheight-1)-j)*32)+player.y 'player.x
					
					exitx=i					
					
				end if
				
				'c+=1
				
			next i
		next j
		
			
	        Close #1 
		 
	end if

'' So we get to the ending quicker...
#if CHEAT=1
	with stats
		.ghosts=0
		.spiders=0
		.people=1
		.portals=0
	end with
#endif


end sub

sub map_add(x as integer,y as integer,s as integer)
	with map(blocks)
		.s=s
		.mx=x
		.my=y
		.x=.mx*32
		.y=.my*32				
	end with
		
	blocks+=1
end sub

sub map_change(x as integer,y as integer,s as integer)
	dim as integer c

	for c=0 to blocks-1
		with map(c)
		
			if .mx=x and .my=y then
				.s=s
				
				if .s=-1 then .solid=0	'' empty square
				
				if .s=38 then .ydir=-1	'' U/D platform starts upward
				if .s=40 then .xdir=1	'' L/R platform starts left 
				
				exit for
			end if			
		end with
	
	next c	
end sub

sub map_draw()
	dim as integer c,s
	dim as integer xp,yp
	
	#if DEBUG>0
		locate 4,1
		print "Map viewx:"+str(viewx)
		print "Map viewy:"+str(viewy)
		print "Map blocks:"+str(blocks)+" Max: "+str(mapw*maph)
	#endif
	

	'for c=0 to (mapw*maph)-1 
	for c=0 to blocks-1
		with map(c)
			if .s>-1 then
			
				xp=.x+viewx
			
				if xp>-32 and xp<640+32  then
				
					yp=.y+viewy
				
					if  yp>-32 and yp<480+32 then
			
						if .s=19 then
							'' Sleeper + ZZzzz..
							put (xp,yp),sprite(.s+altb),trans
						else
							put (xp,yp),sprite(.s),trans
						end if
						#if DEBUG=2
						'draw string (.x+viewx+1,.y+1),str(c),rgb(0,0,0)
						'draw string (.x+viewx,.y),str(c),rgb(255,0,0)
						
						draw string (.x+viewx,.y),"X:"+str(.x),rgb(255,100,0)
						draw string (.x+viewx,.y+12),"Y:"+str(.y),rgb(255,100,0)
						
						#endif
					end if
				end if
				
				
				
			
			end if
		end with
		
	next c

	if (alt=1) then
		rotsprite(6)
		rotsprite(36)
		vrotsprite(57)	
	end if
	alt=1-alt
	
	
	
	
	'' Slower alternate (sleepers)
	count+=1
	if count>20 then
		count=0:
		altb=1-altb
	
		'' swap portal sprite
		put sprite(21),(0,0),portal_spr(portal_count),trans 'pset		
		portal_count+=1
		if portal_count>4 then portal_count=0
		
		'' swap spike sprite
		put sprite(13),(0,0),spike_spr(spike_count),pset		
		spike_count+=1
		if spike_count>1 then spike_count=0
		
		
	end if
	
	
end sub


sub map_update()
	'' move blocks
	dim as integer c,i
	
	for c=0 to blocks-1
	
		select case as const map(c).s
			case 0:
			'' block...
			
			case 1,31:
				'' pushable block (mono/colour)... (block won't fall if on players head!)
				
				for i=0 to 1
					if map_collide(c,0,2)=0 and map_hitplayer(c,0,2)=0then
						map(c).x+=0
						map(c).y+=2
					end if
				next i
		
			case 60:
				'' falling diamond/orb
				for i=0 to 1
					if map_collide16(c,0,2)=0 then
						map(c).x+=0
						map(c).y+=2
					end if
				next i
				
			case 38:
				'' floating up/down block...
				with map(c)
					if .ydir<0 then
						'' going up (extra height so we don't squash player)
						if map_collide(c,0,2-64)=0 then
							.x+=.xdir
							.y+=.ydir
						else	
							
							.ydir*=-1
						end if
					else
						'' going down (if it hits player head, then change dir)
						if map_collide(c,0,2)=0  and map_hitplayer(c,0,2)=0  then
							.x+=.xdir
							.y+=.ydir
						else	
							
							.ydir*=-1
						end if
					end if
				end with
				
			case 40
				'' floating left/right block...
				with map(c)
					if .xdir>0 then
						'' going right
						if map_collide(c,2,0)=0  and map_hitplayer(c,2,0)=0 then
							.x+=.xdir
						else	
							
							.xdir*=-1
						end if
					else
						'' going left
						if map_collide(c,-2,0)=0 and map_hitplayer(c,-2,0)=0  then
							.x+=.xdir
						else	
							
							.xdir*=-1
						end if
					end if
				end with
		end select
	
	next c
		
end sub

''
''
''
function map_hscroll(xdir as integer) as integer
	viewx+=xdir	
	return 0
end function


function map_vscroll(xdir as integer) as integer
	viewy+=xdir	
	return 0
end function


sub map_grow(hit as integer,hitsprite as integer)
	dim as integer i=0,s,ext=0
	
	select case as const hitsprite
	case 4
	'' plant stalk/flower
		
		map(hit).s=34	'' white stalk to green
		
		for i=1 to 5
			
			s=34			'' green stalk
			if i=5 then s=35	'' flower
			
			'' erase old plant head from list
				
			with map(hit)	
				map_change(.mx,.my-1,-1)
				map_add(.mx,.my-i,s)
			end with
		
		next i
	
	
	case 6	
		'' Wave (top) of water
		with map(hit)
		do
			
			if map_find(.mx+i,.my)=6 then map_change(.mx+i,.my,36) else ext=1
			if map_find(.mx+i,.my+1)=12 then map_change(.mx+i,.my+1,42)
			i-=1	
		loop until ext=1
		
		i=1 '' next to where we stand (above has already changed the water behind player)
		ext=0
		do
			
			if map_find(.mx+i,.my)=6 then map_change(.mx+i,.my,36) else ext=1
			if map_find(.mx+i,.my+1)=12 then map_change(.mx+i,.my+1,42)
			i+=1	
		loop until ext=1
		
		end with
		
	case 12
		'' Bottom of water
		with map(hit)
			do
				
				if map_find(.mx+i,.my-1)=6 then map_change(.mx+i,.my-1,36) else ext=1
				if map_find(.mx+i,.my)=12 then map_change(.mx+i,.my,42)
				i-=1	
			loop until ext=1
			
			i=1
			ext=0
			do
				
				if map_find(.mx+i,.my-1)=6 then map_change(.mx+i,.my-1,36) else ext=1
				if map_find(.mx+i,.my)=12 then map_change(.mx+i,.my,42)
				i+=1	
			loop until ext=1
		
		end with
		
	end select
	
end sub




''
'' See if a BLOCK can move
''
function map_move(no as integer,x as integer, y as integer) as integer

	'' Mono / Colour movable block
	if map(no).s=1 or map(no).s=31 then
		if map_collide(no,x,y)=0 then
			map(no).x+=x
			map(no).y+=y
			return 1
		end if
	end if
	
	return 0
end function


'' check if a block has hit the player
function map_hitplayer(no as integer,x as integer,y as integer) as integer

	dim as integer px,pw
	
	dim as integer mx=map(no).x+(x+viewx)
	dim as integer my=map(no).y+(y+viewy)
	
	with player
		
		px=.x+8
		pw=16
		
		if (mx>=px and mx<=(px+pw) ) or  ((mx+31)>=px and (mx+31)<=(px+pw) ) then
		
			if ( (my+31)>=.y and (my+31)<=(.y+31) ) then return 1
			
			if (my>=.y and my<=(.y+31) ) then return 1
		
		end if 
	end with


	return 0
end function

'' see if box 'no' has hit anything 32x32
function map_collide(no as integer,x as integer,y as integer) as integer
	'' move blocks
	dim as integer i
	
	dim as integer mx=map(no).x+x
	dim as integer my=map(no).y+y
	
	
	for i=0 to blocks-1
	
		if (i<>no) then
			with map(i)
				if (.s>-1) then
				
					if (mx>=.x and mx<=(.x+31) ) or  ((mx+31)>=.x and (mx+31)<=(.x+31) )  then
						
						if (my>=.y and my<=(.y+31) ) then return 1
						
						if ( (my+31)>=.y and (my+31)<=(.y+31) ) then return 1
								
					end if 
				
				end if 
			end with
		end if
	next i

					
	return 0	
end function

''
''
''

'' see if box 'no' has hit anything 32x32
function map_collide16(no as integer,x as integer,y as integer) as integer
	'' move blocks
	dim as integer i
	
	dim as integer mx=map(no).x+x
	dim as integer my=map(no).y+y
	
	
	for i=0 to blocks-1
	
		if (i<>no) then
			with map(i)
				if (.s>-1) then
				
					if (mx>=.x and mx<=(.x+31) ) or  ((mx+15)>=.x and (mx+15)<=(.x+31) )  then
						
						if (my>=.y and my<=(.y+31) ) then return 1
						
						if ( (my+15)>=.y and (my+15)<=(.y+31) ) then return 1
								
					end if 
				
				end if 
			end with
		end if
	next i

					
	return 0	
end function

''
'' rotate sprite horizontally
''

sub rotsprite(no as integer)
	dim as integer pix=0
	
	Dim buffer As UByte Ptr = sprite(no) 
	dim temp(5) as ubyte
	
	pix=32
   	for j as integer=0 to 31
	   
	        for i as integer=0 to 3 	'
	       		temp(i)=buffer[pix+i]
	       	next i
		 
	        for i as integer=0 to 123 	
	       		buffer[pix+i]=buffer[pix+i+4]
	       	next i
	       	
	       	for i as integer=0  to 3
			buffer[pix+124+i]=temp(i)
	       	next i
	       	''
	       	pix+=128
	
	next j
	
end sub

''
''
''

sub vrotsprite(no as integer)
dim as integer pix=0
	
	Dim buffer As UByte Ptr = sprite(no) 
	dim temp(128) as ubyte

	pix=32
	
	 for i as integer=0 to 127 	
	       	temp(i)=buffer[pix+i]
	next i
	
   	for j as integer=0 to 30
	   	    	
	        for i as integer=0 to 127 	
	       	buffer[pix+i]=buffer[pix+i+128]
	       	next i
	       	
	       	''
	       	pix+=128
	
	next j
	
	 for i as integer=0 to 127 
	       	buffer[pix+i]=temp(i)
	next i
	
end sub

''
'' Map Hit - See if 32x32 box hit anything
''
function map_hit(x as integer,y as integer) as integer
	'' move blocks
	dim as integer i
	
	for i=0 to blocks-1
	
		with map(i)
		'if .s>-1 then (.s=2 is a ladder)
		if .solid=1 then
			'' first check
			if (x>=.x and x<=(.x+31) ) or  ((x+31)>=.x and (x+31)<=(.x+31)) then
				
				if (y>=.y and y<=(.y+31) ) then
					return .s
				end if 	
			
				if ( (y+31)>=.y and (y+31)<=(.y+31) ) then
					return .s
				end if 
			
			end if 
		end if 
		end with
	next i
					
	return -1	
end function

''
'' Map Hit - See if a point is within a box (returns block sprite)
''
function map_pointhit(x as integer,y as integer) as integer
	'' move blocks
	dim as integer i
	
	for i=0 to blocks-1	
		with map(i)
		'if .s=0 or .s=1 or .s=8 or .s=10 or .s=28 or .s=30 then		
		
		'' the .s<>14 is so we ignore half height blocks...
		
		if .solid=1 and .s<>14 then
		
			if (x>=.x and x<=(.x+31) ) then		
				if (y>=.y and y<=(.y+31) ) then
					return .s
				end if 	
			end if 
		end if 
		end with
	next i
					
	return -1	
end function

'' Change ALL map sprites!
sub map_swap(a as integer, b as integer)
	dim as integer i
	
	for i=0 to blocks-1	
		with map(i)
			if .s=a then .s=b
		end with
	next i
end sub

'' Find what the sprite is at a co-ord
function map_find(x as integer, y as integer) as integer
	dim as integer i
	
	for i=0 to blocks-1	
		with map(i)
			if .mx=x and .my=y then return .s
		end with
	next i
	
	return -1
end function

sub map_addexit()
	dim as integer i

	for i=0 to maph
	
		if map_find(exitx,i)=-1 then
			map_add(exitx,i,57)	
		else
			exit for	
		end if
	next i

end sub
