'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''
''

#include "header.bi"
#include "fmod.bi"

'' in title.bas
declare sub title_init()
declare sub title_drawmap()
declare sub title_loadmap()

'' in map.bas
declare sub map_initsprites()
declare sub map_loadsprites()
declare sub map_loadmap(as integer)
declare sub map_draw()
declare sub map_update()
declare sub map_addexit()

'' in player.bas
declare sub player_init()
declare sub player_loadmap()
declare sub player_draw()
declare sub player_update()
declare sub player_reset()
declare function player_complete(as integer) as integer
declare function player_over(no as integer,x as integer,y as integer) as integer

'' ui.bas
common shared ui_wait as integer

declare sub ui_init()
declare function ui_waitspace() as integer
declare sub ui_screentop()
declare function ui_space() as integer
declare sub ui_centre( as integer, as string)
declare sub ui_box( as integer, as integer)
declare sub ui_clrtxt()
'' enemy.bas
declare sub enemy_init()
declare sub enemy_loadsprites()
declare sub enemy_add(as integer, as integer)
declare sub enemy_update()
declare sub enemy_draw()
declare sub enemy_reset()

'' shot.bas
declare sub shot_init()
declare sub shot_update()
declare sub shot_draw()

'' in inventory.bas
declare sub inventory_clear()


'' in npc.bas
declare sub npc_reset()
declare sub npc_update()
declare sub npc_draw()
declare sub npc_init()

'' in intro.bas
declare sub intro_init()
declare sub intro_draw()
declare function intro_next() as integer
declare sub intro_reset()

'' in outro.bas
declare sub outro_init()
declare sub outro_drawmap()
declare sub outro_loadmap()

'' in explosion
common shared explosion() as expo
dim explosion(10) as expo

declare sub explosion_add(as integer, as integer, as integer)
declare sub explosion_draw()
declare sub explosion_clr()

''
''
''

sub screendim()

        Dim buffer As UByte Ptr = ScreenPtr()    
	dim as uinteger c=(640*480*2)      
        
        asm
        	mov eax, [c]		''counter
        	mov ebx, [buffer]	''screen buffer
        	
        dtop:
        	mov cx,[ebx]	''screen pos
        	
        	shr ch		''shift colour bytes
        	shr cl
        	
        	mov [ebx],cx	''put shift colour back 
        	
		add ebx,2	''move to next 2 bytes
						
		sub eax,1	'' decrease count
	jnz dtop	
		 
        end asm   

end sub

''

common shared inventory() as item
dim inventory(20) as item

common shared map() as xypos
dim map(mapw*maph) as xypos

common shared player as myplayer


common shared stats as gamestats
''
common shared txt() as string
dim txt(20) as string

''
''
''

common shared enemy() as ghost
dim enemy(40) as ghost

''
''

common shared npc() as ghost
dim npc(20) as ghost


common shared shot() as shotxy
dim  shot(20) as shotxy

''
''
''
dim level as integer
dim levelstatus(5) as integer
dim leveltime(5) as integer
dim levelscore(5) as integer

dim leveltime_str(5) as string


leveltime_str(1)=" --- "
leveltime_str(2)=" --- "
''
''

dim as integer gamemode,quit,key,alt=0,count=0,done=0
dim as integer escapepressed,spacepressed,uppressed,downpressed,choice=1,mpressed

''
''
''

dim as double starttime,endtime
dim as integer ttime,mins,secs,besttime=20*60

''
''
'' --- Font ----
common shared comic12y as any ptr
common shared comic12w as any ptr



'' -- Sound ---
FSOUND_Init(44100, 8, 0) 

common shared sample() As Integer
dim sample(10) As Integer

dim i as integer

for i=0 to 3
	sample(i) = FSOUND_Sample_Load(FSOUND_FREE,"wav\"+str(i)+".mp3", FSOUND_HW3D, 0, 0) 
next i

''
''

dim as integer playmusic=0,music_off

dim as integer titlemusic,intromusic,gamemusic,fanfare

titlemusic = FMUSIC_LoadSong("music\intro.mid")
FMUSIC_SetMasterVolume(titlemusic, 100)

intromusic = FMUSIC_LoadSong("music\prof.mid")
FMUSIC_SetMasterVolume(intromusic, 100)

gamemusic = FMUSIC_LoadSong("music\game.mid")
FMUSIC_SetMasterVolume(gamemusic, 100)

fanfare = FMUSIC_LoadSong("music\fanfare.mid")
FMUSIC_SetMasterVolume(fanfare, 100)

'' -- Load best score --

	if Open("save.dat" For Binary Access read As #1)=0 then
	'	get #1, , besttime

		for i=0 to ubound(levelstatus)
		  	get #1, ,levelstatus(i) 
		 	get #1, ,leveltime(i) 
		 	get #1, ,levelscore(i)
		next i

		' Close the file.  
		Close #1		

		'' make time strings!
		for i=0 to ubound(levelstatus)
		
			ttime=leveltime(i)
			if ttime>0 then 
				if ttime>59 then
					mins=0
					secs=0
					do
						ttime-=60
						mins+=1
					loop while (ttime-60)>=0
					
					secs=ttime
					
				else
					'' prob cheated...
					mins=0
					secs=ttime
				end if
				
				leveltime_str(i)=str(mins)+" mins "+str(secs)+" secs"
			end if
		next i		

	End If




'' --

windowtitle GAMETITLE+" ["+VERSION+"]"
screen 18,32,1'''  ,&h01

''
'' Load and set up things...
''
ui_init()

player_init()

map_initsprites()
map_loadsprites()

enemy_init()
enemy_loadsprites()

shot_init()

npc_init()
''
intro_init()
''
title_init()
title_loadmap()
''

outro_init()

''
''
for i=0 to 4
	explosion_add(100+int(rnd*440),int(rnd*240),int(rnd*50))
next i

gamemode=MODE_WELCOME

'gamemode=MODE_COMPLETE

''
''
''

'FMUSIC_PlaySong(intromusic)

do
'	FSOUND_Update
	ui_wait=0
	
	if music_off=0 then
		if playmusic=0 then
			FMUSIC_StopAllSongs()
		
			select case as const gamemode
			case MODE_WELCOME:
				FMUSIC_PlaySong(titlemusic)
			case MODE_INTRO
				FMUSIC_PlaySong(intromusic)
			case MODE_GAME:
				FMUSIC_PlaySong(gamemusic)
			case MODE_COMPLETE:
				FMUSIC_PlaySong(fanfare)
				
			end select
			playmusic=1
		end if
	end if
	
	''
	'' Draw everything
	''
	
	screenlock()
		
		select case as const gamemode
		case MODE_WELCOME: 
			'' Welcome screen
			cls
			
			
			title_drawmap()
			
			color rgb(255,255,255)			
			
			#if CHEAT=1
			draw string(0,16),"Cheat mode is still on btw..."
			#endif
			
			ui_centre(16,GAMETITLE)	'' 48
			ui_centre(32,"by ssjx")	'' 64
			
			'ui_centre(480-64,"$FBGD 2011 Competition Entry")	'' 64
			
			
			if alt=0 then
				color rgb(255,255,0)	
				ui_centre(64,"Press Space to begin!") ''96
			end if
			
		
			
			draw string(2,480-22),VERSION,,comic12y
			draw string(640-(8*len(SITEURL)),480-22),SITEURL,,comic12y
			
			
			if music_off=1 then
				ui_centre(480-22,"[Escape] to Exit [M] Music On")
			else
				ui_centre(480-22,"[Escape] to Exit [M] Music Off")
			end if 
			
			'ui_centre(480-22-16,"[M] Turn off music")
			
		
		case MODE_INTRO	
			intro_draw()
		
		case MODE_SELECT
			cls	
			title_drawmap()
		
			''
			ui_centre(48,GAMETITLE)
			ui_centre(64,"by ssjx")
			
			'draw string(0,0),"High Score: "+str(hiscore),,comic12w
			'draw string(2,480-22),VERSION,,comic12y
			'draw string(640-(8*len(SITEURL)),480-22),SITEURL,,comic12y
			
			ui_centre(480-22,"Arrow Up / Down to choose, Press Space to start")
			''
		
			ui_clrtxt()
			txt(0)="Please Select:"
			txt(1)="                          "
			txt(2)="View Introduction"
			txt(3)=""
			
			txt(4)="Level 1 - Castle"
			txt(5)="Status : Not Cleared"
			txt(6)="Best time  :"+leveltime_str(1) '' +"["+str(leveltime(1) )
			txt(7)="Best score :"+str(levelscore(1))
			
			
			txt(8)=""
			txt(9)="Level 2 - Underground"
			txt(10)="Status : Not Cleared"
			txt(11)="Best time  :"+leveltime_str(2) '' +"["+str(leveltime(2) )
			txt(12)="Best score :"+str(levelscore(2))
			
			
			txt(13)=""
			txt(14)="View Outro"
			txt(15)="Status : Locked"
			
			if levelstatus(1)=1 then txt(5)="Status : Cleared!"
			if levelstatus(2)=1 then txt(10)="Status : Cleared!"
			
			if levelstatus(1)=1 or levelstatus(2)=1 then txt(15)="Status : Unlocked!"
			
			if choice=1 then txt(2)="$* "+txt(2)+" *"
			if choice=2 then txt(4)="$* "+txt(4)+" *"
			if choice=3 then txt(9)="$* "+txt(9)+" *"
			if choice=4 then txt(14)="$* "+txt(14)+" *"
			
			ui_box(200,200)
					
		case MODE_READY
			'' Get Ready!
			
		case MODE_GAME: 	
			'' Main game
			cls
			
			map_draw()
			player_draw()
			enemy_draw()
			shot_draw()
			npc_draw()
			ui_screentop()
			
			if done=1 then
				done=2
				ui_clrtxt()
				txt(0)="Well Done! You have revived the"
				txt(1)="people and got rid of the monsters!"
				txt(2)=""
				txt(3)="Now return to where you started"
				txt(4)="so Prof White can bring you home!"
				txt(5)=""
				txt(6)="Feel free to zap any of the remaining ghosts!"
				ui_box(200,200)
				ui_wait=1
			end if
		
			
		case MODE_OVER:
			cls
			map_draw()
			player_draw()
			enemy_draw()
			shot_draw()
			npc_draw()
			ui_screentop()
			
			screendim()
			
			color rgb(255,255,0)
			
			ui_clrtxt()
			txt(0)="You failed, maybe try again?"
			txt(1)=""
			txt(2)=" Press [Space] to continue "
			txt(3)="#"
			
			if player.score>levelscore(level) then
				txt(3)=""
				txt(4)="** New High Score **"
				txt(5)="#"
			end if
			
			ui_box(200,200)
		
		case MODE_COMPLETE:
			cls
			'color rgb(0,200,200)
			'locate 8,4
			'print ttime
			
			outro_drawmap()
			explosion_draw()
			
			if player.score>=levelscore(level) then
				ui_centre(440,"** New High Score **") ''456
			end if			
		end select
	
	screenunlock()
	
	''
	'' Controls and main game stuff...
	''
	select case as const gamemode
		case MODE_WELCOME
			
			key=0
			'' Space to play 
			if  MultiKey(SC_SPACE) then
				spacepressed=1
			end if	
		
			if MultiKey(SC_SPACE)=0 and spacepressed=1 then
				spacepressed=0
				key=1
			end if
			
			'' Escape to exit 
			if  MultiKey(SC_ESCAPE) then
				escapepressed=1
			end if	
		
			if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
				escapepressed=0
				key=2
			end if
			
			
			if key=1 then
				gamemode=MODE_SELECT
				
				'' space
				'intro_reset()
				'gamemode=MODE_INTRO
				'enemy_reset()
				'inventory_clear()
				'player_reset()
				'npc_reset()
				'done=0
			end if
			
			if key=2 then
				'' escape
				quit=1
			end if
			
			'' for the flashing start
			count+=1
			if count>=30 then
				count=0
				alt=1-alt
			end if
		
		case MODE_INTRO
		
			if ui_wait=1 then
				key=ui_waitspace()
			end if
			
			if key=2 then
				'' Escape
				playmusic=0
				gamemode=MODE_GAME			
				map_loadmap(1)
				level=1
				starttime=timer	
			else
				'' Space
				if intro_next()=-1 then
					playmusic=0
					gamemode=MODE_GAME			
					map_loadmap(1)
					level=1	
					starttime=timer
				end if
			end if
		
		
		case MODE_SELECT
			
			if  MultiKey(SC_UP) and uppressed=0 then
				uppressed=1
			end if
			
			if  MultiKey(SC_DOWN) and downpressed=0 then
				downpressed=1
			end if
			
			if  MultiKey(SC_UP)=0 and uppressed=1 then
				choice-=1
				uppressed=0
			end if
			
			if  MultiKey(SC_DOWN)=0 and downpressed=1 then
				choice+=1
				downpressed=0
			end if
			
			if choice<1 then choice=4
			if choice>4 then choice=1
			
			
			'' Space to play 
			key=0
			
			if  MultiKey(SC_SPACE) then
				spacepressed=1
			end if	
		
			if MultiKey(SC_SPACE)=0 and spacepressed=1 then
				spacepressed=0
				key=1
			end if
			
			'' Escape to exit 
			if  MultiKey(SC_ESCAPE) then
				escapepressed=1
			end if	
		
			if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
				escapepressed=0
				key=2
			end if
			
			if key=1 then
				'' space
				
				intro_reset()	
				enemy_reset()
				inventory_clear()
				player_reset()
				npc_reset()
				done=0
				
				if choice=1 then 
					playmusic=0
					gamemode=MODE_INTRO
				end if
				
				if choice=2 then
					playmusic=0
					gamemode=MODE_GAME
					level=1
					map_loadmap(level)	
					starttime=timer
				end if
				
				if choice=3 then 
					playmusic=0
					gamemode=MODE_GAME
					level=2
					map_loadmap(level)	
					starttime=timer
				end if
				
				if choice=4 then
					if levelstatus(1)=1 or levelstatus(2)=1 then
					playmusic=0
					level=1
					gamemode=MODE_COMPLETE
					end if
				end if
				
			end if
		
			if key=2 then
				gamemode=MODE_WELCOME
			end if
		
		case MODE_READY
			'' Get Ready!
		
				
		case MODE_GAME:
			
			map_update()
			player_update()
			enemy_update()
			shot_update()
			npc_update()
			
			'' we do this by a flag otherwise  we will wait in a lock and break things...
			'' Use when we read signs, wake people 
			''
			if ui_wait=1 then
				ui_waitspace()
			end if
			
			if player.life=0 then 
				playmusic=0
				gamemode=MODE_OVER
			endif
			
			if done=0 then
				if player_complete(1)=1 then
					ui_clrtxt()	
					map_addexit()
					done=1
				
				end if
			end if
			
			if done=2 then
				if player_over(57,0,0)>-1 then
					playmusic=0
					gamemode=MODE_COMPLETE
					
					'' time taken
					endtime=timer
					ttime=int(endtime-starttime)
					
					'' Completed
					'' =================
					'' new high score!
					if player.score>levelscore(level) then levelscore(level)=player.score
					
					'' new fasteset time! (or current best time not set)
					if ttime<leveltime(level) or leveltime(level)=0 then
						leveltime(level)=ttime
					
					
						if ttime>59 then
							mins=0
							secs=0
							do
								ttime-=60
								mins+=1
							loop while (ttime-60)>=0
							
							secs=ttime
							
						else
							'' prob cheated...
							mins=0
							secs=ttime
						end if
						
						leveltime_str(level)=str(mins)+" mins "+str(secs)+" secs"
					
					end if
					'' ====================
					
					'' mark as completed
					levelstatus(level)=1
					
					
				end if
			end if
			
			'' Escape to exit 
			if  MultiKey(SC_ESCAPE) then
				escapepressed=1
			end if	
		
			if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
				playmusic=0
				escapepressed=0
				gamemode=MODE_OVER
			end if
			
			
		
		
		case MODE_OVER:
			ui_waitspace()
			
			if player.score>levelscore(level) then levelscore(level)=player.score
			
			playmusic=0	
			gamemode=MODE_WELCOME
			
		case MODE_COMPLETE:
			'ui_waitspace()
			'gamemode=MODE_WELCOME
		
			'' Space to play 
			if  MultiKey(SC_SPACE) then
				spacepressed=1
			end if	
		
			if MultiKey(SC_SPACE)=0 and spacepressed=1 then
				spacepressed=0
				
				playmusic=0
				gamemode=MODE_WELCOME
			end if
		
			
	end select
	
	'' Take a screen shot	
	if multikey(SC_S) then
		bsave "screen.bmp",0
	end if
	
	
	'' Music On/Off (on key release)
	if  MultiKey(SC_M) then
		mpressed=1
	end if	

	if MultiKey(SC_M)=0 and mpressed=1 then
		mpressed=0
		music_off=1-music_off
		if music_off=1 then FMUSIC_StopAllSongs()
		playmusic=0
	end if
	
	'' Exit through x
	if inkey()=chr(255)+"k" then quit=1
	While Inkey <> "": Wend
	
	''
	'' Sleep so we don't hog cpu...
	'' 
	
	sleep 10,1
		
loop while quit=0

'' save the scores

if Open("save.dat" For Binary Access write As #1)=0 then
					
	for i=0 to ubound(levelstatus)
	  	put #1, ,levelstatus(i) 
	 	put #1, ,leveltime(i) 
	 	put #1, ,levelscore(i)
	next i
	Close #1
end if

''

FMUSIC_FreeSong (titlemusic)
FMUSIC_FreeSong (intromusic)
FMUSIC_FreeSong (gamemusic)
FMUSIC_FreeSong (fanfare)

FSOUND_Close()


