'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''
#include "header.bi"
#include "bmp.bi"

declare sub intro_drawmap()
declare sub intro_reset()
declare sub intro_loadmap()


dim shared page as integer
dim shared map(40,13) as integer
dim shared sprite(20) as any ptr

const path as string="gfx/intro/"


'' in map.bas
common shared viewx as integer
common shared viewy as integer

'' in ui.bas
common shared txt() as string
common shared ui_wait as integer

declare function ui_waitspace() as integer
declare sub ui_bubble(as integer,as integer)
declare sub ui_clrtxt()
declare sub ui_centre( as integer, as string)
''
'' --- Font ----
common shared comic12y as any ptr
common shared comic12w as any ptr


dim shared prof as xypos
dim shared you as xypos


sub intro_init()
	dim i as integer
		
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i

	bload path+"block.bmp",sprite(1)
	bload path+"ladder.bmp",sprite(2)
	bload path+"table.bmp",sprite(3)
	bload path+"milk.bmp",sprite(4)
	bload path+"oats.bmp",sprite(5)	
		
	bload path+"earth.bmp",sprite(6)
	bload path+"fire.bmp",sprite(7)
	bload path+"air.bmp",sprite(8)
	bload path+"water.bmp",sprite(9)		
		
	bload path+"right.bmp",sprite(10)
	bload path+"prof.bmp",sprite(11)
	
	
	bload path+"grass.bmp",sprite(12)
	bload path+"flower.bmp",sprite(13)
	
	bload path+"gen1.bmp",sprite(14)
	bload path+"gen2.bmp",sprite(15)
	bload path+"gen3.bmp",sprite(16)
	bload path+"red_apple.bmp",sprite(17)

	'' Sprite 20 - Skip!
	intro_reset()	
	intro_loadmap()
end sub

sub intro_reset()
	viewx=0
	viewy=0
	page=1
end sub

sub intro_draw()
	cls
	dim as integer i=0
	viewx=0
	viewy=0
	
	ui_clrtxt()
		
	select case as const page
	
	case 0:
		'' two planets seperated by thin wall
		print "Two planets here...."
	
	case 1:
		intro_drawmap()
		draw string (2,0),"Professor White's Lab...",,comic12y
		
		txt(0)="Hi Professor White!"
		txt(1)="Have you discovered anything interesting?"
		txt(2)="#"
		
		ui_bubble(you.x,you.y)

	case 2:
		intro_drawmap()
		
		txt(0)="Why, yes I have as it happens!"
		txt(1)="#"
		
		ui_bubble(prof.x,prof.y)
		
	
	case 3:
		intro_drawmap()
		
		txt(0)="Oh dear..."
		txt(1)="Dare I ask, what you've found?"
		txt(2)="Should I be getting my walking shoes?"
		txt(3)="#"
		
		ui_bubble(you.x,you.y)
		
	case 4:
		intro_drawmap()
		
		txt(0)="It seems portals have opened on the"
		txt(1)="other side of the planet and nearly"
		txt(2)="all life has been drained!"
		txt(3)="#"
		
		ui_bubble(prof.x,prof.y)
		
	case 5:
		intro_drawmap()
		
		txt(0)="That sounds bad..."
		txt(1)="#"
		
		ui_bubble(you.x,you.y)
		
	case 6:
		intro_drawmap()
		
		txt(0)="Indeed!"
		txt(1)="It looks like this stolen life force"
		txt(2)="is being used to allow strange monsters"
		txt(3)="to come through and invade!"
		
		ui_bubble(prof.x,prof.y)	
	
	case 7:
		intro_drawmap()
		
		txt(0)="I'm sensing you have a solution..."
		txt(1)="#"
		
		ui_bubble(you.x,you.y)
	
	case 8:
		intro_drawmap()
		
		txt(0)="Yes!"
		txt(1)="I've made you a device that extracts"
		txt(2)="the stolen life force, this sends the"
		txt(3)="monster back and can be used to"
		txt(4)="revive the plants and people!"
		txt(5)="#"
		
		ui_bubble(prof.x,prof.y)
	
	case 9:
		intro_drawmap()
		
		txt(0)="So, you want me to risk life and limb"
		txt(1)="to defeat horrible monsters from another"
		txt(2)="dimension!?"
		txt(3)="#"
		
		ui_bubble(you.x,you.y)

	case 10:
		intro_drawmap()
		
		txt(0)="I would go.. but you know... "
		txt(1)="my research.."
		txt(2)="#"

		ui_bubble(prof.x,prof.y)
		
	case 11:
		intro_drawmap()
		txt(0)="Right... "
		txt(1)="How do I use this extraction"
		txt(2)="device then?"
		txt(3)="#"

		ui_bubble(you.x,you.y)

	case 12:
		intro_drawmap()
		
		txt(0)="Easy! Just press [Space]"
		txt(1)="to fire, then collect the"
		txt(2)="green life orbs!"
		txt(3)="#"

		ui_bubble(prof.x,prof.y)
	
	case 13:
		intro_drawmap()
		
		txt(0)="To use an orb to revive"
		txt(1)="something, stand in front "
		txt(2)="of it and press [Space]."
		txt(3)="#"

		ui_bubble(prof.x,prof.y)	

	case 14:
		intro_drawmap()
		
		txt(0)="Okay so how do I get there?"
		txt(1)="#"
		
		ui_bubble(you.x,you.y)
	
	case 15:
		intro_drawmap()
		
		txt(0)="I have just finished building"
		txt(1)="a teleporter! It's in the next"
		txt(2)="room!"
		txt(3)="#"
		
		ui_bubble(prof.x,prof.y)	
	
	case 16:
		cls
	
		ui_centre(200,"You and Professor White walk to the next room...")
	
		
	case 17:
		intro_drawmap()
		
		txt(0)="Yikes!! Is this thing safe?!"
		txt(1)="#"
		
		ui_bubble(you.x,you.y)
		
	case 18:
		intro_drawmap()
		
		txt(0)="It worked fine on those giant apples!"
		txt(1)="#"
		
		ui_bubble(prof.x,prof.y)	

	case 19:
		intro_drawmap()
		
		txt(0)="Now remember:"
		txt(1)="- Restore the sleeping people!"
		txt(2)="- Zap the spider things!"
		txt(3)="  (you can ignore the ghosts..)!"
		txt(4)="- Close all the portals!"
		txt(5)="Got that?"
		
		txt(6)="#"
		
		ui_bubble(prof.x,prof.y)	

	case 20:
		intro_drawmap()
		
		txt(0)="Ready!"
		txt(1)="#"
		
		ui_bubble(you.x,you.y)

	case 21
		ui_centre(190,"After an elaborate light show and many sparks...")
		ui_centre(210, "You find yourself on the other side of the planet!")
		

	end select

color rgb(255,255,0)
ui_centre(440,"[Space] to Continue / [Escape] to Skip")

ui_wait=1

end sub


'' Move to the next slide in our intro 
function intro_next() as integer
	page+=1
	
	if page>21 then return -1
	
	return page
end function 

sub intro_loadmap()

	dim as ubyte r,g,b
	dim as integer i,j,spr
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight

	'' load the map
	if  Open(path+"lab.bmp" For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				spr=0
				'' block
				if (r=192 and g=192 and b=192) then spr=20
				
				'' block
				if (r=0 and g=0 and b=0) then spr=1
				
				'' ladder
				if (r=255 and g=255 and b=0) then spr=2
				'' table
				if (r=170 and g=85 and b=0) then spr=3
				'' milk
				if (r=128 and g=255 and b=255) then spr=4
				'' oats
				if (r=0 and g=255 and b=255) then spr=5
				
				'' earth
				if (r=0 and g=255 and b=0) then spr=6
				'' fire
				if (r=255 and g=0 and b=0) then spr=7
				'' air
				if (r=128 and g=128 and b=255) then spr=8
				'' water
				if (r=0 and g=0 and b=255) then spr=9
				
				
				'' Player
				if (r=255 and g=0 and b=255) then 
					spr=0 '10
					you.x=i
					you.y=(mapheight-1)-j
				end if
				
				'' Prof White
				if (r=255 and g=128 and b=0) then 
					spr=0 '11
					prof.x=i
					prof.y=(mapheight-1)-j
				end if
				
				
				'' grass
				if (r=0 and g=64 and b=0) then spr=12
				'' flower
				if (r=255 and g=128 and b=255) then spr=13
				
				'' gen
				if (r=64 and g=0 and b=128) then spr=14
				
				'' gen
				if (r=128 and g=0 and b=255) then spr=15
				
				'' gen
				if (r=128 and g=0 and b=64) then spr=16
				
				'' apple
				if (r=0 and g=255 and b=64) then spr=17
				
				'' Put our sprite on the map!
				map(i,(mapheight-1)-j)=spr
					
			next i
		next j
		
			
	        Close #1    
	end if


end sub


sub intro_drawmap()
	dim as integer i,j,s,xoff=0
	
	'' clear bg
	line (0,240)-(640,440),rgb(00,0,0),bf
	
	for j=0 to 19 ''
		line (0,(j*20)) -(640,(j+1)*20),rgb(0,j*12,255),bf
	next j
	
	'' later pages use the other half of the map
	if page>=16 then xoff=20
	
	for j=0 to 12
		for i=0 to 19
			s=map(i+xoff,j)
			
			if s<>20 then
				if s<>13 then put (i*32,j*32),sprite(0),pset
				put (i*32,j*32),sprite(s),trans '' map(i,j),trans
			end if
		next i
	next j
	
	'' to keep you/prof on screen when the map moves
	with you
		put (.x*32,.y*32),sprite(10),trans
	end with
	
	
	with prof
		put (.x*32,.y*32),sprite(11),trans
	end with
		
end sub



