'' FBGD 2011 Entry by ssjx (12/11/11) [http://ssjx.co.uk]
'' ==============================================================
''
'' * Change spiders so they can walk past ladders
''
''
''
''

#include "header.bi"
#include "fmod.bi"

common shared viewx as integer
common shared viewy as integer
common shared enemy() as ghost

declare function map_hit(as integer, as integer) as integer

'' Sound samples
common shared sample() As Integer

'' ----------


declare sub enemy_reset()

dim shared sprite(10) as any ptr

dim shared ghostcount as integer
dim shared alt as integer=0
dim shared count as integer=0


sub enemy_init()

	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
	
	enemy_reset()

end sub

sub enemy_reset()
	ghostcount=0
end sub

sub enemy_loadsprites()
	const path as string="gfx/mono/"

	'' normal 32x32 sprites	
	bload path+"ghost.bmp",sprite(0)
	bload path+"ghost1.bmp",sprite(1)
	bload path+"spider.bmp",sprite(2)
	bload path+"spider1.bmp",sprite(3)
	bload path+"spider-v1.bmp",sprite(4)
	bload path+"spider-v2.bmp",sprite(5)
end sub


sub enemy_add(x as integer, y as integer,t as integer)

	with enemy(ghostcount)
		.active=t	
		''.s=t-1
		
		if t=1 then .s=0 	'' ghost
		if t=2 then .s=2	'' spider
		if t=3 then .s=4	'' v spider
		
		.x=x
		.y=y
		.xdir=1
		.ydir=1
		
		.sx=x
		.sy=y
	end with

	ghostcount+=1

end sub

sub enemy_update()
	dim as integer c

	for c=0 to ubound(enemy)
		'put (.x,.y),sprite(.s+alt),trans
			
		with enemy(c)
			select case as const .active
			case 1:
			'' ghost
				.x+=.xdir
				.y+=.ydir
				
				if (.x<=0 or .x>=(mapw*32)-32) then .xdir*=-1
				
				if (.y<=0 or .y>=(maph*32)-64) then .ydir*=-1	
			
			case 2:
				'' spider (l-r)
				.x+=.xdir
				
				if (map_hit(.x,.y)>-1) or (map_hit(.x+(32*.xdir),.y+2)=-1) then 
					.xdir*=-1
				end if
				
			case 3:
				'' spider (u-d)
				.y+=.ydir
				
				if (map_hit(.x,.y)>-1) then 
					.ydir*=-1
				end if
				
			end select	
			
		end with
	
	next c

''
	count+=1
	if count>=10 then
		count=0
		alt=1-alt
	end if

end sub

sub enemy_draw()
	dim as integer c,xp,yp

	#if DEBUG=1
		locate 5,5
		print "Ghost Count:"+str(ghostcount)
	#endif

	for c=0 to ubound(enemy)
		with enemy(c)
			if .active>0 then
				
				xp=.x+viewx
				yp=.y+viewy
				
				
				if (xp>-32 and xp<(swidth+32)) then 
					if (yp>-32 and yp<(sheight+32)) then 
					
						put (xp,yp),sprite(.s+alt),trans
						
						if .active=3 then
						'' web line
							line (xp+15,.sy+viewy)-(xp+15,yp),rgb(255,255,255)
							line (xp+16,.sy+viewy)-(xp+16,yp),rgb(255,255,255)
						end if
					end if
				end if
				
			end if
		end with
	next c

end sub

''
'' Does POINT x,y fall inside of enemy? if so then has been shot by player!
''
function enemy_hit(x as integer, y as integer) as integer
	dim as integer c,t
	
	for c=0 to ubound(enemy)
		with enemy(c)
			if .active>0 then
				if (x>=.x and x<=(.x+31) ) then		
					if (y>=.y and y<=(.y+31) ) then
						t=.active
						.active=0
						
						FSOUND_PlaySound(FSOUND_FREE, sample(3))
						return t
					end if 	
				end if 
			end if 
		end with
	next c
	
	return 0
end function

''
'' Does PLAYER BOX x,y fall inside of enemy? if so then has been hit by player!
''
function enemy_playerhit(x as integer, y as integer) as integer
	dim as integer c
	dim as integer w=16
	dim as integer eox,ew
	
	'' player width/offset
	x+=8
	
	for c=0 to ubound(enemy)
		with enemy(c)
			if .active>0 then
				
				if .active=1 then eox=0:ew=31	'' Ghost
				if .active=2 then eox=8:ew=16	'' Spider
				
				
				if (x>=(.x+eox) and x<=(.x+eox+ew) ) or  ((x+w)>=(.x+eox) and (x+w)<=(.x+eox+ew)) then
					
					if (y>=.y and y<=(.y+31) ) then
						return 1
					end if 	
				
					if ( (y+31)>=.y and (y+31)<=(.y+31) ) then
						return 1
					end if 
				
				end if 
			end if 
		end with
	next c
	
	return 0
end function

