''
'' Infinite Road Racer (2018)
'' v0.1 by ssjx (http://ssjx.co.uk)
''
'' Traffic!
''
''
#include "header.bi"

common shared basemap() as ubyte
common shared mapwidth as integer
common shared mapheight as integer

''
common shared map_y as integer
common shared map_ofy as integer

common shared player as playerxy

'' In map.bas
declare function map_get(ax as integer,ay as integer) as integer

'' In shots.bas
declare sub p_shot_add(sx as integer,sy as integer,sd as integer,typ as integer,owner as integer)
declare function p_shot_hit(tx as integer,ty as integer,tw as integer,th as integer) as integer

declare sub expo_add(x as integer, y as integer)

''
declare function traffic_sidebump(px as integer,py as integer) as integer
declare function traffic_bump(carno as integer) as integer

type carxy
	active as integer
	x as integer
	y as integer	
	ofx as integer
	ofy as integer
	xdir as integer
	ydir as integer
	lane as integer
	firedelay as integer
	speed as integer
	armour as integer
end type

dim shared cars(100) as carxy
dim shared carsprite(5) as any ptr
dim shared road(400*16) as ubyte	'' Basemap

''
''
''

function road_get(ax as integer,ay as integer) as integer
	return road( (ay*mapwidth)+ax )
end function

''
'' Enemy 
''

function enemy_dist(no as integer) as integer
	dim as integer cx,cy
	dim as integer px=player.x+16
	dim as integer py=player.y
		
	with cars(no)
		cx=(.x*32)+.ofx+16
		cy=(.y*32)+.ofy-((mapheight-map_y)*32)+map_ofy
	end with
	
	if abs(cx-px)<16 then 
		if abs(py-cy)<200 then		
			if py>cy then return 1
			if py<cy then return -1
		end if
	end if
	
	return 0	
end function


'' Quick distance of player from a car
function player_dist(no as integer) as integer
	dim as integer cy
	dim as integer py=player.y
	
	with cars(no)
		cy=(.y*32)+.ofy-((mapheight-map_y)*32)+map_ofy
	end with
	
	return abs(py-cy)				
end function

''
''
''

'sub traffic_reset()
'	for i as integer=0 to ubound(cars)
'		cars(i).active=0
'	next i
'end sub

sub traffic_init()
	for i as integer=0 to ubound(carsprite)
		carsprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	bload "gfx\car1.bmp",carsprite(0)
	bload "gfx\car2.bmp",carsprite(1)
	bload "gfx\tank.bmp",carsprite(2)
	bload "gfx\tank2.bmp",carsprite(3)	
end sub


sub traffic_set()
	dim as integer i,j,lane
	dim as integer cc=0,c=0

	for i=0 to ubound(cars)
		cars(i).active=0
		cars(cc).ofx=0
		cars(cc).ofy=0
		cars(cc).speed=1
		cars(cc).xdir=0
		cars(cc).ydir=0
	next i	

	for j=0 to mapheight-1
		lane=1
		for i=0 to mapwidth-1
			road(c)=0
			if basemap(c)=1 or basemap(c)=2 then
				road(c)=lane
				lane+=1
			end if
			c+=1
		next i	
	next j

	c=0
	for j=0 to mapheight-20
		for i=0 to mapwidth-1
			if road(c)>0 then
				
				if cc<ubound(cars) then
					if int(rnd*100)<4 then
					
						if int(rnd*10)<6 then
							'' Friendly cars
							cars(cc).active=basemap(c)
							cars(cc).armour=1
						else
							'' Enemy!
							cars(cc).active=3
							cars(cc).armour=1
						end if
						
						cars(cc).x=i
						cars(cc).y=j
						
						cars(cc).lane=road(c)
						
						if road(c)<=3 then cars(cc).ydir=-1
						if road(c)>=4 then cars(cc).ydir=1
						
						cc+=1
						
					end if
					
				end if
			end if
			c+=1
			
			if cc=ubound(cars) then exit for
		next i	
		if cc=ubound(cars) then exit for
	next j	


end sub

sub traffic_update()
	dim as integer i,j

	for i=0 to ubound(cars)
		with cars(i)
			if .active>0 then
				if .lane<=3 then
					'' up car
					
					if .ofy=0 then
						if .y>0 then
							if road_get(.x,.y-1)<>cars(i).lane then
								if road_get(.x+1,.y-1)=cars(i).lane then .xdir=1
								if road_get(.x-1,.y-1)=cars(i).lane then .xdir=-1
							end if	
						else
							.y=(mapheight-1)
							for j=0 to 11
								if road_get(j,99)=cars(i).lane then 
									cars(i).x=j
									exit for
								end if
							next
						end if
					end if
					
					if traffic_bump(i)=0 then
						.ofy-=.speed
						if .ofy=-32 then
							.ofy=0
							.y-=1
						end if		
					end if
				end if	
					
				if .lane>=4 then
					'' down car
					if .ofy=0 then
						if (.y<(mapheight-1)) then
							if road_get(.x,.y+1)<>cars(i).lane then
								if road_get(.x+1,.y+1)=cars(i).lane then .xdir=1
								if road_get(.x-1,.y+1)=cars(i).lane then .xdir=-1
							end if	
						else
							.y=0
							for j=0 to 11
								if road_get(j,0)=cars(i).lane then 
									cars(i).x=j
									exit for
								end if
							next
						end if
					end if 
					
					if traffic_bump(i)=0 then
						.ofy+=.speed
						if .ofy=32 then
							.ofy=0
							.y+=1
						end if
					end if
		
				end if
				
				'' Enemy cars can shot!
				if .active=3 then
					'' Distance?
					if .firedelay=0 then
						dim as integer ed
						ed=enemy_dist(i) 
						if ed<>0 then
							.firedelay=20
							
							dim as integer ax=(.x*32)+.ofx
							dim as integer ay=(.y*32)+.ofy-((mapheight-map_y)*32)+map_ofy
							
							'' If close, randomly fire!
							if ed=1 then p_shot_add(ax,ay+26,ed,2,1)
							if  ed=-1 then p_shot_add(ax,ay-14,ed,1,1)
						end if
					else
						.firedelay-=1 
					end if
					
				end if
			
				'' All cars follow the road
				if .xdir<>0 and .speed<>0 then
					.ofx+=.xdir
					if .ofx=32 or .ofx=-32 then
						.ofx=0
						.x+=.xdir
						.xdir=0
					end if
				end if
				
				'' Cars hit by a shot?
				dim as integer ax=(.x*32)+.ofx
				dim as integer ay=(.y*32)+.ofy-((mapheight-map_y)*32)+map_ofy
				dim as integer ph=p_shot_hit(ax,ay,32,32)
				
				if ph>0 then
					.armour-=1
					if .armour=0 then
						'' Only adjust score if shot owner is player!
						if ph=1 then
							if .active=3 then player.score+=10 else player.score-=10
						end if
						
						expo_add(ax+8,ay+8)
						
						.active=0
					end if
				end if
				
				'' Cars start moving after hit when player moves away!
				if .speed=0 and player_dist(i)>96 then .speed=1
				
			end if
			
		end with
	next i

end sub


sub traffic_draw()
	dim as integer ax,ay ',ln

	for i as integer=0 to ubound(cars)
	
		with cars(i)
			if .active>0 then
			
				ax=(.x*32)+.ofx
				ay=(.y*32)+.ofy-((mapheight-map_y)*32)+map_ofy
				
				if .active=1 then put (ax,ay),carsprite(0),trans	'' Up Car
				if .active=2 then put (ax,ay),carsprite(1),trans	'' Down Car
				if .active=3 then 
					'' Tank
					if .ydir=-1 then put (ax,ay),carsprite(2),trans
					if .ydir=1 then put (ax,ay),carsprite(3),trans		
				
				end if	
					
			end if
			
		end with
	next i
end sub

function traffic_bump(carno as integer) as integer
	dim as integer px=player.x+5
	dim as integer py=player.y

	dim as integer hit=0
	dim as integer ax,ay
		
	if cars(carno).active<>0 then
		
		with cars(carno)
			ax=(.x*32)+.ofx+5
			ay=(.y*32)+.ofy-((mapheight-map_y)*32)+map_ofy
			
			ay+=.ydir
		end with		
	 
	 	hit=0
	 	'' Player inside tree?
		if py>=ay and py<=(ay+32) then
 			'' top left
			if px>=ax and px<=(ax+22) then hit+=1
			
			'' top right
			if (px+22)>=ax and (px+22)<=(ax+22) then hit+=2
		end if
		
		if (py+32)>=ay and (py+32)<=(ay+32) then
			'' bottom left
			if px>=ax and px<=(ax+22) then hit+=4
			
			''bottom right
			if (px+22)>=ax and (px+22)<=(ax+22) then hit+=8
		end if 
		 
	 	'' Tree inside player?
	 	if ay>=py and ay<=(py+32) then
 			'' top left
			if ax>=px and ax<=(px+22) then hit+=1
			
			'' top right
			if (ax+22)>=px and (ax+22)<=(px+22) then hit+=2
		end if
		
		if (ay+32)>=py and (ay+32)<=(py+32) then
			'' bottom left
			if ax>=px and ax<=(px+22) then hit+=4
			
			''bottom right
			if (ax+22)>=px and (ax+22)<=(px+22) then hit+=8
		end if 
 
 		if hit>0 then 
		 	cars(carno).speed=0
 			return 1
 		end if
 	end if
	
	return hit

end function


function traffic_sidebump(px as integer,py as integer) as integer
	dim as integer hit=0
	dim as integer ax,ay
	
	px=px+5
	
	for i as integer=0 to ubound(cars)
		
		if cars(i).active<>0 then
			
			with cars(i)
				ax=(.x*32)+.ofx+5
				ay=(.y*32)+.ofy-((mapheight-map_y)*32)+map_ofy
			end with		
		 
		 	hit=0
		 	'' Player inside tree?
			if py>=ay and py<=(ay+32) then
	 			'' top left
				if px>=ax and px<=(ax+22) then hit+=1
				
				'' top right
				if (px+22)>=ax and (px+22)<=(ax+22) then hit+=2
			end if
			
			if (py+32)>=ay and (py+32)<=(ay+32) then
				'' bottom left
				if px>=ax and px<=(ax+22) then hit+=4
				
				''bottom right
				if (px+22)>=ax and (px+22)<=(ax+22) then hit+=8
			end if 
			 
		 	'' Tree inside player?
		 	if ay>=py and ay<=(py+32) then
	 			'' top left
				if ax>=px and ax<=(px+22) then hit+=1
				
				'' top right
				if (ax+22)>=px and (ax+22)<=(px+22) then hit+=2
			end if
			
			if (ay+32)>=py and (ay+32)<=(py+32) then
				'' bottom left
				if ax>=px and ax<=(px+22) then hit+=4
				
				''bottom right
				if (ax+22)>=px and (ax+22)<=(px+22) then hit+=8
			end if 
	 
	 		if hit>0 then 
			 	cars(i).speed=0
	 			return 1
	 		end if
	 	end if
	next i
	
	return hit
end function

