''
'' Infinite Road Racer (2018)
'' v0.1 by ssjx (http://ssjx.co.uk)
''

#include "header.bi"
''

common shared player as playerxy

dim shared shot(40) as xypos
dim shared shotsprite(5) as any ptr

sub p_shot_reset()
	for i as integer=0 to ubound(shot)
		shot(i).active=0
	next
end sub

sub p_shot_init()
	for i as integer=0 to ubound(shotsprite)
		shotsprite(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i
	
	bload "gfx\shot.bmp",shotsprite(0)
	bload "gfx\rocket.bmp",shotsprite(1)
	bload "gfx\rocket2.bmp",shotsprite(2)
	bload "gfx\shot2.bmp",shotsprite(3)
	
	p_shot_reset()
end sub

sub p_shot_add(sx as integer,sy as integer,sd as integer,st as integer,owner as integer)
	for i as integer=0 to ubound(shot)
		with shot(i)
			if .active=0 then
				.active=1
				.x=sx+8
				.y=sy
				if owner=0 then
					'' Player shots are faster
					.ydir=sd*8
				else
					'' Enemy shots are slower
					.ydir=sd*4
				end if
				
				.xdir=0
				.typ=st
				.owner=owner
				.dist=0
				exit for
			end if
		end with
	next
end sub

sub p_photon_add(sx as integer,sy as integer,xd as integer,owner as integer)
	for i as integer=0 to ubound(shot)
		with shot(i)
			if .active=0 then
				.active=1
				.x=sx+8
				.y=sy
				.xdir=xd*4
				.ydir=0
				.typ=3
				.owner=owner
				.dist=0
				exit for
			end if
		end with
	next
end sub

sub p_shot_draw()
'	dim as integer g
	
	for i as integer=0 to ubound(shot)
		with shot(i)
			if .active=1 then
			
			'	if .typ=
			
				put (.x,.y),shotsprite(.typ),trans
				.y+=.ydir+player.speed
				.x+=.xdir
				.dist+=1
				
				if .dist>=70 then .active=0
				if (.y<-32) or (.y>512) then .active=0
				if (.x<-32) or (.x>(16*32)) then .active=0
			end if
		end with
	next
end sub

function p_shot_hit(tx as integer,ty as integer,tw as integer,th as integer) as integer
	dim as integer sx,sy
		
	for i as integer=0 to ubound(shot)
		with shot(i)
			if .active=1 then
				sy=.y+8	
				
				select case as const .owner
				case 0: 
					'' Player shots (double)
					sx=.x+1
					if (sx>tx) and (sx<tx+tw) then
						if (sy>ty) and (sy<ty+th) then
						.active=0
						return 1
						end if
					end if
				
					sx=.x+14
					if (sx>tx) and (sx<tx+tw) then
						if (sy>ty) and (sy<ty+th) then
						.active=0
						return 1
						end if
					end if
				case 1:
					
					'' Enemy
					sx=.x+8
					if (sx>tx) and (sx<tx+tw) then
						if (sy>ty) and (sy<ty+th) then
						.active=0
						return 2
						end if
					end if
					
				end select
			end if
		end with
	next
	
	return 0
end function

function p_shot_player(tx as integer,ty as integer,tw as integer,th as integer) as integer
	dim as integer sx,sy
		
	for i as integer=0 to ubound(shot)
		with shot(i)
			sx=.x+8
			sy=.y+8
			if .active=1 and .owner=1 then
				if (sx>tx) and (sx<tx+tw) then
					if (sy>ty) and (sy<ty+th) then
					.active=0
					return 1
					end if
				end if
				
			end if
		end with
	next
	
	return 0
end function


