''
'' Infinite Road Racer (2018)
'' v0.1 by ssjx (http://ssjx.co.uk)
''
#include "header.bi"

'' In map.bas
declare function map_hit(ax as integer,ay as integer) as integer

declare function map_bump(px as integer, py as integer) as integer

declare function collect_spanner(ax as integer, ay as integer) as integer

declare sub p_shot_add(sx as integer,sy as integer,sd as integer,typ as integer,owner as integer)
declare function p_shot_player(tx as integer,ty as integer,tw as integer,th as integer) as integer

declare sub expo_add(x as integer, y as integer)

declare function traffic_sidebump(px as integer,py as integer) as integer
''


common shared player as playerxy

dim shared as any ptr playersprite(10)
dim shared as integer firedelay=0
dim shared as integer up=0,down=0

''
'' Player
''

sub player_reset()
	with player
		.gear=0
		.speed=0
		.x=6*32
		.y=10*32 '8*32
		.mode=0
		.damage=0
		.bonus=200
	end with
end sub

sub player_init()
	dim i as integer

	for i=0 to 3
		playersprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	bload "gfx\car.bmp",playersprite(0)
	bload "gfx\boat.bmp",playersprite(1)
	
	for i=5 to 6
		playersprite(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i
	
	bload "gfx\ui\square1.bmp",playersprite(5)
	bload "gfx\ui\square2.bmp",playersprite(6)
	
	player_reset()
	
end sub






sub player_draw()
	put (player.x,player.y),playersprite(player.mode),trans
		
'	draw string (400,10),"Gear "+str(player.gear)+" / "+str(player.speed)
'	draw string (400,25),"Damage "+str(player.damage)
'	draw string (400,40),"Map Hit "+str(map_hit(player.x+16,player.y+16))
'	draw string (400,55),"Score: "+str(player.score)

	'' Player hit
	if p_shot_player(player.x,player.y,32,32)=1 then 
		expo_add(player.x+8,player.y+8)
		player.damage+=1
	end if
	
end sub


sub player_hud()
	const as integer edge=528
	const as integer top=16
	
	dim as integer ofx=(512-(10*24)+8)/2
	
	color rgb(0,255,0)
	draw string (edge,top+0),"Score"
	draw string (edge,top+48),"Bonus"
	
	if player.damage>=3 then color rgb(255,0,0)
	draw string (edge,top+96),"Damage"

	color rgb(255,255,255)
	draw string (edge,top+16),str(player.score)	
	draw string (edge,top+64),str(player.bonus)
	draw string (edge,top+112),str(player.damage*20)+"%"
end sub


sub player_controls()	
	with player
		if  MultiKey(SC_UP) then 
			if up=0 then 
				if .gear<3 then .gear+=1
				up=1
			end if
		end if
		
		if MultiKey(SC_UP)=0 then up=0
		
		if  MultiKey(SC_DOWN) then 
			if down=0 then
				if .gear>-2 then .gear-=1
				down=1
			end if
		end if
		
		if MultiKey(SC_DOWN)=0 then down=0
		''
		
		'' Work out actual speed
		if .gear>0 then
			.speed=1 shl (.gear-1)
		else 
			if .gear=0 then
				.speed=0
			else
				.speed=.gear
			end if 
		end if
		
		'' Hit a tree (forward/back)
		if map_bump(.x,.y-.speed)>0 then 
			.gear=0
			.damage+=1
		end if
		
		'' Hit a car		
		if traffic_sidebump(.x,.y-.speed)>0 then
			.gear=0
			.damage+=1
		end if
		
		'' Slower on water
		if map_hit(.x+16,.y+16)=3 then
			if .gear>2 then .gear=2
			.mode=1	'' Boat
		else
			.mode=0	'' Car
		end if
		
		'' Collected a spanner
		if collect_spanner(.x+16,.y+16)=1 then
			if .damage>0 then .damage-=1 else .score+=20
		end if
		
		'' Work out actual speed (Dupe!)
		if .gear>0 then
			.speed=1 shl (.gear-1)
		else 
			if .gear=0 then
				.speed=0
			else
				.speed=.gear
			end if 
		end if
		
		if .speed<>0 then
			if  MultiKey(SC_RIGHT) and map_bump(.x+2,.y-.speed)=0 and traffic_sidebump(.x+2,.y-.speed)=0 then .x+=2
			if  MultiKey(SC_LEFT)  and map_bump(.x-2,.y-.speed)=0 and traffic_sidebump(.x-2,.y-.speed)=0  then .x-=2	
		end if
	end with
	
	if firedelay=0 then
		if  MultiKey(SC_SPACE) then 
			firedelay=10
			
			p_shot_add(player.x,player.y,-1,0,0)
		end if
	else
		firedelay-=1
	end if
		
end sub



