''
'' Infinite Road Racer (2018)
'' v0.1 by ssjx (http://ssjx.co.uk)
''
'' 256 Map Loading
''

#include "header.bi"
''
''
'' From elsewhere
declare sub p_photon_add(sx as integer,sy as integer,xd as integer,owner as integer)

common shared level as integer
common shared player as playerxy
common shared basemap() as ubyte

'' In this file...
declare sub segment_load()
declare sub map_build()
declare sub map_prep()

common shared map_y as integer
common shared map_ofy as integer
common shared map_done as integer

common shared mapwidth as integer
common shared mapheight as integer

dim shared as any ptr mapsprite(20)
dim shared solid(100) as xy

dim shared collect(5) as xy
dim shared as any ptr collectspr(5)

dim shared segments(800*10) as ubyte

dim shared as integer last_hit,last_pos,last_x,last_y

''
''
''

sub map_reset()
	map_y=16	
	map_ofy=0
end sub

sub map_init()
	
	for i as integer=0 to ubound(mapsprite)
		mapsprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	bload "gfx\start.bmp",mapsprite(15)
 
 	for i as integer=0 to ubound(collectspr)
		collectspr(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i
 	
 	bload "gfx\collect\spanner.bmp",collectspr(0)
 	
	 map_reset()
 
end sub

sub map_loadtheme()
	dim as string path
	
	if (rnd*10)>5 then path="gfx\desert\" else path="gfx\forest\"
	
	bload path+"grass.bmp",mapsprite(0)
	bload path+"road.bmp",mapsprite(1)
	bload path+"road.bmp",mapsprite(2)
	bload path+"water.bmp",mapsprite(3)
	bload path+"tree.bmp",mapsprite(4)
	bload path+"corner1.bmp",mapsprite(6)
	bload path+"corner2.bmp",mapsprite(7)
	bload path+"corner3.bmp",mapsprite(8)
	bload path+"corner4.bmp",mapsprite(9)
	bload path+"tower.bmp",mapsprite(10)
end sub



''''
sub segment_load()
	dim header as bmphdr
	
	mapwidth=16 'header.w
	mapheight=400 'header.h

	dim as integer i,j,c
	dim as integer segno=0,segpos
	dim src(16*50) as ubyte
	dim dest(16*50) as ubyte
	
	dim fn(3) as string=>{"01","02","03","04"}
	
	for f as integer =0 to ubound(fn)
	
		if  Open("map\"+fn(f)+".bmp" For binary access read As #1)=0 then
			get #1,,header
			get #1,header.offset+1,src()  
		        Close #1   
			
			'' flip row by row..
			c=0
			for j=0 to 50-1
				for i=0 to 16-1
					dest(c+i)=src((16*( (50-1)-j))+i)  '' 32*(31-j)
				next i
				c+=16	''32
			next j
			
			'' Add to segments array
			segpos=segno*800
			
			for i=0 to (16*50)-1
				segments(segpos+i)=dest(i)  '' 32*(31-j)
			next i
			
			segno+=1
					
		end if
	next f
end sub


sub map_build()
	dim as integer segpos=0
	dim as integer i,j,c
	
	c=0
	for j=0 to 7
		for i=0 to (16*50)-1
			basemap(c)=segments(segpos+i)  '' 32*(31-j)
			c+=1
		next i
		
		segpos=int(rnd*4)*800		
	next j

	'' Add rounded corners to look pretty...
	map_prep()
end sub

sub map_prep()
	dim as integer i,j,c=0,ps=0
	
	'' add round corners magically...
	
	for j=0 to mapheight-2
		for i=0 to mapwidth-1
			if basemap(c)=0 then
				if basemap(c+1)=1 and basemap(c+mapwidth)=1 then basemap(c)=6
				if basemap(c+1)=2 and basemap(c+mapwidth)=2 then basemap(c)=6
				
				if basemap(c-1)=1 and basemap(c+mapwidth)=1 then basemap(c)=9
				if basemap(c-1)=2 and basemap(c+mapwidth)=2 then basemap(c)=9
				
				if basemap(c+1)=1 and basemap(c-mapwidth)=1 then basemap(c)=8
				if basemap(c+1)=2 and basemap(c-mapwidth)=2 then basemap(c)=8
				
				if basemap(c-1)=1 and basemap(c-mapwidth)=1 then basemap(c)=7
				if basemap(c-1)=2 and basemap(c-mapwidth)=2 then basemap(c)=7
			end if
			
			c=c+1	
		next i
		
	next j


	'' Replace trees with side shooters (later levels will get more)
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			if basemap(c)=4 and int(rnd*100)<(3+level) then basemap(c)=10
			c+=1
		next i
	next j


	'' Randomly add some spanners
	'' y=0 is the end where the player starts
	dim as integer tx,ty
	c=0
	do 	
		tx=int(rnd*16)
		ty=int(rnd*200)+100
		
		ps=(ty*16)+tx
		
		if (basemap(ps)<4) then
			collect(c).x=8+(tx*32)
			collect(c).y=8+(ty*32)
			c=c+1
		end if
	loop while c<=ubound(collect)
	
	'collect(0).x=32
	'collect(0).y=13*32
	
	'' Add start and end marker
	ps=0
	for i=0 to mapwidth-1
		'' Start
		ps=394*mapwidth
		if basemap(ps+i)<1 or basemap(ps+i)>2 then basemap(ps+i)=15
		
		'' End
		ps=11*mapwidth		
		if basemap(ps+i)<1 or basemap(ps+i)>2 then basemap(ps+i)=15
	next i
	
	''
	map_done=0

end sub
''
function map_get(ax as integer,ay as integer) as integer
	return basemap( (ay*mapwidth)+ax )
end function

sub map_draw()
	dim as integer ax,ay
	dim as integer i,j,s,sn=0
	
	if player.speed>0 then
		if map_y<mapheight-1 then
			map_ofy+=player.speed
		
			if (map_ofy>=32) then
				map_ofy=map_ofy-32 ''0
				map_y+=1
			end if
		else
			'' Finish line
			player.gear=0
			player.speed=0
			map_done=1
		end if
	else
		if player.speed<0 then
			if  map_y>16 then
				map_ofy+=player.speed
				
				if (map_ofy<=-32) then
					map_ofy=map_ofy+32 ''0
					map_y-=1
				end if
			else
				'' Start line
				player.gear=0
				player.speed=0
				
			end if
		end if	
	end if
	
	for j=0 to 16
		for i=0 to mapwidth-1
			s=basemap(((mapheight-1-map_y+j)*mapwidth)+i)
			ax=i*32
			ay=((j-1)*32)+map_ofy
			
			put (ax,ay),mapsprite(s),pset
			
			'' Add Tree (or Turret) to list of solid objects
			if s=4 or s=10 then 
				solid(sn).x=i*32
				solid(sn).y=((j-1)*32)+map_ofy
				sn+=1
				
				if s=10 and int(rnd*800)<5 then 
					p_photon_add(ax+8,ay+8,1,1)
					p_photon_add(ax+8,ay+8,-1,1)
				end if	
			end if
		next i			
	next j
	
	'' Draw some spanners
	for i=0 to ubound(collect)
		if collect(i).x>-1 then
			ay=((map_y*32)+map_ofy)-collect(i).y
		
			put (collect(i).x,ay),collectspr(0),trans	
			
			'draw string (512,160+(i*16) ),"S:"+str(collect(i).x)+" , "+str(ay)
		end if
	next i
	
	
	solid(sn).x=-1
	solid(sn).y=-1
	
'	draw string (400,80),"Map Y:"+str(mapheight-map_y)+" / "+str(map_y)
	
'	draw string (400,80),"Last Hit: "+str(last_hit)
'	draw string (400,95),"Last Pos: "+str(last_pos)
'	draw string (400,110),"Last x: "+str(last_x)
'	draw string (400,125),"Last y: "+str(last_y)
	
	
	
			
end sub

function map_hit(ax as integer, ay as integer) as integer
	dim as integer i,j,c=0

	ay=ay+((mapheight-map_y)*32)-map_ofy

	for j=0 to mapheight-1
		for i=0 to mapwidth-1
		
			if ax>=(i*32) and ax<=(i*32)+31 then
				if ay>=(j*32) and ay<=(j*32)+31 then
				
					last_hit=basemap(c)
					last_pos=c
					last_x=i
					last_y=j
					
					return basemap(c)
					
				end if
			end if
			c+=1
		next i
		
	next j
	
	return -1
	
end function

function collect_spanner(ax as integer, ay as integer) as integer
	dim as integer i,j,cx,cy

	for i=0 to ubound(collect)
		
		if collect(i).x>-1 then	
		
			cy=((map_y*32)+map_ofy)-collect(i).y
			cx=collect(i).x
				
			if ax>=cx and ax<=(cx)+15 then
				if ay>=(cy) and ay<=(cy)+31 then
				
					collect(i).x=-1
					return 1
					
				end if
			end if
		end if
	next i
	
	return 0
	
end function


'' Player hit tree?
function map_bump(px as integer, py as integer) as integer
	dim as integer hit=0
	dim as integer ax,ay
	
	px=px+5
	
	for i as integer=0 to ubound(solid)
		if solid(i).x=-1 then exit for
	 	
	 	ax=solid(i).x
	 	ay=solid(i).y
	 	
	 	'' Player inside tree?
		if py>=ay and py<=(ay+32) then
 			'' top left
			if px>=ax and px<=(ax+32) then hit+=1
			
			'' top right
			if (px+22)>=ax and (px+22)<=(ax+32) then hit+=2
		end if
		
		if (py+32)>=ay and (py+32)<=(ay+32) then
			'' bottom left
			if px>=ax and px<=(ax+32) then hit+=4
			
			''bottom right
			if (px+22)>=ax and (px+22)<=(ax+32) then hit+=8
		end if 
		 
		 
	 	'' Tree inside player?
	 	if ay>=py and ay<=(py+32) then
 			'' top left
			if ax>=px and ax<=(px+22) then hit+=1
			
			'' top right
			if (ax+32)>=px and (ax+32)<=(px+22) then hit+=2
		end if
		
		if (ay+32)>=py and (ay+32)<=(py+32) then
			'' bottom left
			if ax>=px and ax<=(px+22) then hit+=4
			
			''bottom right
			if (ax+32)>=px and (ax+32)<=(px+22) then hit+=8
		end if 
	 
	 
	next i
	
	return hit
end function



